/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.models;

import com.loohp.interactivechatdiscordsrvaddon.resources.models.Coordinates3D;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ModelDisplay {
    private ModelDisplayPosition position;
    private Coordinates3D rotation;
    private Coordinates3D translation;
    private Coordinates3D scale;

    public ModelDisplay(ModelDisplayPosition position, Coordinates3D rotation, Coordinates3D translation, Coordinates3D scale) {
        this.position = position;
        this.rotation = rotation;
        this.translation = translation;
        this.scale = scale;
    }

    public ModelDisplayPosition getPosition() {
        return this.position;
    }

    public Coordinates3D getRotation() {
        return this.rotation;
    }

    public Coordinates3D getTranslation() {
        return this.translation;
    }

    public Coordinates3D getScale() {
        return this.scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelDisplay that = (ModelDisplay)o;
        return this.position == that.position && Objects.equals(this.rotation, that.rotation) && Objects.equals(this.translation, that.translation) && Objects.equals(this.scale, that.scale);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.rotation, this.translation, this.scale});
    }

    public static enum ModelDisplayPosition {
        THIRDPERSON_RIGHTHAND("thirdperson_righthand", "thirdperson"),
        THIRDPERSON_LEFTHAND(THIRDPERSON_RIGHTHAND, "thirdperson_lefthand"),
        FIRSTPERSON_RIGHTHAND("firstperson_righthand", "firstperson"),
        FIRSTPERSON_LEFTHAND(FIRSTPERSON_RIGHTHAND, "firstperson_lefthand"),
        GUI("gui"),
        HEAD("head"),
        GROUND("ground"),
        FIXED("fixed");

        private ModelDisplayPosition fallback;
        private Set<String> keys;

        public static ModelDisplayPosition fromKey(String key) {
            for (ModelDisplayPosition position : ModelDisplayPosition.values()) {
                if (!position.getKeys().stream().anyMatch(each -> each.equalsIgnoreCase(key))) continue;
                return position;
            }
            return null;
        }

        private ModelDisplayPosition(ModelDisplayPosition fallback, String ... keys) {
            this.keys = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(keys)));
            this.fallback = fallback;
        }

        private ModelDisplayPosition(String ... keys) {
            this((ModelDisplayPosition)null, keys);
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public boolean hasFallback() {
            return this.fallback != null;
        }

        public ModelDisplayPosition getFallback() {
            return this.fallback;
        }
    }
}

