/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.models;

import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.Coordinates3D;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.IModelManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelAxis;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelDisplay;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelElement;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelFace;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelGUILight;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.TextureUV;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

public class BlockModel {
    private IModelManager manager;
    private String resourceLocation;
    private String parent;
    private boolean ambientocclusion;
    private ModelGUILight guiLight;
    private Map<ModelDisplay.ModelDisplayPosition, ModelDisplay> display;
    private Map<String, String> textures;
    private List<ModelElement> elements;
    private List<ModelOverride> overrides;

    public static BlockModel fromJson(IModelManager manager, String resourceLocation, JSONObject rootJson) {
        String parent = (String)rootJson.getOrDefault((Object)"parent", null);
        boolean ambientocclusion = (Boolean)rootJson.getOrDefault((Object)"ambientocclusion", (Object)true);
        ModelGUILight guiLight = rootJson.containsKey((Object)"gui_light") ? ModelGUILight.fromKey((String)rootJson.get((Object)"gui_light")) : null;
        EnumMap<ModelDisplay.ModelDisplayPosition, ModelDisplay> display = new EnumMap<ModelDisplay.ModelDisplayPosition, ModelDisplay>(ModelDisplay.ModelDisplayPosition.class);
        JSONObject displayJson = (JSONObject)rootJson.get((Object)"display");
        if (displayJson != null) {
            for (Object obj : displayJson.keySet()) {
                String displayKey = obj.toString();
                JSONArray rotationArray = (JSONArray)((JSONObject)displayJson.get((Object)displayKey)).get((Object)"rotation");
                JSONArray translationArray = (JSONArray)((JSONObject)displayJson.get((Object)displayKey)).get((Object)"translation");
                JSONArray scaleArray = (JSONArray)((JSONObject)displayJson.get((Object)displayKey)).get((Object)"scale");
                Coordinates3D rotation = rotationArray == null ? new Coordinates3D(0.0, 0.0, 0.0) : new Coordinates3D(((Number)rotationArray.get(0)).doubleValue(), ((Number)rotationArray.get(1)).doubleValue(), ((Number)rotationArray.get(2)).doubleValue());
                Coordinates3D translation = translationArray == null ? new Coordinates3D(0.0, 0.0, 0.0) : new Coordinates3D(((Number)translationArray.get(0)).doubleValue(), ((Number)translationArray.get(1)).doubleValue(), ((Number)translationArray.get(2)).doubleValue());
                Coordinates3D scale = scaleArray == null ? new Coordinates3D(1.0, 1.0, 1.0) : new Coordinates3D(((Number)scaleArray.get(0)).doubleValue(), ((Number)scaleArray.get(1)).doubleValue(), ((Number)scaleArray.get(2)).doubleValue());
                ModelDisplay.ModelDisplayPosition displayPos = ModelDisplay.ModelDisplayPosition.fromKey(displayKey);
                display.put(displayPos, new ModelDisplay(displayPos, rotation, translation, scale));
            }
        }
        HashMap<String, String> texture = new HashMap<String, String>();
        JSONObject textureJson = (JSONObject)rootJson.get((Object)"textures");
        if (textureJson != null) {
            for (Object obj : textureJson.keySet()) {
                String textureKey = obj.toString();
                texture.put(textureKey, textureJson.get((Object)textureKey).toString());
            }
        }
        ArrayList<ModelElement> elements = new ArrayList<ModelElement>();
        JSONArray elementsArray = (JSONArray)rootJson.get((Object)"elements");
        if (elementsArray != null) {
            for (Object obj : elementsArray) {
                ModelElement.ModelElementRotation rotation;
                JSONObject elementJson = (JSONObject)obj;
                String name = (String)elementJson.get((Object)"name");
                JSONArray fromArray = (JSONArray)elementJson.get((Object)"from");
                JSONArray toArray = (JSONArray)elementJson.get((Object)"to");
                Coordinates3D from = new Coordinates3D(((Number)fromArray.get(0)).doubleValue(), ((Number)fromArray.get(1)).doubleValue(), ((Number)fromArray.get(2)).doubleValue());
                Coordinates3D to = new Coordinates3D(((Number)toArray.get(0)).doubleValue(), ((Number)toArray.get(1)).doubleValue(), ((Number)toArray.get(2)).doubleValue());
                JSONObject rotationJson = (JSONObject)elementJson.get((Object)"rotation");
                if (rotationJson == null) {
                    rotation = null;
                } else {
                    JSONArray originArray = (JSONArray)rotationJson.get((Object)"origin");
                    Coordinates3D origin = originArray == null ? new Coordinates3D(0.0, 0.0, 0.0) : new Coordinates3D(((Number)originArray.get(0)).doubleValue(), ((Number)originArray.get(1)).doubleValue(), ((Number)originArray.get(2)).doubleValue());
                    ModelAxis axis = ModelAxis.valueOf(rotationJson.get((Object)"axis").toString().toUpperCase());
                    double angle = ((Number)rotationJson.get((Object)"angle")).doubleValue();
                    boolean rescale = (Boolean)rotationJson.getOrDefault((Object)"rescale", (Object)false);
                    rotation = new ModelElement.ModelElementRotation(origin, axis, angle, rescale);
                }
                boolean shade = (Boolean)elementJson.getOrDefault((Object)"shade", (Object)true);
                EnumMap<ModelFace.ModelFaceSide, ModelFace> face = new EnumMap<ModelFace.ModelFaceSide, ModelFace>(ModelFace.ModelFaceSide.class);
                JSONObject facesJson = (JSONObject)elementJson.get((Object)"faces");
                if (facesJson != null) {
                    for (Object obj1 : facesJson.keySet()) {
                        String faceKey = obj1.toString();
                        ModelFace.ModelFaceSide side = ModelFace.ModelFaceSide.fromKey(faceKey);
                        JSONObject faceJson = (JSONObject)facesJson.get((Object)faceKey);
                        JSONArray uvArray = (JSONArray)faceJson.get((Object)"uv");
                        TextureUV uv = uvArray == null ? null : new TextureUV(((Number)uvArray.get(0)).doubleValue(), ((Number)uvArray.get(1)).doubleValue(), ((Number)uvArray.get(2)).doubleValue(), ((Number)uvArray.get(3)).doubleValue());
                        String faceTexture = (String)faceJson.get((Object)"texture");
                        Object cullfaceObj = faceJson.get((Object)"cullface");
                        ModelFace.ModelFaceSide cullface = cullfaceObj != null && cullfaceObj instanceof String ? ModelFace.ModelFaceSide.fromKey((String)cullfaceObj) : side;
                        int faceRotation = ((Number)faceJson.getOrDefault((Object)"rotation", (Object)0)).intValue();
                        int faceTintindex = ((Number)faceJson.getOrDefault((Object)"tintindex", (Object)-1)).intValue();
                        face.put(side, new ModelFace(side, uv, faceTexture, cullface, faceRotation, faceTintindex));
                    }
                }
                elements.add(new ModelElement(name, from, to, rotation, shade, face));
            }
        }
        ArrayList<ModelOverride> overrides = new ArrayList<ModelOverride>();
        JSONArray overridesArray = (JSONArray)rootJson.get((Object)"overrides");
        if (overridesArray != null) {
            ListIterator itr = overridesArray.listIterator(overridesArray.size());
            while (itr.hasPrevious()) {
                JSONObject overrideJson = (JSONObject)itr.previous();
                JSONObject predicateJson = (JSONObject)overrideJson.get((Object)"predicate");
                EnumMap<ModelOverride.ModelOverrideType, Float> predicates = new EnumMap<ModelOverride.ModelOverrideType, Float>(ModelOverride.ModelOverrideType.class);
                for (Object obj1 : predicateJson.keySet()) {
                    String predicateTypeKey = obj1.toString();
                    ModelOverride.ModelOverrideType type = ModelOverride.ModelOverrideType.fromKey(predicateTypeKey);
                    if (type == null) continue;
                    Object value = predicateJson.get((Object)predicateTypeKey);
                    predicates.put(type, Float.valueOf(((Number)value).floatValue()));
                }
                String model = (String)overrideJson.get((Object)"model");
                overrides.add(new ModelOverride(predicates, model));
            }
        }
        return new BlockModel(manager, resourceLocation, parent, ambientocclusion, guiLight, display, texture, elements, overrides);
    }

    public BlockModel(IModelManager manager, String resourceLocation, String parent, boolean ambientocclusion, ModelGUILight guiLight, Map<ModelDisplay.ModelDisplayPosition, ModelDisplay> display, Map<String, String> textures, List<ModelElement> elements, List<ModelOverride> overrides) {
        this.resourceLocation = resourceLocation;
        this.manager = manager;
        this.parent = parent;
        this.ambientocclusion = ambientocclusion;
        this.guiLight = guiLight;
        this.display = Collections.unmodifiableMap(display);
        this.textures = Collections.unmodifiableMap(textures);
        this.elements = Collections.unmodifiableList(elements);
        this.overrides = Collections.unmodifiableList(overrides);
    }

    public IModelManager getManager() {
        return this.manager;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public String getRawParent() {
        return this.parent;
    }

    public String getParent() {
        return this.parent == null ? null : (this.parent.contains(":") ? this.parent : "minecraft:" + this.parent);
    }

    public boolean isAmbientocclusion() {
        return this.ambientocclusion;
    }

    public ModelGUILight getRawGUILight() {
        return this.guiLight;
    }

    public ModelGUILight getGUILight() {
        return this.guiLight == null ? ModelGUILight.SIDE : this.guiLight;
    }

    public Map<ModelDisplay.ModelDisplayPosition, ModelDisplay> getRawDisplay() {
        return this.display;
    }

    public ModelDisplay getDisplay(ModelDisplay.ModelDisplayPosition position) {
        ModelDisplay modelDisplay = this.display.get((Object)position);
        if (modelDisplay != null) {
            return modelDisplay;
        }
        if (position.hasFallback()) {
            return this.display.get((Object)position.getFallback());
        }
        return null;
    }

    public Map<String, String> getTextures() {
        return this.textures;
    }

    public List<ModelElement> getElements() {
        return this.elements;
    }

    public List<ModelOverride> getOverrides() {
        return this.overrides;
    }

    /*
     * WARNING - void declaration
     */
    public BlockModel resolve(boolean post1_8) {
        void var6_8;
        boolean ambientocclusion = this.isAmbientocclusion();
        EnumMap<ModelDisplay.ModelDisplayPosition, ModelDisplay> display = new EnumMap<ModelDisplay.ModelDisplayPosition, ModelDisplay>(ModelDisplay.ModelDisplayPosition.class);
        display.putAll(this.getRawDisplay());
        HashMap<String, String> textures = new HashMap<String, String>(this.getTextures());
        for (Map.Entry entry : textures.entrySet()) {
            String var;
            String mapped;
            String value = (String)entry.getValue();
            if (!value.startsWith("#") || (mapped = (String)textures.get(var = value.substring(1))) == null) continue;
            entry.setValue(mapped);
        }
        ArrayList<ModelElement> elements = new ArrayList<ModelElement>(this.getElements());
        boolean bl = false;
        while (var6_8 < elements.size()) {
            ModelElement element = (ModelElement)elements.get((int)var6_8);
            EnumMap<ModelFace.ModelFaceSide, ModelFace> faces = new EnumMap<ModelFace.ModelFaceSide, ModelFace>(ModelFace.ModelFaceSide.class);
            faces.putAll(element.getFaces());
            for (Map.Entry entry : faces.entrySet()) {
                String var;
                String mapped;
                ModelFace face = (ModelFace)entry.getValue();
                String value = ((ModelFace)entry.getValue()).getTexture();
                if (!value.startsWith("#") || (mapped = (String)textures.get(var = value.substring(1))) == null) continue;
                entry.setValue(face.cloneWithNewTexture(mapped));
            }
            elements.set((int)var6_8, new ModelElement(element.getName(), element.getFrom(), element.getTo(), element.getRotation(), element.isShade(), faces));
            ++var6_8;
        }
        BlockModel blockModel = new BlockModel(this.getManager(), this.getResourceLocation(), this.getRawParent(), ambientocclusion, this.getRawGUILight(), display, textures, elements, this.getOverrides());
        if (post1_8) {
            String newRawParent = blockModel.getRawParent();
            if (newRawParent == null) {
                return blockModel.getManager().getRawBlockModel("minecraft:interactivechatdiscordsrvaddon/block/block").resolve(blockModel, post1_8);
            }
            if (newRawParent.equals("builtin/generated")) {
                return blockModel.getManager().getRawBlockModel("minecraft:interactivechatdiscordsrvaddon/item/generated").resolve(blockModel, post1_8);
            }
        }
        return blockModel;
    }

    /*
     * WARNING - void declaration
     */
    public BlockModel resolve(BlockModel parentModel, boolean post1_8) {
        void var8_10;
        String parent = parentModel.getRawParent();
        ModelGUILight guiLight = this.getRawGUILight();
        if (parentModel.getRawGUILight() != null) {
            guiLight = parentModel.getRawGUILight();
        }
        EnumMap<ModelDisplay.ModelDisplayPosition, ModelDisplay> display = new EnumMap<ModelDisplay.ModelDisplayPosition, ModelDisplay>(ModelDisplay.ModelDisplayPosition.class);
        display.putAll(parentModel.getRawDisplay());
        display.putAll(this.getRawDisplay());
        HashMap<String, String> textures = new HashMap<String, String>();
        textures.putAll(parentModel.getTextures());
        textures.putAll(this.getTextures());
        for (Map.Entry entry : textures.entrySet()) {
            String var;
            String mapped;
            String value = (String)entry.getValue();
            if (!value.startsWith("#") || (mapped = (String)textures.get(var = value.substring(1))) == null) continue;
            entry.setValue(mapped);
        }
        ArrayList<ModelElement> elements = new ArrayList<ModelElement>(this.getElements().isEmpty() ? parentModel.getElements() : this.getElements());
        boolean bl = false;
        while (var8_10 < elements.size()) {
            ModelElement element = (ModelElement)elements.get((int)var8_10);
            EnumMap<ModelFace.ModelFaceSide, ModelFace> faces = new EnumMap<ModelFace.ModelFaceSide, ModelFace>(ModelFace.ModelFaceSide.class);
            faces.putAll(element.getFaces());
            for (Map.Entry entry : faces.entrySet()) {
                String var;
                String mapped;
                ModelFace face = (ModelFace)entry.getValue();
                String value = ((ModelFace)entry.getValue()).getTexture();
                if (!value.startsWith("#") || (mapped = (String)textures.get(var = value.substring(1))) == null) continue;
                entry.setValue(face.cloneWithNewTexture(mapped));
            }
            elements.set((int)var8_10, new ModelElement(element.getName(), element.getFrom(), element.getTo(), element.getRotation(), element.isShade(), faces));
            ++var8_10;
        }
        return new BlockModel(this.getManager(), this.getResourceLocation(), parent, this.isAmbientocclusion(), guiLight, display, textures, elements, parentModel.getOverrides());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockModel model = (BlockModel)o;
        return this.ambientocclusion == model.ambientocclusion && Objects.equals(this.manager, model.manager) && Objects.equals(this.resourceLocation, model.resourceLocation) && Objects.equals(this.parent, model.parent) && this.guiLight == model.guiLight && Objects.equals(this.display, model.display) && Objects.equals(this.textures, model.textures) && Objects.equals(this.elements, model.elements) && Objects.equals(this.overrides, model.overrides);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.manager, this.resourceLocation, this.parent, this.ambientocclusion, this.guiLight, this.display, this.textures, this.elements, this.overrides});
    }
}

