/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.languages;

import com.loohp.interactivechat.libs.org.apache.commons.io.input.BOMInputStream;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechatdiscordsrvaddon.resources.AbstractManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.languages.ILanguageManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.languages.LanguageMeta;
import com.loohp.interactivechatdiscordsrvaddon.resources.languages.TranslateFunction;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LanguageManager
extends AbstractManager
implements ILanguageManager {
    private Map<String, LanguageMeta> languageMeta = new HashMap<String, LanguageMeta>();
    private Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    private List<Consumer<LanguageReloadEvent>> reloadListeners = Collections.synchronizedList(new LinkedList());
    private TranslateFunction translateFunction = LanguageManager.defaultTranslateFunction(this);
    private Supplier<Collection<String>> availableLanguagesSupplier = LanguageManager.defaultAvailableLanguagesSupplier(this);

    public static TranslateFunction defaultTranslateFunction(LanguageManager manager) {
        return (translationKey, language) -> {
            Map<String, String> mapping = manager.translations.get(language);
            if (mapping == null) {
                return translationKey;
            }
            return mapping.getOrDefault(translationKey, translationKey);
        };
    }

    public static Supplier<Collection<String>> defaultAvailableLanguagesSupplier(LanguageManager manager) {
        return () -> manager.translations.keySet();
    }

    public LanguageManager(ResourceManager manager) {
        super(manager);
    }

    @Override
    protected void loadDirectory(String namespace, ResourcePackFile root, Object ... meta) {
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException(root.getAbsolutePath() + " is not a directory.");
        }
        if (meta.length >= 0) {
            try {
                this.languageMeta.putAll((Map)meta[0]);
            }
            catch (Throwable e) {
                new ResourceLoadingException("Invalid meta arguments, Map<? extends String, ? extends LanguageMeta> expected!", e).printStackTrace();
            }
        }
        JSONParser parser = new JSONParser();
        HashMap translations = new HashMap();
        for (ResourcePackFile resourcePackFile : root.listFilesRecursively()) {
            Reader reader;
            String name = resourcePackFile.getName();
            if (!this.manager.isFlattenLegacy() && name.endsWith(".json")) {
                try {
                    reader = new InputStreamReader((InputStream)new BOMInputStream(resourcePackFile.getInputStream()), StandardCharsets.UTF_8);
                    JSONObject json = (JSONObject)parser.parse(reader);
                    ((InputStreamReader)reader).close();
                    HashMap<String, String> mapping = new HashMap<String, String>();
                    for (Object obj : json.keySet()) {
                        try {
                            String key = (String)obj;
                            mapping.put(key, (String)json.get((Object)key));
                        }
                        catch (Exception exception) {}
                    }
                    translations.put(resourcePackFile.getName().substring(0, resourcePackFile.getName().lastIndexOf(".")), mapping);
                }
                catch (Exception e) {
                    new ResourceLoadingException("Unable to load language " + resourcePackFile.getAbsolutePath(), e).printStackTrace();
                }
                continue;
            }
            if (!this.manager.isFlattenLegacy() || !name.endsWith(".lang")) continue;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(resourcePackFile.getInputStream()), StandardCharsets.UTF_8));
                try {
                    String line;
                    HashMap<String, String> mapping = new HashMap<String, String>();
                    while ((line = ((BufferedReader)reader).readLine()) != null) {
                        int separator = line.indexOf("=");
                        if (separator < 0) continue;
                        mapping.put(line.substring(0, separator), line.substring(separator + 1));
                    }
                    translations.put(resourcePackFile.getName().substring(0, resourcePackFile.getName().lastIndexOf(".")), mapping);
                }
                finally {
                    ((BufferedReader)reader).close();
                }
            }
            catch (Exception e) {
                new ResourceLoadingException("Unable to load language " + resourcePackFile.getAbsolutePath(), e).printStackTrace();
            }
        }
        for (Map.Entry entry : translations.entrySet()) {
            String key = (String)entry.getKey();
            Map<String, String> mapping = this.translations.get(key);
            if (mapping == null) {
                this.translations.put(key, (Map)entry.getValue());
                continue;
            }
            mapping.putAll((Map)entry.getValue());
        }
    }

    @Override
    protected void filterResources(Pattern namespace, Pattern path) {
        Iterator<String> itr = this.translations.keySet().iterator();
        while (itr.hasNext()) {
            String namespacedKey = itr.next();
            String assetNamespace = namespacedKey.substring(0, namespacedKey.indexOf(":"));
            String assetKey = namespacedKey.substring(namespacedKey.indexOf(":") + 1);
            if (!assetKey.contains(".")) {
                assetKey = assetKey + (this.manager.isFlattenLegacy() ? ".lang" : ".json");
            }
            if (!namespace.matcher(assetNamespace).matches() || !path.matcher(assetKey).matches()) continue;
            itr.remove();
        }
    }

    public void registerReloadListener(Consumer<LanguageReloadEvent> listener) {
        this.reloadListeners.add(listener);
    }

    public void unregisterReloadListener(Consumer<LanguageReloadEvent> listener) {
        this.reloadListeners.removeIf(each -> each.equals(listener));
    }

    public void clearTranslateFunction() {
        this.translateFunction = LanguageManager.defaultTranslateFunction(this);
        this.reload();
    }

    public TranslateFunction getTranslateFunction() {
        return this.translateFunction;
    }

    public void setTranslateFunction(TranslateFunction translateFunction) {
        this.translateFunction = translateFunction;
        this.reload();
    }

    @Override
    public String applyTranslations(String str, String language) {
        return this.translateFunction.apply(str, language);
    }

    @Override
    public List<String> getAvailableLanguages() {
        return this.availableLanguagesSupplier.get().stream().sorted().collect(Collectors.toList());
    }

    public void setAvailableLanguagesSupplier(Supplier<Collection<String>> availableLanguagesSupplier) {
        this.availableLanguagesSupplier = availableLanguagesSupplier;
        this.reload();
    }

    public void resetAvailableLanguagesSupplier() {
        this.availableLanguagesSupplier = LanguageManager.defaultAvailableLanguagesSupplier(this);
        this.reload();
    }

    public Map<String, LanguageMeta> getAllLanguageMeta() {
        return Collections.unmodifiableMap(this.languageMeta);
    }

    @Override
    public LanguageMeta getLanguageMeta(String language) {
        return this.languageMeta.get(language);
    }

    @Override
    protected void reload() {
        HashMap<String, Map<String, String>> outerMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : this.translations.entrySet()) {
            outerMap.put(entry.getKey(), Collections.unmodifiableMap(entry.getValue()));
        }
        LanguageReloadEvent event = new LanguageReloadEvent(this, Collections.unmodifiableMap(outerMap));
        this.reloadListeners.forEach(each -> each.accept(event));
    }

    public static class LanguageReloadEvent {
        private LanguageManager languageManager;
        private Map<String, Map<String, String>> translations;

        public LanguageReloadEvent(LanguageManager languageManager, Map<String, Map<String, String>> translations) {
            this.languageManager = languageManager;
            this.translations = translations;
        }

        public LanguageManager getLanguageManager() {
            return this.languageManager;
        }

        public Map<String, Map<String, String>> getTranslations() {
            return this.translations;
        }
    }
}

