/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.fonts;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextDecoration;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontProvider;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MinecraftFont;
import com.loohp.interactivechatdiscordsrvaddon.utils.ComponentStringUtils;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TrueTypeFont
extends MinecraftFont {
    public static final String TYPE_KEY = "ttf";
    private static final BufferedImage INTERNAL_IMAGE = new BufferedImage(1, 1, 2);
    private String resourceLocation;
    private AffineTransform shift;
    private float size;
    private float oversample;
    private String exclude;
    private IntSet displayableCharacters;
    private Graphics2D internalGraphics;
    private Font font;

    public TrueTypeFont(ResourceManager manager, FontProvider provider, String resourceLocation, AffineTransform shift, float size, float oversample, String exclude) {
        super(manager, provider);
        this.resourceLocation = resourceLocation;
        this.shift = shift;
        this.size = size;
        this.oversample = oversample;
        this.exclude = exclude;
        this.internalGraphics = null;
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        catch (Throwable e) {
            throw new ResourceLoadingException("No fonts provided by the JVM or the Operating System!\nCheck the Q&A section in https://www.spigotmc.org/resources/83917/ for more information", e);
        }
    }

    @Override
    public void reloadFonts() {
        this.displayableCharacters = IntSets.emptySet();
        if (this.internalGraphics != null) {
            this.internalGraphics.dispose();
            this.internalGraphics = null;
        }
        try {
            this.font = Font.createFont(0, this.manager.getFontManager().getFontResource(this.resourceLocation).getFile().getInputStream()).deriveFont(this.shift);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(this.font);
            this.internalGraphics = INTERNAL_IMAGE.createGraphics();
            this.internalGraphics.setFont(this.font.deriveFont(this.size));
            IntLinkedOpenHashSet displayableCharacters = new IntLinkedOpenHashSet();
            for (int i = 0; i < 1112064; ++i) {
                String character = new String(Character.toChars(i));
                if (this.exclude.contains(character) || !this.canDisplayCharacter(character)) continue;
                displayableCharacters.add(i);
            }
            this.displayableCharacters = IntSets.unmodifiable((IntSet)displayableCharacters);
        }
        catch (FontFormatException | IOException e) {
            if (this.provider == null) {
                throw new ResourceLoadingException("Unable to load TrueTypeFont provider at " + this.resourceLocation, e);
            }
            throw new ResourceLoadingException("Unable to load TrueTypeFont provider at " + this.resourceLocation + " (Defined in " + this.provider.getNamespacedKey() + ")", e);
        }
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public AffineTransform getShift() {
        return this.shift;
    }

    public float getSize() {
        return this.size;
    }

    public float getOversample() {
        return this.oversample;
    }

    public String getExclude() {
        return this.exclude;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public boolean canDisplayCharacter(String character) {
        if (this.internalGraphics == null) {
            return false;
        }
        if (this.exclude.contains(character)) {
            return false;
        }
        return this.font.canDisplayUpTo(character) < 0 && this.internalGraphics.getFontMetrics().stringWidth(character) != 0;
    }

    @Override
    public IntSet getDisplayableCharacters() {
        return this.displayableCharacters;
    }

    @Override
    public MinecraftFont.FontRenderResult printCharacter(BufferedImage image, String character, int x, int y, float fontSize, int lastItalicExtraWidth, TextColor color, List<TextDecoration> decorations) {
        int extraWidth;
        int newW;
        float scale = fontSize / 16.0f;
        fontSize -= 13.0f - this.size;
        decorations = TrueTypeFont.sortDecorations(decorations);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setFont(this.font.deriveFont(this.size));
        int w = g.getFontMetrics().stringWidth(character);
        Font fontToPrint = this.font.deriveFont(fontSize);
        BufferedImage[] magicCharImages = null;
        boolean bold = false;
        boolean italic = false;
        block7: for (TextDecoration decoration : decorations) {
            switch (decoration) {
                case OBFUSCATED: {
                    magicCharImages = new BufferedImage[3];
                    for (int i = 0; i < magicCharImages.length; ++i) {
                        String magicCharacter = ComponentStringUtils.toMagic(this.provider, character);
                        magicCharImages[i] = this.provider.forCharacter(magicCharacter).getCharacterImage(magicCharacter, fontSize, color).orElse(new BufferedImage(1, 1, 2));
                    }
                    continue block7;
                }
                case BOLD: {
                    bold = true;
                    break;
                }
                case ITALIC: {
                    fontToPrint = fontToPrint.deriveFont(2);
                    italic = true;
                    break;
                }
                case STRIKETHROUGH: {
                    Map<TextAttribute, ?> attributes = fontToPrint.getAttributes();
                    attributes.put(TextAttribute.STRIKETHROUGH, true);
                    fontToPrint = new Font(attributes);
                    break;
                }
                case UNDERLINED: {
                    Map<TextAttribute, ?> attributes = fontToPrint.getAttributes();
                    attributes.put(TextAttribute.UNDERLINE, true);
                    fontToPrint = new Font(attributes);
                    break;
                }
            }
        }
        g.setColor(new Color(color.value()));
        g.setFont(fontToPrint);
        int height = g.getFontMetrics().getHeight() / 2;
        int finalWidth = newW = g.getFontMetrics().stringWidth(character);
        int n = extraWidth = italic ? 0 : lastItalicExtraWidth;
        if (magicCharImages == null) {
            g.drawString(character, x, y + height);
            if (bold) {
                g.drawString(character, (float)x + scale * 2.0f + (float)extraWidth, (float)(y + height));
                finalWidth = (int)((float)finalWidth + scale * 2.0f);
            }
        } else {
            for (BufferedImage magicCharImage : magicCharImages) {
                g.drawImage(magicCharImage, x + extraWidth, y, newW, height, null);
            }
            if (bold) {
                for (BufferedImage magicCharImage : magicCharImages) {
                    g.drawImage(magicCharImage, (int)((float)x + scale * 2.0f) + extraWidth, y, newW, height, null);
                }
                finalWidth = (int)((float)finalWidth + scale * 2.0f);
            }
        }
        g.dispose();
        float spaceWidth = (float)newW / (float)w;
        return new MinecraftFont.FontRenderResult(image, finalWidth + extraWidth, height + (int)Math.round(this.shift.getTranslateY()), (int)Math.round((double)spaceWidth + this.shift.getTranslateX()), 0);
    }

    @Override
    public Optional<BufferedImage> getCharacterImage(String character, float fontSize, TextColor color) {
        BufferedImage image = new BufferedImage((int)(10.0f * fontSize), (int)(10.0f * fontSize), 2);
        Graphics2D g = image.createGraphics();
        Font fontToPrint = this.font.deriveFont(fontSize);
        g.setColor(new Color(color.value()));
        g.setFont(fontToPrint);
        int height = g.getFontMetrics().getHeight() / 2;
        g.drawString(character, 0, height);
        image = ImageUtils.copyAndGetSubImage(image, 0, 0, g.getFontMetrics().stringWidth(character), height);
        g.dispose();
        return Optional.of(image);
    }

    @Override
    public int getCharacterWidth(String character) {
        return this.internalGraphics.getFontMetrics().stringWidth(character);
    }
}

