/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.fonts;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextDecoration;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontProvider;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MinecraftFont;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Optional;

public class SpaceFont
extends MinecraftFont {
    public static final String TYPE_KEY = "space";
    public static final int DEFAULT_HEIGHT = 8;
    private Int2IntMap charAdvances;

    public static SpaceFont generateLegacyHardcodedInstance(ResourceManager manager, FontProvider provider) {
        return new SpaceFont(manager, provider, Int2IntMaps.singleton((int)32, (int)4));
    }

    public SpaceFont(ResourceManager manager, FontProvider provider, Int2IntMap charAdvances) {
        super(manager, provider);
        this.charAdvances = charAdvances;
    }

    @Override
    public void reloadFonts() {
    }

    @Override
    public boolean canDisplayCharacter(String character) {
        return this.charAdvances.containsKey(character.codePointAt(0));
    }

    @Override
    public MinecraftFont.FontRenderResult printCharacter(BufferedImage image, String character, int x, int y, float fontSize, int lastItalicExtraWidth, TextColor color, List<TextDecoration> decorations) {
        decorations = SpaceFont.sortDecorations(decorations);
        int advance = (int)Math.round((double)this.charAdvances.get(character.codePointAt(0)) * 0.75);
        if (advance != 0) {
            int sign = advance < 0 ? -1 : 1;
            int originalW = advance = Math.abs(advance);
            int w = (int)Math.round((double)originalW * ((double)Math.round(fontSize) / 8.0));
            int h = Math.round(fontSize);
            int beforeTransformW = w;
            int pixelSize = Math.round((float)beforeTransformW / (float)originalW);
            int strikeSize = (int)(fontSize / 8.0f);
            int boldSize = (int)((double)fontSize / 16.0 * 2.0);
            int italicExtraWidth = 0;
            boolean italic = false;
            for (TextDecoration decoration : decorations) {
                switch (decoration) {
                    case BOLD: {
                        w += boldSize - 1;
                        break;
                    }
                    case ITALIC: {
                        italicExtraWidth = (int)Math.round(0.2857142857142857 * (double)h);
                        italic = true;
                        break;
                    }
                }
            }
            int extraWidth = italic ? 0 : lastItalicExtraWidth;
            return new MinecraftFont.FontRenderResult(image, w * sign + extraWidth, h, pixelSize, italicExtraWidth);
        }
        return new MinecraftFont.FontRenderResult(image, 0, 0, 0, lastItalicExtraWidth);
    }

    @Override
    public Optional<BufferedImage> getCharacterImage(String character, float fontSize, TextColor color) {
        int advance = (int)Math.round((double)this.charAdvances.get(character.codePointAt(0)) * 0.75);
        if (advance == 0) {
            return Optional.empty();
        }
        BufferedImage charImage = new BufferedImage(Math.abs(advance), 8, 2);
        charImage = ImageUtils.resizeImageFillHeight(charImage, Math.round(fontSize));
        return Optional.of(charImage);
    }

    @Override
    public int getCharacterWidth(String character) {
        return this.charAdvances.get(character.codePointAt(0)) - 1;
    }

    @Override
    public IntSet getDisplayableCharacters() {
        return IntSets.unmodifiable((IntSet)this.charAdvances.keySet());
    }
}

