/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.fonts;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextDecoration;
import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.BitmapFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontProvider;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.IFontManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.LegacyUnicodeFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.SpaceFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.TrueTypeFont;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class MinecraftFont {
    public static final double ITALIC_SHEAR_X = -0.2857142857142857;
    public static final int OBFUSCATE_OVERLAP_COUNT = 3;
    private static final List<TextDecoration> DECORATIONS_ORDER = new ArrayList<TextDecoration>();
    protected ResourceManager manager;
    protected FontProvider provider;

    public static List<TextDecoration> sortDecorations(List<TextDecoration> decorations) {
        ArrayList<TextDecoration> list = new ArrayList<TextDecoration>(DECORATIONS_ORDER.size());
        for (TextDecoration decoration : DECORATIONS_ORDER) {
            if (!decorations.contains(decoration)) continue;
            list.add(decoration);
        }
        return list;
    }

    public static MinecraftFont fromJson(ResourceManager manager, IFontManager fontManager, FontProvider provider, JSONObject fontJson) throws Exception {
        String typeStr;
        switch (typeStr = fontJson.get((Object)"type").toString()) {
            case "space": {
                Int2IntOpenHashMap charAdvances = new Int2IntOpenHashMap();
                JSONObject advancesJson = (JSONObject)fontJson.get((Object)"advances");
                for (Object obj1 : advancesJson.keySet()) {
                    String character = (String)obj1;
                    int advance = ((Number)advancesJson.get((Object)character)).intValue();
                    charAdvances.put(character.codePointAt(0), advance);
                }
                return new SpaceFont(manager, provider, (Int2IntMap)charAdvances);
            }
            case "bitmap": {
                String resourceLocation = fontJson.get((Object)"file").toString();
                int height = ((Number)fontJson.getOrDefault((Object)"height", (Object)8)).intValue();
                int ascent = ((Number)fontJson.get((Object)"ascent")).intValue();
                List<String> chars = ((JSONArray)fontJson.get((Object)"chars")).stream().map(each -> each.toString()).collect(Collectors.toList());
                return new BitmapFont(manager, provider, resourceLocation, height, ascent, chars);
            }
            case "legacy_unicode": {
                String template = fontJson.get((Object)"template").toString();
                DataInputStream sizesInput = new DataInputStream(new BufferedInputStream(fontManager.getFontResource(fontJson.get((Object)"sizes").toString()).getFile().getInputStream()));
                Int2ObjectOpenHashMap sizes = new Int2ObjectOpenHashMap();
                int i = 0;
                while (true) {
                    try {
                        byte b = sizesInput.readByte();
                        byte start = (byte)(b >> 4 & 0xF);
                        byte end = (byte)(b & 0xF);
                        sizes.put(i, (Object)new LegacyUnicodeFont.GlyphSize(start, end));
                    }
                    catch (EOFException e) {
                        break;
                    }
                    ++i;
                }
                sizesInput.close();
                return new LegacyUnicodeFont(manager, provider, (Int2ObjectMap<LegacyUnicodeFont.GlyphSize>)sizes, template);
            }
            case "ttf": {
                String resourceLocation = fontJson.get((Object)"file").toString();
                JSONArray shiftArray = (JSONArray)fontJson.get((Object)"shift");
                float leftShift = ((Number)shiftArray.get(0)).floatValue();
                float downShift = ((Number)shiftArray.get(1)).floatValue();
                AffineTransform shift = AffineTransform.getTranslateInstance(-leftShift, downShift);
                float size = ((Number)fontJson.get((Object)"size")).floatValue();
                float oversample = ((Number)fontJson.get((Object)"oversample")).floatValue();
                String skip = fontJson.getOrDefault((Object)"skip", (Object)"").toString();
                return new TrueTypeFont(manager, provider, resourceLocation, shift, size, oversample, skip);
            }
        }
        throw new ResourceLoadingException("Unknown font type \"" + typeStr + "\"");
    }

    public MinecraftFont(ResourceManager manager, FontProvider provider) {
        this.manager = manager;
        this.provider = provider;
    }

    public ResourceManager getManager() {
        return this.manager;
    }

    public FontProvider getProvider() {
        return this.provider;
    }

    protected void setProvider(FontProvider provider) {
        this.provider = provider;
    }

    public abstract boolean canDisplayCharacter(String var1);

    public abstract FontRenderResult printCharacter(BufferedImage var1, String var2, int var3, int var4, float var5, int var6, TextColor var7, List<TextDecoration> var8);

    public abstract Optional<BufferedImage> getCharacterImage(String var1, float var2, TextColor var3);

    public abstract int getCharacterWidth(String var1);

    public abstract void reloadFonts();

    public abstract IntSet getDisplayableCharacters();

    static {
        DECORATIONS_ORDER.add(TextDecoration.OBFUSCATED);
        DECORATIONS_ORDER.add(TextDecoration.BOLD);
        DECORATIONS_ORDER.add(TextDecoration.ITALIC);
        DECORATIONS_ORDER.add(TextDecoration.STRIKETHROUGH);
        DECORATIONS_ORDER.add(TextDecoration.UNDERLINED);
    }

    public static class FontRenderResult {
        private BufferedImage image;
        private int width;
        private int height;
        private int spaceWidth;
        private int italicExtraWidth;

        public FontRenderResult(BufferedImage image, int width, int height, int spaceWidth, int italicExtraWidth) {
            this.image = image;
            this.width = width;
            this.height = height;
            this.spaceWidth = spaceWidth;
            this.italicExtraWidth = italicExtraWidth;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getSpaceWidth() {
            return this.spaceWidth;
        }

        public int getItalicExtraWidth() {
            return this.italicExtraWidth;
        }
    }
}

