/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.fonts;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextDecoration;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontProvider;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontTextureResource;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MinecraftFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.GeneratedTextureResource;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import com.loohp.interactivechatdiscordsrvaddon.utils.ComponentStringUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Optional;

public class LegacyUnicodeFont
extends MinecraftFont {
    public static final String TYPE_KEY = "legacy_unicode";
    public static final double ITALIC_SHEAR_X = -0.2857142857142857;
    protected Optional<FontTextureResource> missingCharacter;
    private Int2ObjectMap<Optional<FontTextureResource>> charImages;
    private Int2ObjectMap<GlyphSize> sizes;
    private String template;

    public static String getSectionSubstring(int i) {
        return String.format("%04x", i).substring(0, 2);
    }

    public LegacyUnicodeFont(ResourceManager manager, FontProvider provider, Int2ObjectMap<GlyphSize> sizes, String template) {
        super(manager, provider);
        this.sizes = sizes;
        this.template = template;
        BufferedImage missingCharacter = new BufferedImage(5, 8, 2);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 5; ++j) {
                boolean flag = j == 0 || j + 1 == 5 || i == 0 || i + 1 == 8;
                missingCharacter.setRGB(j, i, flag ? -1 : 0);
            }
        }
        this.missingCharacter = Optional.of(new FontTextureResource(new GeneratedTextureResource(manager, missingCharacter)));
    }

    @Override
    public void reloadFonts() {
        this.charImages = new Int2ObjectOpenHashMap();
        if (!this.hasTemplate()) {
            return;
        }
        for (int i = 0; i < 65536; i += 256) {
            TextureResource resource = this.manager.getFontManager().getFontResource(this.template.replaceFirst("%s", LegacyUnicodeFont.getSectionSubstring(i)));
            if (resource == null) continue;
            BufferedImage fontBaseImage = resource.getTexture(256, 256);
            int u = 0;
            for (int y = 0; y < 256; y += 16) {
                for (int x = 0; x < 256; x += 16) {
                    int character = i + u;
                    if (character != 0) {
                        GlyphSize size = (GlyphSize)this.sizes.get(character);
                        if (size.getEnd() - size.getStart() > 0) {
                            this.charImages.put(character, Optional.of(new FontTextureResource(resource, 256, 256, x + size.getStart(), y, size.getEnd() - size.getStart() + 1, 16)));
                        } else {
                            this.charImages.put(character, Optional.empty());
                        }
                    }
                    ++u;
                }
            }
        }
    }

    public IntSet getCharacterSets() {
        return this.charImages.keySet();
    }

    public Int2ObjectMap<GlyphSize> getSizes() {
        return this.sizes;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public String getTemplate() {
        return this.template;
    }

    @Override
    public boolean canDisplayCharacter(String character) {
        return this.charImages.containsKey(character.codePointAt(0));
    }

    @Override
    public MinecraftFont.FontRenderResult printCharacter(BufferedImage image, String character, int x, int y, float fontSize, int lastItalicExtraWidth, TextColor color, List<TextDecoration> decorations) {
        decorations = LegacyUnicodeFont.sortDecorations(decorations);
        Color awtColor = new Color(color.value());
        Optional<FontTextureResource> optCharImage = (Optional<FontTextureResource>)this.charImages.get(character.codePointAt(0));
        if (optCharImage == null) {
            optCharImage = this.missingCharacter;
        }
        if (optCharImage.isPresent()) {
            BufferedImage charImage = optCharImage.get().getFontImage();
            int originalW = charImage.getWidth();
            charImage = ImageUtils.resizeImageFillHeight(charImage, (int)Math.floor(fontSize));
            int w = charImage.getWidth();
            int h = charImage.getHeight();
            charImage = ImageUtils.multiply(charImage, ImageUtils.changeColorTo(ImageUtils.copyImage(charImage), awtColor));
            int beforeTransformW = w;
            double accuratePixelSize = (double)beforeTransformW / (double)originalW;
            int pixelSize = (int)Math.round(accuratePixelSize);
            int strikeSize = (int)(fontSize / 8.0f);
            int boldSize = (int)((double)fontSize / 16.0 * 2.0);
            int italicExtraWidth = 0;
            boolean italic = false;
            boolean underlineStrikethroughExpanded = false;
            for (TextDecoration decoration : decorations) {
                switch (decoration) {
                    case OBFUSCATED: {
                        charImage = new BufferedImage(charImage.getWidth(), charImage.getHeight(), 2);
                        Graphics2D g = charImage.createGraphics();
                        for (int i = 0; i < 3; ++i) {
                            String magicCharacter = ComponentStringUtils.toMagic(this.provider, character);
                            BufferedImage magicImage = this.provider.forCharacter(magicCharacter).getCharacterImage(magicCharacter, fontSize, color).orElse(new BufferedImage(1, 1, 2));
                            g.drawImage(magicImage, 0, 0, charImage.getWidth(), charImage.getHeight(), null);
                        }
                        g.dispose();
                        break;
                    }
                    case BOLD: {
                        BufferedImage boldImage = new BufferedImage(charImage.getWidth() + 2, charImage.getHeight(), 2);
                        for (int x0 = 0; x0 < charImage.getWidth(); ++x0) {
                            for (int y0 = 0; y0 < charImage.getHeight(); ++y0) {
                                int pixelColor = charImage.getRGB(x0, y0);
                                int alpha = ColorUtils.getAlpha(pixelColor);
                                if (alpha == 0) continue;
                                for (int i = 0; i < boldSize; ++i) {
                                    boldImage.setRGB(x0 + i, y0, pixelColor);
                                }
                            }
                        }
                        charImage = boldImage;
                        w += boldSize - 1;
                        break;
                    }
                    case ITALIC: {
                        int extraWidth = (int)((double)charImage.getHeight() * 0.2857142857142857);
                        BufferedImage italicImage = new BufferedImage(charImage.getWidth() + extraWidth * 2, charImage.getHeight(), 2);
                        Graphics2D g = italicImage.createGraphics();
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g.transform(AffineTransform.getShearInstance(-0.2857142857142857, 0.0));
                        g.drawImage((Image)charImage, extraWidth, 0, null);
                        g.dispose();
                        charImage = italicImage;
                        italicExtraWidth = (int)Math.round(0.2857142857142857 * (double)h);
                        italic = true;
                        break;
                    }
                    case STRIKETHROUGH: {
                        charImage = ImageUtils.expandCenterAligned(charImage, 0, 0, 0, underlineStrikethroughExpanded ? 0 : pixelSize + 1);
                        underlineStrikethroughExpanded = true;
                        Graphics2D g = charImage.createGraphics();
                        g.setColor(awtColor);
                        g.fillRect(0, (int)(fontSize / 2.0f), w + pixelSize + 1, strikeSize);
                        g.dispose();
                        break;
                    }
                    case UNDERLINED: {
                        charImage = ImageUtils.expandCenterAligned(charImage, 0, strikeSize * 2, 0, underlineStrikethroughExpanded ? 0 : pixelSize + 1);
                        underlineStrikethroughExpanded = true;
                        Graphics2D g = charImage.createGraphics();
                        g.setColor(awtColor);
                        g.fillRect(0, (int)fontSize, w + pixelSize + 1, strikeSize);
                        g.dispose();
                        break;
                    }
                }
            }
            Graphics2D g = image.createGraphics();
            int extraWidth = italic ? 0 : lastItalicExtraWidth;
            g.drawImage((Image)charImage, x + extraWidth, y, null);
            g.dispose();
            return new MinecraftFont.FontRenderResult(image, w + extraWidth, h, (int)Math.floor(accuratePixelSize + 1.0), italicExtraWidth);
        }
        return new MinecraftFont.FontRenderResult(image, 0, 0, 0, lastItalicExtraWidth);
    }

    @Override
    public Optional<BufferedImage> getCharacterImage(String character, float fontSize, TextColor color) {
        Color awtColor = new Color(color.value());
        Optional<FontTextureResource> optCharImage = (Optional<FontTextureResource>)this.charImages.get(character.codePointAt(0));
        if (optCharImage == null) {
            optCharImage = this.missingCharacter;
        }
        if (optCharImage.isPresent()) {
            BufferedImage charImage = optCharImage.get().getFontImage();
            charImage = ImageUtils.resizeImageFillHeight(charImage, Math.round(fontSize));
            charImage = ImageUtils.multiply(charImage, ImageUtils.changeColorTo(ImageUtils.copyImage(charImage), awtColor));
            return Optional.of(charImage);
        }
        return Optional.empty();
    }

    @Override
    public int getCharacterWidth(String character) {
        GlyphSize size = (GlyphSize)this.sizes.get(character.codePointAt(0));
        return size.getEnd() - size.getStart() + 1;
    }

    @Override
    public IntSet getDisplayableCharacters() {
        return IntSets.unmodifiable((IntSet)this.charImages.keySet());
    }

    public static class GlyphSize {
        private byte start;
        private byte end;

        public GlyphSize(byte start, byte end) {
            this.start = start;
            this.end = end;
        }

        public byte getStart() {
            return this.start;
        }

        public byte getEnd() {
            return this.end;
        }
    }
}

