/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.fonts;

import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ICacheManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;

public class FontTextureResource {
    private static long CACHE_TIME = 0L;
    private TextureResource resource;
    private char resourceWidth;
    private char resourceHeight;
    private char x;
    private char y;
    private char width;
    private char height;

    public static long getCacheTime() {
        return CACHE_TIME;
    }

    public static void setCacheTime(long cacheTime) {
        CACHE_TIME = cacheTime;
    }

    public FontTextureResource(TextureResource resource, char resourceWidth, char resourceHeight, char x, char y, char width, char height) {
        this.resource = resource;
        this.resourceWidth = resourceWidth;
        this.resourceHeight = resourceHeight;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public FontTextureResource(TextureResource resource, int resourceWidth, int resourceHeight, int x, int y, int width, int height) {
        this(resource, (char)resourceWidth, (char)resourceHeight, (char)x, (char)y, (char)width, (char)height);
    }

    public FontTextureResource(TextureResource resource, int x, int y, int width, int height) {
        this(resource, 0, 0, x, y, width, height);
    }

    public FontTextureResource(TextureResource resource) {
        this(resource, 0, 0, 0, 0, 0, 0);
    }

    public BufferedImage getFontImage() {
        Reference<BufferedImage> internalReference;
        BufferedImage internal;
        BufferedImage image = this.resourceWidth < '\u0001' || this.resourceHeight < '\u0001' ? this.resource.getTexture() : this.resource.getTexture(this.resourceWidth, this.resourceHeight);
        if (CACHE_TIME > 0L && (internal = (internalReference = this.resource.getUnsafe().getTextureReference()).get()) != null) {
            String hash = ImageUtils.hash(internal);
            if (this.resource.getManager().getManager().getResourceRegistry("CacheManager", ICacheManager.class).getCache(hash) == null) {
                this.resource.getManager().getManager().getResourceRegistry("CacheManager", ICacheManager.class).putCache(hash, internal);
            }
        }
        if (this.width < '\u0001' || this.height < '\u0001') {
            return image;
        }
        return image.getSubimage(this.x, this.y, this.width, this.height);
    }

    public TextureResource getResource() {
        return this.resource;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

