/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.fonts;

import com.loohp.interactivechat.libs.org.apache.commons.text.StringEscapeUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MinecraftFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MissingFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.SpaceFont;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FontProvider {
    private ResourceManager manager;
    private String key;
    private List<MinecraftFont> providers;
    private Int2ObjectMap<IntList> displayableCharactersByWidth;

    public FontProvider(ResourceManager manager, String key, List<MinecraftFont> providers) {
        this.manager = manager;
        this.key = key;
        this.providers = new ArrayList<MinecraftFont>(providers);
    }

    public void prependProviders(List<MinecraftFont> newProviders) {
        this.providers.addAll(0, newProviders);
    }

    public String getNamespacedKey() {
        return this.key;
    }

    public List<MinecraftFont> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public Int2ObjectMap<IntList> getDisplayableCharactersByWidth() {
        return Int2ObjectMaps.unmodifiable(this.displayableCharactersByWidth);
    }

    public void reloadFonts() {
        int i = 0;
        if (this.manager.isFontLegacy() && (this.providers.isEmpty() || !(this.providers.get(0) instanceof SpaceFont))) {
            this.providers.add(0, SpaceFont.generateLegacyHardcodedInstance(this.manager, this));
            --i;
        }
        if (this.providers.isEmpty() || !(this.providers.get(this.providers.size() - 1) instanceof MissingFont)) {
            this.providers.add(new MissingFont(this.manager, this));
        }
        Iterator<MinecraftFont> itr = this.providers.iterator();
        while (itr.hasNext()) {
            MinecraftFont font = itr.next();
            try {
                font.reloadFonts();
            }
            catch (Exception e) {
                new ResourceLoadingException("Unable to load " + font.getClass().getSimpleName() + " provider " + i + " in " + this.key, e).printStackTrace();
                itr.remove();
            }
            ++i;
        }
        IntOpenHashSet set = new IntOpenHashSet();
        Int2ObjectOpenHashMap displayableCharactersByWidth = new Int2ObjectOpenHashMap();
        for (MinecraftFont font : this.providers) {
            IntIterator intIterator = font.getDisplayableCharacters().iterator();
            while (intIterator.hasNext()) {
                int codePoint = (Integer)intIterator.next();
                if (set.contains(codePoint)) continue;
                int width = font.getCharacterWidth(new String(Character.toChars(codePoint)));
                IntList list = (IntList)displayableCharactersByWidth.get(width);
                if (list == null) {
                    list = new IntArrayList();
                    displayableCharactersByWidth.put(width, (Object)list);
                }
                list.add(codePoint);
                set.add(codePoint);
            }
        }
        for (Int2ObjectMap.Entry entry : displayableCharactersByWidth.int2ObjectEntrySet()) {
            entry.setValue((Object)IntLists.unmodifiable((IntList)((IntList)entry.getValue())));
        }
        this.displayableCharactersByWidth = displayableCharactersByWidth;
    }

    public MinecraftFont forCharacterOrNull(String character) {
        for (MinecraftFont font : this.providers) {
            if (!font.canDisplayCharacter(character)) continue;
            return font;
        }
        return null;
    }

    public MinecraftFont forCharacter(String character) {
        MinecraftFont font = this.forCharacterOrNull(character);
        if (font != null) {
            return font;
        }
        throw new ResourceLoadingException("No font provider can display the character \"" + character + "\" (" + StringEscapeUtils.escapeJava((String)character) + ") for the font \"" + this.key + "\", this is likely due to an issue with your resource pack setup.");
    }
}

