/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.fonts;

import com.loohp.interactivechat.libs.net.kyori.adventure.key.Key;
import com.loohp.interactivechat.libs.org.apache.commons.io.input.BOMInputStream;
import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechatdiscordsrvaddon.resources.AbstractManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontProvider;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.IFontManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MinecraftFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.GeneratedTextureResource;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class FontManager
extends AbstractManager
implements IFontManager {
    public static final Key DEFAULT_FONT = Key.key((String)"minecraft:default");
    public static final Key UNIFORM_FONT = Key.key((String)"minecraft:uniform");
    private Key defaultKey = DEFAULT_FONT;
    private Map<String, FontProvider> fonts = new HashMap<String, FontProvider>();
    private Map<String, Map<String, ResourcePackFile>> files = new HashMap<String, Map<String, ResourcePackFile>>();

    public FontManager(ResourceManager manager) {
        super(manager);
    }

    @Override
    protected void loadDirectory(String namespace, ResourcePackFile root, Object ... meta) {
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException(root.getAbsolutePath() + " is not a directory.");
        }
        Map<String, ResourcePackFile> fileList = this.files.get(namespace);
        if (fileList == null) {
            fileList = new HashMap<String, ResourcePackFile>();
            this.files.put(namespace, fileList);
        }
        JSONParser parser = new JSONParser();
        HashMap<String, FontProvider> fonts = new HashMap<String, FontProvider>(this.fonts);
        Collection<ResourcePackFile> files = root.listFilesRecursively();
        for (ResourcePackFile file : files) {
            fileList.put(file.getName(), file);
        }
        for (ResourcePackFile file : files) {
            if (!file.getName().endsWith(".json")) continue;
            try {
                String key = namespace + ":" + file.getName();
                key = key.substring(0, key.lastIndexOf("."));
                InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
                JSONObject rootJson = (JSONObject)parser.parse((Reader)reader);
                reader.close();
                ArrayList<MinecraftFont> providedFonts = new ArrayList<MinecraftFont>();
                int index = -1;
                for (Object obj : (JSONArray)rootJson.get((Object)"providers")) {
                    ++index;
                    JSONObject fontJson = (JSONObject)obj;
                    try {
                        MinecraftFont minecraftFont = MinecraftFont.fromJson(this.manager, this, null, fontJson);
                        providedFonts.add(minecraftFont);
                    }
                    catch (Exception e) {
                        new ResourceLoadingException("Unable to load font provider " + index + " in " + file.getAbsolutePath(), e).printStackTrace();
                    }
                }
                FontProvider existingProvider = (FontProvider)fonts.get(key);
                if (existingProvider == null) {
                    FontProvider provider = new FontProvider(this.manager, key, providedFonts);
                    for (MinecraftFont mcFont : provider.getProviders()) {
                        mcFont.setProvider(provider);
                    }
                    fonts.put(key, provider);
                    continue;
                }
                for (MinecraftFont mcFont : providedFonts) {
                    mcFont.setProvider(existingProvider);
                }
                existingProvider.prependProviders(providedFonts);
            }
            catch (Exception e) {
                new ResourceLoadingException("Unable to load font " + file.getAbsolutePath(), e).printStackTrace();
            }
        }
        this.fonts.clear();
        this.fonts.putAll(fonts);
    }

    @Override
    protected void filterResources(Pattern namespace, Pattern path) {
        Iterator<String> itr = this.fonts.keySet().iterator();
        while (itr.hasNext()) {
            String namespacedKey = itr.next();
            String assetNamespace = namespacedKey.substring(0, namespacedKey.indexOf(":"));
            String assetKey = namespacedKey.substring(namespacedKey.indexOf(":") + 1);
            if (!assetKey.contains(".")) {
                assetKey = assetKey + ".json";
            }
            if (!namespace.matcher(assetNamespace).matches() || !path.matcher(assetKey).matches()) continue;
            itr.remove();
        }
        for (Map.Entry<String, Map<String, ResourcePackFile>> entry : this.files.entrySet()) {
            String assetNamespace = entry.getKey();
            Iterator<String> itr2 = entry.getValue().keySet().iterator();
            while (itr2.hasNext()) {
                String assetKey = itr2.next();
                if (!assetKey.contains(".")) {
                    assetKey = assetKey + ".json";
                }
                if (!namespace.matcher(assetNamespace).matches() || !path.matcher(assetKey).matches()) continue;
                itr2.remove();
            }
        }
    }

    @Override
    public Key getDefaultFontKey() {
        return this.defaultKey;
    }

    public void setDefaultKey(Key defaultKey) {
        this.defaultKey = defaultKey;
    }

    @Override
    protected void reload() {
        for (FontProvider provider : this.fonts.values()) {
            provider.reloadFonts();
        }
    }

    @Override
    public TextureResource getFontResource(String resourceLocation) {
        String key;
        String namespace;
        if (resourceLocation.contains(":")) {
            namespace = resourceLocation.substring(0, resourceLocation.indexOf(":"));
            key = resourceLocation.substring(resourceLocation.indexOf(":") + 1);
        } else {
            namespace = "minecraft";
            key = resourceLocation;
        }
        if (resourceLocation.endsWith(".png")) {
            return this.manager.getTextureManager().getTexture(resourceLocation, false);
        }
        Map<String, ResourcePackFile> fileList = this.files.get(namespace);
        if (fileList == null) {
            return null;
        }
        ResourcePackFile current0 = fileList.get(key);
        if (current0 != null && current0.exists()) {
            return new GeneratedTextureResource(this.manager, current0);
        }
        ResourcePackFile current1 = fileList.get(key.replace("font/", ""));
        if (current1 != null && current1.exists()) {
            return new GeneratedTextureResource(this.manager, current1);
        }
        return null;
    }

    @Override
    public FontProvider getFontProviders(Key resourceKey) {
        return this.getFontProviders(resourceKey == null ? this.getDefaultFontKey().asString() : resourceKey.asString());
    }

    @Override
    public FontProvider getFontProviders(String resourceLocation) {
        String defaultFont;
        if (!resourceLocation.contains(":")) {
            resourceLocation = "minecraft:" + resourceLocation;
        }
        return this.fonts.getOrDefault(resourceLocation, resourceLocation.equals(defaultFont = this.defaultKey.asString()) ? null : this.getFontProviders(defaultFont));
    }
}

