/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.fonts;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextDecoration;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontProvider;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontTextureResource;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MinecraftFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import com.loohp.interactivechatdiscordsrvaddon.utils.ComponentStringUtils;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Optional;

public class BitmapFont
extends MinecraftFont {
    public static final String TYPE_KEY = "bitmap";
    public static final double ITALIC_SHEAR_X = -0.2857142857142857;
    private Int2ObjectMap<FontTextureResource> charImages;
    private Int2IntMap charWidth;
    private String resourceLocation;
    private int height;
    private int ascent;
    private int scale;
    private List<String> chars;

    public BitmapFont(ResourceManager manager, FontProvider provider, String resourceLocation, int height, int ascent, List<String> chars) {
        super(manager, provider);
        this.resourceLocation = resourceLocation;
        this.height = height;
        this.ascent = ascent;
        this.chars = chars;
    }

    @Override
    public void reloadFonts() {
        this.charImages = new Int2ObjectOpenHashMap();
        this.charWidth = new Int2IntOpenHashMap();
        if (this.chars.isEmpty()) {
            return;
        }
        TextureResource resource = this.manager.getFontManager().getFontResource(this.resourceLocation);
        if (resource == null || !resource.isTexture()) {
            if (this.provider == null) {
                throw new ResourceLoadingException(this.resourceLocation + " is not a valid font resource");
            }
            throw new ResourceLoadingException(this.resourceLocation + " is not a valid font resource (Defined in " + this.provider.getNamespacedKey() + ")");
        }
        BufferedImage fontBaseImage = resource.getTexture();
        int yIncrement = fontBaseImage.getHeight() / this.chars.size();
        this.scale = Math.abs(this.height == 0 ? 0 : yIncrement / this.height);
        int y = 0;
        for (String line : this.chars) {
            if (!line.isEmpty()) {
                int xIncrement = fontBaseImage.getWidth() / line.codePointCount(0, line.length());
                int x = 0;
                int i = 0;
                while (i < line.length()) {
                    int character;
                    if ((i += (character = line.codePointAt(i)) < 65536 ? 1 : 2) != 0 && i != 32) {
                        int lastX = 0;
                        block2: for (int x0 = x; x0 < x + xIncrement; ++x0) {
                            for (int y0 = y; y0 < y + yIncrement; ++y0) {
                                int alpha = ColorUtils.getAlpha(fontBaseImage.getRGB(x0, y0));
                                if (alpha == 0) continue;
                                lastX = x0 - x + 1;
                                continue block2;
                            }
                        }
                        if (x + lastX > fontBaseImage.getWidth()) {
                            lastX = fontBaseImage.getWidth() - x;
                        }
                        if (lastX > 0) {
                            this.charImages.put(character, (Object)new FontTextureResource(resource, x, y, lastX, yIncrement));
                            this.charWidth.put(character, lastX);
                        }
                    }
                    x += xIncrement;
                }
            }
            y += yIncrement;
        }
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getScale() {
        return this.scale;
    }

    public List<String> getChars() {
        return this.chars;
    }

    @Override
    public boolean canDisplayCharacter(String character) {
        return this.charImages.containsKey(character.codePointAt(0));
    }

    @Override
    public MinecraftFont.FontRenderResult printCharacter(BufferedImage image, String character, int x, int y, float fontSize, int lastItalicExtraWidth, TextColor color, List<TextDecoration> decorations) {
        decorations = BitmapFont.sortDecorations(decorations);
        Color awtColor = new Color(color.value());
        BufferedImage charImage = ((FontTextureResource)this.charImages.get(character.codePointAt(0))).getFontImage();
        int originalW = charImage.getWidth();
        float scale = fontSize / 8.0f;
        float ascent = this.ascent - 7;
        float descent = this.height - this.ascent - 1;
        int fillHeight = (int)Math.floor(fontSize + (ascent + descent) * scale);
        charImage = ImageUtils.resizeImageFillHeight(charImage, Math.abs(fillHeight));
        int w = charImage.getWidth();
        int h = charImage.getHeight();
        charImage = ImageUtils.multiply(charImage, ImageUtils.changeColorTo(ImageUtils.copyImage(charImage), awtColor));
        int beforeTransformW = w;
        double accuratePixelSize = (double)beforeTransformW / (double)originalW;
        int pixelSize = (int)Math.round(accuratePixelSize);
        int strikeSize = (int)((double)fontSize / 8.0);
        int boldSize = (int)((double)fontSize / 16.0 * 3.0);
        int italicExtraWidth = 0;
        boolean italic = false;
        boolean underlineStrikethroughExpanded = false;
        for (TextDecoration decoration : decorations) {
            switch (decoration) {
                case OBFUSCATED: {
                    charImage = new BufferedImage(charImage.getWidth(), charImage.getHeight(), 2);
                    Graphics2D g = charImage.createGraphics();
                    for (int i = 0; i < 3; ++i) {
                        String magicCharacter = ComponentStringUtils.toMagic(this.provider, character);
                        BufferedImage magicImage = this.provider.forCharacter(magicCharacter).getCharacterImage(magicCharacter, fontSize, color).orElse(new BufferedImage(1, 1, 2));
                        g.drawImage(magicImage, 0, 0, charImage.getWidth(), charImage.getHeight(), null);
                    }
                    g.dispose();
                    break;
                }
                case BOLD: {
                    BufferedImage boldImage = new BufferedImage(charImage.getWidth() + 2, charImage.getHeight(), 2);
                    for (int x0 = 0; x0 < charImage.getWidth(); ++x0) {
                        for (int y0 = 0; y0 < charImage.getHeight(); ++y0) {
                            int pixelColor = charImage.getRGB(x0, y0);
                            int alpha = ColorUtils.getAlpha(pixelColor);
                            if (alpha == 0) continue;
                            for (int i = 0; i < boldSize; ++i) {
                                boldImage.setRGB(x0 + i, y0, pixelColor);
                            }
                        }
                    }
                    charImage = boldImage;
                    w += boldSize - 1;
                    break;
                }
                case ITALIC: {
                    int extraWidth = (int)((double)charImage.getHeight() * 0.2857142857142857);
                    BufferedImage italicImage = new BufferedImage(charImage.getWidth() + extraWidth * 2, charImage.getHeight(), 2);
                    Graphics2D g = italicImage.createGraphics();
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.transform(AffineTransform.getShearInstance(-0.2857142857142857, 0.0));
                    g.drawImage((Image)charImage, extraWidth, 0, null);
                    g.dispose();
                    charImage = italicImage;
                    italicExtraWidth = (int)Math.round(0.2857142857142857 * (double)h);
                    italic = true;
                    break;
                }
                case STRIKETHROUGH: {
                    charImage = ImageUtils.expandCenterAligned(charImage, 0, 0, 0, underlineStrikethroughExpanded ? 0 : pixelSize * this.scale);
                    Graphics2D g = charImage.createGraphics();
                    g.setColor(awtColor);
                    g.fillRect(0, (int)(fontSize / 2.0f), w + pixelSize * this.scale, strikeSize);
                    g.dispose();
                    break;
                }
                case UNDERLINED: {
                    charImage = ImageUtils.expandCenterAligned(charImage, 0, strikeSize * 2, 0, underlineStrikethroughExpanded ? 0 : pixelSize * this.scale);
                    Graphics2D g = charImage.createGraphics();
                    g.setColor(awtColor);
                    g.fillRect(0, (int)fontSize, w + pixelSize * this.scale, strikeSize);
                    g.dispose();
                    break;
                }
            }
        }
        Graphics2D g = image.createGraphics();
        int extraWidth = italic ? 0 : lastItalicExtraWidth;
        int sign = fillHeight >= 0 ? 1 : -1;
        int spaceWidth = (int)Math.floor(accuratePixelSize * (double)this.scale);
        if (sign > 0) {
            g.drawImage((Image)charImage, x + extraWidth, (int)((float)y - ascent * scale), null);
        } else {
            g.drawImage(ImageUtils.flipVertically(charImage), x + extraWidth, y, -w, -h, null);
            spaceWidth = (int)Math.ceil((double)spaceWidth + accuratePixelSize * 8.0) + 1;
        }
        g.dispose();
        return new MinecraftFont.FontRenderResult(image, w * sign + extraWidth, h, spaceWidth, italicExtraWidth);
    }

    @Override
    public Optional<BufferedImage> getCharacterImage(String character, float fontSize, TextColor color) {
        Color awtColor = new Color(color.value());
        BufferedImage charImage = ((FontTextureResource)this.charImages.get(character.codePointAt(0))).getFontImage();
        float descent = this.height - this.ascent - 1;
        charImage = ImageUtils.resizeImageFillHeight(charImage, Math.abs(Math.round(fontSize + ((float)this.ascent + descent) * (float)this.scale)));
        charImage = ImageUtils.multiply(charImage, ImageUtils.changeColorTo(ImageUtils.copyImage(charImage), awtColor));
        return Optional.of(charImage);
    }

    @Override
    public int getCharacterWidth(String character) {
        return this.charWidth.get(character.codePointAt(0));
    }

    @Override
    public IntSet getDisplayableCharacters() {
        return IntSets.unmodifiable((IntSet)this.charImages.keySet());
    }
}

