/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourcePackZipEntryFile
implements ResourcePackFile {
    private String absoluteRootPath;
    private ResourcePackZipEntryFile zipRootFile;
    private ZipFile zipRoot;
    private String zipPath;
    private boolean isDirectory;
    private ZipEntry zipEntry;

    public ResourcePackZipEntryFile(File resourcePackZip) throws IOException {
        this.absoluteRootPath = resourcePackZip.getAbsolutePath();
        this.zipRootFile = this;
        this.zipRoot = new ZipFile(resourcePackZip);
        this.zipPath = "";
        this.isDirectory = true;
        this.zipEntry = null;
    }

    private ResourcePackZipEntryFile(String absoluteRootPath, ResourcePackZipEntryFile zipRootFile, ZipFile zipRoot, String zipPath, boolean isDirectory, ZipEntry zipEntry) {
        this.absoluteRootPath = absoluteRootPath;
        this.zipRootFile = zipRootFile;
        this.zipRoot = zipRoot;
        this.zipPath = zipPath;
        this.isDirectory = isDirectory;
        this.zipEntry = zipEntry;
    }

    public ZipFile getZipRoot() {
        return this.zipRoot;
    }

    public boolean hasZipEntry() {
        return this.zipEntry != null;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    @Override
    public ResourcePackFile getPackRootFile() {
        return this.zipRootFile;
    }

    @Override
    public String getName() {
        String path = this.getPath();
        if (path.contains("/")) {
            path = path.substring(path.lastIndexOf("/") + 1);
        }
        return path;
    }

    @Override
    public String getParent() {
        String path = this.getPath();
        if (!path.contains("/")) {
            return null;
        }
        path = path.substring(0, path.lastIndexOf("/"));
        return path;
    }

    @Override
    public ResourcePackFile getParentFile() {
        return new ResourcePackZipEntryFile(this.absoluteRootPath, this.zipRootFile, this.zipRoot, this.getParent(), true, null);
    }

    @Override
    public String getPath() {
        return this.zipPath;
    }

    @Override
    public String getAbsolutePath() {
        String path = this.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (this.absoluteRootPath.contains("\\")) {
            path = path.replace("/", "\\");
        }
        return this.absoluteRootPath + path;
    }

    @Override
    public boolean exists() {
        return this.isDirectory || this.zipEntry != null;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public Collection<ResourcePackFile> listFilesAndFolders() {
        HashSet<ResourcePackFile> set = new HashSet<ResourcePackFile>();
        Enumeration<? extends ZipEntry> itr = this.zipRoot.entries();
        while (itr.hasMoreElements()) {
            String entryPath;
            ZipEntry entry = itr.nextElement();
            if (entry.isDirectory() || (entryPath = entry.getName()).equals(this.zipPath) || !entryPath.startsWith(this.zipPath)) continue;
            String relativePath = entryPath.substring(this.zipPath.length());
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (relativePath.contains("/")) {
                String folderName = relativePath.substring(0, relativePath.indexOf("/"));
                set.add(new ResourcePackZipEntryFile(this.absoluteRootPath, this.zipRootFile, this.zipRoot, (this.zipPath.isEmpty() ? this.zipPath : this.zipPath + "/") + folderName, true, null));
                continue;
            }
            set.add(new ResourcePackZipEntryFile(this.absoluteRootPath, this.zipRootFile, this.zipRoot, entryPath, false, entry));
        }
        return set;
    }

    @Override
    public ResourcePackFile getChild(String name) {
        for (ResourcePackFile entry : this.listFilesAndFolders()) {
            ResourcePackZipEntryFile zipEntryFile = (ResourcePackZipEntryFile)entry;
            if (!zipEntryFile.zipPath.equals((this.zipPath.isEmpty() ? this.zipPath : this.zipPath + "/") + name)) continue;
            return zipEntryFile;
        }
        return new ResourcePackZipEntryFile(this.absoluteRootPath, this.zipRootFile, this.zipRoot, (this.zipPath.isEmpty() ? this.zipPath : this.zipPath + "/") + name, false, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePackZipEntryFile that = (ResourcePackZipEntryFile)o;
        return Objects.equals(this.absoluteRootPath, that.absoluteRootPath) && Objects.equals(this.zipRoot, that.zipRoot) && Objects.equals(this.zipPath, that.zipPath);
    }

    public int hashCode() {
        return Objects.hash(this.absoluteRootPath, this.zipRoot, this.zipPath);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.zipRoot.getInputStream(this.zipEntry);
    }

    @Override
    public Collection<ResourcePackFile> listFilesRecursively(String[] extensions) {
        ArrayList<ResourcePackFile> list = new ArrayList<ResourcePackFile>();
        Enumeration<? extends ZipEntry> itr = this.zipRoot.entries();
        while (itr.hasMoreElements()) {
            ZipEntry entry = itr.nextElement();
            if (entry.isDirectory()) continue;
            String entryPath = entry.getName();
            if (this.zipEntry != null && entry.getName().equals(this.zipEntry.getName()) || !entryPath.startsWith(this.zipPath) || extensions != null && !Arrays.stream(extensions).anyMatch(each -> entryPath.endsWith("." + each))) continue;
            list.add(new ResourcePackZipEntryFile(this.absoluteRootPath, this.zipRootFile, this.zipRoot, entryPath, false, entry));
        }
        return list;
    }

    @Override
    public void close() {
        try {
            this.zipRoot.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

