/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechat.libs.org.apache.commons.io.FileUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourcePackSystemFile
implements ResourcePackFile {
    private ResourcePackSystemFile root;
    private File file;
    private Set<InputStream> streams;

    public ResourcePackSystemFile(File file) {
        this.root = this;
        this.file = file;
        this.streams = new HashSet<InputStream>();
    }

    private ResourcePackSystemFile(ResourcePackSystemFile root, File file) {
        this.root = root;
        this.file = file;
        this.streams = null;
    }

    public File getFile() {
        return this.file;
    }

    public ResourcePackSystemFile getResourceSystemRoot() {
        return this.root;
    }

    public boolean isResourceSystemRoot() {
        return this.root == this;
    }

    @Override
    public ResourcePackFile getPackRootFile() {
        return this.root;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getParent() {
        if (this.isResourceSystemRoot()) {
            return null;
        }
        return this.file.getParent();
    }

    @Override
    public ResourcePackFile getParentFile() {
        if (this.getParent() == null) {
            return null;
        }
        return new ResourcePackSystemFile(this.root, this.file.getParentFile());
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public Collection<ResourcePackFile> listFilesAndFolders() {
        return Arrays.stream(this.file.listFiles()).map(each -> new ResourcePackSystemFile(this.root, (File)each)).collect(Collectors.toSet());
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public ResourcePackFile getChild(String name) {
        return new ResourcePackSystemFile(this.root, new File(this.file, name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePackSystemFile that = (ResourcePackSystemFile)o;
        if (!Objects.equals(this.isResourceSystemRoot(), that.isResourceSystemRoot())) {
            return false;
        }
        if (this.isResourceSystemRoot()) {
            return Objects.equals(this.file, that.file);
        }
        return Objects.equals(this.root, that.root) && Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        if (this.isResourceSystemRoot()) {
            return Objects.hash(this.file);
        }
        return Objects.hash(this.root, this.file);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream stream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
        this.root.streams.add(stream);
        return stream;
    }

    @Override
    public Collection<ResourcePackFile> listFilesRecursively(String[] extensions) {
        return FileUtils.listFiles((File)this.file, (String[])extensions, (boolean)true).stream().map(each -> new ResourcePackSystemFile(this.root, (File)each)).collect(Collectors.toList());
    }

    @Override
    public void close() {
        for (InputStream stream : this.root.streams) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

