/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceFilterBlock;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackType;
import com.loohp.interactivechatdiscordsrvaddon.resources.languages.LanguageMeta;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ResourcePackInfo {
    public static final String UNKNOWN_PACK_ICON_LOCATION = "minecraft:misc/unknown_pack";
    private ResourceManager manager;
    private ResourcePackFile file;
    private ResourcePackType type;
    private boolean status;
    private boolean exist;
    private String rejectedReason;
    private String name;
    private int packFormat;
    private Component description;
    private Map<String, LanguageMeta> languageMeta;
    private BufferedImage icon;
    private List<ResourceFilterBlock> resourceFilterBlocks;

    private ResourcePackInfo(ResourceManager manager, ResourcePackFile file, ResourcePackType type, String name, boolean status, boolean exist, String rejectedReason, int packFormat, Component description, Map<String, LanguageMeta> languageMeta, BufferedImage icon, List<ResourceFilterBlock> resourceFilterBlocks) {
        this.manager = manager;
        this.file = file;
        this.type = type;
        this.name = name;
        this.status = status;
        this.exist = exist;
        this.rejectedReason = rejectedReason;
        this.packFormat = packFormat;
        this.description = description;
        this.languageMeta = Collections.unmodifiableMap(languageMeta);
        this.icon = icon;
        this.resourceFilterBlocks = resourceFilterBlocks;
    }

    public ResourcePackInfo(ResourceManager manager, ResourcePackFile file, ResourcePackType type, String name, boolean status, String rejectedReason, int packFormat, Component description, Map<String, LanguageMeta> languageMeta, BufferedImage icon, List<ResourceFilterBlock> resourceFilterBlocks) {
        this(manager, file, type, name, status, true, rejectedReason, packFormat, description, languageMeta, icon, resourceFilterBlocks);
    }

    public ResourcePackInfo(ResourceManager manager, ResourcePackFile file, ResourcePackType type, String name, String rejectedReason) {
        this(manager, file, type, name, false, false, rejectedReason, -1, null, Collections.emptyMap(), null, Collections.emptyList());
    }

    public ResourceManager getManager() {
        return this.manager;
    }

    public ResourcePackFile getResourcePackFile() {
        return this.file;
    }

    public ResourcePackType getType() {
        return this.type;
    }

    public int getPackOrder() {
        return this.manager.getResourcePackInfo().indexOf(this);
    }

    public boolean isValid() {
        return this.manager.isValid();
    }

    public boolean getStatus() {
        return this.status;
    }

    public String getRejectedReason() {
        return this.rejectedReason;
    }

    public boolean exists() {
        return this.exist;
    }

    public String getName() {
        return this.name;
    }

    public int getPackFormat() {
        return this.packFormat;
    }

    public int compareServerPackFormat(int localFormat) {
        return Integer.compare(this.packFormat, localFormat);
    }

    public Component getDescription() {
        return this.description;
    }

    public Map<String, LanguageMeta> getLanguageMeta() {
        return this.languageMeta;
    }

    public BufferedImage getRawIcon() {
        return this.icon;
    }

    public BufferedImage getIcon() {
        return this.icon == null ? this.manager.getTextureManager().getTexture(UNKNOWN_PACK_ICON_LOCATION).getTexture() : this.icon;
    }

    public List<ResourceFilterBlock> getResourceFilterBlocks() {
        return this.resourceFilterBlocks;
    }
}

