/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactivechat.libs.org.apache.commons.io.input.BOMInputStream;
import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechat.utils.InteractiveChatComponentSerializer;
import com.loohp.interactivechatdiscordsrvaddon.resources.AbstractManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.IResourceRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceFilterBlock;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackInfo;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackSystemFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackType;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackZipEntryFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.languages.LanguageManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.languages.LanguageMeta;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.ModManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class ResourceManager
implements AutoCloseable {
    private List<ResourcePackInfo> resourcePackInfo = new ArrayList<ResourcePackInfo>();
    private Map<String, IResourceRegistry> resourceRegistries;
    private ModelManager modelManager;
    private TextureManager textureManager;
    private FontManager fontManager;
    private LanguageManager languageManager;
    private Map<String, ModManager> modManagers;
    private boolean flattenLegacy;
    private boolean fontLegacy;
    private AtomicBoolean isValid;
    private UUID uuid;

    public ResourceManager(boolean flattenLegacy, boolean fontLegacy, Collection<ModManagerSupplier<?>> modManagerProviders, Collection<ResourceRegistrySupplier<?>> resourceManagerUtilsProviders) {
        this.flattenLegacy = flattenLegacy;
        this.fontLegacy = fontLegacy;
        this.isValid = new AtomicBoolean(true);
        this.uuid = UUID.randomUUID();
        this.resourceRegistries = new HashMap<String, IResourceRegistry>();
        for (ResourceRegistrySupplier<?> resourceRegistrySupplier : resourceManagerUtilsProviders) {
            Object resourceRegistry = resourceRegistrySupplier.init(this);
            this.resourceRegistries.put(resourceRegistry.getRegistryIdentifier(), (IResourceRegistry)resourceRegistry);
        }
        this.modelManager = new ModelManager(this);
        this.textureManager = new TextureManager(this);
        this.fontManager = new FontManager(this);
        this.languageManager = new LanguageManager(this);
        this.modManagers = new HashMap<String, ModManager>();
        for (ModManagerSupplier modManagerSupplier : modManagerProviders) {
            Object modManager = modManagerSupplier.init(this);
            this.modManagers.put(((ModManager)modManager).getModName(), (ModManager)modManager);
        }
    }

    public synchronized ResourcePackInfo loadResources(File resourcePackFile, ResourcePackType type) {
        List<ResourceFilterBlock> resourceFilterBlocks;
        int format;
        JSONObject json;
        ResourcePackFile resourcePack;
        if (!this.isValid()) {
            throw new IllegalStateException("ResourceManager already closed!");
        }
        String resourcePackName = resourcePackFile.getName();
        if (!resourcePackFile.exists()) {
            new IllegalArgumentException(resourcePackFile.getAbsolutePath() + " is not a directory nor is a zip file.").printStackTrace();
            ResourcePackInfo info = new ResourcePackInfo(this, null, type, resourcePackName, "Resource Pack is not a directory nor a zip file.");
            this.resourcePackInfo.add(0, info);
            return info;
        }
        if (resourcePackFile.isDirectory()) {
            resourcePack = new ResourcePackSystemFile(resourcePackFile);
        } else {
            try {
                resourcePack = new ResourcePackZipEntryFile(resourcePackFile);
            }
            catch (IOException e) {
                new IllegalArgumentException(resourcePackFile.getAbsolutePath() + " is an invalid zip file.", e).printStackTrace();
                ResourcePackInfo info = new ResourcePackInfo(this, null, type, resourcePackName, "Resource Pack is an invalid zip file.");
                this.resourcePackInfo.add(0, info);
                return info;
            }
        }
        ResourcePackFile packMcmeta = resourcePack.getChild("pack.mcmeta");
        if (!packMcmeta.exists()) {
            new ResourceLoadingException(resourcePackName + " does not have a pack.mcmeta").printStackTrace();
            ResourcePackInfo info = new ResourcePackInfo(this, resourcePack, type, resourcePackName, "pack.mcmeta not found");
            this.resourcePackInfo.add(0, info);
            return info;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(packMcmeta.getInputStream()), StandardCharsets.UTF_8);){
            json = (JSONObject)new JSONParser().parse((Reader)reader);
        }
        catch (Throwable e) {
            new ResourceLoadingException("Unable to read pack.mcmeta for " + resourcePackName, e).printStackTrace();
            ResourcePackInfo info = new ResourcePackInfo(this, resourcePack, type, resourcePackName, "Unable to read pack.mcmeta");
            this.resourcePackInfo.add(0, info);
            return info;
        }
        Component description = null;
        HashMap<String, LanguageMeta> languageMeta = new HashMap<String, LanguageMeta>();
        try {
            JSONArray filterBlockArray;
            JSONObject filterJson;
            JSONObject languageJson;
            JSONObject packJson = (JSONObject)json.get((Object)"pack");
            format = ((Number)packJson.get((Object)"pack_format")).intValue();
            String rawDescription = packJson.get((Object)"description").toString();
            try {
                description = InteractiveChatComponentSerializer.gson().deserialize((Object)rawDescription);
            }
            catch (Exception e) {
                description = null;
            }
            if (description == null) {
                description = LegacyComponentSerializer.legacySection().deserialize(rawDescription);
            }
            if (description.color() == null) {
                description = description.color((TextColor)NamedTextColor.GRAY);
            }
            if ((languageJson = (JSONObject)json.get((Object)"language")) != null) {
                for (Object obj : languageJson.keySet()) {
                    String language = (String)obj;
                    JSONObject meta = (JSONObject)languageJson.get((Object)language);
                    String region = (String)meta.get((Object)"region");
                    String name = (String)meta.get((Object)"name");
                    boolean bidirectional = (Boolean)meta.get((Object)"bidirectional");
                    languageMeta.put(language, new LanguageMeta(language, region, name, bidirectional));
                }
            }
            resourceFilterBlocks = (filterJson = (JSONObject)json.get((Object)"filter")) != null && (filterBlockArray = (JSONArray)filterJson.get((Object)"block")) != null ? ResourceFilterBlock.fromJson(filterBlockArray) : Collections.emptyList();
        }
        catch (Exception e) {
            new ResourceLoadingException("Invalid pack.mcmeta for " + resourcePackName, e).printStackTrace();
            ResourcePackInfo info = new ResourcePackInfo(this, resourcePack, type, resourcePackName, "Invalid pack.mcmeta");
            this.resourcePackInfo.add(0, info);
            return info;
        }
        BufferedImage icon = null;
        ResourcePackFile packIcon = resourcePack.getChild("pack.png");
        if (packIcon.exists()) {
            try (InputStream inputStream2 = packIcon.getInputStream();){
                icon = ImageIO.read(inputStream2);
            }
            catch (Exception inputStream2) {
                // empty catch block
            }
        }
        ResourcePackFile assetsFolder = resourcePack.getChild("assets");
        try {
            this.filterResources(resourceFilterBlocks);
            this.loadAssets(assetsFolder, languageMeta);
        }
        catch (Exception e) {
            new ResourceLoadingException("Unable to load assets for " + resourcePackName, e).printStackTrace();
            ResourcePackInfo info = new ResourcePackInfo(this, resourcePack, type, resourcePackName, false, "Unable to load assets", format, description, languageMeta, icon, resourceFilterBlocks);
            this.resourcePackInfo.add(0, info);
            return info;
        }
        ResourcePackInfo info = new ResourcePackInfo(this, resourcePack, type, resourcePackName, true, null, format, description, languageMeta, icon, resourceFilterBlocks);
        this.resourcePackInfo.add(0, info);
        return info;
    }

    private void filterResources(List<ResourceFilterBlock> resourceFilterBlocks) {
        for (ResourceFilterBlock resourceFilterBlock : resourceFilterBlocks) {
            Pattern namespace = resourceFilterBlock.getNamespace();
            Pattern path = resourceFilterBlock.getPath();
            ((AbstractManager)this.modelManager).filterResources(namespace, path);
            ((AbstractManager)this.textureManager).filterResources(namespace, path);
            ((AbstractManager)this.fontManager).filterResources(namespace, path);
            ((AbstractManager)this.languageManager).filterResources(namespace, path);
            for (ModManager modManager : this.modManagers.values()) {
                modManager.filterResources(namespace, path);
            }
        }
        ((AbstractManager)this.modelManager).reload();
        ((AbstractManager)this.textureManager).reload();
        ((AbstractManager)this.fontManager).reload();
        ((AbstractManager)this.languageManager).reload();
        for (ModManager modManager : this.modManagers.values()) {
            modManager.reload();
        }
    }

    private void loadAssets(ResourcePackFile assetsFolder, Map<String, LanguageMeta> languageMeta) {
        String namespace;
        if (!assetsFolder.exists() || !assetsFolder.isDirectory()) {
            throw new IllegalArgumentException(assetsFolder.getAbsolutePath() + " is not a directory.");
        }
        Collection<ResourcePackFile> folders = assetsFolder.listFilesAndFolders();
        for (ResourcePackFile folder : folders) {
            if (!folder.isDirectory()) continue;
            namespace = folder.getName();
            ResourcePackFile models = folder.getChild("models");
            if (!models.exists() || !models.isDirectory()) continue;
            ((AbstractManager)this.modelManager).loadDirectory(namespace, models, new Object[0]);
        }
        for (ResourcePackFile folder : folders) {
            if (!folder.isDirectory()) continue;
            namespace = folder.getName();
            ResourcePackFile textures = folder.getChild("textures");
            if (!textures.exists() || !textures.isDirectory()) continue;
            ((AbstractManager)this.textureManager).loadDirectory(namespace, textures, new Object[0]);
        }
        for (ResourcePackFile folder : folders) {
            if (!folder.isDirectory()) continue;
            namespace = folder.getName();
            ResourcePackFile font = folder.getChild("font");
            if (!font.exists() || !font.isDirectory()) continue;
            ((AbstractManager)this.fontManager).loadDirectory(namespace, font, new Object[0]);
        }
        for (ResourcePackFile folder : folders) {
            if (!folder.isDirectory()) continue;
            namespace = folder.getName();
            ResourcePackFile lang = folder.getChild("lang");
            if (!lang.exists() || !lang.isDirectory()) continue;
            ((AbstractManager)this.languageManager).loadDirectory(namespace, lang, languageMeta);
        }
        for (ModManager modManager : this.modManagers.values()) {
            for (String folderName : modManager.getModAssetsFolderNames()) {
                for (ResourcePackFile folder : folders) {
                    if (!folder.isDirectory()) continue;
                    String namespace2 = folder.getName();
                    ResourcePackFile modFolder = folder.getChild(folderName);
                    if (!modFolder.exists() || !modFolder.isDirectory()) continue;
                    modManager.loadDirectory(namespace2, modFolder, new Object[0]);
                }
            }
        }
        ((AbstractManager)this.modelManager).reload();
        ((AbstractManager)this.textureManager).reload();
        ((AbstractManager)this.fontManager).reload();
        ((AbstractManager)this.languageManager).reload();
        for (ModManager modManager : this.modManagers.values()) {
            modManager.reload();
        }
    }

    public List<ResourcePackInfo> getResourcePackInfo() {
        return Collections.unmodifiableList(this.resourcePackInfo);
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public TextureManager getTextureManager() {
        return this.textureManager;
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ModManager getModManager(String modName) {
        return this.modManagers.get(modName);
    }

    public boolean hasModManager(String modName) {
        return this.modManagers.containsKey(modName);
    }

    public <T extends ModManager> T getModManager(String modName, Class<T> managerClass) {
        return (T)this.getModManager(modName);
    }

    public <T extends ModManager> boolean hasModManager(String modName, Class<T> managerClass) {
        return managerClass.isInstance(this.getModManager(modName));
    }

    public Map<String, ModManager> getModManagers() {
        return Collections.unmodifiableMap(this.modManagers);
    }

    public IResourceRegistry getResourceRegistry(String identifier) {
        return this.resourceRegistries.get(identifier);
    }

    public boolean hasResourceRegistry(String identifier) {
        return this.resourceRegistries.containsKey(identifier);
    }

    public <T extends IResourceRegistry> T getResourceRegistry(String identifier, Class<T> registryClass) {
        return (T)this.getResourceRegistry(identifier);
    }

    public <T extends IResourceRegistry> boolean hasResourceRegistry(String identifier, Class<T> registryClass) {
        return registryClass.isInstance(this.getResourceRegistry(identifier));
    }

    public Map<String, IResourceRegistry> getResourceRegistries() {
        return Collections.unmodifiableMap(this.resourceRegistries);
    }

    public boolean isFlattenLegacy() {
        return this.flattenLegacy;
    }

    public boolean isFontLegacy() {
        return this.fontLegacy;
    }

    public boolean isValid() {
        return this.isValid.get();
    }

    protected UUID getUuid() {
        return this.uuid;
    }

    @Override
    public synchronized void close() {
        if (this.isValid.getAndSet(false)) {
            for (ResourcePackInfo info : this.resourcePackInfo) {
                if (info.getResourcePackFile() == null) continue;
                info.getResourcePackFile().close();
            }
            for (IResourceRegistry resourceRegistry : this.resourceRegistries.values()) {
                resourceRegistry.close();
            }
            this.modelManager.close();
            this.textureManager.close();
            this.fontManager.close();
            this.languageManager.close();
            for (ModManager modManager : this.modManagers.values()) {
                modManager.close();
            }
        }
    }

    @FunctionalInterface
    public static interface ResourceRegistrySupplier<T extends IResourceRegistry>
    extends Function<ResourceManager, T> {
        public T init(ResourceManager var1);

        @Override
        default public T apply(ResourceManager resourceManager) {
            return this.init(resourceManager);
        }
    }

    @FunctionalInterface
    public static interface ModManagerSupplier<T extends ModManager>
    extends Function<ResourceManager, T> {
        public T init(ResourceManager var1);

        @Override
        default public T apply(ResourceManager resourceManager) {
            return this.init(resourceManager);
        }
    }
}

