/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechat.libs.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import com.loohp.interactivechat.libs.org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.utils.FileUtils;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.TriConsumer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class ResourceDownloadManager {
    public static final String ASSETS_DATA_URL = "https://api.loohpjames.com/spigot/plugins/interactivechatdiscordsrvaddon?minecraftVersion=%s";
    public static final String VERSIONS_URL = "https://api.loohpjames.com/spigot/plugins/interactivechatdiscordsrvaddon/versions";
    public static final String MOJANG_RESOURCES_URL = "http://resources.download.minecraft.net/";
    private static Set<String> MINECRAFT_VERSIONS = null;
    private String minecraftVersion;
    private File packFolder;
    private JSONObject data;
    private JSONObject assetIndex;

    private static void ensureVersions() {
        if (MINECRAFT_VERSIONS == null) {
            JSONObject data = HTTPRequestUtils.getJSONResponse((String)VERSIONS_URL);
            MINECRAFT_VERSIONS = new LinkedHashSet<String>();
            if (data != null && data.containsKey((Object)"versions")) {
                for (Object version : (JSONArray)data.get((Object)"versions")) {
                    MINECRAFT_VERSIONS.add(version.toString());
                }
            }
            MINECRAFT_VERSIONS = Collections.unmodifiableSet(MINECRAFT_VERSIONS);
        }
    }

    public static Set<String> getMinecraftVersions() {
        ResourceDownloadManager.ensureVersions();
        return MINECRAFT_VERSIONS;
    }

    public ResourceDownloadManager(String minecraftVersion, File packFolder) {
        this.minecraftVersion = minecraftVersion;
        this.packFolder = packFolder;
        this.data = null;
        this.assetIndex = null;
    }

    private void ensureData() {
        if (this.data == null || this.assetIndex == null) {
            this.data = HTTPRequestUtils.getJSONResponse((String)ASSETS_DATA_URL.replace("%s", this.minecraftVersion));
            JSONObject client = (JSONObject)this.data.get((Object)"client-entries");
            this.assetIndex = HTTPRequestUtils.getJSONResponse((String)client.get((Object)"asset-index").toString());
        }
    }

    public String getHash() {
        this.ensureData();
        return this.data.get((Object)"hash").toString();
    }

    public synchronized void downloadResources(TriConsumer<TaskType, String, Double> progressListener) {
        this.ensureData();
        JSONObject client = (JSONObject)this.data.get((Object)"client-entries");
        String clientUrl = client.get((Object)"url").toString();
        progressListener.accept(TaskType.CLIENT_DOWNLOAD, "", 0.0);
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream((InputStream)new ByteArrayInputStream(HTTPRequestUtils.download((String)clientUrl)), StandardCharsets.UTF_8.toString(), false, true, true);){
            ZipArchiveEntry entry;
            while ((entry = zip.getNextZipEntry()) != null) {
                int n;
                String name = entry.getName();
                if (!name.startsWith("assets") && !name.equals("pack.png") || entry.isDirectory()) continue;
                String fileName = this.getEntryName(name);
                progressListener.accept(TaskType.EXTRACT, name, 0.0);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] byteChunk = new byte[4096];
                while ((n = zip.read(byteChunk)) > 0) {
                    baos.write(byteChunk, 0, n);
                }
                byte[] currentEntry = baos.toByteArray();
                File folder = new File(this.packFolder, name).getParentFile();
                folder.mkdirs();
                File file = new File(folder, fileName);
                if (file.exists()) {
                    file.delete();
                }
                FileUtils.copy((InputStream)new ByteArrayInputStream(currentEntry), (File)file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject downloadedEntries = (JSONObject)this.data.get((Object)"downloaded-entries");
        int size = downloadedEntries.size();
        int i = 0;
        for (Object obj : downloadedEntries.keySet()) {
            String key = obj.toString();
            String value = downloadedEntries.get((Object)key).toString();
            String fileName = this.getEntryName(key);
            double percentage = (double)(++i) / (double)size * 100.0;
            String trimmedValue = (value.startsWith("/") ? value.substring(1) : value).trim();
            if (!trimmedValue.isEmpty()) {
                trimmedValue = trimmedValue + "/";
            }
            progressListener.accept(TaskType.DOWNLOAD, trimmedValue + fileName, percentage);
            File folder = value.isEmpty() || value.equals("/") ? this.packFolder : new File(this.packFolder, value);
            folder.mkdirs();
            File file = new File(folder, fileName);
            if (file.exists()) {
                file.delete();
            }
            HTTPRequestUtils.download((File)file, (String)key);
        }
        progressListener.accept(TaskType.DONE, "", 100.0);
    }

    public synchronized void downloadLanguages(TriConsumer<TaskType, String, Double> progressListener) {
        this.ensureData();
        JSONObject json = (JSONObject)this.assetIndex.get((Object)"objects");
        LinkedHashMap<String, String> langEntries = new LinkedHashMap<String, String>();
        for (Object obj : json.keySet()) {
            String key = (String)obj;
            if (!key.startsWith("minecraft/lang/")) continue;
            langEntries.put(key, ((JSONObject)json.get((Object)key)).get((Object)"hash").toString());
        }
        File assetsFolder = new File(this.packFolder, "assets");
        assetsFolder.mkdirs();
        int size = langEntries.size();
        int i = 0;
        for (Map.Entry entry : langEntries.entrySet()) {
            String name = (String)entry.getKey();
            String hash = (String)entry.getValue();
            double percentage = (double)(++i) / (double)size * 100.0;
            progressListener.accept(TaskType.DOWNLOAD, "assets/" + name, percentage);
            File file = name.isEmpty() || name.equals("/") ? assetsFolder : new File(assetsFolder, name);
            file.getParentFile().mkdirs();
            if (file.exists()) {
                file.delete();
            }
            HTTPRequestUtils.download((File)file, (String)(MOJANG_RESOURCES_URL + hash.substring(0, 2) + "/" + hash));
        }
        progressListener.accept(TaskType.DONE, "", 100.0);
    }

    public synchronized void downloadExtras(Runnable preparation, BiConsumer<String, byte[]> dataHandler) {
        this.ensureData();
        try {
            if (this.data.containsKey((Object)"extras-entries")) {
                JSONObject extras = (JSONObject)this.data.get((Object)"extras-entries");
                preparation.run();
                for (Object obj : extras.keySet()) {
                    String key = obj.toString();
                    String value = extras.get((Object)key).toString();
                    try {
                        dataHandler.accept(value, HTTPRequestUtils.download((String)key));
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getEntryName(String name) {
        int pos = name.lastIndexOf("/");
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        pos = name.lastIndexOf("\\");
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static enum TaskType {
        CLIENT_DOWNLOAD,
        EXTRACT,
        DOWNLOAD(true),
        DONE;

        private boolean hasPercentage;

        private TaskType(boolean hasPercentage) {
            this.hasPercentage = hasPercentage;
        }

        private TaskType() {
            this(false);
        }

        public boolean isHasPercentage() {
            return this.hasPercentage;
        }
    }
}

