/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.objectholders.ValuePairs;
import com.loohp.interactivechat.utils.CustomArrayUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.graphics.BlendingUtils;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.BlendingModes;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Face;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Hexahedron;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Model;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Point3D;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.CacheObject;
import com.loohp.interactivechatdiscordsrvaddon.resources.ICacheManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.BlockModel;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.Coordinates3D;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelDisplay;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelElement;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelFace;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelGUILight;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.TextureUV;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.EnchantmentProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureAnimation;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureMeta;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import com.loohp.interactivechatdiscordsrvaddon.utils.ModelUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.TintUtils;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ModelRenderer
implements AutoCloseable {
    public static final Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> DEFAULT_POST_RESOLVE_FUNCTION = blockModel -> new ValuePairs(blockModel, Collections.emptyMap());
    public static final int INTERNAL_W = 64;
    public static final int INTERNAL_H = 64;
    public static final float RESCALE_22_5 = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    public static final float RESCALE_45 = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    public static final int QUALITY_THRESHOLD = 70;
    public static final int SKIN_RESOLUTION = 1600;
    public static final int TEXTURE_RESOLUTION = 800;
    public static final String CACHE_KEY = "ModelRender";
    public static final String MODEL_NOT_FOUND = "notfound";
    private static final double[] OVERLAY_ADDITION_FACTORS = new double[6];
    private static final String PLAYER_MODEL_RESOURCELOCATION = "minecraft:interactivechatdiscordsrvaddon/builtin_entity/player_model";
    private static final String PLAYER_MODEL_SLIM_RESOURCELOCATION = "minecraft:interactivechatdiscordsrvaddon/builtin_entity/player_model_slim";
    private Function<String, ThreadFactory> threadFactoryBuilder;
    private LongSupplier cacheTimeoutSupplier;
    private IntSupplier modelThreads;
    private IntSupplier renderThreads;
    private ThreadPoolExecutor modelResolvingService;
    private ThreadPoolExecutor renderingService;
    private ScheduledExecutorService controlService;
    private AtomicBoolean isValid = new AtomicBoolean(true);

    public ModelRenderer(Function<String, ThreadFactory> threadFactoryBuilder, LongSupplier cacheTimeoutSupplier, IntSupplier modelThreads, IntSupplier renderThreads) {
        this.threadFactoryBuilder = threadFactoryBuilder;
        this.cacheTimeoutSupplier = cacheTimeoutSupplier;
        this.modelThreads = modelThreads;
        this.renderThreads = renderThreads;
        int modelThreadSize = modelThreads.getAsInt();
        int renderThreadSize = renderThreads.getAsInt();
        ThreadFactory factory0 = threadFactoryBuilder.apply("InteractiveChatDiscordSRVAddon Async Model Resolving Thread #%d");
        this.modelResolvingService = new ThreadPoolExecutor(modelThreadSize, modelThreadSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory0);
        ThreadFactory factory1 = threadFactoryBuilder.apply("InteractiveChatDiscordSRVAddon Async Model Rendering Thread #%d");
        this.renderingService = new ThreadPoolExecutor(renderThreadSize, renderThreadSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory1);
        ThreadFactory factory2 = threadFactoryBuilder.apply("InteractiveChatDiscordSRVAddon Async Model Renderer Control Thread");
        this.controlService = Executors.newSingleThreadScheduledExecutor(factory2);
        this.controlService.scheduleAtFixedRate(() -> this.reloadPoolSize(), 30L, 30L, TimeUnit.SECONDS);
    }

    public ModelRenderer(LongSupplier cacheTimeoutSupplier, IntSupplier modelThreads, IntSupplier renderThreads) {
        this(str -> Executors.defaultThreadFactory(), cacheTimeoutSupplier, modelThreads, renderThreads);
    }

    @Override
    public synchronized void close() {
        this.isValid.set(false);
        this.controlService.shutdown();
        this.modelResolvingService.shutdown();
        this.renderingService.shutdown();
    }

    public synchronized void reloadPoolSize() {
        int modelThreadSize = this.modelThreads.getAsInt();
        int renderThreadSize = this.renderThreads.getAsInt();
        this.modelResolvingService.setMaximumPoolSize(modelThreadSize);
        this.modelResolvingService.setCorePoolSize(modelThreadSize);
        this.renderingService.setMaximumPoolSize(renderThreadSize);
        this.renderingService.setCorePoolSize(renderThreadSize);
    }

    public RenderResult renderPlayer(int width, int height, ResourceManager manager, boolean post1_8, boolean slim, Map<String, TextureResource> providedTextures, TintUtils.TintIndexData tintIndexData, Map<PlayerModelItemPosition, PlayerModelItem> modelItems) {
        RenderResult renderResult;
        Object cachedRender;
        BlockModel playerModel = manager.getModelManager().resolveBlockModel(slim ? PLAYER_MODEL_SLIM_RESOURCELOCATION : PLAYER_MODEL_RESOURCELOCATION, InteractiveChat.version.isOld(), Collections.emptyMap());
        if (playerModel == null) {
            return new RenderResult(MODEL_NOT_FOUND);
        }
        Model playerRenderModel = this.generateStandardRenderModel(playerModel, manager, providedTextures, Collections.emptyMap(), tintIndexData, false, true, null);
        HashMap<PlayerModelItem, ValuePairs<BlockModel, Map<String, TextureResource>>> resolvedItems = new HashMap<PlayerModelItem, ValuePairs<BlockModel, Map<String, TextureResource>>>();
        for (PlayerModelItem playerModelItem : modelItems.values()) {
            BlockModel blockModel = playerModelItem.getModelKey() == null ? null : manager.getModelManager().resolveBlockModel(playerModelItem.getModelKey(), InteractiveChat.version.isOld(), playerModelItem.getPredicate());
            ValuePairs<BlockModel, Map<String, TextureResource>> resolveFunctionResult = playerModelItem.getPostResolveFunction().apply(blockModel);
            BlockModel blockModel2 = (BlockModel)resolveFunctionResult.getFirst();
            Map overrideTextures = (Map)resolveFunctionResult.getSecond();
            resolvedItems.put(playerModelItem, (ValuePairs<BlockModel, Map<String, TextureResource>>)new ValuePairs((Object)blockModel2, (Object)overrideTextures));
        }
        String cacheKey = this.cacheKey(width, height, manager.getUuid(), slim, this.cacheKeyResolvedItems(resolvedItems), this.cacheKeyProvidedTextures(providedTextures));
        if (manager.hasResourceRegistry("CacheManager", ICacheManager.class) && (cachedRender = manager.getResourceRegistry("CacheManager", ICacheManager.class).getCache(cacheKey)) != null && (renderResult = (RenderResult)((CacheObject)cachedRender).getObject()).isSuccessful()) {
            return renderResult;
        }
        for (Map.Entry entry : resolvedItems.entrySet()) {
            Coordinates3D transform;
            Coordinates3D rotation;
            PlayerModelItem playerModelItem = (PlayerModelItem)entry.getKey();
            BlockModel itemBlockModel = (BlockModel)((ValuePairs)entry.getValue()).getFirst();
            Map overrideTextures = (Map)((ValuePairs)entry.getValue()).getSecond();
            Model itemRenderModel = null;
            if (itemBlockModel != null) {
                if (itemBlockModel.getRawParent() == null || !itemBlockModel.getRawParent().contains("/")) {
                    itemRenderModel = this.generateStandardRenderModel(itemBlockModel, manager, playerModelItem.getProvidedTextures(), overrideTextures, playerModelItem.getTintIndexData(), playerModelItem.isEnchanted(), false, playerModelItem.getRawEnchantmentGlintProvider());
                } else if (itemBlockModel.getRawParent().equals("builtin/generated")) {
                    BufferedImage image = new BufferedImage(64, 64, 2);
                    Graphics2D g = image.createGraphics();
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    int i = 0;
                    while (itemBlockModel.getTextures().containsKey("layer" + i)) {
                        TextureResource resource = overrideTextures.getOrDefault("", (TextureResource)overrideTextures.get("layer" + i));
                        String resourceLocation = itemBlockModel.getTextures().get("layer" + i);
                        if (!resourceLocation.contains(":")) {
                            resourceLocation = "minecraft:" + resourceLocation;
                        }
                        if (resource == null) {
                            resource = providedTextures.get(resourceLocation);
                        }
                        if (resource == null) {
                            resource = manager.getTextureManager().getTexture(resourceLocation);
                        }
                        BufferedImage texture = resource.getTexture();
                        texture = tintIndexData.applyTint(texture, 1);
                        if (resource.hasTextureMeta()) {
                            TextureProperties properties;
                            TextureMeta meta = resource.getTextureMeta();
                            if (meta.hasProperties() && (properties = meta.getProperties()).isBlur()) {
                                texture = ImageUtils.applyGaussianBlur(texture);
                            }
                            if (meta.hasAnimation()) {
                                TextureAnimation animation = meta.getAnimation();
                                texture = animation.hasWidth() && animation.hasHeight() ? ImageUtils.copyAndGetSubImage(texture, 0, 0, animation.getWidth(), animation.getHeight()) : ImageUtils.copyAndGetSubImage(texture, 0, 0, texture.getWidth(), texture.getWidth());
                            }
                        }
                        g.drawImage(texture, 0, 0, image.getWidth(), image.getHeight(), null);
                        ++i;
                    }
                    g.dispose();
                    image = tintIndexData.applyTint(image, 0);
                    if (playerModelItem.isEnchanted()) {
                        image = (BufferedImage)playerModelItem.getEnchantmentGlintProvider().apply(image);
                    }
                    itemRenderModel = this.generateItemRenderModel(16.0, 16.0, 16.0, image);
                }
            }
            if (itemRenderModel == null) continue;
            itemRenderModel.translate(-8.0, -8.0, -8.0);
            ModelDisplay displayData = itemBlockModel.getRawDisplay().get((Object)playerModelItem.getPosition().getModelDisplayPosition());
            boolean flipX = playerModelItem.getPosition().isLiteralFlipped();
            boolean isMirror = false;
            if (displayData == null && playerModelItem.getPosition().getModelDisplayPosition().hasFallback()) {
                displayData = itemBlockModel.getRawDisplay().get((Object)playerModelItem.getPosition().getModelDisplayPosition().getFallback());
                isMirror = true;
            }
            if (isMirror || !flipX) {
                if (displayData != null) {
                    Coordinates3D scale = displayData.getScale();
                    itemRenderModel.scale(scale.getX(), scale.getY(), scale.getZ());
                    rotation = displayData.getRotation();
                    itemRenderModel.rotate(rotation.getX(), rotation.getY(), rotation.getZ() + (double)(post1_8 ? 10 : 0), false);
                    transform = displayData.getTranslation();
                    itemRenderModel.translate(transform.getX(), transform.getY() + (double)(post1_8 ? -10 : 0), transform.getZ() + (post1_8 ? -2.75 : 0.0));
                }
                if (flipX) {
                    itemRenderModel.flipAboutPlane(false, true, true);
                }
            } else if (displayData != null) {
                Coordinates3D scale = displayData.getScale();
                itemRenderModel.scale(scale.getX(), scale.getY(), scale.getZ());
                rotation = displayData.getRotation();
                itemRenderModel.rotate(rotation.getX(), -rotation.getY(), -rotation.getZ(), false);
                transform = displayData.getTranslation();
                itemRenderModel.translate(-transform.getX(), transform.getY(), transform.getZ());
            }
            if (playerModelItem.getPosition().yIsZAxis()) {
                if (post1_8) {
                    itemRenderModel.rotate(180.0, 180.0, 0.0, false);
                } else {
                    itemRenderModel.rotate(90.0, 0.0, 0.0, true);
                }
            }
            double scale = playerModelItem.getPosition().getScale();
            itemRenderModel.scale(scale, scale, scale);
            itemRenderModel.translate(16.0 * scale / 2.0, 16.0 * scale / 2.0, 16.0 * scale / 2.0);
            Coordinates3D defaultTranslation = playerModelItem.getPosition().getDefaultTranslate();
            itemRenderModel.translate(defaultTranslation.getX(), defaultTranslation.getY(), defaultTranslation.getZ());
            playerRenderModel.append(itemRenderModel);
        }
        playerRenderModel.translate(-8.0, -8.0, -8.0);
        playerRenderModel.rotate(0.0, 180.0, 0.0, false);
        playerRenderModel.translate(8.0, 8.0, 8.0);
        BufferedImage image = new BufferedImage(width, height, 2);
        this.renderPlayerModel(playerRenderModel, image, playerModel.getGUILight());
        RenderResult renderResult2 = new RenderResult(image);
        manager.getResourceRegistry("CacheManager", ICacheManager.class).putCache(cacheKey, renderResult2);
        return renderResult2;
    }

    public RenderResult render(int width, int height, ResourceManager manager, Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> postResolveFunction, boolean post1_8, String modelKey, ModelDisplay.ModelDisplayPosition displayPosition, boolean enchanted, UnaryOperator<BufferedImage> enchantmentGlintProvider, Function<BufferedImage, RawEnchantmentGlintData> rawEnchantmentGlintProvider) {
        return this.render(width, height, manager, postResolveFunction, post1_8, modelKey, displayPosition, Collections.emptyMap(), Collections.emptyMap(), TintUtils.TintIndexData.EMPTY_INSTANCE, enchanted, enchantmentGlintProvider, rawEnchantmentGlintProvider);
    }

    public RenderResult render(int width, int height, ResourceManager manager, Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> postResolveFunction, boolean post1_8, String modelKey, ModelDisplay.ModelDisplayPosition displayPosition, Map<ModelOverride.ModelOverrideType, Float> predicate, Map<String, TextureResource> providedTextures, TintUtils.TintIndexData tintIndexData, boolean enchanted, UnaryOperator<BufferedImage> enchantmentGlintProvider, Function<BufferedImage, RawEnchantmentGlintData> rawEnchantmentGlintProvider) {
        return this.render(width, height, 64, 64, manager, postResolveFunction, post1_8, modelKey, displayPosition, predicate, providedTextures, tintIndexData, enchanted, enchantmentGlintProvider, rawEnchantmentGlintProvider);
    }

    public RenderResult render(int width, int height, int internalWidth, int internalHeight, ResourceManager manager, Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> postResolveFunction, boolean post1_8, String modelKey, ModelDisplay.ModelDisplayPosition displayPosition, Map<ModelOverride.ModelOverrideType, Float> predicate, Map<String, TextureResource> providedTextures, TintUtils.TintIndexData tintIndexData, boolean enchanted, UnaryOperator<BufferedImage> enchantmentGlintProvider, Function<BufferedImage, RawEnchantmentGlintData> rawEnchantmentGlintProvider) {
        return this.render(width, height, internalWidth, internalHeight, manager, postResolveFunction, post1_8, modelKey, displayPosition, predicate, providedTextures, tintIndexData, enchanted, false, enchantmentGlintProvider, rawEnchantmentGlintProvider);
    }

    public RenderResult render(int width, int height, int internalWidth, int internalHeight, ResourceManager manager, Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> postResolveFunction, boolean post1_8, String modelKey, ModelDisplay.ModelDisplayPosition displayPosition, Map<ModelOverride.ModelOverrideType, Float> predicate, Map<String, TextureResource> providedTextures, TintUtils.TintIndexData tintIndexData, boolean enchanted, boolean usePlayerModelPosition, UnaryOperator<BufferedImage> enchantmentGlintProvider, Function<BufferedImage, RawEnchantmentGlintData> rawEnchantmentGlintProvider) {
        RenderResult cachedResult;
        if (postResolveFunction == null) {
            postResolveFunction = DEFAULT_POST_RESOLVE_FUNCTION;
        }
        String rejectedReason = null;
        BlockModel blockModel = manager.getModelManager().resolveBlockModel(modelKey, post1_8, predicate);
        ValuePairs<BlockModel, Map<String, TextureResource>> resolveFunctionResult = postResolveFunction.apply(blockModel);
        blockModel = (BlockModel)resolveFunctionResult.getFirst();
        Map overrideTextures = (Map)resolveFunctionResult.getSecond();
        if (blockModel == null) {
            return new RenderResult(MODEL_NOT_FOUND);
        }
        String cacheKey = this.cacheKey(new Object[]{width, height, manager.getUuid(), postResolveFunction.hashCode(), modelKey, displayPosition, predicate, this.cacheKeyProvidedTextures(providedTextures), this.cacheKeyProvidedTextures(overrideTextures), enchanted});
        CacheObject<?> cachedRender = manager.getResourceRegistry("CacheManager", ICacheManager.class).getCache(cacheKey);
        if (cachedRender != null && (cachedResult = (RenderResult)cachedRender.getObject()).isSuccessful()) {
            return cachedResult;
        }
        BufferedImage image = new BufferedImage(internalWidth, internalHeight, 2);
        if (blockModel.getRawParent() == null || !blockModel.getRawParent().contains("/")) {
            this.renderBlockModel(this.generateStandardRenderModel(blockModel, manager, providedTextures, overrideTextures, tintIndexData, enchanted, false, rawEnchantmentGlintProvider), image, blockModel.getDisplay(displayPosition), blockModel.getGUILight(), usePlayerModelPosition);
        } else if (blockModel.getRawParent().equals("builtin/generated")) {
            Graphics2D g = image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            int i = 0;
            while (blockModel.getTextures().containsKey("layer" + i)) {
                TextureResource resource = overrideTextures.getOrDefault("", (TextureResource)overrideTextures.get("layer" + i));
                String resourceLocation = blockModel.getTextures().get("layer" + i);
                if (!resourceLocation.contains(":")) {
                    resourceLocation = "minecraft:" + resourceLocation;
                }
                if (resource == null) {
                    resource = providedTextures.get(resourceLocation);
                }
                if (resource == null) {
                    resource = manager.getTextureManager().getTexture(resourceLocation);
                }
                BufferedImage texture = resource.getTexture();
                if (resource.hasTextureMeta()) {
                    TextureProperties properties;
                    TextureMeta meta = resource.getTextureMeta();
                    if (meta.hasProperties() && (properties = meta.getProperties()).isBlur()) {
                        texture = ImageUtils.applyGaussianBlur(texture);
                    }
                    if (meta.hasAnimation()) {
                        TextureAnimation animation = meta.getAnimation();
                        texture = animation.hasWidth() && animation.hasHeight() ? ImageUtils.copyAndGetSubImage(texture, 0, 0, animation.getWidth(), animation.getHeight()) : ImageUtils.copyAndGetSubImage(texture, 0, 0, texture.getWidth(), texture.getWidth());
                    }
                }
                g.drawImage(texture, 0, 0, image.getWidth(), image.getHeight(), null);
                ++i;
            }
            g.dispose();
            image = tintIndexData.applyTint(image, 0);
            if (enchanted) {
                image = (BufferedImage)enchantmentGlintProvider.apply(image);
            }
        } else {
            rejectedReason = blockModel.getRawParent();
        }
        RenderResult result = rejectedReason == null ? new RenderResult(ImageUtils.resizeImageQuality(image, width, height)) : new RenderResult(rejectedReason == null ? "null" : rejectedReason);
        manager.getResourceRegistry("CacheManager", ICacheManager.class).putCache(cacheKey, result);
        return result;
    }

    private Model generateItemRenderModel(double width, double height, double depth, BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        double intervalX = 1.0 / (double)w * width;
        double intervalY = 1.0 / (double)h * height;
        double z = depth / 2.0 - 0.5;
        ArrayList<Hexahedron> hexahedrons = new ArrayList<Hexahedron>();
        int[] colors = image.getRGB(0, 0, w, h, null, 0, w);
        hexahedrons.add(Hexahedron.fromCorners(new Point3D(0.0, 0.0, z), new Point3D(width, height, z + 1.0), new BufferedImage[]{null, null, ImageUtils.flipHorizontal(image), null, ImageUtils.copyImage(image), null}));
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int color = colors[y * w + x];
                if (ColorUtils.getAlpha(color) <= 0) continue;
                BufferedImage pixel = new BufferedImage(1, 1, 2);
                pixel.setRGB(0, 0, color);
                BufferedImage[] imageArray = new BufferedImage[6];
                imageArray[0] = ColorUtils.getAlpha(ImageUtils.getRGB(colors, x, y + 1, w, h)) <= 0 ? ImageUtils.copyImage(pixel) : null;
                imageArray[1] = ColorUtils.getAlpha(ImageUtils.getRGB(colors, x, y - 1, w, h)) <= 0 ? ImageUtils.copyImage(pixel) : null;
                imageArray[2] = null;
                imageArray[3] = ColorUtils.getAlpha(ImageUtils.getRGB(colors, x + 1, y, w, h)) <= 0 ? ImageUtils.copyImage(pixel) : null;
                imageArray[4] = null;
                BufferedImage bufferedImage = imageArray[5] = ColorUtils.getAlpha(ImageUtils.getRGB(colors, x - 1, y, w, h)) <= 0 ? ImageUtils.copyImage(pixel) : null;
                if (CustomArrayUtils.allNull((Object)imageArray)) continue;
                double scaledX = (double)x * intervalX;
                double scaledY = height - (double)y * intervalY;
                hexahedrons.add(Hexahedron.fromCorners(new Point3D(scaledX, scaledY, z), new Point3D(scaledX + intervalX, scaledY - intervalY, z + 1.0), imageArray));
            }
        }
        return new Model(hexahedrons);
    }

    private Model generateStandardRenderModel(BlockModel blockModel, ResourceManager manager, Map<String, TextureResource> providedTextures, Map<String, TextureResource> overrideTextures, TintUtils.TintIndexData tintIndexData, boolean enchanted, boolean skin, Function<BufferedImage, RawEnchantmentGlintData> rawEnchantmentGlintProvider) {
        ConcurrentHashMap cachedResize = new ConcurrentHashMap();
        ArrayList<ModelElement> elements = new ArrayList<ModelElement>(blockModel.getElements());
        ArrayList<Hexahedron> hexahedrons = new ArrayList<Hexahedron>(elements.size());
        ConcurrentLinkedQueue<Future<Hexahedron>> tasks = new ConcurrentLinkedQueue<Future<Hexahedron>>();
        Iterator itr = elements.iterator();
        while (itr.hasNext()) {
            ModelElement element = (ModelElement)itr.next();
            tasks.add(this.modelResolvingService.submit(() -> {
                ModelElement.ModelElementRotation rotation = element.getRotation();
                BufferedImage[] images = new BufferedImage[6];
                Hexahedron hexahedron = Hexahedron.fromCorners(new Point3D(element.getFrom().getX(), element.getFrom().getY(), element.getFrom().getZ()), new Point3D(element.getTo().getX(), element.getTo().getY(), element.getTo().getZ()), images);
                BufferedImage[][] overlayImages = new BufferedImage[6][];
                BlendingModes[][] overlayBlendMode = new BlendingModes[6][];
                int i = 0;
                for (ModelFace.ModelFaceSide side : ModelFace.ModelFaceSide.values()) {
                    ModelFace faceData = element.getFace(side);
                    if (faceData == null) {
                        images[i] = null;
                    } else {
                        Face face;
                        ModelFace.ModelFaceSide cullface = faceData.getCullface();
                        if (cullface != null && ModelUtils.shouldTriggerCullface(face = hexahedron.getByDirectionOrder().get(i), cullface)) {
                            switch (cullface) {
                                case UP: {
                                    face.setCullface(hexahedron.getDownFace());
                                    break;
                                }
                                case DOWN: {
                                    face.setCullface(hexahedron.getUpFace());
                                    break;
                                }
                                case NORTH: {
                                    face.setCullface(hexahedron.getSouthFace());
                                    break;
                                }
                                case EAST: {
                                    face.setCullface(hexahedron.getWestFace());
                                    break;
                                }
                                case SOUTH: {
                                    face.setCullface(hexahedron.getNorthFace());
                                    break;
                                }
                                case WEST: {
                                    face.setCullface(hexahedron.getEastFace());
                                }
                            }
                        }
                        TextureUV uv = faceData.getUV();
                        TextureResource resource = this.findKey(blockModel.getTextures(), faceData.getRawTexture()).stream().findFirst().map(each -> (TextureResource)overrideTextures.get(each)).orElse(null);
                        if (resource == null) {
                            resource = (TextureResource)providedTextures.get(faceData.getTexture());
                        }
                        if (resource == null) {
                            resource = manager.getTextureManager().getTexture(faceData.getTexture(), false);
                        }
                        if (resource == null || !resource.isTexture()) {
                            images[i] = null;
                        } else if (uv != null && (uv.getXDiff() == 0.0 || uv.getYDiff() == 0.0)) {
                            images[i] = null;
                        } else {
                            BufferedImage cached = (BufferedImage)cachedResize.get(faceData.getTexture());
                            if (cached == null) {
                                cached = resource.getTexture();
                                if (resource.hasTextureMeta()) {
                                    TextureProperties properties;
                                    TextureMeta meta = resource.getTextureMeta();
                                    if (meta.hasProperties() && (properties = meta.getProperties()).isBlur()) {
                                        cached = ImageUtils.applyGaussianBlur(cached);
                                    }
                                    if (meta.hasAnimation()) {
                                        TextureAnimation animation = meta.getAnimation();
                                        cached = animation.hasWidth() && animation.hasHeight() ? ImageUtils.copyAndGetSubImage(cached, 0, 0, animation.getWidth(), animation.getHeight()) : ImageUtils.copyAndGetSubImage(cached, 0, 0, cached.getWidth(), cached.getWidth());
                                    }
                                }
                                cached = cached.getWidth() > cached.getHeight() ? ImageUtils.resizeImageFillWidth(cached, skin ? 1600 : 800) : ImageUtils.resizeImageFillHeight(cached, skin ? 1600 : 800);
                                cachedResize.put(faceData.getTexture(), cached);
                            }
                            images[i] = ImageUtils.copyImage(cached);
                            if (uv == null) {
                                double y2;
                                double x2;
                                double y1;
                                double x1;
                                switch (side) {
                                    case DOWN: {
                                        Point3D[] points = hexahedron.getDownFace().getPoints();
                                        x1 = points[2].z;
                                        y1 = points[2].x;
                                        x2 = points[0].z;
                                        y2 = points[0].x;
                                        break;
                                    }
                                    case EAST: {
                                        Point3D[] points = hexahedron.getEastFace().getPoints();
                                        x1 = points[2].z;
                                        y1 = points[2].y;
                                        x2 = points[0].z;
                                        y2 = points[0].y;
                                        break;
                                    }
                                    case NORTH: {
                                        Point3D[] points = hexahedron.getNorthFace().getPoints();
                                        x1 = points[2].x;
                                        y1 = points[2].y;
                                        x2 = points[0].x;
                                        y2 = points[0].y;
                                        break;
                                    }
                                    case SOUTH: {
                                        Point3D[] points = hexahedron.getSouthFace().getPoints();
                                        x1 = points[0].x;
                                        y1 = points[2].y;
                                        x2 = points[2].x;
                                        y2 = points[0].y;
                                        break;
                                    }
                                    case UP: {
                                        Point3D[] points = hexahedron.getUpFace().getPoints();
                                        x1 = points[0].x;
                                        y1 = points[0].z;
                                        x2 = points[2].x;
                                        y2 = points[2].z;
                                        break;
                                    }
                                    default: {
                                        Point3D[] points = hexahedron.getWestFace().getPoints();
                                        x1 = points[0].z;
                                        y1 = points[2].y;
                                        x2 = points[2].z;
                                        y2 = points[0].y;
                                    }
                                }
                                uv = new TextureUV(x1, y1, x2, y2);
                            }
                            uv = uv.getScaled(1.0, (double)images[i].getHeight() / (double)images[i].getWidth());
                            uv = uv.getScaled((double)images[i].getWidth() / 16.0);
                            int x1 = (int)Math.ceil(uv.getX1());
                            int y1 = (int)Math.ceil(uv.getY1());
                            int dX = Math.abs((int)Math.floor(uv.getX2()) - x1);
                            int dY = Math.abs((int)Math.floor(uv.getY2()) - y1);
                            if (uv.isVerticallyFlipped()) {
                                images[i] = ImageUtils.flipVertically(images[i]);
                                y1 = images[i].getHeight() - y1;
                            }
                            if (uv.isHorizontallyFlipped()) {
                                images[i] = ImageUtils.flipHorizontal(images[i]);
                                x1 = images[i].getWidth() - x1;
                            }
                            images[i] = ImageUtils.copyAndGetSubImage(images[i], x1, y1, Math.max(1, dX), Math.max(1, dY));
                            int rotationAngle = faceData.getRotation();
                            if (rotationAngle % 360 != 0) {
                                images[i] = ImageUtils.rotateImageByDegrees(images[i], rotationAngle);
                            }
                            images[i] = tintIndexData.applyTint(images[i], faceData.getTintindex());
                            if (enchanted) {
                                RawEnchantmentGlintData overlayResult = (RawEnchantmentGlintData)rawEnchantmentGlintProvider.apply(images[i]);
                                overlayImages[i] = overlayResult.getOverlay().toArray(new BufferedImage[0]);
                                overlayBlendMode[i] = (BlendingModes[])overlayResult.getBlending().stream().map(each -> BlendingUtils.convert(each)).toArray(BlendingModes[]::new);
                            }
                        }
                    }
                    ++i;
                }
                hexahedron.setImage(images);
                hexahedron.setOverlay(overlayImages);
                hexahedron.setOverlayBlendingMode(overlayBlendMode);
                hexahedron.setOverlayAdditionFactor(OVERLAY_ADDITION_FACTORS);
                if (rotation != null) {
                    double absAngle;
                    hexahedron.translate(-rotation.getOrigin().getX(), -rotation.getOrigin().getY(), -rotation.getOrigin().getZ());
                    if (rotation.isRescale() && (absAngle = Math.abs(rotation.getAngle())) != 0.0) {
                        if (absAngle == 22.5) {
                            hexahedron.scale(RESCALE_22_5, RESCALE_22_5, RESCALE_22_5);
                        } else if (absAngle == 45.0) {
                            hexahedron.scale(RESCALE_45, RESCALE_45, RESCALE_45);
                        } else {
                            throw new IllegalArgumentException("Element rotation can only be between angles 45 and -45 with 22.5 degrees increments");
                        }
                    }
                    switch (rotation.getAxis()) {
                        case X: {
                            hexahedron.rotate(rotation.getAngle(), 0.0, 0.0, false);
                            break;
                        }
                        case Y: {
                            hexahedron.rotate(0.0, rotation.getAngle(), 0.0, false);
                            break;
                        }
                        default: {
                            hexahedron.rotate(0.0, 0.0, rotation.getAngle(), false);
                        }
                    }
                    hexahedron.translate(rotation.getOrigin().getX(), rotation.getOrigin().getY(), rotation.getOrigin().getZ());
                }
                return hexahedron;
            }));
            itr.remove();
        }
        while (!tasks.isEmpty() || !elements.isEmpty()) {
            Future task = (Future)tasks.poll();
            if (task == null) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                hexahedrons.add((Hexahedron)task.get());
            }
            catch (Throwable e) {
                new RuntimeException("Unable to generate model: " + blockModel.getResourceLocation(), e).printStackTrace();
                hexahedrons = null;
                for (Future future : tasks) {
                    future.cancel(true);
                }
                tasks = null;
                if (e instanceof OutOfMemoryError) {
                    System.gc();
                }
                Object[] missingTextures = new BufferedImage[6];
                Arrays.fill(missingTextures, TextureManager.getMissingImage(16, 16));
                return new Model(Hexahedron.fromCorners(new Point3D(0.0, 0.0, 0.0), new Point3D(16.0, 16.0, 16.0), (BufferedImage[])missingTextures));
            }
        }
        return new Model(hexahedrons);
    }

    private void renderPlayerModel(Model renderModel, BufferedImage image, ModelGUILight lightData) {
        AffineTransform baseTransform = AffineTransform.getTranslateInstance((double)image.getWidth() / 2.0, (double)image.getHeight() / 7.0 * 5.0);
        baseTransform.concatenate(AffineTransform.getScaleInstance((double)image.getWidth() / 39.09375, (double)image.getWidth() / 39.09375));
        renderModel.translate(-8.0, -8.0, -8.0);
        renderModel.updateLighting(lightData.getLightVector(), lightData.getAmbientLevel(), lightData.getMaxLevel());
        long start = System.currentTimeMillis();
        renderModel.render(image, true, baseTransform, BlendingModes.NORMAL, this.renderingService).join();
        InteractiveChatDiscordSrvAddon.plugin.playerModelRenderingTimes.add((int)Math.min(System.currentTimeMillis() - start, Integer.MAX_VALUE));
    }

    private void renderBlockModel(Model renderModel, BufferedImage image, ModelDisplay displayData, ModelGUILight lightData, boolean usePlayerPosition) {
        AffineTransform baseTransform;
        if (usePlayerPosition) {
            renderModel.translate(-8.0, -8.0, -8.0);
            renderModel.rotate(0.0, 180.0, 0.0, false);
            renderModel.translate(8.0, 8.0, 8.0);
            baseTransform = AffineTransform.getTranslateInstance((double)image.getWidth() / 2.0, (double)image.getHeight() / 7.0 * 5.0);
            baseTransform.concatenate(AffineTransform.getScaleInstance((double)image.getWidth() / 39.09375, (double)image.getWidth() / 39.09375));
        } else {
            baseTransform = AffineTransform.getTranslateInstance((double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
            baseTransform.concatenate(AffineTransform.getScaleInstance((double)image.getWidth() / 16.0, (double)image.getHeight() / 16.0));
        }
        renderModel.translate(-8.0, -8.0, -8.0);
        if (displayData != null) {
            Coordinates3D scale = displayData.getScale();
            renderModel.scale(scale.getX(), scale.getY(), scale.getZ());
            Coordinates3D rotation = displayData.getRotation();
            renderModel.rotate(rotation.getX(), rotation.getY(), rotation.getZ(), false);
            Coordinates3D transform = displayData.getTranslation();
            renderModel.translate(transform.getX(), transform.getY(), transform.getZ());
        }
        renderModel.updateLighting(lightData.getLightVector(), lightData.getAmbientLevel(), lightData.getMaxLevel());
        renderModel.render(image, renderModel.getComponents().size() <= 70, baseTransform, BlendingModes.NORMAL, this.renderingService).join();
    }

    private String cacheKey(Object ... obj) {
        return Arrays.stream(obj).map(each -> {
            if (each == null) {
                return "null";
            }
            if (each instanceof Map) {
                return this.cacheKeyMap((Map)each);
            }
            return each.toString();
        }).collect(Collectors.joining("/", "ModelRender/", ""));
    }

    private String cacheKeyMap(Map<?, ?> map) {
        Comparator<Map.Entry> c = Comparator.comparing(entry -> entry.getKey() == null ? "null" : entry.getKey().toString());
        c = c.thenComparing(entry -> entry.getValue() == null ? "null" : entry.getValue().toString());
        return map.entrySet().stream().sorted(c).map(entry -> (entry.getKey() == null ? "null" : entry.getKey().toString()) + ":" + (entry.getValue() == null ? "null" : entry.getValue().toString())).collect(Collectors.joining(", ", "{", "}"));
    }

    private String cacheKeyProvidedTextures(Map<String, TextureResource> providedTextures) {
        return providedTextures.entrySet().stream().map(entry -> {
            TextureResource resource = (TextureResource)entry.getValue();
            if (resource.isTexture()) {
                return (String)entry.getKey() + ":" + ImageUtils.hash(resource.getTexture());
            }
            if (resource.hasFile()) {
                return (String)entry.getKey() + ":" + resource.getFile().getAbsolutePath();
            }
            return (String)entry.getKey() + ":" + resource;
        }).collect(Collectors.joining(", ", "{", "}"));
    }

    private String cacheKeyResolvedItems(Map<PlayerModelItem, ValuePairs<BlockModel, Map<String, TextureResource>>> modelItems) {
        return modelItems.entrySet().stream().map(entry -> {
            PlayerModelItem resource = (PlayerModelItem)entry.getKey();
            return entry.getKey() + ":[" + (Object)((Object)resource.getPosition()) + ", " + resource.getModelKey() + ", " + this.cacheKeyMap(resource.getPredicate()) + ", " + resource.isEnchanted() + ", " + this.cacheKeyProvidedTextures(resource.getProvidedTextures()) + ", " + resource.getPostResolveFunction().hashCode() + ", " + this.cacheKeyProvidedTextures((Map)((ValuePairs)entry.getValue()).getSecond()) + "]";
        }).collect(Collectors.joining(", ", "{", "}"));
    }

    private <K, V> Set<K> findKey(Map<K, V> map, V value) {
        HashSet<K> result = new HashSet<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    static {
        Arrays.fill(OVERLAY_ADDITION_FACTORS, 0.7450980392156863);
    }

    public static class RenderResult {
        private BufferedImage image;
        private String rejectedReason;

        public RenderResult(BufferedImage image) {
            this.image = image;
            this.rejectedReason = null;
        }

        public RenderResult(String rejectedReason) {
            this.image = null;
            this.rejectedReason = rejectedReason;
        }

        public boolean isSuccessful() {
            return this.image != null;
        }

        public BufferedImage getImage() {
            return ImageUtils.copyImage(this.image);
        }

        public String getRejectedReason() {
            return this.rejectedReason;
        }
    }

    public static class PlayerModelItem {
        private PlayerModelItemPosition position;
        private String modelKey;
        private Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> postResolveFunction;
        private Map<ModelOverride.ModelOverrideType, Float> predicate;
        private boolean enchanted;
        private Map<String, TextureResource> providedTextures;
        private TintUtils.TintIndexData tintIndexData;
        private UnaryOperator<BufferedImage> enchantmentGlintProvider;
        private Function<BufferedImage, RawEnchantmentGlintData> rawEnchantmentGlintProvider;

        public PlayerModelItem(PlayerModelItemPosition position, String modelKey, Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> postResolveFunction, Map<ModelOverride.ModelOverrideType, Float> predicate, boolean enchanted, Map<String, TextureResource> providedTextures, TintUtils.TintIndexData tintIndexData, UnaryOperator<BufferedImage> enchantmentGlintProvider, Function<BufferedImage, RawEnchantmentGlintData> rawEnchantmentGlintProvider) {
            this.position = position;
            this.modelKey = modelKey;
            this.postResolveFunction = postResolveFunction == null ? DEFAULT_POST_RESOLVE_FUNCTION : postResolveFunction;
            this.predicate = predicate;
            this.enchanted = enchanted;
            this.providedTextures = providedTextures;
            this.tintIndexData = tintIndexData;
            this.enchantmentGlintProvider = enchantmentGlintProvider;
            this.rawEnchantmentGlintProvider = rawEnchantmentGlintProvider;
        }

        public PlayerModelItemPosition getPosition() {
            return this.position;
        }

        public String getModelKey() {
            return this.modelKey;
        }

        public Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> getPostResolveFunction() {
            return this.postResolveFunction;
        }

        public Map<ModelOverride.ModelOverrideType, Float> getPredicate() {
            return this.predicate;
        }

        public boolean isEnchanted() {
            return this.enchanted;
        }

        public Map<String, TextureResource> getProvidedTextures() {
            return this.providedTextures;
        }

        public TintUtils.TintIndexData getTintIndexData() {
            return this.tintIndexData;
        }

        public UnaryOperator<BufferedImage> getEnchantmentGlintProvider() {
            return this.enchantmentGlintProvider;
        }

        public Function<BufferedImage, RawEnchantmentGlintData> getRawEnchantmentGlintProvider() {
            return this.rawEnchantmentGlintProvider;
        }
    }

    public static enum PlayerModelItemPosition {
        HELMET(new Coordinates3D(3.05, 22.05, 3.05), 0.62, false, false, ModelDisplay.ModelDisplayPosition.HEAD),
        RIGHT_HAND(new Coordinates3D(7.3, -2.5, 4.05), 0.9, false, true, ModelDisplay.ModelDisplayPosition.THIRDPERSON_RIGHTHAND),
        LEFT_HAND(new Coordinates3D(-5.6, -2.5, 4.05), 0.9, true, true, ModelDisplay.ModelDisplayPosition.THIRDPERSON_LEFTHAND);

        private Coordinates3D defaultTranslate;
        private double scale;
        private boolean literalFlipped;
        private boolean yIsZAxis;
        private ModelDisplay.ModelDisplayPosition modelDisplayPosition;

        private PlayerModelItemPosition(Coordinates3D defaultTranslate, double scale, boolean literalFlipped, boolean yIsZAxis, ModelDisplay.ModelDisplayPosition modelDisplayPosition) {
            this.defaultTranslate = defaultTranslate;
            this.scale = scale;
            this.literalFlipped = literalFlipped;
            this.yIsZAxis = yIsZAxis;
            this.modelDisplayPosition = modelDisplayPosition;
        }

        public ModelDisplay.ModelDisplayPosition getModelDisplayPosition() {
            return this.modelDisplayPosition;
        }

        public Coordinates3D getDefaultTranslate() {
            return this.defaultTranslate;
        }

        public double getScale() {
            return this.scale;
        }

        public boolean isLiteralFlipped() {
            return this.literalFlipped;
        }

        public boolean yIsZAxis() {
            return this.yIsZAxis;
        }
    }

    public static class RawEnchantmentGlintData {
        private List<BufferedImage> overlay;
        private List<EnchantmentProperties.OpenGLBlending> blending;

        public RawEnchantmentGlintData(List<BufferedImage> overlay, List<EnchantmentProperties.OpenGLBlending> blending) {
            this.overlay = overlay;
            this.blending = blending;
        }

        public List<BufferedImage> getOverlay() {
            return this.overlay;
        }

        public List<EnchantmentProperties.OpenGLBlending> getBlending() {
            return this.blending;
        }
    }
}

