/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechat.objectholders.OfflineICPlayer;
import com.loohp.interactivechat.objectholders.ValuePairs;
import com.loohp.interactivechatdiscordsrvaddon.resources.IResourceRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.BlockModel;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.EnchantmentProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CustomItemTextureRegistry
implements IResourceRegistry {
    public static final String IDENTIFIER = "CustomItemTextureRegistry";
    private List<CustomItemTextureResolver> resolvers = new CopyOnWriteArrayList<CustomItemTextureResolver>();

    public static ResourceManager.ResourceRegistrySupplier<CustomItemTextureRegistry> getDefaultSupplier() {
        return manager -> new CustomItemTextureRegistry();
    }

    @Override
    public String getRegistryIdentifier() {
        return IDENTIFIER;
    }

    public void appendResolver(CustomItemTextureResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void prependResolver(CustomItemTextureResolver resolver) {
        this.resolvers.add(0, resolver);
    }

    public void removeResolver(CustomItemTextureResolver resolver) {
        this.resolvers.remove(resolver);
    }

    public Optional<Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>>> getItemPostResolveFunction(String modelKey, EquipmentSlot heldSlot, ItemStack itemStack, boolean is1_8, Map<ModelOverride.ModelOverrideType, Float> predicates, OfflineICPlayer player, World world, LivingEntity entity, UnaryOperator<String> translateFunction) {
        return this.resolvers.stream().map(each -> result -> each.getItemPostResolveFunction((ValuePairs<BlockModel, Map<String, TextureResource>>)result, modelKey, heldSlot, itemStack, is1_8, predicates, player, world, entity, translateFunction)).reduce(Function::andThen).map(each -> ((Function<BlockModel, ValuePairs>)blockModel -> new ValuePairs(blockModel, new HashMap())).andThen(each));
    }

    public Optional<TextureResource> getElytraOverrideTextures(EquipmentSlot heldSlot, ItemStack itemStack, UnaryOperator<String> translateFunction) {
        return this.resolvers.stream().map(each -> each.getElytraOverrideTextures(heldSlot, itemStack, translateFunction)).filter(each -> each.isPresent()).findFirst().flatMap(each -> each);
    }

    public List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> getEnchantmentGlintOverrideTextures(EquipmentSlot heldSlot, ItemStack itemStack, Supplier<List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>>> ifEmpty, UnaryOperator<String> translateFunction) {
        return this.resolvers.stream().map(each -> each.getEnchantmentGlintOverrideTextures(heldSlot, itemStack, translateFunction)).filter(each -> !each.isEmpty()).findFirst().orElseGet(ifEmpty);
    }

    public Optional<TextureResource> getArmorOverrideTextures(String layer, EquipmentSlot heldSlot, ItemStack itemStack, OfflineICPlayer player, World world, LivingEntity entity, UnaryOperator<String> translateFunction) {
        return this.resolvers.stream().map(each -> each.getArmorOverrideTextures(layer, heldSlot, itemStack, player, world, entity, translateFunction)).filter(each -> each.isPresent()).findFirst().flatMap(each -> each);
    }

    public static interface CustomItemTextureResolver {
        public ValuePairs<BlockModel, Map<String, TextureResource>> getItemPostResolveFunction(ValuePairs<BlockModel, Map<String, TextureResource>> var1, String var2, EquipmentSlot var3, ItemStack var4, boolean var5, Map<ModelOverride.ModelOverrideType, Float> var6, OfflineICPlayer var7, World var8, LivingEntity var9, UnaryOperator<String> var10);

        public Optional<TextureResource> getElytraOverrideTextures(EquipmentSlot var1, ItemStack var2, UnaryOperator<String> var3);

        public List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> getEnchantmentGlintOverrideTextures(EquipmentSlot var1, ItemStack var2, UnaryOperator<String> var3);

        public Optional<TextureResource> getArmorOverrideTextures(String var1, EquipmentSlot var2, ItemStack var3, OfflineICPlayer var4, World var5, LivingEntity var6, UnaryOperator<String> var7);
    }
}

