/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ModelRenderer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;

public class CacheObject<T> {
    private long timeCreated;
    private T object;

    protected static CacheObject<?> deserialize(byte[] data) throws IOException, ClassNotFoundException {
        try (DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(data));){
            long timeCreated = inputStream.readLong();
            byte type = inputStream.readByte();
            if (type == 0) {
                byte[] dataArray = new byte[data.length - 9];
                inputStream.readFully(dataArray);
                CacheObject<String> cacheObject = new CacheObject<String>(timeCreated, new String(dataArray, StandardCharsets.UTF_8));
                return cacheObject;
            }
            if (type == 1) {
                byte[] dataArray = new byte[data.length - 9];
                inputStream.readFully(dataArray);
                CacheObject<BufferedImage> cacheObject = new CacheObject<BufferedImage>(timeCreated, ImageUtils.fromArray(dataArray));
                return cacheObject;
            }
            if (type == 2) {
                byte[] dataArray = new byte[data.length - 10];
                inputStream.readFully(dataArray);
                if (inputStream.readBoolean()) {
                    CacheObject<ModelRenderer.RenderResult> cacheObject = new CacheObject<ModelRenderer.RenderResult>(timeCreated, new ModelRenderer.RenderResult(ImageUtils.fromArray(dataArray)));
                    return cacheObject;
                }
                CacheObject<ModelRenderer.RenderResult> cacheObject = new CacheObject<ModelRenderer.RenderResult>(timeCreated, new ModelRenderer.RenderResult(new String(dataArray, StandardCharsets.UTF_8)));
                return cacheObject;
            }
            if (type == 3) {
                byte[] dataArray = new byte[data.length - 9];
                inputStream.readFully(dataArray);
                try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(dataArray));){
                    CacheObject<Object> cacheObject = new CacheObject<Object>(timeCreated, objectInputStream.readObject());
                    return cacheObject;
                }
            }
            throw new IllegalArgumentException("Illegal class type " + type);
        }
    }

    protected CacheObject(long timeCreated, T object) {
        this.timeCreated = timeCreated;
        this.object = object;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public T getObject() {
        return this.object;
    }

    protected byte[] serialize() throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                dataOutputStream.writeLong(this.timeCreated);
                if (this.object instanceof String) {
                    dataOutputStream.writeByte(0);
                    dataOutputStream.write(((String)this.object).getBytes(StandardCharsets.UTF_8));
                } else if (this.object instanceof BufferedImage) {
                    dataOutputStream.writeByte(1);
                    dataOutputStream.write(ImageUtils.toArray((BufferedImage)this.object));
                } else if (this.object instanceof ModelRenderer.RenderResult) {
                    dataOutputStream.writeByte(2);
                    ModelRenderer.RenderResult renderResult = (ModelRenderer.RenderResult)this.object;
                    if (renderResult.isSuccessful()) {
                        dataOutputStream.writeBoolean(true);
                        dataOutputStream.write(ImageUtils.toArray(renderResult.getImage()));
                    } else {
                        dataOutputStream.writeBoolean(false);
                        dataOutputStream.write(renderResult.getRejectedReason().getBytes(StandardCharsets.UTF_8));
                    }
                } else if (this.object instanceof Serializable) {
                    dataOutputStream.writeByte(3);
                    try (ObjectOutputStream outputStream = new ObjectOutputStream(dataOutputStream);){
                        outputStream.writeObject(this.object);
                        outputStream.flush();
                    }
                } else {
                    throw new IllegalArgumentException("Illegal object class: " + this.object.getClass());
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }
}

