/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources;

import com.loohp.interactivechat.utils.FileUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.org.mapdb.DB;
import com.loohp.interactivechatdiscordsrvaddon.libs.org.mapdb.DBMaker;
import com.loohp.interactivechatdiscordsrvaddon.libs.org.mapdb.HTreeMap;
import com.loohp.interactivechatdiscordsrvaddon.libs.org.mapdb.Serializer;
import com.loohp.interactivechatdiscordsrvaddon.resources.CacheObject;
import com.loohp.interactivechatdiscordsrvaddon.resources.ICacheManager;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CacheManager
implements ICacheManager {
    private File folder;
    private DB db;
    private HTreeMap<String, byte[]> cacheObjectMap;
    private ScheduledExecutorService service;
    private AtomicBoolean isValid;

    public CacheManager(File folder, Duration timeout) {
        this.folder = folder;
        if (folder.exists()) {
            FileUtils.removeFolderRecursively((File)folder);
        }
        folder.mkdirs();
        this.db = DBMaker.fileDB((File)new File(folder, "data.dat")).fileMmapEnableIfSupported().fileDeleteAfterClose().make();
        this.cacheObjectMap = this.db.hashMap("cache", (Serializer)Serializer.STRING, (Serializer)Serializer.BYTE_ARRAY).createOrOpen();
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleAtFixedRate(() -> this.cacheObjectMap.expireEvict(), 5L, 5L, TimeUnit.MINUTES);
        this.isValid = new AtomicBoolean(true);
    }

    @Override
    public String getRegistryIdentifier() {
        return "CacheManager";
    }

    @Override
    public CacheObject<?> getCache(String key) {
        if (!this.isValid.get()) {
            return null;
        }
        byte[] data = (byte[])this.cacheObjectMap.get((Object)key);
        if (data == null) {
            return null;
        }
        try {
            return CacheObject.deserialize(data);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public <T> void putCache(String key, T value) {
        if (!this.isValid.get()) {
            return;
        }
        try {
            this.cacheObjectMap.put((Object)key, (Object)new CacheObject<T>(System.currentTimeMillis(), value).serialize());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CacheObject<?> removeCache(String key) {
        if (!this.isValid.get()) {
            return null;
        }
        byte[] data = (byte[])this.cacheObjectMap.remove((Object)key);
        if (data == null) {
            return null;
        }
        try {
            return CacheObject.deserialize(data);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void clearAllCache() {
        if (!this.isValid.get()) {
            return;
        }
        this.cacheObjectMap.clear();
    }

    @Override
    public synchronized void close() {
        if (this.isValid.getAndSet(false)) {
            this.service.shutdown();
            this.cacheObjectMap.close();
            this.db.close();
            if (this.folder.exists()) {
                FileUtils.removeFolderRecursively((File)this.folder);
            }
        }
    }
}

