/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ToolTipComponent<T> {
    private T toolTipComponent;
    private ToolTipType<T> type;

    public static ToolTipComponent<Component> text(Component component) {
        return new ToolTipComponent<Component>(component, ToolTipType.TEXT);
    }

    public static ToolTipComponent<BufferedImage> image(BufferedImage image) {
        return new ToolTipComponent<BufferedImage>(image, ToolTipType.IMAGE);
    }

    private ToolTipComponent(T toolTipComponent, ToolTipType<T> type) {
        this.toolTipComponent = toolTipComponent;
        this.type = type;
    }

    public T getToolTipComponent() {
        return this.toolTipComponent;
    }

    public ToolTipType<T> getType() {
        return this.type;
    }

    public static final class ToolTipType<V> {
        public static final ToolTipType<Component> TEXT = new ToolTipType<Component>("TEXT", Component.class);
        public static final ToolTipType<BufferedImage> IMAGE = new ToolTipType<BufferedImage>("IMAGE", BufferedImage.class);
        private static final Map<String, ToolTipType<?>> TYPES;
        private String name;
        private Class<V> typeClass;

        public static Map<String, ToolTipType<?>> values() {
            return TYPES;
        }

        private ToolTipType(String name, Class<V> typeClass) {
            this.name = name;
            this.typeClass = typeClass;
        }

        public Class<V> getTypeClass() {
            return this.typeClass;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            HashMap<String, ToolTipType<Object>> types = new HashMap<String, ToolTipType<Object>>();
            types.put(TEXT.name(), TEXT);
            types.put(IMAGE.name(), IMAGE);
            TYPES = Collections.unmodifiableMap(types);
        }
    }
}

