/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageSticker;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class PreviewableImageContainer {
    private String name;
    private String url;
    private List<String> altUrls;
    private Supplier<CompletableFuture<InputStream>> retrieveInputStream;

    public static PreviewableImageContainer fromSticker(MessageSticker sticker) {
        return new PreviewableImageContainer(sticker.getName(), sticker.getIconUrl(), Collections.emptyList(), null);
    }

    public static PreviewableImageContainer fromAttachment(Message.Attachment attachment) {
        return new PreviewableImageContainer(attachment.getFileName(), attachment.getUrl(), Collections.singletonList(attachment.getProxyUrl()), () -> attachment.retrieveInputStream());
    }

    public PreviewableImageContainer(String name, String url, List<String> altUrls, Supplier<CompletableFuture<InputStream>> retrieveInputStream) {
        this.name = name;
        this.url = url;
        this.altUrls = altUrls;
        this.retrieveInputStream = retrieveInputStream;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public List<String> getAltUrls() {
        return this.altUrls;
    }

    public List<String> getAllUrls() {
        ArrayList<String> urls = new ArrayList<String>(this.altUrls);
        urls.add(0, this.url);
        return urls;
    }

    public CompletableFuture<InputStream> retrieveInputStream() {
        return this.retrieveInputStream == null ? null : this.retrieveInputStream.get();
    }
}

