/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import java.util.Objects;

public class IntegerRange {
    private int min;
    private int max;

    public IntegerRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public IntegerRange(String strValue) {
        switch (strValue.length() - strValue.replace("-", "").length()) {
            case 0: {
                this.max = this.min = Integer.parseInt(strValue);
                break;
            }
            case 1: {
                if (strValue.startsWith("-")) {
                    this.max = this.min = Integer.parseInt(strValue);
                    break;
                }
                if (strValue.endsWith("-")) {
                    this.min = Integer.parseInt(strValue.substring(0, strValue.length() - 1));
                    this.max = Integer.MAX_VALUE;
                    break;
                }
                String[] split = strValue.split("-");
                this.min = Integer.parseInt(split[0]);
                this.max = Integer.parseInt(split[1]);
                break;
            }
            case 2: {
                if (strValue.startsWith("--")) {
                    this.min = Integer.MIN_VALUE;
                    this.max = Integer.parseInt(strValue.substring(1));
                    break;
                }
                if (strValue.startsWith("-") && strValue.endsWith("-")) {
                    this.min = Integer.parseInt(strValue.substring(0, strValue.length() - 1));
                    this.max = Integer.MAX_VALUE;
                    break;
                }
                if (strValue.startsWith("-") && !strValue.endsWith("-") && !strValue.contains("--")) {
                    int lastDash = strValue.lastIndexOf(45);
                    this.min = Integer.parseInt(strValue.substring(0, lastDash));
                    this.max = Integer.parseInt(strValue.substring(lastDash + 1));
                    break;
                }
                throw new ResourceLoadingException("Could not parse range");
            }
            case 3: {
                if (!strValue.contains("---") && strValue.startsWith("-")) {
                    String[] split = strValue.split("--");
                    if (split.length != 2 || split[0].isEmpty() || split[1].isEmpty()) {
                        throw new ResourceLoadingException("Could not parse range");
                    }
                    this.min = Integer.parseInt(split[0]);
                    this.max = -Integer.parseInt(split[1]);
                    break;
                }
                throw new ResourceLoadingException("Could not parse range");
            }
            default: {
                throw new ResourceLoadingException("Could not parse range");
            }
        }
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean test(int value) {
        return this.min <= value && this.max >= value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerRange that = (IntegerRange)o;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

