/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.objectholders.CustomPlaceholder;
import com.loohp.interactivechat.objectholders.ICPlayer;
import com.loohp.interactivechat.objectholders.OfflineICPlayer;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.DiscordDisplayData;
import java.awt.Color;

public class HoverClickDisplayData
extends DiscordDisplayData {
    private String displayText;
    private Component hoverText;
    private Color color;
    private CustomPlaceholder.ClickEventAction clickAction;
    private String clickValue;

    public HoverClickDisplayData(OfflineICPlayer player, int position, Color color, String displayText, Component hoverText, CustomPlaceholder.ClickEventAction clickAction, String clickValue) {
        super(player, position);
        this.displayText = displayText;
        this.hoverText = hoverText;
        this.color = color;
        this.clickAction = clickAction;
        this.clickValue = clickValue;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Component getHoverText() {
        return this.hoverText;
    }

    public boolean hasHover() {
        return this.hoverText != null;
    }

    public Color getColor() {
        return this.color;
    }

    public CustomPlaceholder.ClickEventAction getClickAction() {
        return this.clickAction;
    }

    public String getClickValue() {
        return this.clickValue;
    }

    public boolean hasClick() {
        return this.clickAction != null && this.clickValue != null;
    }

    public static class Builder {
        private ICPlayer player;
        private Integer postion;
        private String displayText;
        private Component hoverText;
        private Color color;
        private CustomPlaceholder.ClickEventAction clickAction;
        private String clickValue;

        public ICPlayer getPlayer() {
            return this.player;
        }

        public Builder player(ICPlayer player) {
            this.player = player;
            return this;
        }

        public Integer getPostion() {
            return this.postion;
        }

        public Builder postion(int postion) {
            this.postion = postion;
            return this;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Component getHoverText() {
            return this.hoverText;
        }

        public Builder hoverText(Component hoverText) {
            this.hoverText = hoverText;
            return this;
        }

        public Color getColor() {
            return this.color;
        }

        public Builder color(Color color) {
            this.color = color;
            return this;
        }

        public CustomPlaceholder.ClickEventAction getClickAction() {
            return this.clickAction;
        }

        public Builder clickAction(CustomPlaceholder.ClickEventAction clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public String getClickValue() {
            return this.clickValue;
        }

        public Builder clickValue(String clickValue) {
            this.clickValue = clickValue;
            return this;
        }

        public HoverClickDisplayData build() {
            if (this.player == null) {
                throw new IllegalStateException("player must be provided");
            }
            if (this.postion == null) {
                throw new IllegalStateException("postion must be provided");
            }
            if (this.color == null) {
                throw new IllegalStateException("color must be provided");
            }
            if (this.displayText == null) {
                throw new IllegalStateException("displayText must be provided");
            }
            return new HoverClickDisplayData((OfflineICPlayer)this.player, this.postion, this.color, this.displayText, this.hoverText, this.clickAction, this.clickValue);
        }
    }
}

