/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import java.lang.reflect.Field;
import java.util.function.Function;

public class FieldAccessor<T> {
    private Field field;
    private Function<Object, T> mapper;
    private T defaultValue;

    public static <T> FieldAccessor<T> fromField(Field field, Function<Object, T> mapper, T defaultValue) {
        return new FieldAccessor<T>(field, mapper, defaultValue);
    }

    public static <T> FieldAccessor<T> fromField(Field field, Function<Object, T> mapper) {
        return new FieldAccessor<Object>(field, mapper, null);
    }

    public static <T> FieldAccessor<T> fromField(Field field, T defaultValue) {
        return new FieldAccessor<T>(field, null, defaultValue);
    }

    public static <T> FieldAccessor<T> fromField(Field field) {
        return new FieldAccessor<Object>(field, null, null);
    }

    public static <T> FieldAccessor<T> ofValue(T defaultValue) {
        return new FieldAccessor<T>(null, null, defaultValue);
    }

    private FieldAccessor(Field field, Function<Object, T> mapper, T defaultValue) {
        this.field = field;
        this.mapper = mapper;
        this.defaultValue = defaultValue;
    }

    public T get(Object object) throws IllegalAccessException {
        this.field.setAccessible(true);
        Object obj = this.field.get(object);
        if (this.mapper != null) {
            return this.mapper.apply(obj);
        }
        return (T)obj;
    }

    public T getOrDefault(Object object) {
        if (this.field == null) {
            return this.defaultValue;
        }
        try {
            this.field.setAccessible(true);
            Object obj = this.field.get(object);
            if (this.mapper != null) {
                return this.mapper.apply(obj);
            }
            return (T)obj;
        }
        catch (Throwable e) {
            return this.defaultValue;
        }
    }

    public Field getField() {
        return this.field;
    }

    public Function<Object, T> getMapper() {
        return this.mapper;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }
}

