/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import com.loohp.interactivechat.objectholders.ValuePairs;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.MessageAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.AttachmentOption;
import github.scarsz.discordsrv.objects.MessageFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiscordMessageContent {
    private String authorName;
    private String authorIconUrl;
    private String title;
    private List<String> description;
    private List<String> imageUrl;
    private String thumbnail;
    private List<MessageEmbed.Field> fields;
    private int color;
    private String footer;
    private String footerImageUrl;
    private Map<String, byte[]> attachments;

    public DiscordMessageContent(String authorName, String authorIconUrl, List<String> description, List<String> imageUrl, int color, Map<String, byte[]> attachments) {
        this.authorName = authorName;
        this.authorIconUrl = authorIconUrl;
        this.description = description;
        this.imageUrl = imageUrl;
        this.fields = new ArrayList<MessageEmbed.Field>();
        this.color = color;
        this.attachments = attachments;
        this.footer = null;
        this.footerImageUrl = null;
    }

    public DiscordMessageContent(String authorName, String authorIconUrl, String description, String imageUrl, Color color) {
        this(authorName, authorIconUrl, new ArrayList<String>(Arrays.asList(description)), new ArrayList<String>(Arrays.asList(imageUrl)), color.getRGB(), new HashMap<String, byte[]>());
    }

    public DiscordMessageContent(String authorName, String authorIconUrl, String description, String imageUrl, int color) {
        this(authorName, authorIconUrl, new ArrayList<String>(Arrays.asList(description)), new ArrayList<String>(Arrays.asList(imageUrl)), color, new HashMap<String, byte[]>());
    }

    public DiscordMessageContent(String authorName, String authorIconUrl, Color color) {
        this(authorName, authorIconUrl, new ArrayList<String>(), new ArrayList<String>(), color.getRGB(), new HashMap<String, byte[]>());
    }

    public DiscordMessageContent(String authorName, String authorIconUrl, int color) {
        this(authorName, authorIconUrl, new ArrayList<String>(), new ArrayList<String>(), color, new HashMap<String, byte[]>());
    }

    public DiscordMessageContent(Message message) {
        if (message.getEmbeds().isEmpty()) {
            throw new IllegalArgumentException("Not embeds found!");
        }
        MessageEmbed embed = (MessageEmbed)message.getEmbeds().get(0);
        this.authorName = embed.getAuthor().getName();
        this.authorIconUrl = embed.getAuthor().getIconUrl();
        this.description = new ArrayList<String>();
        this.fields = new ArrayList<MessageEmbed.Field>(embed.getFields());
        if (embed.getDescription() != null) {
            this.description.add(embed.getDescription());
        }
        this.imageUrl = new ArrayList<String>();
        if (embed.getImage() != null) {
            this.imageUrl.add(embed.getImage().getUrl());
        }
        this.color = embed.getColorRaw();
        if (embed.getThumbnail() != null) {
            this.thumbnail = embed.getThumbnail().getUrl();
        }
        this.attachments = new HashMap<String, byte[]>();
    }

    public DiscordMessageContent(MessageFormat messageFormat) {
        this.authorName = messageFormat.getAuthorName();
        this.authorIconUrl = messageFormat.getAuthorImageUrl();
        this.description = new ArrayList<String>();
        if (messageFormat.getDescription() != null) {
            this.description.add(messageFormat.getDescription());
        }
        this.fields = messageFormat.getFields() == null ? new ArrayList<MessageEmbed.Field>() : new ArrayList<MessageEmbed.Field>(messageFormat.getFields());
        this.imageUrl = new ArrayList<String>();
        if (messageFormat.getImageUrl() != null) {
            this.imageUrl.add(messageFormat.getImageUrl());
        }
        this.color = messageFormat.getColorRaw();
        this.thumbnail = messageFormat.getThumbnailUrl();
        this.attachments = new HashMap<String, byte[]>();
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public String getAuthorIconUrl() {
        return this.authorIconUrl;
    }

    public void setAuthorIconUrl(String authorIconUrl) {
        this.authorIconUrl = authorIconUrl;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getDescriptions() {
        return this.description;
    }

    public void setDescriptions(List<String> description) {
        this.description = description;
    }

    public void addDescription(String description) {
        this.description.add(description);
    }

    public void setDescription(int index, String description) {
        this.description.set(index, description);
    }

    public void clearDescriptions() {
        this.description.clear();
    }

    public List<String> getImageUrls() {
        return this.imageUrl;
    }

    public void setImageUrls(List<String> imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void addImageUrl(String imageUrl) {
        this.imageUrl.add(imageUrl);
    }

    public void setImageUrl(int index, String imageUrl) {
        this.imageUrl.set(index, imageUrl);
    }

    public void clearImageUrls() {
        this.imageUrl.clear();
    }

    public List<MessageEmbed.Field> getFields() {
        return this.fields;
    }

    public void addFields(MessageEmbed.Field ... field) {
        this.fields.addAll(Arrays.asList(field));
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooterImageUrl() {
        return this.footerImageUrl;
    }

    public void setFooterImageUrl(String footerImageUrl) {
        this.footerImageUrl = footerImageUrl;
    }

    public Map<String, byte[]> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, byte[]> attachments) {
        this.attachments = attachments;
    }

    public void addAttachment(String name, byte[] data) {
        this.attachments.put(name, data);
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    public RestAction<List<Message>> toJDAMessageRestAction(TextChannel channel) {
        LinkedHashMap<MessageAction, Object> actions = new LinkedHashMap<MessageAction, Object>();
        HashSet<String> rootAttachments = new HashSet<String>();
        rootAttachments.add(this.authorIconUrl);
        EmbedBuilder embed = new EmbedBuilder().setAuthor(this.authorName, null, this.authorIconUrl).setColor(this.color).setThumbnail(this.thumbnail).setTitle(this.title);
        for (MessageEmbed.Field field : this.fields) {
            embed.addField(field);
        }
        if (this.description.size() > 0) {
            embed.setDescription((CharSequence)this.description.get(0));
        }
        if (this.imageUrl.size() > 0) {
            String url = this.imageUrl.get(0);
            embed.setImage(url);
            rootAttachments.add(url);
        }
        if ((this.imageUrl.size() == 1 || this.description.size() == 1) && this.footer != null) {
            if (this.footerImageUrl == null) {
                embed.setFooter(this.footer);
            } else {
                embed.setFooter(this.footer, this.footerImageUrl);
                rootAttachments.add(this.footerImageUrl);
            }
        }
        actions.put(channel.sendMessage(embed.build()), rootAttachments);
        for (int i = 1; i < this.imageUrl.size() || i < this.description.size(); ++i) {
            HashSet usedAttachments = new HashSet();
            EmbedBuilder embedBuilder = new EmbedBuilder().setColor(this.color);
            if (i < this.imageUrl.size()) {
                String url = this.imageUrl.get(i);
                embedBuilder.setImage(url);
                usedAttachments.add(url);
            }
            if (i < this.description.size()) {
                embedBuilder.setDescription((CharSequence)this.description.get(i));
            }
            if (i + 1 >= this.imageUrl.size() && i + 1 >= this.description.size() && this.footer != null) {
                if (this.footerImageUrl == null) {
                    embedBuilder.setFooter(this.footer);
                } else {
                    embedBuilder.setFooter(this.footer, this.footerImageUrl);
                }
            }
            if (embedBuilder.isEmpty()) continue;
            actions.put(channel.sendMessage(embedBuilder.build()), usedAttachments);
        }
        HashSet<String> embeddedAttachments = new HashSet<String>();
        for (Map.Entry entry : actions.entrySet()) {
            MessageAction action = (MessageAction)entry.getKey();
            Set neededUrls = (Set)entry.getValue();
            for (Map.Entry<String, byte[]> attachment : this.attachments.entrySet()) {
                String attachmentName = attachment.getKey();
                if (!neededUrls.contains("attachment://" + attachmentName)) continue;
                action.addFile(attachment.getValue(), attachmentName, new AttachmentOption[0]);
                embeddedAttachments.add(attachmentName);
            }
        }
        MessageAction lastAction = (MessageAction)actions.keySet().stream().skip(actions.size() - 1).findFirst().get();
        for (Map.Entry<String, byte[]> attachment : this.attachments.entrySet()) {
            String attachmentName = attachment.getKey();
            if (embeddedAttachments.contains(attachmentName)) continue;
            lastAction.addFile(attachment.getValue(), attachmentName, new AttachmentOption[0]);
        }
        return RestAction.allOf(actions.keySet());
    }

    public ValuePairs<List<MessageEmbed>, Set<String>> toJDAMessageEmbeds() {
        ArrayList actions = new ArrayList();
        ArrayList<MessageEmbed> list = new ArrayList<MessageEmbed>();
        HashSet<String> embeddedAttachments = new HashSet<String>();
        EmbedBuilder embed = new EmbedBuilder().setAuthor(this.authorName, null, this.authorIconUrl).setColor(this.color).setThumbnail(this.thumbnail).setTitle(this.title);
        if (this.thumbnail != null && this.thumbnail.startsWith("attachment://")) {
            embeddedAttachments.add(this.thumbnail.substring(13));
        }
        for (MessageEmbed.Field field : this.fields) {
            embed.addField(field);
        }
        if (this.description.size() > 0) {
            embed.setDescription((CharSequence)this.description.get(0));
        }
        if (this.imageUrl.size() > 0) {
            String url = this.imageUrl.get(0);
            embed.setImage(url);
            if (url.startsWith("attachment://")) {
                embeddedAttachments.add(url.substring(13));
            }
        }
        if ((this.imageUrl.size() == 1 || this.description.size() == 1) && this.footer != null) {
            if (this.footerImageUrl == null) {
                embed.setFooter(this.footer);
            } else {
                embed.setFooter(this.footer, this.footerImageUrl);
                if (this.footerImageUrl.startsWith("attachment://")) {
                    embeddedAttachments.add(this.footerImageUrl.substring(13));
                }
            }
        }
        list.add(embed.build());
        for (int i = 1; i < this.imageUrl.size() || i < this.description.size(); ++i) {
            HashSet<String> hashSet = new HashSet<String>();
            EmbedBuilder otherEmbed = new EmbedBuilder().setColor(this.color);
            if (i < this.imageUrl.size()) {
                String url = this.imageUrl.get(i);
                otherEmbed.setImage(url);
                hashSet.add(url);
                if (url.startsWith("attachment://")) {
                    embeddedAttachments.add(url.substring(13));
                }
            }
            if (i < this.description.size()) {
                otherEmbed.setDescription((CharSequence)this.description.get(i));
            }
            if (i + 1 >= this.imageUrl.size() && i + 1 >= this.description.size() && this.footer != null) {
                if (this.footerImageUrl == null) {
                    otherEmbed.setFooter(this.footer);
                } else {
                    otherEmbed.setFooter(this.footer, this.footerImageUrl);
                    if (this.footerImageUrl.startsWith("attachment://")) {
                        embeddedAttachments.add(this.footerImageUrl.substring(13));
                    }
                }
            }
            if (otherEmbed.isEmpty()) continue;
            list.add(otherEmbed.build());
            actions.add(hashSet);
        }
        for (Set set : actions) {
            for (Map.Entry<String, byte[]> attachment : this.attachments.entrySet()) {
                String attachmentName = attachment.getKey();
                if (!set.contains("attachment://" + attachmentName)) continue;
                embeddedAttachments.add(attachmentName);
            }
        }
        return new ValuePairs(list, embeddedAttachments);
    }
}

