/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import com.loohp.interactivechat.libs.net.kyori.adventure.key.Key;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextDecoration;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactivechat.objectholders.ValuePairs;
import com.loohp.interactivechat.utils.ComponentCompacting;
import com.loohp.interactivechat.utils.ComponentFlattening;
import it.unimi.dsi.fastutil.chars.CharObjectImmutablePair;
import it.unimi.dsi.fastutil.chars.CharObjectPair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class CharacterData {
    private Key font;
    private TextColor color;
    private List<TextDecoration> decorations;

    public static ValuePairs<String, List<CharObjectPair<CharacterData>>> fromComponent(Component component, UnaryOperator<String> shaper) {
        LinkedList<CharacterData> data = new LinkedList<CharacterData>();
        StringBuilder sb = new StringBuilder();
        component = ComponentFlattening.flatten((Component)component);
        for (Component each : component.children()) {
            Key font = each.style().font();
            TextColor color = each.color();
            if (color == null) {
                color = NamedTextColor.WHITE;
            }
            List<TextDecoration> decorations = each.decorations().entrySet().stream().filter(entry -> ((TextDecoration.State)entry.getValue()).equals((Object)TextDecoration.State.TRUE)).map(entry -> (TextDecoration)entry.getKey()).collect(Collectors.toList());
            String content = each instanceof TextComponent ? ((TextComponent)each).content() : PlainTextComponentSerializer.plainText().serialize(each);
            if (content.isEmpty()) continue;
            CharacterData characterData = new CharacterData(font, color, decorations);
            for (char c : content.toCharArray()) {
                sb.append(c);
                data.add(characterData);
            }
        }
        String resultStr = (String)shaper.apply(sb.toString());
        ArrayList<CharObjectImmutablePair> result = new ArrayList<CharObjectImmutablePair>(resultStr.length());
        for (int i = 0; i < resultStr.length(); ++i) {
            result.add(new CharObjectImmutablePair(resultStr.charAt(i), (Object)((CharacterData)data.get(i))));
        }
        return new ValuePairs((Object)resultStr, result);
    }

    public static Component toComponent(List<CharObjectPair<CharacterData>> dataList) {
        ArrayList<Component> components = new ArrayList<Component>(dataList.size());
        for (CharObjectPair<CharacterData> data : dataList) {
            CharacterData characterData = (CharacterData)data.right();
            Component component = ((TextComponent)Component.text((char)data.firstChar()).color(characterData.getColor())).font(characterData.getFont());
            for (TextDecoration textDecoration : characterData.getDecorations()) {
                component = component.decorate(textDecoration);
            }
            components.add(component);
        }
        return ComponentCompacting.optimize((Component)Component.empty().children(components));
    }

    public CharacterData(Key font, TextColor color, List<TextDecoration> decorations) {
        this.font = font;
        this.color = color;
        this.decorations = decorations;
    }

    public Key getFont() {
        return this.font;
    }

    public TextColor getColor() {
        return this.color;
    }

    public List<TextDecoration> getDecorations() {
        return this.decorations;
    }
}

