/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.main;

import com.loohp.interactivechat.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechat.utils.ChatColorUtils;
import com.loohp.interactivechat.utils.ComponentStyling;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.URLClassLoaderAccess;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.intellij.uiDesigner.core.GridConstraints;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.intellij.uiDesigner.core.GridLayoutManager;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.intellij.uiDesigner.core.Spacer;
import com.loohp.interactivechatdiscordsrvaddon.main.GUIMain;
import com.loohp.interactivechatdiscordsrvaddon.main.TransferableImage;
import com.loohp.interactivechatdiscordsrvaddon.resources.ICacheManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceDownloadManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackInfo;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackType;
import com.loohp.interactivechatdiscordsrvaddon.resources.languages.LanguageManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureAnimation;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureMeta;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import com.loohp.interactivechatdiscordsrvaddon.utils.ResourcePackInfoUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class MinecraftFontRenderer
extends JFrame {
    public static final Pattern COLOR_HEX_PATTERN = Pattern.compile("^#[0-9a-fA-F]{6}$");
    private static final URLClassLoaderAccess LOADER_ACCESS = URLClassLoaderAccess.create((URLClassLoader)GUIMain.class.getClassLoader());
    private String title;
    private BufferedImage image;
    private Icon icon;
    private JTextArea textAreaInput;
    private JTextArea textAreaResources;
    private JButton reloadResourcesButton;
    private JButton saveButton;
    private JCheckBox legacyTextCheckBox;
    private JSpinner spinnerOffsetX;
    private JSpinner spinnerOffsetY;
    private JPanel imagePanel;
    private JPanel panel;
    private JProgressBar resourceBar;
    private JTextField backgroundColorTextField;
    private JComboBox<LanguageData> comboBoxLanguages;
    private JButton buttonDownloadLanguages;
    private JScrollPane scrollPaneTextInput;
    private JCheckBox glowingTextBox;
    private ResourceManager resourceManager;
    private AtomicReference<BufferedImage> renderedImage;
    private AtomicReference<List<Component>> renderingComponents;
    private Color backgroundColor;
    private File lastSavedLocation;
    private ExecutorService executorService;
    private ReentrantLock resourceLock;
    private ReentrantLock updateTextImageLock;
    private ReentrantLock repaintLock;

    public MinecraftFontRenderer(String title, BufferedImage image, Icon icon) {
        this.title = title;
        this.image = image;
        this.icon = icon;
        this.resourceManager = null;
        this.renderedImage = new AtomicReference();
        this.renderingComponents = new AtomicReference();
        this.backgroundColor = Color.BLACK;
        this.lastSavedLocation = new File(".");
        this.$$$setupUI$$$();
        this.executorService = Executors.newSingleThreadExecutor();
        this.resourceLock = new ReentrantLock(true);
        this.updateTextImageLock = new ReentrantLock(true);
        this.repaintLock = new ReentrantLock(true);
        for (File jarFile : new File("InteractiveChatDiscordSrvAddon", "libs").listFiles()) {
            String jarName = jarFile.getName();
            if (!jarName.endsWith(".jar")) continue;
            try {
                LOADER_ACCESS.addURL(jarFile.toURI().toURL());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.setContentPane(this.panel);
        this.setTitle(title + " - Minecraft Font Renderer");
        this.setSize(1300, 1000);
        this.setDefaultCloseOperation(3);
        this.setIconImage(image);
        this.resourceBar.setMaximum(10000);
        this.backgroundColorTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String hex = MinecraftFontRenderer.this.backgroundColorTextField.getText();
                if (!hex.startsWith("#")) {
                    hex = "#" + hex;
                }
                if (COLOR_HEX_PATTERN.matcher(hex).matches()) {
                    MinecraftFontRenderer.this.backgroundColor = MinecraftFontRenderer.this.hex2Rgb(hex);
                    MinecraftFontRenderer.this.imagePanel.repaint();
                }
                MinecraftFontRenderer.this.backgroundColorTextField.setText(MinecraftFontRenderer.this.rgb2Hex(MinecraftFontRenderer.this.backgroundColor).toUpperCase());
            }
        });
        this.backgroundColorTextField.addActionListener(e -> {
            String hex = this.backgroundColorTextField.getText();
            if (!hex.startsWith("#")) {
                hex = "#" + hex;
            }
            if (COLOR_HEX_PATTERN.matcher(hex).matches()) {
                this.backgroundColor = this.hex2Rgb(hex);
                this.imagePanel.repaint();
            }
            this.backgroundColorTextField.setText(this.rgb2Hex(this.backgroundColor).toUpperCase());
        });
        this.reloadResourcesButton.addActionListener(e -> this.executorService.submit(() -> this.loadResources()));
        this.saveButton.addActionListener(e -> this.executorService.submit(() -> this.saveImage()));
        this.textAreaInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(() -> MinecraftFontRenderer.this.executorService.submit(() -> {
                    MinecraftFontRenderer.this.updateTextComponent();
                    MinecraftFontRenderer.this.repaintTextImage();
                }));
            }
        });
        this.spinnerOffsetX.addChangeListener(e -> this.scheduleTextReload());
        this.spinnerOffsetY.addChangeListener(e -> this.scheduleTextReload());
        this.legacyTextCheckBox.addActionListener(e -> {
            if (!this.textAreaInput.getText().isEmpty()) {
                if (this.legacyTextCheckBox.isSelected()) {
                    Toolkit.getDefaultToolkit().beep();
                    int input = JOptionPane.showOptionDialog(null, GUIMain.createLabel("Changing to legacy text will remove formatting!", 13.0f, Color.BLACK), title, -1, 2, null, new Object[]{"Continue", "Cancel"}, null);
                    if (input == 0) {
                        try {
                            this.textAreaInput.setText(LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().character('\u00a7').build().serialize(GsonComponentSerializer.gson().deserialize((Object)this.textAreaInput.getText())).replace('\u00a7', '&'));
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        this.legacyTextCheckBox.setSelected(false);
                    }
                } else {
                    try {
                        this.textAreaInput.setText((String)GsonComponentSerializer.gson().serialize((Component)LegacyComponentSerializer.legacySection().deserialize(ChatColorUtils.translateAlternateColorCodes((char)'&', (String)this.textAreaInput.getText(), (boolean)false, (boolean)true, Collections.emptyList()))));
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
            this.scheduleTextReload();
        });
        this.buttonDownloadLanguages.addActionListener(e -> this.executorService.submit(() -> {
            this.downloadAllLanguages(title, image, icon);
            this.loadResources();
        }));
        final JPopupMenu menu = new JPopupMenu("Actions");
        JMenuItem copy = new JMenuItem("Copy image");
        copy.addActionListener(event -> this.copyImage());
        menu.add(copy);
        JMenuItem save = new JMenuItem("Save image as...");
        save.addActionListener(event -> this.saveImage());
        menu.add(save);
        this.imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    menu.show(MinecraftFontRenderer.this.imagePanel, e.getX(), e.getY());
                }
            }
        });
        this.comboBoxLanguages.addActionListener(e -> this.scheduleTextReload());
        this.glowingTextBox.addActionListener(e -> this.scheduleTextReload());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                MinecraftFontRenderer.this.updateTextAreaInputSize();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MinecraftFontRenderer.this.updateTextAreaInputSize();
            }
        });
        this.executorService.submit(() -> this.loadResources());
    }

    private void createUIComponents() {
        this.spinnerOffsetX = new JSpinner(new SpinnerNumberModel(10, -8192, 8192, 1));
        this.spinnerOffsetY = new JSpinner(new SpinnerNumberModel(10, -8192, 8192, 1));
        this.imagePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(MinecraftFontRenderer.this.backgroundColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                MinecraftFontRenderer.this.updateImage();
                BufferedImage image = (BufferedImage)MinecraftFontRenderer.this.renderedImage.get();
                if (image != null) {
                    g.drawImage(image, this.getWidth() / 2 - image.getWidth() / 2, this.getHeight() / 2 - image.getHeight() / 2, this);
                    MinecraftFontRenderer.this.saveButton.setEnabled(true);
                } else {
                    MinecraftFontRenderer.this.saveButton.setEnabled(false);
                }
            }
        };
    }

    private void scheduleTextReload() {
        this.executorService.submit(() -> {
            this.updateTextComponent();
            this.repaintTextImage();
        });
    }

    public void updateTextAreaInputSize() {
        int maxX = this.getWidth() - this.textAreaResources.getWidth();
        int y = this.textAreaInput.getHeight();
        if (this.textAreaInput.getWidth() > maxX) {
            this.textAreaInput.setMaximumSize(new Dimension(maxX, y));
            this.textAreaInput.setPreferredSize(new Dimension(maxX, y));
            this.textAreaInput.setSize(maxX, y);
        }
    }

    public void repaintTextImage() {
        try {
            if (!this.repaintLock.tryLock(0L, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.imagePanel.repaint();
        this.repaintLock.unlock();
    }

    public BufferedImage getRawEnchantedImage(BufferedImage source) {
        TextureResource resource = this.resourceManager.getTextureManager().getTexture("minecraft:misc/enchanted_item_glint");
        BufferedImage tintOriginal = resource.getTexture();
        if (resource.hasTextureMeta()) {
            TextureProperties properties;
            TextureMeta meta = resource.getTextureMeta();
            if (meta.hasProperties() && (properties = meta.getProperties()).isBlur()) {
                tintOriginal = ImageUtils.applyGaussianBlur(tintOriginal);
            }
            if (meta.hasAnimation()) {
                TextureAnimation animation = meta.getAnimation();
                tintOriginal = animation.hasWidth() && animation.hasHeight() ? ImageUtils.copyAndGetSubImage(tintOriginal, 0, 0, animation.getWidth(), animation.getHeight()) : ImageUtils.copyAndGetSubImage(tintOriginal, 0, 0, tintOriginal.getWidth(), tintOriginal.getWidth());
            }
        }
        BufferedImage tintImage = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        Graphics2D g3 = tintImage.createGraphics();
        g3.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g3.drawImage(tintOriginal, 0, 0, tintImage.getWidth() * 4, tintImage.getHeight() * 4, null);
        g3.dispose();
        return tintImage;
    }

    public BufferedImage getEnchantedImage(BufferedImage source) {
        return ImageUtils.additionNonTransparent(source, this.getRawEnchantedImage(source), 0.7450980392156863);
    }

    public Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public String rgb2Hex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public void loadResources() {
        int valuePerPack;
        List resourceOrder;
        try {
            if (!this.resourceLock.tryLock(0L, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.reloadResourcesButton.setEnabled(false);
        this.resourceBar.setValue(0);
        this.resourceBar.setVisible(true);
        this.textAreaResources.setText("Loading Resources...");
        this.updateTextAreaInputSize();
        try {
            YamlConfiguration yaml = new YamlConfiguration(Files.newInputStream(Paths.get("InteractiveChatDiscordSrvAddon/config.yml", new String[0]), new OpenOption[0]));
            resourceOrder = yaml.getStringList("Resources.Order");
            Collections.reverse(resourceOrder);
            valuePerPack = (int)(1.0 / (double)(resourceOrder.size() + 1) * 10000.0);
        }
        catch (IOException e) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("There is an error while loading from config:\n" + e.getMessage(), 13.0f, Color.RED), this.title, 0);
            return;
        }
        if (this.resourceManager != null) {
            this.resourceManager.close();
        }
        PrintStream original = System.err;
        try {
            File defaultPack = new File("InteractiveChatDiscordSrvAddon/built-in", "Default");
            File defaultPackMeta = new File(defaultPack, "pack.mcmeta");
            BufferedReader reader = Files.newBufferedReader(defaultPackMeta.toPath(), StandardCharsets.UTF_8);
            JSONObject json = (JSONObject)new JSONParser().parse((Reader)reader);
            reader.close();
            int packFormat = ((Number)((JSONObject)json.get((Object)"pack")).get((Object)"pack_format")).intValue();
            this.resourceManager = new ResourceManager(false, packFormat < 9, Collections.emptyList(), Collections.singletonList(ICacheManager.getDummySupplier()));
            this.resourceManager.loadResources(defaultPack, ResourcePackType.BUILT_IN);
            this.resourceBar.setValue(valuePerPack);
            for (String resourceName : resourceOrder) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                System.setErr(new PrintStream(baos));
                try {
                    File resourcePackFile = new File("InteractiveChatDiscordSrvAddon/resourcepacks/" + resourceName);
                    ResourcePackInfo resourcePackInfo = this.resourceManager.loadResources(resourcePackFile, ResourcePackType.LOCAL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String error = baos.toString();
                if (!error.isEmpty()) {
                    ForkJoinPool.commonPool().execute(() -> JOptionPane.showMessageDialog(null, GUIMain.createLabel("There are errors while loading \"" + resourceName + "\":\n" + error, 13.0f, Color.RED), this.title, 0));
                }
                this.resourceBar.setValue(this.resourceBar.getValue() + valuePerPack);
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("An error occurred!\n" + sw, 13.0f, Color.RED), this.title, 0);
        }
        System.setErr(original);
        this.textAreaResources.setText("Loaded Resources:\n");
        for (ResourcePackInfo info : this.resourceManager.getResourcePackInfo()) {
            this.textAreaResources.append(" - " + ResourcePackInfoUtils.resolveName(info));
            if (!info.getStatus()) {
                this.textAreaResources.append(" (Failed)");
            }
            this.textAreaResources.append("\n");
        }
        List<LanguageData> languages = this.getAllLanguageData(this.resourceManager.getLanguageManager());
        String lastSelected = this.comboBoxLanguages.getSelectedItem() == null ? null : ((LanguageData)this.comboBoxLanguages.getSelectedItem()).getLanguage();
        this.comboBoxLanguages.removeAllItems();
        for (LanguageData language : languages) {
            this.comboBoxLanguages.addItem(language);
        }
        Optional<LanguageData> optLanguage = languages.stream().filter(each -> each.getLanguage().equalsIgnoreCase(lastSelected == null ? "en_us" : lastSelected)).findFirst();
        if (optLanguage.isPresent()) {
            this.comboBoxLanguages.setSelectedItem(optLanguage.get());
        } else {
            this.comboBoxLanguages.setSelectedIndex(0);
        }
        this.reloadResourcesButton.setEnabled(true);
        this.resourceBar.setVisible(false);
        this.updateTextAreaInputSize();
        this.resourceLock.unlock();
    }

    private void updateTextComponent() {
        if (this.resourceManager == null) {
            return;
        }
        try {
            if (!this.updateTextImageLock.tryLock(0L, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            Object component;
            String text = this.textAreaInput.getText();
            if (text.isEmpty()) {
                component = Component.empty();
            } else {
                try {
                    component = this.legacyTextCheckBox.isSelected() ? LegacyComponentSerializer.legacySection().deserialize(ChatColorUtils.translateAlternateColorCodes((char)'&', (String)text, (boolean)false, (boolean)true, Collections.emptyList())) : GsonComponentSerializer.gson().deserialize((Object)text);
                }
                catch (Throwable e) {
                    component = PlainTextComponentSerializer.plainText().deserialize(e.getLocalizedMessage().replaceAll("\\t", "    ")).color((TextColor)NamedTextColor.RED);
                }
            }
            ArrayList prints = new ArrayList(ComponentStyling.splitAtLineBreaks((Component)component));
            this.renderingComponents.set(prints);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.updateTextImageLock.unlock();
    }

    private synchronized void updateImage() {
        List<Component> prints = this.renderingComponents.get();
        if (prints == null) {
            this.renderedImage.set(null);
            return;
        }
        int w = this.imagePanel.getWidth();
        int h = this.imagePanel.getHeight();
        BufferedImage image = new BufferedImage(w, h, 2);
        int x = (Integer)this.spinnerOffsetX.getValue();
        int y = (Integer)this.spinnerOffsetY.getValue();
        LanguageData language = (LanguageData)this.comboBoxLanguages.getSelectedItem();
        for (Component print : prints) {
            if (y > h) break;
            if (this.glowingTextBox.isSelected()) {
                ImageUtils.printComponentGlowing(this.resourceManager, image, print, language.getLanguage(), false, x, y, 16.0f);
            } else {
                ImageUtils.printComponent(this.resourceManager, image, print, language.getLanguage(), false, x, y, 16.0f);
            }
            y += 20;
        }
        this.renderedImage.set(image);
    }

    public synchronized void copyImage() {
        BufferedImage image = this.renderedImage.get();
        if (image == null) {
            return;
        }
        TransferableImage trans = new TransferableImage(image);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(trans, null);
    }

    public synchronized void saveImage() {
        File file;
        int input;
        BufferedImage image = this.renderedImage.get();
        if (image == null) {
            return;
        }
        do {
            JFileChooser fileChooser = new JFileChooser(this.lastSavedLocation);
            fileChooser.setSelectedFile(new File(this.lastSavedLocation, "text.png"));
            int result = fileChooser.showSaveDialog(this);
            if (result != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            if (file.getParentFile() != null) {
                this.lastSavedLocation = file.getParentFile();
            }
            if (!file.exists()) break;
            Toolkit.getDefaultToolkit().beep();
        } while ((input = JOptionPane.showOptionDialog(null, GUIMain.createLabel(file.getName() + " already exists! Do you want to overwrite?", 15.0f), this.title, -1, 2, null, new Object[]{"Overwrite", "Cancel"}, null)) != 0);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("An error occurred!\n" + sw, 13.0f, Color.RED), this.title, 0);
        }
    }

    protected void downloadAllLanguages(String title, BufferedImage image, Icon icon) {
        File defaultAssetsFolder = new File("InteractiveChatDiscordSrvAddon/built-in", "Default");
        defaultAssetsFolder.mkdirs();
        JPanel panel = new JPanel();
        panel.add(GUIMain.createLabel("Select Minecraft Version: ", 13.0f));
        JComboBox<String> options = new JComboBox<String>();
        for (String version : ResourceDownloadManager.getMinecraftVersions()) {
            options.addItem(version);
        }
        panel.add(options);
        int result = JOptionPane.showOptionDialog(null, panel, title, -1, 1, icon, null, null);
        if (result < 0) {
            return;
        }
        ResourceDownloadManager downloadManager = new ResourceDownloadManager((String)options.getSelectedItem(), defaultAssetsFolder);
        JFrame frame = new JFrame(title);
        frame.setIconImage(image);
        frame.setSize(800, 175);
        frame.setDefaultCloseOperation(0);
        frame.setLocationRelativeTo(null);
        panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        panel.setLayout(new GridLayout(0, 1));
        JLabel label = GUIMain.createLabel("<html>Downloading Assets:<html/>", 13.0f);
        label.setSize(800, 125);
        panel.add(label);
        JProgressBar progressBar = new JProgressBar(0, 10000);
        panel.add(progressBar);
        frame.add((java.awt.Component)panel, "Center");
        frame.setResizable(false);
        frame.setVisible(true);
        CompletableFuture future = new CompletableFuture();
        new Thread(() -> {
            downloadManager.downloadLanguages((type, fileName, percentage) -> {
                switch (type) {
                    case DOWNLOAD: {
                        label.setText("<html>Downloading Assets:<br>Downloading " + fileName + "<html/>");
                        progressBar.setValue(Math.min(9999, (int)(percentage * 100.0)));
                        break;
                    }
                    case DONE: {
                        label.setText("<html>Done!<html/>");
                    }
                }
            });
            future.complete(null);
        }).start();
        future.join();
        progressBar.setValue(9999);
        JOptionPane.showMessageDialog(null, GUIMain.createLabel("Assets saved at: " + defaultAssetsFolder.getAbsolutePath(), 15.0f), title, 1, icon);
        frame.setVisible(false);
        frame.dispose();
    }

    private List<LanguageData> getAllLanguageData(LanguageManager languageManager) {
        return languageManager.getAvailableLanguages().stream().map(language -> {
            String name = languageManager.applyTranslations("language.name", (String)language);
            String region = languageManager.applyTranslations("language.region", (String)language);
            return new LanguageData((String)language, name.equalsIgnoreCase("language.name") ? null : name, region.equalsIgnoreCase("language.region") ? null : region);
        }).collect(Collectors.toList());
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayoutManager(7, 13, new Insets(10, 10, 10, 10), -1, -1));
        JLabel label1 = new JLabel();
        label1.setText("Text Input");
        this.panel.add((java.awt.Component)label1, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.textAreaResources = new JTextArea();
        this.textAreaResources.setColumns(0);
        this.textAreaResources.setEditable(false);
        this.textAreaResources.setLineWrap(false);
        this.textAreaResources.setText("Loading Resources...");
        this.panel.add((java.awt.Component)this.textAreaResources, new GridConstraints(1, 11, 1, 2, 0, 3, 2, 2, new Dimension(-1, 200), new Dimension(150, -1), null, 0, false));
        this.reloadResourcesButton = new JButton();
        this.reloadResourcesButton.setText("Reload Resources");
        this.panel.add((java.awt.Component)this.reloadResourcesButton, new GridConstraints(0, 12, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Offset X");
        this.panel.add((java.awt.Component)label2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.panel.add((java.awt.Component)this.spinnerOffsetX, new GridConstraints(4, 1, 1, 1, 8, 1, 0, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Offset Y");
        this.panel.add((java.awt.Component)label3, new GridConstraints(4, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.panel.add((java.awt.Component)this.spinnerOffsetY, new GridConstraints(4, 3, 1, 1, 8, 1, 0, 0, null, null, null, 0, false));
        this.panel.add((java.awt.Component)this.imagePanel, new GridConstraints(5, 0, 2, 11, 0, 3, 4, 4, null, null, null, 0, false));
        this.saveButton = new JButton();
        this.saveButton.setText("Save");
        this.panel.add((java.awt.Component)this.saveButton, new GridConstraints(6, 12, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setText("Background Color");
        label4.setToolTipText("Visual Background Color");
        this.panel.add((java.awt.Component)label4, new GridConstraints(4, 4, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.backgroundColorTextField = new JTextField();
        this.backgroundColorTextField.setColumns(8);
        this.backgroundColorTextField.setHorizontalAlignment(11);
        this.backgroundColorTextField.setText("#000000");
        this.panel.add((java.awt.Component)this.backgroundColorTextField, new GridConstraints(4, 5, 1, 1, 8, 1, 0, 0, null, null, null, 0, false));
        this.legacyTextCheckBox = new JCheckBox();
        this.legacyTextCheckBox.setSelected(false);
        this.legacyTextCheckBox.setText("Legacy Text");
        this.panel.add((java.awt.Component)this.legacyTextCheckBox, new GridConstraints(0, 10, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.panel.add((java.awt.Component)spacer1, new GridConstraints(4, 10, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.panel.add((java.awt.Component)spacer2, new GridConstraints(0, 11, 1, 1, 0, 1, 2, 1, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("Language");
        label5.setToolTipText("");
        this.panel.add((java.awt.Component)label5, new GridConstraints(4, 6, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.comboBoxLanguages = new JComboBox();
        this.comboBoxLanguages.setToolTipText("Language for Translatable Components");
        this.panel.add(this.comboBoxLanguages, new GridConstraints(4, 7, 1, 1, 8, 1, 0, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.panel.add((java.awt.Component)spacer3, new GridConstraints(3, 11, 3, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.resourceBar = new JProgressBar();
        this.panel.add((java.awt.Component)this.resourceBar, new GridConstraints(2, 11, 1, 2, 0, 1, 2, 0, null, null, null, 0, false));
        this.buttonDownloadLanguages = new JButton();
        this.buttonDownloadLanguages.setText("Download All Languages");
        this.panel.add((java.awt.Component)this.buttonDownloadLanguages, new GridConstraints(4, 8, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.scrollPaneTextInput = new JScrollPane();
        this.panel.add((java.awt.Component)this.scrollPaneTextInput, new GridConstraints(1, 0, 3, 11, 0, 3, 4, 2, null, null, null, 0, false));
        this.textAreaInput = new JTextArea();
        this.textAreaInput.setColumns(0);
        this.textAreaInput.setLineWrap(true);
        this.textAreaInput.setWrapStyleWord(true);
        this.scrollPaneTextInput.setViewportView(this.textAreaInput);
        this.glowingTextBox = new JCheckBox();
        this.glowingTextBox.setText("Glowing");
        this.panel.add((java.awt.Component)this.glowingTextBox, new GridConstraints(4, 9, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        label1.setLabelFor(this.scrollPaneTextInput);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private static class LanguageData {
        private String language;
        private String name;
        private String region;
        private String displayName;

        public LanguageData(String language, String name, String region) {
            this.language = language;
            this.name = name;
            this.region = region;
            if (name == null) {
                this.displayName = "[" + language + "]";
            } else {
                StringBuilder sb = new StringBuilder("\u202a").append(name);
                if (region != null) {
                    sb.append(" \u202a(").append(region).append(")");
                }
                this.displayName = sb.append(" [").append(language).append("]").toString();
            }
        }

        public String getLanguage() {
            return this.language;
        }

        public String getName() {
            return this.name;
        }

        public String getRegion() {
            return this.region;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LanguageData that = (LanguageData)o;
            return this.language.equals(that.language);
        }

        public int hashCode() {
            return Objects.hash(this.language);
        }
    }
}

