/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.main;

import com.loohp.interactivechat.libs.com.loohp.yamlconfiguration.ConfigurationSection;
import com.loohp.interactivechat.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.registry.Registry;
import com.loohp.interactivechat.updater.Version;
import com.loohp.interactivechat.utils.FileUtils;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.LibraryDownloadManager;
import com.loohp.interactivechatdiscordsrvaddon.main.BlockModelRenderer;
import com.loohp.interactivechatdiscordsrvaddon.main.MinecraftFontRenderer;
import com.loohp.interactivechatdiscordsrvaddon.registry.InteractiveChatRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceDownloadManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class GUIMain {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.0");

    public static void launch(String[] args) {
        String title = "InteractiveChat DiscordSRV Addon Tools";
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Enumeration<URL> enumeration = GUIMain.class.getClassLoader().getResources("plugin.yml");
            YamlConfiguration pluginYaml = new YamlConfiguration(enumeration.nextElement().openStream());
            String pluginName = pluginYaml.getString("name");
            String version = pluginYaml.getString("version");
            YamlConfiguration icPluginYaml = new YamlConfiguration(enumeration.nextElement().openStream());
            String icPluginName = icPluginYaml.getString("name");
            String icVersion = icPluginYaml.getString("version");
            String append = GUIMain.compatible() ? "Select one of the tools below" : "<p style=\"color:red;\"><b>These versions of InteractiveChat & InteractiveChat DiscordSRV Addon are incompatible!<br>Please Upgrade!</b></p>";
            BufferedImage image = ImageIO.read(GUIMain.class.getClassLoader().getResourceAsStream("icon.png"));
            ImageIcon icon = new ImageIcon(image);
            title = pluginName + " v" + version + " Tools";
            String message = "<html><center><b>You are running " + pluginName + " v" + version + "</b><br>(Paired with " + icPluginName + " v" + icVersion + ")<br>" + append + "<html/>";
            JLabel messageLabel = GUIMain.createLabel(message, 15.0f);
            messageLabel.setHorizontalAlignment(0);
            BufferedImage resizedIcon = new BufferedImage(32, 32, 2);
            Graphics2D g = resizedIcon.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(image, 0, 0, 32, 32, null);
            g.dispose();
            block11: while (true) {
                int input = JOptionPane.showOptionDialog(null, messageLabel, title, -1, 1, icon, new Object[]{"Check for Updates", "Validate Plugin Configs", "Generate Default Configs", "Download Assets", "Block Model Renderer (1.13+)", "Minecraft Font Renderer (1.13+)", "Visit Links"}, null);
                switch (input) {
                    case 0: {
                        GUIMain.checkForUpdates(title, icon, version);
                        continue block11;
                    }
                    case 1: {
                        GUIMain.validConfigs(title, icon);
                        continue block11;
                    }
                    case 2: {
                        GUIMain.generateDefaultConfigs(title, icon);
                        continue block11;
                    }
                    case 3: {
                        GUIMain.downloadAssets(title, resizedIcon, icon);
                        continue block11;
                    }
                    case 4: {
                        GUIMain.blockModelRenderer(title, resizedIcon, icon);
                        break block11;
                    }
                    case 5: {
                        GUIMain.minecraftFontRenderer(title, resizedIcon, icon);
                        break block11;
                    }
                    case 6: {
                        GUIMain.visitLinks(title, icon);
                        continue block11;
                    }
                }
                break;
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("An error occurred!\n" + sw, 13.0f, Color.RED), title, 0);
        }
    }

    protected static void visitLinks(String title, Icon icon) throws URISyntaxException, IOException {
        int input = JOptionPane.showOptionDialog(null, GUIMain.createLabel("Visit links through buttons below!", 15.0f), title, -1, 1, icon, new Object[]{"SpigotMC", "GitHub", "Discord Server", "Build Server"}, null);
        if (Desktop.isDesktopSupported()) {
            Desktop dt = Desktop.getDesktop();
            switch (input) {
                case -1: {
                    break;
                }
                case 0: {
                    dt.browse(new URI("https://www.spigotmc.org/resources/83917/"));
                    break;
                }
                case 1: {
                    dt.browse(new URI("https://github.com/LOOHP/InteractiveChat-DiscordSRV-Addon"));
                    break;
                }
                case 2: {
                    dt.browse(new URI("http://dev.discord.loohpjames.com"));
                    break;
                }
                case 3: {
                    dt.browse(new URI("https://ci.loohpjames.com"));
                }
            }
        }
    }

    protected static void checkForUpdates(String title, Icon icon, String localPluginVersion) throws URISyntaxException, IOException {
        int input;
        JSONObject response = (JSONObject)HTTPRequestUtils.getJSONResponse((String)"https://api.loohpjames.com/spigot/data").get((Object)"InteractiveChat-DiscordSRV-Addon");
        String spigotPluginVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"release");
        String devBuildVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"devbuild");
        int spigotPluginId = (int)((Long)((JSONObject)response.get((Object)"spigotmc")).get((Object)"pluginid")).longValue();
        int posOfThirdDot = localPluginVersion.indexOf(".", localPluginVersion.indexOf(".", localPluginVersion.indexOf(".") + 1) + 1);
        Version currentDevBuild = new Version(localPluginVersion);
        Version currentRelease = new Version(localPluginVersion.substring(0, posOfThirdDot >= 0 ? posOfThirdDot : localPluginVersion.length()));
        Version spigotmc = new Version(spigotPluginVersion);
        Version devBuild = new Version(devBuildVersion);
        if (currentRelease.compareTo(spigotmc) < 0) {
            input = JOptionPane.showOptionDialog(null, GUIMain.createLabel("There is a new version available! (" + currentDevBuild + ")\nLocal version: " + localPluginVersion, 15.0f), title, -1, 1, icon, new Object[]{"OK", "Download Link"}, null);
        } else if (currentDevBuild.compareTo(devBuild) < 0) {
            input = JOptionPane.showOptionDialog(null, GUIMain.createLabel("There is a new DEV build available! (" + currentDevBuild + ")\nLocal version: " + localPluginVersion, 15.0f), title, -1, 1, icon, new Object[]{"OK", "Download Link"}, null);
        } else {
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("You are already running the latest version! (" + localPluginVersion + ")", 15.0f), title, 1, icon);
            input = 0;
        }
        if (input == 1 && Desktop.isDesktopSupported()) {
            Desktop dt = Desktop.getDesktop();
            dt.browse(new URI("https://ci.loohpjames.com/job/InteractiveChat-DiscordSRV-Addon/"));
        }
    }

    protected static void validConfigs(String title, Icon icon) throws IOException {
        File folder = new File("InteractiveChatDiscordSrvAddon");
        if (!folder.exists() || !folder.isDirectory()) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("Error: Plugin folder not found", 15.0f, Color.RED), title, 0, icon);
            return;
        }
        LinkedHashMap<File, List<String>> results = new LinkedHashMap<File, List<String>>();
        for (File file : folder.listFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            YamlConfiguration yaml = new YamlConfiguration((InputStream)new FileInputStream(file));
            results.put(file, GUIMain.validateConfigurationSection("", (ConfigurationSection)yaml));
        }
        StringBuilder message = new StringBuilder("Validation Results: (Plugin Folder: " + folder.getAbsolutePath() + ")\n");
        for (Map.Entry entry : results.entrySet()) {
            String fileName = ((File)entry.getKey()).getName();
            List errors = (List)entry.getValue();
            message.append("\n").append(fileName).append(": ");
            if (errors.isEmpty()) {
                message.append("Valid!\n");
                continue;
            }
            message.append("\n");
            for (String error : errors) {
                message.append(error).append("\n");
            }
        }
        message.append("\nNote that a valid config doesn't mean REGEX are valid.");
        JOptionPane.showMessageDialog(null, GUIMain.createLabel(message.toString(), 13.0f), title, 1, icon);
    }

    protected static List<String> validateConfigurationSection(String currentPath, ConfigurationSection section) {
        LinkedList<String> errors = new LinkedList<String>();
        try {
            for (String key : section.getKeys(false)) {
                String path = currentPath.isEmpty() ? key : currentPath + "." + key;
                try {
                    Object value = section.get(key);
                    if (!(value instanceof ConfigurationSection)) continue;
                    errors.addAll(GUIMain.validateConfigurationSection(path, (ConfigurationSection)value));
                }
                catch (Throwable e) {
                    errors.add("Failed to parse option around: " + path);
                }
            }
        }
        catch (Throwable e) {
            errors.add("Failed to parse option around: " + currentPath);
        }
        return errors;
    }

    protected static void generateDefaultConfigs(String title, Icon icon) throws IOException {
        File folder = new File("InteractiveChatDiscordSrvAddon", "generated");
        FileUtils.removeFolderRecursively((File)folder);
        folder.mkdirs();
        FileUtils.copy((InputStream)GUIMain.class.getClassLoader().getResourceAsStream("config.yml"), (File)new File(folder, "config.yml"));
        if (folder != null) {
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("Files saved at: " + folder.getAbsolutePath(), 15.0f), title, 1, icon);
        }
    }

    protected static void downloadAssets(String title, BufferedImage image, Icon icon) {
        File defaultAssetsFolder = new File("InteractiveChatDiscordSrvAddon/built-in", "Default");
        defaultAssetsFolder.mkdirs();
        File libsFolder = new File("InteractiveChatDiscordSrvAddon", "libs");
        libsFolder.mkdirs();
        JPanel panel = new JPanel();
        panel.add(GUIMain.createLabel("Select Minecraft Version: ", 13.0f));
        JComboBox<String> options = new JComboBox<String>();
        for (String version : ResourceDownloadManager.getMinecraftVersions()) {
            options.addItem(version);
        }
        panel.add(options);
        int result = JOptionPane.showOptionDialog(null, panel, title, -1, 1, icon, null, null);
        if (result < 0) {
            return;
        }
        ResourceDownloadManager resourceDownloadManager = new ResourceDownloadManager((String)options.getSelectedItem(), defaultAssetsFolder);
        LibraryDownloadManager libraryDownloadManager = new LibraryDownloadManager(libsFolder);
        JFrame frame = new JFrame(title);
        frame.setIconImage(image);
        frame.setSize(800, 175);
        frame.setDefaultCloseOperation(0);
        frame.setLocationRelativeTo(null);
        panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        panel.setLayout(new GridLayout(0, 1));
        JLabel label = GUIMain.createLabel("<html>Downloading Assets:<html/>", 13.0f);
        label.setSize(800, 125);
        panel.add(label);
        JProgressBar progressBar = new JProgressBar(0, 10000);
        panel.add(progressBar);
        frame.add((Component)panel, "Center");
        frame.setResizable(false);
        frame.setVisible(true);
        CompletableFuture future = new CompletableFuture();
        new Thread(() -> {
            resourceDownloadManager.downloadResources((type, fileName, percentage) -> {
                switch (type) {
                    case CLIENT_DOWNLOAD: {
                        label.setText("<html>Downloading Assets:<br>Downloading client jar<html/>");
                        break;
                    }
                    case EXTRACT: {
                        label.setText("<html>Downloading Assets:<br>Extracting " + fileName + "<html/>");
                        break;
                    }
                    case DOWNLOAD: {
                        label.setText("<html>Downloading Assets:<br>Downloading " + fileName + "<html/>");
                        progressBar.setValue(Math.min(9999, (int)(percentage * 100.0)));
                        break;
                    }
                    case DONE: {
                        label.setText("<html>Done!<html/>");
                    }
                }
            });
            libraryDownloadManager.downloadLibraries((downloadResult, jarName) -> {
                if (downloadResult.booleanValue()) {
                    label.setText("<html>Downloaded library \"" + jarName + "\"<html/>");
                }
            });
            future.complete(null);
        }).start();
        future.join();
        progressBar.setValue(9999);
        JOptionPane.showMessageDialog(null, GUIMain.createLabel("Assets saved at: " + defaultAssetsFolder.getAbsolutePath(), 15.0f), title, 1, icon);
        frame.setVisible(false);
        frame.dispose();
    }

    protected static void blockModelRenderer(String title, BufferedImage image, Icon icon) throws IllegalAccessException {
        new BlockModelRenderer(title, image, icon);
    }

    protected static void minecraftFontRenderer(String title, BufferedImage image, Icon icon) {
        new MinecraftFontRenderer(title, image, icon);
    }

    protected static JLabel createLabel(String message, float fontSize) {
        return GUIMain.createLabel(message, fontSize, Color.BLACK);
    }

    protected static JLabel createLabel(String message, float fontSize, Color color) {
        JLabel label = new JLabel("<html>" + message.replace("\n", "<br>") + "<html/>");
        label.setFont(label.getFont().deriveFont(0).deriveFont(fontSize));
        label.setForeground(color);
        return label;
    }

    protected static boolean compatible() {
        try {
            return Registry.class.getField("INTERACTIVE_CHAT_DISCORD_SRV_ADDON_COMPATIBLE_VERSION").getInt(null) == InteractiveChatRegistry.class.getField("INTERACTIVE_CHAT_DISCORD_SRV_ADDON_COMPATIBLE_VERSION").getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return false;
        }
    }
}

