/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.main;

import com.loohp.interactivechat.libs.com.loohp.yamlconfiguration.ConfigurationSection;
import com.loohp.interactivechat.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.updater.Version;
import com.loohp.interactivechat.utils.FileUtils;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import com.loohp.interactivechatdiscordsrvaddon.main.GUIMain;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceDownloadManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class CMLMain {
    protected static BufferedReader IN = new BufferedReader(new InputStreamReader(System.in));

    public static void launch(String[] args) {
        try {
            Enumeration<URL> enumeration = GUIMain.class.getClassLoader().getResources("plugin.yml");
            YamlConfiguration pluginYaml = new YamlConfiguration(enumeration.nextElement().openStream());
            String pluginName = pluginYaml.getString("name");
            String version = pluginYaml.getString("version");
            YamlConfiguration icPluginYaml = new YamlConfiguration(enumeration.nextElement().openStream());
            String icPluginName = icPluginYaml.getString("name");
            String icVersion = icPluginYaml.getString("version");
            System.out.println("Starting " + pluginName + " v" + version + " Tools...");
            System.out.println();
            block14: while (true) {
                String input;
                System.out.println("You are running " + pluginName + " v" + version);
                System.out.println("Paired with " + icPluginName + " v" + icVersion);
                System.out.println();
                System.out.println("Links:");
                System.out.println("SpigotMC: \"https://www.spigotmc.org/resources/83917/\"");
                System.out.println("GitHub: \"https://github.com/LOOHP/InteractiveChat-DiscordSRV-Addon\"");
                System.out.println("Discord: \"http://dev.discord.loohpjames.com\"");
                System.out.println("Build Server: \"https://ci.loohpjames.com\"");
                System.out.println();
                System.out.println("Select one of the tools by typing in their corresponding number");
                System.out.println("1. Check for Updates   2. Validate Plugin Configs   3.Generate Default Configs   4. Download Assets    5. Exit");
                switch (input = IN.readLine()) {
                    case "1": {
                        CMLMain.checkForUpdates(version);
                        continue block14;
                    }
                    case "2": {
                        CMLMain.validConfigs();
                        continue block14;
                    }
                    case "3": {
                        CMLMain.generateDefaultConfigs();
                        continue block14;
                    }
                    case "4": {
                        CMLMain.downloadAssets();
                        continue block14;
                    }
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("An error occurred!");
            e.printStackTrace();
        }
    }

    protected static void checkForUpdates(String localPluginVersion) throws URISyntaxException, IOException {
        JSONObject response = (JSONObject)HTTPRequestUtils.getJSONResponse((String)"https://api.loohpjames.com/spigot/data").get((Object)"InteractiveChat-DiscordSRV-Addon");
        String spigotPluginVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"release");
        String devBuildVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"devbuild");
        int spigotPluginId = (int)((Long)((JSONObject)response.get((Object)"spigotmc")).get((Object)"pluginid")).longValue();
        int posOfThirdDot = localPluginVersion.indexOf(".", localPluginVersion.indexOf(".", localPluginVersion.indexOf(".") + 1) + 1);
        Version currentDevBuild = new Version(localPluginVersion);
        Version currentRelease = new Version(localPluginVersion.substring(0, posOfThirdDot >= 0 ? posOfThirdDot : localPluginVersion.length()));
        Version spigotmc = new Version(spigotPluginVersion);
        Version devBuild = new Version(devBuildVersion);
        if (currentRelease.compareTo(spigotmc) < 0) {
            System.out.println("There is a new version available! (" + currentDevBuild + ")\nLocal version: " + localPluginVersion + "");
            System.out.println("You can download a new build at: https://ci.loohpjames.com/job/InteractiveChat-DiscordSRV-Addon/");
        } else if (currentDevBuild.compareTo(devBuild) < 0) {
            System.out.println("There is a new DEV build available! (" + currentDevBuild + ")\nLocal version: " + localPluginVersion);
            System.out.println("You can download a new build at: https://ci.loohpjames.com/job/InteractiveChat-DiscordSRV-Addon/");
        } else {
            System.out.println("You are already running the latest version! (" + localPluginVersion + ")");
        }
    }

    protected static void validConfigs() throws IOException {
        File folder = new File("InteractiveChatDiscordSrvAddon");
        if (!folder.exists() || !folder.isDirectory()) {
            System.out.println("Error: Plugin folder not found");
            return;
        }
        LinkedHashMap<File, List<String>> results = new LinkedHashMap<File, List<String>>();
        for (File file : folder.listFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            YamlConfiguration yaml = new YamlConfiguration((InputStream)new FileInputStream(file));
            results.put(file, CMLMain.validateConfigurationSection("", (ConfigurationSection)yaml));
        }
        StringBuilder message = new StringBuilder("Validation Results: (Plugin Folder: " + folder.getAbsolutePath() + ")\n");
        for (Map.Entry entry : results.entrySet()) {
            String fileName = ((File)entry.getKey()).getName();
            List errors = (List)entry.getValue();
            message.append("\n").append(fileName).append(": ");
            if (errors.isEmpty()) {
                message.append("Valid!\n");
                continue;
            }
            message.append("\n");
            for (String error : errors) {
                message.append(error).append("\n");
            }
        }
        message.append("\nNote that a valid config doesn't mean REGEX are valid.");
        System.out.println(message);
    }

    protected static List<String> validateConfigurationSection(String currentPath, ConfigurationSection section) {
        LinkedList<String> errors = new LinkedList<String>();
        try {
            for (String key : section.getKeys(false)) {
                String path = currentPath.isEmpty() ? key : currentPath + "." + key;
                try {
                    Object value = section.get(key);
                    if (!(value instanceof ConfigurationSection)) continue;
                    errors.addAll(CMLMain.validateConfigurationSection(path, (ConfigurationSection)value));
                }
                catch (Throwable e) {
                    errors.add("Failed to parse option around: " + path);
                }
            }
        }
        catch (Throwable e) {
            errors.add("Failed to parse option around: " + currentPath);
        }
        return errors;
    }

    protected static void generateDefaultConfigs() throws IOException {
        File folder = new File("InteractiveChatDiscordSrvAddon", "generated");
        FileUtils.removeFolderRecursively((File)folder);
        folder.mkdirs();
        FileUtils.copy((InputStream)GUIMain.class.getClassLoader().getResourceAsStream("config.yml"), (File)new File(folder, "config.yml"));
        if (folder != null) {
            System.out.println("Files saved at: " + folder.getAbsolutePath());
        }
    }

    protected static void downloadAssets() throws IOException {
        String input;
        File defaultAssetsFolder = new File("InteractiveChatDiscordSrvAddon/built-in", "Default");
        defaultAssetsFolder.mkdirs();
        System.out.println("Available Minecraft Versions:");
        for (String version : ResourceDownloadManager.getMinecraftVersions()) {
            System.out.println(version);
        }
        System.out.println();
        System.out.println("Select Minecraft Version: (Type the version string)");
        while (true) {
            input = IN.readLine();
            if (ResourceDownloadManager.getMinecraftVersions().contains(input)) break;
            System.out.println("That is not a valid Minecraft version!");
            System.out.println();
        }
        ResourceDownloadManager downloadManager = new ResourceDownloadManager(input, defaultAssetsFolder);
        CompletableFuture future = new CompletableFuture();
        new Thread(() -> {
            downloadManager.downloadResources((type, fileName, percentage) -> {
                switch (type) {
                    case CLIENT_DOWNLOAD: {
                        System.out.println("Downloading client jar");
                        break;
                    }
                    case EXTRACT: {
                        System.out.println("Extracting " + fileName);
                        break;
                    }
                    case DOWNLOAD: {
                        System.out.println("Downloading " + fileName);
                        break;
                    }
                    case DONE: {
                        System.out.println("Done!");
                    }
                }
            });
            future.complete(null);
        }).start();
        future.join();
        System.out.println("Assets saved at: " + defaultAssetsFolder.getAbsolutePath());
    }
}

