/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.main;

import com.loohp.interactivechat.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.interactivechat.objectholders.ValueTrios;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.intellij.uiDesigner.core.GridConstraints;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.intellij.uiDesigner.core.GridLayoutManager;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.intellij.uiDesigner.core.Spacer;
import com.loohp.interactivechatdiscordsrvaddon.main.GUIMain;
import com.loohp.interactivechatdiscordsrvaddon.main.TransferableImage;
import com.loohp.interactivechatdiscordsrvaddon.registry.ResourceRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.ICacheManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ModelRenderer;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackInfo;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackType;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelDisplay;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.EnchantmentProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.GeneratedTextureResource;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureAnimation;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureMeta;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import com.loohp.interactivechatdiscordsrvaddon.utils.ModelUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.ResourcePackInfoUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.TintUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class BlockModelRenderer
extends JFrame {
    public static final Pattern COLOR_HEX_PATTERN = Pattern.compile("^#[0-9a-fA-F]{6}$");
    private String title;
    private BufferedImage image;
    private Icon icon;
    private JTextField textFieldResourceKey;
    private JSpinner spinnerWidth;
    private JSpinner spinnerHeight;
    private JTextArea textAreaResources;
    private JButton reloadResourcesButton;
    private JButton renderModelButton;
    private JPanel panel;
    private JPanel imagePanel;
    private JPanel predicateKeyPanel;
    private JPanel predicateValuePanel;
    private JButton buttonSave;
    private JLabel renderTimesLabel;
    private JButton providedTexturesButton;
    private JTextField backgroundColorTextField;
    private JProgressBar resourceBar;
    private JCheckBox altPosBox;
    private JSpinner spinnerThreads;
    private JCheckBox enchantedCheckBox;
    private Map<ModelOverride.ModelOverrideType, JSpinner> overrideSettings;
    private JDialog providedTexturesDialog;
    private Map<JComponent, ValueTrios<Supplier<String>, JButton, JFileChooser>> providedTextureSettings;
    private ResourceManager resourceManager;
    private ModelRenderer modelRenderer;
    private LinkedList<String> keyHistory;
    private int historyIndex;
    private String currentHistoryKey;
    private String tabString;
    private int tabPosition;
    private int tabIndex;
    private List<String> tabOptions;
    private BufferedImage renderedImage;
    private Color backgroundColor;
    private String lastRenderedKey;
    private File lastSavedLocation;
    private ExecutorService executorService;
    private ReentrantLock lock;

    public BlockModelRenderer(String title, BufferedImage image, Icon icon) throws IllegalAccessException {
        this.title = title;
        this.image = image;
        this.icon = icon;
        this.resourceManager = null;
        this.$$$setupUI$$$();
        this.modelRenderer = new ModelRenderer(() -> 0L, () -> 8, () -> (Integer)this.spinnerThreads.getValue());
        this.overrideSettings = new EnumMap<ModelOverride.ModelOverrideType, JSpinner>(ModelOverride.ModelOverrideType.class);
        this.providedTextureSettings = new LinkedHashMap<JComponent, ValueTrios<Supplier<String>, JButton, JFileChooser>>();
        this.executorService = Executors.newSingleThreadExecutor();
        this.lock = new ReentrantLock(true);
        this.lastRenderedKey = "";
        this.renderedImage = null;
        this.backgroundColor = Color.BLACK;
        this.lastSavedLocation = new File(".");
        this.keyHistory = new LinkedList();
        this.historyIndex = -1;
        this.currentHistoryKey = null;
        this.tabString = null;
        this.tabPosition = 0;
        this.tabIndex = -1;
        this.tabOptions = null;
        this.setContentPane(this.panel);
        this.setTitle(title + " - Block Model Renderer");
        this.setSize(1200, 900);
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setDefaultCloseOperation(3);
        this.setIconImage(image);
        this.resourceBar.setMaximum(10000);
        this.predicateKeyPanel.setLayout(new GridLayout(0, 1));
        this.predicateValuePanel.setLayout(new GridLayout(0, 1));
        JLabel label = new JLabel("ENCHANTED");
        this.enchantedCheckBox = new JCheckBox();
        this.enchantedCheckBox.setHorizontalAlignment(4);
        this.predicateKeyPanel.add(label);
        this.predicateValuePanel.add(this.enchantedCheckBox);
        for (ModelOverride.ModelOverrideType type : ModelOverride.ModelOverrideType.values()) {
            JSpinner spinner = new JSpinner(new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 1.0));
            label = new JLabel(type.toString());
            this.predicateKeyPanel.add(label);
            this.predicateValuePanel.add(spinner);
            this.overrideSettings.put(type, spinner);
        }
        this.predicateValuePanel.setLayout(new GridLayout(0, 1));
        this.providedTexturesDialog = new JDialog((Frame)this, "Provided Textures");
        this.providedTexturesDialog.setIconImage(image);
        this.providedTexturesDialog.setDefaultCloseOperation(1);
        final JPanel builtInProvidedTexturesPanel = new JPanel();
        builtInProvidedTexturesPanel.setLayout(new GridLayout(0, 2));
        for (Field field : ResourceRegistry.class.getFields()) {
            if (!field.getName().endsWith("_PLACEHOLDER") || !field.getType().equals(String.class)) continue;
            JLabel fieldLabel = new JLabel((String)field.get(null));
            builtInProvidedTexturesPanel.add(fieldLabel);
            JFileChooser fieldFileChooser = new JFileChooser(this.lastSavedLocation);
            fieldFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return "PNG images";
                }
            });
            JButton fieldButton = new JButton("No File Chosen");
            fieldButton.addActionListener(e -> {
                fieldFileChooser.setSelectedFile(null);
                fieldButton.setText("No File Chosen");
                int result = fieldFileChooser.showOpenDialog(this.providedTexturesDialog);
                if (result == 0) {
                    fieldButton.setText(fieldFileChooser.getSelectedFile().getName());
                }
            });
            this.providedTextureSettings.put(fieldLabel, (ValueTrios<Supplier<String>, JButton, JFileChooser>)new ValueTrios(() -> fieldLabel.getText(), (Object)fieldButton, (Object)fieldFileChooser));
            builtInProvidedTexturesPanel.add(fieldButton);
        }
        JButton buttonMoreProvidedTextures = new JButton("Add Custom");
        buttonMoreProvidedTextures.addActionListener(e -> {
            JTextField fieldText = new JTextField();
            builtInProvidedTexturesPanel.add(fieldText);
            JFileChooser fieldFileChooser = new JFileChooser(this.lastSavedLocation);
            fieldFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return "PNG images";
                }
            });
            JButton fieldButton = new JButton("No File Chosen");
            fieldButton.addActionListener(ev -> {
                fieldFileChooser.setSelectedFile(null);
                fieldButton.setText("No File Chosen");
                int result = fieldFileChooser.showOpenDialog(this.providedTexturesDialog);
                if (result == 0) {
                    fieldButton.setText(fieldFileChooser.getSelectedFile().getName());
                }
            });
            this.providedTextureSettings.put(fieldText, (ValueTrios<Supplier<String>, JButton, JFileChooser>)new ValueTrios(() -> fieldText.getText(), (Object)fieldButton, (Object)fieldFileChooser));
            builtInProvidedTexturesPanel.add(fieldButton);
            SwingUtilities.invokeLater(() -> this.providedTexturesDialog.pack());
        });
        JPanel layoutPanel = new JPanel();
        BoxLayout layout = new BoxLayout(layoutPanel, 1);
        layoutPanel.setLayout(layout);
        layoutPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        layoutPanel.add(builtInProvidedTexturesPanel);
        layoutPanel.add(buttonMoreProvidedTextures);
        buttonMoreProvidedTextures.setAlignmentX(0.5f);
        this.providedTexturesDialog.add(layoutPanel);
        this.providedTexturesDialog.pack();
        this.providedTexturesDialog.setLocationRelativeTo(null);
        this.providedTexturesDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Iterator itr = BlockModelRenderer.this.providedTextureSettings.entrySet().iterator();
                while (itr.hasNext()) {
                    JTextField textField;
                    Map.Entry entry = itr.next();
                    JComponent component = (JComponent)entry.getKey();
                    if (!(component instanceof JTextField) || !(textField = (JTextField)component).getText().trim().isEmpty()) continue;
                    itr.remove();
                    builtInProvidedTexturesPanel.remove(textField);
                    builtInProvidedTexturesPanel.remove((Component)((ValueTrios)entry.getValue()).getSecond());
                }
                SwingUtilities.invokeLater(() -> BlockModelRenderer.this.providedTexturesDialog.pack());
            }
        });
        this.providedTexturesDialog.setResizable(false);
        this.providedTexturesButton.addActionListener(new ActionListener(){

            @Override
            public synchronized void actionPerformed(ActionEvent e) {
                if (!BlockModelRenderer.this.providedTexturesDialog.isVisible()) {
                    BlockModelRenderer.this.providedTexturesDialog.setVisible(true);
                }
            }
        });
        this.renderModelButton.addActionListener(e -> this.executorService.submit(() -> this.render()));
        this.reloadResourcesButton.addActionListener(e -> this.executorService.submit(() -> this.loadResources()));
        this.textFieldResourceKey.addActionListener(e -> this.executorService.submit(() -> {
            if (this.renderModelButton.isEnabled()) {
                this.render();
            }
        }));
        this.textFieldResourceKey.setFocusTraversalKeysEnabled(false);
        this.textFieldResourceKey.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (BlockModelRenderer.this.tabPosition != BlockModelRenderer.this.textFieldResourceKey.getCaretPosition()) {
                    BlockModelRenderer.this.tabPosition = BlockModelRenderer.this.textFieldResourceKey.getCaretPosition();
                    BlockModelRenderer.this.tabString = null;
                }
            }
        });
        this.textFieldResourceKey.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                switch (code) {
                    case 38: {
                        if (BlockModelRenderer.this.historyIndex + 1 >= BlockModelRenderer.this.keyHistory.size()) break;
                        if (BlockModelRenderer.this.historyIndex == -1 && !BlockModelRenderer.this.keyHistory.isEmpty()) {
                            BlockModelRenderer.this.currentHistoryKey = BlockModelRenderer.this.textFieldResourceKey.getText();
                            BlockModelRenderer.this.textFieldResourceKey.setText((String)BlockModelRenderer.this.keyHistory.getFirst());
                            BlockModelRenderer.this.historyIndex++;
                        } else {
                            if (BlockModelRenderer.this.historyIndex == 0 && !BlockModelRenderer.this.textFieldResourceKey.getText().equalsIgnoreCase((String)BlockModelRenderer.this.keyHistory.getFirst())) {
                                BlockModelRenderer.this.currentHistoryKey = BlockModelRenderer.this.textFieldResourceKey.getText();
                                BlockModelRenderer.this.historyIndex--;
                            }
                            BlockModelRenderer.this.textFieldResourceKey.setText((String)BlockModelRenderer.this.keyHistory.get(++BlockModelRenderer.this.historyIndex));
                        }
                        BlockModelRenderer.this.tabString = null;
                        break;
                    }
                    case 40: {
                        if (BlockModelRenderer.this.historyIndex > 0) {
                            BlockModelRenderer.this.textFieldResourceKey.setText((String)BlockModelRenderer.this.keyHistory.get(--BlockModelRenderer.this.historyIndex));
                            BlockModelRenderer.this.tabString = null;
                            break;
                        }
                        if (BlockModelRenderer.this.historyIndex <= -1 || BlockModelRenderer.this.currentHistoryKey == null) break;
                        BlockModelRenderer.this.textFieldResourceKey.setText(BlockModelRenderer.this.currentHistoryKey);
                        BlockModelRenderer.this.currentHistoryKey = null;
                        BlockModelRenderer.this.historyIndex--;
                        BlockModelRenderer.this.tabString = null;
                        break;
                    }
                    case 9: {
                        if (BlockModelRenderer.this.resourceManager == null) break;
                        String text = BlockModelRenderer.this.textFieldResourceKey.getText().substring(0, BlockModelRenderer.this.tabPosition);
                        if (!text.equalsIgnoreCase(BlockModelRenderer.this.tabString)) {
                            BlockModelRenderer.this.tabString = text;
                            BlockModelRenderer.this.tabOptions = BlockModelRenderer.this.resourceManager.getModelManager().getRawBlockModelMapping().keySet().stream().filter(each -> each.startsWith(text)).sorted().collect(Collectors.toList());
                            if (BlockModelRenderer.this.tabOptions.isEmpty()) break;
                            BlockModelRenderer.this.tabIndex = 0;
                            BlockModelRenderer.this.tabPosition = BlockModelRenderer.this.textFieldResourceKey.getCaretPosition();
                            String option = (String)BlockModelRenderer.this.tabOptions.get(BlockModelRenderer.this.tabIndex);
                            BlockModelRenderer.this.textFieldResourceKey.setText(option);
                            BlockModelRenderer.this.textFieldResourceKey.setCaretPosition(Math.min(option.length(), BlockModelRenderer.this.tabPosition));
                            break;
                        }
                        if (BlockModelRenderer.this.tabOptions.isEmpty()) break;
                        BlockModelRenderer.this.tabIndex++;
                        if (BlockModelRenderer.this.tabIndex >= BlockModelRenderer.this.tabOptions.size()) {
                            BlockModelRenderer.this.tabIndex = 0;
                        }
                        String option = (String)BlockModelRenderer.this.tabOptions.get(BlockModelRenderer.this.tabIndex);
                        BlockModelRenderer.this.textFieldResourceKey.setText(option);
                        BlockModelRenderer.this.textFieldResourceKey.setCaretPosition(Math.min(option.length(), BlockModelRenderer.this.tabPosition));
                        break;
                    }
                    case 37: 
                    case 39: {
                        BlockModelRenderer.this.tabString = null;
                        SwingUtilities.invokeLater(() -> BlockModelRenderer.this.tabPosition = BlockModelRenderer.this.textFieldResourceKey.getCaretPosition());
                        break;
                    }
                    default: {
                        if (BlockModelRenderer.this.tabString != null && !BlockModelRenderer.this.tabOptions.isEmpty()) {
                            BlockModelRenderer.this.textFieldResourceKey.setCaretPosition(BlockModelRenderer.this.textFieldResourceKey.getText().length());
                        }
                        BlockModelRenderer.this.tabString = null;
                        SwingUtilities.invokeLater(() -> BlockModelRenderer.this.tabPosition = BlockModelRenderer.this.textFieldResourceKey.getCaretPosition());
                    }
                }
            }
        });
        this.buttonSave.addActionListener(e -> this.executorService.submit(() -> this.saveImage()));
        this.backgroundColorTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String hex = BlockModelRenderer.this.backgroundColorTextField.getText();
                if (!hex.startsWith("#")) {
                    hex = "#" + hex;
                }
                if (COLOR_HEX_PATTERN.matcher(hex).matches()) {
                    BlockModelRenderer.this.backgroundColor = BlockModelRenderer.this.hex2Rgb(hex);
                    BlockModelRenderer.this.imagePanel.repaint();
                }
                BlockModelRenderer.this.backgroundColorTextField.setText(BlockModelRenderer.this.rgb2Hex(BlockModelRenderer.this.backgroundColor).toUpperCase());
            }
        });
        this.backgroundColorTextField.addActionListener(e -> {
            String hex = this.backgroundColorTextField.getText();
            if (!hex.startsWith("#")) {
                hex = "#" + hex;
            }
            if (COLOR_HEX_PATTERN.matcher(hex).matches()) {
                this.backgroundColor = this.hex2Rgb(hex);
                this.imagePanel.repaint();
            }
            this.backgroundColorTextField.setText(this.rgb2Hex(this.backgroundColor).toUpperCase());
        });
        this.tabPosition = this.textFieldResourceKey.getText().length();
        this.textFieldResourceKey.setCaretPosition(this.tabPosition);
        final JPopupMenu menu = new JPopupMenu("Actions");
        JMenuItem copy = new JMenuItem("Copy image");
        copy.addActionListener(event -> this.copyImage());
        menu.add(copy);
        JMenuItem save = new JMenuItem("Save image as...");
        save.addActionListener(event -> this.saveImage());
        menu.add(save);
        this.imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    menu.show(BlockModelRenderer.this.imagePanel, e.getX(), e.getY());
                }
            }
        });
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.executorService.submit(() -> this.loadResources());
    }

    private void createUIComponents() {
        this.spinnerWidth = new JSpinner(new SpinnerNumberModel(600, 1, 8192, 1));
        this.spinnerHeight = new JSpinner(new SpinnerNumberModel(600, 1, 8192, 1));
        this.spinnerThreads = new JSpinner(new SpinnerNumberModel(Runtime.getRuntime().availableProcessors(), 1, 1024, 1));
        this.imagePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BlockModelRenderer.this.backgroundColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (BlockModelRenderer.this.renderedImage != null) {
                    g.drawImage(BlockModelRenderer.this.renderedImage, this.getWidth() / 2 - BlockModelRenderer.this.renderedImage.getWidth() / 2, this.getHeight() / 2 - BlockModelRenderer.this.renderedImage.getHeight() / 2, this);
                    BlockModelRenderer.this.buttonSave.setEnabled(true);
                } else {
                    BlockModelRenderer.this.buttonSave.setEnabled(false);
                }
            }
        };
    }

    public BufferedImage getRawEnchantedImage(BufferedImage source) {
        TextureResource resource = this.resourceManager.getTextureManager().getTexture("minecraft:misc/enchanted_item_glint");
        BufferedImage tintOriginal = resource.getTexture();
        if (resource.hasTextureMeta()) {
            TextureProperties properties;
            TextureMeta meta = resource.getTextureMeta();
            if (meta.hasProperties() && (properties = meta.getProperties()).isBlur()) {
                tintOriginal = ImageUtils.applyGaussianBlur(tintOriginal);
            }
            if (meta.hasAnimation()) {
                TextureAnimation animation = meta.getAnimation();
                tintOriginal = animation.hasWidth() && animation.hasHeight() ? tintOriginal.getSubimage(0, 0, animation.getWidth(), animation.getHeight()) : tintOriginal.getSubimage(0, 0, tintOriginal.getWidth(), tintOriginal.getWidth());
            }
        }
        BufferedImage tintImage = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        Graphics2D g3 = tintImage.createGraphics();
        g3.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        tintOriginal = tintImage.getHeight() < tintImage.getWidth() ? ImageUtils.resizeImageFillWidth(tintOriginal, tintImage.getWidth() * 4) : ImageUtils.resizeImageFillHeight(tintOriginal, tintImage.getHeight() * 4);
        g3.drawImage((Image)tintOriginal, 0, 0, null);
        g3.dispose();
        return tintImage;
    }

    public BufferedImage getEnchantedImage(BufferedImage source) {
        return ImageUtils.additionNonTransparent(source, this.getRawEnchantedImage(source), 0.7450980392156863);
    }

    public Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public String rgb2Hex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public void loadResources() {
        int valuePerPack;
        List resourceOrder;
        try {
            if (!this.lock.tryLock(0L, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.renderModelButton.setEnabled(false);
        this.reloadResourcesButton.setEnabled(false);
        this.resourceBar.setValue(0);
        this.resourceBar.setVisible(true);
        this.textAreaResources.setText("Loading Resources...");
        try {
            YamlConfiguration yaml = new YamlConfiguration(Files.newInputStream(Paths.get("InteractiveChatDiscordSrvAddon/config.yml", new String[0]), new OpenOption[0]));
            resourceOrder = yaml.getStringList("Resources.Order");
            Collections.reverse(resourceOrder);
            valuePerPack = (int)(1.0 / (double)(resourceOrder.size() + 1) * 10000.0);
        }
        catch (IOException e) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("There is an error while loading from config:\n" + e.getMessage(), 13.0f, Color.RED), this.title, 0);
            return;
        }
        if (this.resourceManager != null) {
            this.resourceManager.close();
        }
        PrintStream original = System.err;
        try {
            this.resourceManager = new ResourceManager(false, false, Collections.emptyList(), Collections.singletonList(ICacheManager.getDummySupplier()));
            this.resourceManager.loadResources(new File("InteractiveChatDiscordSrvAddon/built-in", "Default"), ResourcePackType.BUILT_IN);
            this.resourceBar.setValue(valuePerPack);
            for (String resourceName : resourceOrder) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                System.setErr(new PrintStream(baos));
                try {
                    File resourcePackFile = new File("InteractiveChatDiscordSrvAddon/resourcepacks/" + resourceName);
                    ResourcePackInfo resourcePackInfo = this.resourceManager.loadResources(resourcePackFile, ResourcePackType.LOCAL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String error = baos.toString();
                if (!error.isEmpty()) {
                    ForkJoinPool.commonPool().execute(() -> JOptionPane.showMessageDialog(null, GUIMain.createLabel("There are errors while loading \"" + resourceName + "\":\n" + error, 13.0f, Color.RED), this.title, 0));
                }
                this.resourceBar.setValue(this.resourceBar.getValue() + valuePerPack);
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("An error occurred!\n" + sw, 13.0f, Color.RED), this.title, 0);
        }
        System.setErr(original);
        this.textAreaResources.setText("Loaded Resources:\n");
        for (ResourcePackInfo info : this.resourceManager.getResourcePackInfo()) {
            this.textAreaResources.append(" - " + ResourcePackInfoUtils.resolveName(info));
            if (!info.getStatus()) {
                this.textAreaResources.append(" (Failed)");
            }
            this.textAreaResources.append("\n");
        }
        this.renderModelButton.setEnabled(true);
        this.reloadResourcesButton.setEnabled(true);
        this.resourceBar.setVisible(false);
        this.lock.unlock();
    }

    public void render() {
        try {
            if (!this.lock.tryLock(0L, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.renderModelButton.setEnabled(false);
        this.reloadResourcesButton.setEnabled(false);
        this.spinnerThreads.setEnabled(false);
        String key = this.textFieldResourceKey.getText();
        if (!key.contains(":")) {
            key = "minecraft:" + key;
            this.textFieldResourceKey.setText(key);
        }
        String finalKey = key;
        this.keyHistory.removeIf(each -> each.equalsIgnoreCase(finalKey));
        this.keyHistory.add(0, key);
        this.historyIndex = 0;
        this.currentHistoryKey = null;
        int lastSlash = key.lastIndexOf("/");
        String trimmedKey = key.substring(lastSlash < 0 ? key.lastIndexOf(":") + 1 : lastSlash + 1);
        HashMap<String, TextureResource> providedTextures = new HashMap<String, TextureResource>();
        EnumMap<ModelOverride.ModelOverrideType, Float> predicates = new EnumMap<ModelOverride.ModelOverrideType, Float>(ModelOverride.ModelOverrideType.class);
        TintUtils.SpawnEggTintData tintData = TintUtils.getSpawnEggTint(trimmedKey);
        if (tintData != null) {
            BufferedImage baseImage = this.resourceManager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "spawn_egg").getTexture();
            Object overlayImage = this.resourceManager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "spawn_egg_overlay").getTexture(baseImage.getWidth(), baseImage.getHeight());
            BufferedImage bufferedImage = ImageUtils.changeColorTo(ImageUtils.copyImage(baseImage), tintData.getBase());
            BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage((BufferedImage)overlayImage), tintData.getOverlay());
            baseImage = ImageUtils.multiply(baseImage, bufferedImage);
            overlayImage = ImageUtils.multiply((BufferedImage)overlayImage, colorOverlay);
            providedTextures.put(ResourceRegistry.SPAWN_EGG_PLACEHOLDER, new GeneratedTextureResource(this.resourceManager, baseImage));
            providedTextures.put(ResourceRegistry.SPAWN_EGG_OVERLAY_PLACEHOLDER, new GeneratedTextureResource(this.resourceManager, (BufferedImage)overlayImage));
        }
        TintUtils.TintIndexData tintIndexData = TintUtils.getTintData(trimmedKey);
        for (Map.Entry<ModelOverride.ModelOverrideType, JSpinner> entry : this.overrideSettings.entrySet()) {
            float value = ((Number)entry.getValue().getValue()).floatValue();
            if (value == 0.0f) continue;
            predicates.put(entry.getKey(), Float.valueOf(value));
        }
        for (ValueTrios valueTrios : this.providedTextureSettings.values()) {
            String texturePlaceholder = (String)((Supplier)valueTrios.getFirst()).get();
            File file = ((JFileChooser)valueTrios.getThird()).getSelectedFile();
            if (file == null || !file.getName().endsWith(".png")) continue;
            try {
                BufferedImage image = texturePlaceholder.equals("minecraft:interactivechatdiscordsrvaddon/skin") || texturePlaceholder.equals("minecraft:interactivechatdiscordsrvaddon/skin_full") ? ModelUtils.convertToModernSkinTexture(ImageIO.read(file)) : ImageIO.read(file);
                providedTextures.put(texturePlaceholder, new GeneratedTextureResource(this.resourceManager, image));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.modelRenderer.reloadPoolSize();
        long start = System.currentTimeMillis();
        try {
            ModelRenderer.RenderResult result = this.modelRenderer.render((Integer)this.spinnerWidth.getValue(), (Integer)this.spinnerHeight.getValue(), (Integer)this.spinnerWidth.getValue(), (Integer)this.spinnerHeight.getValue(), this.resourceManager, null, false, key, ModelDisplay.ModelDisplayPosition.GUI, predicates, providedTextures, tintIndexData, this.enchantedCheckBox.isSelected(), this.altPosBox.isSelected(), source -> this.getEnchantedImage((BufferedImage)source), source -> new ModelRenderer.RawEnchantmentGlintData(Collections.singletonList(this.getRawEnchantedImage((BufferedImage)source)), Collections.singletonList(EnchantmentProperties.OpenGLBlending.GLINT)));
            long end = System.currentTimeMillis();
            if (result.isSuccessful()) {
                this.renderedImage = result.getImage();
                this.imagePanel.repaint();
                this.renderTimesLabel.setText(end - start + "ms");
                this.lastRenderedKey = key;
            } else {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, GUIMain.createLabel("Render Rejected:\n" + result.getRejectedReason(), 13.0f, Color.RED), this.title, 0);
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("An error occurred!\n" + sw, 13.0f, Color.RED), this.title, 0);
        }
        this.renderModelButton.setEnabled(true);
        this.reloadResourcesButton.setEnabled(true);
        this.spinnerThreads.setEnabled(true);
        this.lock.unlock();
    }

    public synchronized void copyImage() {
        if (this.renderedImage == null) {
            return;
        }
        TransferableImage trans = new TransferableImage(this.renderedImage);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(trans, null);
    }

    public synchronized void saveImage() {
        File file;
        int input;
        if (this.renderedImage == null) {
            return;
        }
        String key = this.lastRenderedKey;
        if (!this.lastRenderedKey.isEmpty()) {
            int lastSlash = key.lastIndexOf("/");
            key = key.substring(lastSlash < 0 ? key.lastIndexOf(":") : lastSlash);
        }
        do {
            JFileChooser fileChooser = new JFileChooser(this.lastSavedLocation);
            fileChooser.setSelectedFile(new File(this.lastSavedLocation, key + ".png"));
            int result = fileChooser.showSaveDialog(this);
            if (result != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            if (file.getParentFile() != null) {
                this.lastSavedLocation = file.getParentFile();
            }
            if (!file.exists()) break;
            Toolkit.getDefaultToolkit().beep();
        } while ((input = JOptionPane.showOptionDialog(null, GUIMain.createLabel(file.getName() + " already exists! Do you want to overwrite?", 15.0f), this.title, -1, 2, null, new Object[]{"Overwrite", "Cancel"}, null)) != 0);
        try {
            ImageIO.write((RenderedImage)this.renderedImage, "png", file);
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, GUIMain.createLabel("An error occurred!\n" + sw, 13.0f, Color.RED), this.title, 0);
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayoutManager(7, 13, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        label1.setText("Model Resource Key");
        this.panel.add((Component)label1, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Width");
        this.panel.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.panel.add((Component)this.spinnerWidth, new GridConstraints(1, 1, 1, 2, 8, 1, 0, 0, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1), 0, false));
        this.textFieldResourceKey = new JTextField();
        this.textFieldResourceKey.setText("minecraft:item/");
        this.textFieldResourceKey.setToolTipText("Example: \"minecraft:item/stone\"");
        this.panel.add((Component)this.textFieldResourceKey, new GridConstraints(0, 2, 1, 10, 8, 1, 2, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Height");
        this.panel.add((Component)label3, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.panel.add((Component)this.spinnerHeight, new GridConstraints(1, 4, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1), 0, false));
        this.textAreaResources = new JTextArea();
        this.textAreaResources.setEditable(false);
        this.panel.add((Component)this.textAreaResources, new GridConstraints(2, 11, 1, 2, 0, 3, 2, 2, null, new Dimension(250, 50), null, 0, false));
        this.panel.add((Component)this.imagePanel, new GridConstraints(2, 0, 5, 11, 0, 3, 4, 4, null, null, null, 0, false));
        this.renderModelButton = new JButton();
        this.renderModelButton.setText("Render Model");
        this.panel.add((Component)this.renderModelButton, new GridConstraints(0, 12, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.predicateKeyPanel = new JPanel();
        this.predicateKeyPanel.setLayout(new GridBagLayout());
        this.panel.add((Component)this.predicateKeyPanel, new GridConstraints(5, 11, 1, 1, 0, 3, 0, 0, null, null, null, 0, false));
        this.reloadResourcesButton = new JButton();
        this.reloadResourcesButton.setText("Reload Resources");
        this.panel.add((Component)this.reloadResourcesButton, new GridConstraints(1, 12, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.buttonSave = new JButton();
        this.buttonSave.setEnabled(false);
        this.buttonSave.setText("Save Image");
        this.panel.add((Component)this.buttonSave, new GridConstraints(6, 12, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.predicateValuePanel = new JPanel();
        this.predicateValuePanel.setLayout(new GridBagLayout());
        this.predicateValuePanel.setEnabled(true);
        this.panel.add((Component)this.predicateValuePanel, new GridConstraints(5, 12, 1, 1, 0, 3, 0, 0, null, null, null, 0, false));
        this.renderTimesLabel = new JLabel();
        this.renderTimesLabel.setText("0ms");
        this.panel.add((Component)this.renderTimesLabel, new GridConstraints(6, 11, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setText("Customization");
        this.panel.add((Component)label4, new GridConstraints(4, 11, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.providedTexturesButton = new JButton();
        this.providedTexturesButton.setText("Provided Textures");
        this.panel.add((Component)this.providedTexturesButton, new GridConstraints(4, 12, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.panel.add((Component)spacer1, new GridConstraints(1, 10, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("Background Color");
        label5.setToolTipText("Visual background color");
        this.panel.add((Component)label5, new GridConstraints(1, 5, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.backgroundColorTextField = new JTextField();
        this.backgroundColorTextField.setColumns(8);
        this.backgroundColorTextField.setHorizontalAlignment(11);
        this.backgroundColorTextField.setText("#000000");
        this.backgroundColorTextField.setToolTipText("Visual background color");
        this.panel.add((Component)this.backgroundColorTextField, new GridConstraints(1, 6, 1, 1, 8, 1, 0, 0, null, null, null, 0, false));
        this.resourceBar = new JProgressBar();
        this.panel.add((Component)this.resourceBar, new GridConstraints(3, 11, 1, 2, 0, 1, 2, 0, null, null, null, 0, false));
        this.altPosBox = new JCheckBox();
        this.altPosBox.setText("Alternate Position");
        this.panel.add((Component)this.altPosBox, new GridConstraints(1, 9, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JLabel label6 = new JLabel();
        label6.setText("Threads");
        this.panel.add((Component)label6, new GridConstraints(1, 7, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.panel.add((Component)this.spinnerThreads, new GridConstraints(1, 8, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1), 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

