/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.listeners;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.api.events.PrePacketComponentProcessEvent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.event.ClickEvent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.event.HoverEvent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.event.HoverEventSource;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactivechat.objectholders.ICPlaceholder;
import com.loohp.interactivechat.utils.ComponentReplacing;
import com.loohp.interactivechat.utils.CustomStringUtils;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.api.events.DiscordAttachmentConversionEvent;
import com.loohp.interactivechatdiscordsrvaddon.debug.Debug;
import com.loohp.interactivechatdiscordsrvaddon.graphics.GifReader;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageFrame;
import com.loohp.interactivechatdiscordsrvaddon.modules.DiscordToGameMention;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.PreviewableImageContainer;
import com.loohp.interactivechatdiscordsrvaddon.utils.ThrowingSupplier;
import com.loohp.interactivechatdiscordsrvaddon.utils.URLRequestUtils;
import com.loohp.interactivechatdiscordsrvaddon.wrappers.GraphicsToPacketMapWrapper;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageSticker;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.ComponentLike;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.TextReplacementConfig;
import github.scarsz.discordsrv.util.MessageUtil;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InboundToGameEvents
implements Listener {
    public static final Map<UUID, DiscordAttachmentData> DATA = new ConcurrentHashMap<UUID, DiscordAttachmentData>();
    public static final Map<Player, GraphicsToPacketMapWrapper> MAP_VIEWERS = new ConcurrentHashMap<Player, GraphicsToPacketMapWrapper>();

    @Subscribe(priority=ListenerPriority.LOWEST)
    public void onReceiveMessageFromDiscordPre(DiscordGuildMessagePreProcessEvent event) {
        Debug.debug("Triggering onReceiveMessageFromDiscordPre");
        DiscordSRV srv = InteractiveChatDiscordSrvAddon.discordsrv;
        Map discordRegexes = srv.getDiscordRegexes();
        if (discordRegexes != null) {
            discordRegexes.keySet().removeIf(pattern -> pattern.pattern().equals("@+(everyone|here)"));
        }
    }

    @Subscribe(priority=ListenerPriority.LOW)
    public void onDiscordToGame(DiscordGuildMessagePostProcessEvent event) {
        Debug.debug("Triggering onDiscordToGame");
        InteractiveChatDiscordSrvAddon.plugin.messagesCounter.incrementAndGet();
        Component component = event.getMinecraftMessage();
        if (InteractiveChatDiscordSrvAddon.plugin.escapePlaceholdersFromDiscord) {
            Debug.debug("onDiscordToGame escaping placeholders");
            for (ICPlaceholder placeholder : InteractiveChat.placeholderList.values()) {
                component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(placeholder.getKeyword()).replacement((result, builder) -> builder.content("\\" + result.group())).build());
            }
            event.setMinecraftMessage(component);
        }
    }

    @Subscribe(priority=ListenerPriority.LOWEST)
    public void onReceiveMessageFromDiscordPostLowest(DiscordGuildMessagePostProcessEvent event) {
        if (InteractiveChatDiscordSrvAddon.plugin.discordToGamePriority.equals((Object)ListenerPriority.LOWEST)) {
            this.handleReceiveMessageFromDiscordPost(event);
        }
    }

    @Subscribe(priority=ListenerPriority.LOW)
    public void onReceiveMessageFromDiscordPostLow(DiscordGuildMessagePostProcessEvent event) {
        if (InteractiveChatDiscordSrvAddon.plugin.discordToGamePriority.equals((Object)ListenerPriority.LOW)) {
            this.handleReceiveMessageFromDiscordPost(event);
        }
    }

    @Subscribe(priority=ListenerPriority.NORMAL)
    public void onReceiveMessageFromDiscordPostNormal(DiscordGuildMessagePostProcessEvent event) {
        if (InteractiveChatDiscordSrvAddon.plugin.discordToGamePriority.equals((Object)ListenerPriority.NORMAL)) {
            this.handleReceiveMessageFromDiscordPost(event);
        }
    }

    @Subscribe(priority=ListenerPriority.HIGH)
    public void onReceiveMessageFromDiscordPostHigh(DiscordGuildMessagePostProcessEvent event) {
        if (InteractiveChatDiscordSrvAddon.plugin.discordToGamePriority.equals((Object)ListenerPriority.HIGH)) {
            this.handleReceiveMessageFromDiscordPost(event);
        }
    }

    @Subscribe(priority=ListenerPriority.HIGHEST)
    public void onReceiveMessageFromDiscordPostHighest(DiscordGuildMessagePostProcessEvent event) {
        if (InteractiveChatDiscordSrvAddon.plugin.discordToGamePriority.equals((Object)ListenerPriority.HIGHEST)) {
            this.handleReceiveMessageFromDiscordPost(event);
        }
    }

    @Subscribe(priority=ListenerPriority.MONITOR)
    public void onReceiveMessageFromDiscordPostMonitor(DiscordGuildMessagePostProcessEvent event) {
        if (InteractiveChatDiscordSrvAddon.plugin.discordToGamePriority.equals((Object)ListenerPriority.MONITOR)) {
            this.handleReceiveMessageFromDiscordPost(event);
        }
    }

    public void handleReceiveMessageFromDiscordPost(DiscordGuildMessagePostProcessEvent event) {
        Debug.debug("Triggering onReceiveMessageFromDiscordPost");
        Message message = event.getMessage();
        Component component = event.getMinecraftMessage();
        DiscordSRV srv = InteractiveChatDiscordSrvAddon.discordsrv;
        User author = message.getAuthor();
        if (InteractiveChatDiscordSrvAddon.plugin.translateMentions) {
            Player player;
            UUID uuid;
            Debug.debug("onReceiveMessageFromDiscordPost translating mentions");
            HashSet<Object> mentionTitleSent = new HashSet<Object>();
            HashMap<Member, UUID> channelMembers = new HashMap<Member, UUID>();
            TextChannel channel = event.getChannel();
            Guild guild = channel.getGuild();
            Member authorAsMember = guild.getMember(author);
            String senderDiscordName = authorAsMember == null ? author.getName() : authorAsMember.getEffectiveName();
            UUID senderUUID = srv.getAccountLinkManager().getUuid(author.getId());
            for (Map.Entry entry : srv.getAccountLinkManager().getManyDiscordIds(Bukkit.getOnlinePlayers().stream().map(each -> each.getUniqueId()).collect(Collectors.toSet())).entrySet()) {
                Member member = guild.getMemberById((String)entry.getValue());
                if (member == null || !member.hasAccess((GuildChannel)channel)) continue;
                channelMembers.put(member, (UUID)entry.getKey());
            }
            if (message.mentionsEveryone()) {
                component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("@here").replacement((ComponentLike)Component.text((String)InteractiveChatDiscordSrvAddon.plugin.mentionHighlight.replace("{DiscordMention}", "@here"))).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("@everyone").replacement((ComponentLike)Component.text((String)InteractiveChatDiscordSrvAddon.plugin.mentionHighlight.replace("{DiscordMention}", "@everyone"))).build());
                for (Object uuid2 : channelMembers.values()) {
                    mentionTitleSent.add(uuid2);
                    Player player2 = Bukkit.getPlayer((UUID)uuid2);
                    if (player2 == null) continue;
                    DiscordToGameMention.playTitleScreen(senderDiscordName, channel.getName(), guild.getName(), player2);
                }
            }
            List mentionedRoles = message.getMentionedRoles();
            for (Object role : mentionedRoles) {
                component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("@" + role.getName()).replacement((ComponentLike)Component.text((String)InteractiveChatDiscordSrvAddon.plugin.mentionHighlight.replace("{DiscordMention}", "@" + role.getName()))).build());
                for (Map.Entry entry : channelMembers.entrySet()) {
                    uuid = (UUID)entry.getValue();
                    if (mentionTitleSent.contains(uuid) || !((Member)entry.getKey()).getRoles().contains(role)) continue;
                    mentionTitleSent.add(uuid);
                    player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null) continue;
                    DiscordToGameMention.playTitleScreen(senderDiscordName, channel.getName(), guild.getName(), player);
                }
            }
            List mentionedUsers = message.getMentionedUsers();
            if (!mentionedUsers.isEmpty()) {
                for (User user : mentionedUsers) {
                    component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("@" + user.getName()).replacement((ComponentLike)Component.text((String)InteractiveChatDiscordSrvAddon.plugin.mentionHighlight.replace("{DiscordMention}", "@" + user.getName()))).build());
                    Member member = guild.getMember(user);
                    if (member == null || (uuid = (UUID)channelMembers.get(member)) == null || mentionTitleSent.contains(uuid) || senderUUID != null && senderUUID.equals(uuid)) continue;
                    mentionTitleSent.add(uuid);
                    player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null) continue;
                    DiscordToGameMention.playTitleScreen(senderDiscordName, channel.getName(), guild.getName(), player);
                }
            }
            event.setMinecraftMessage(component);
        }
        String processedMessage = MessageUtil.toLegacy((Component)component);
        if (InteractiveChatDiscordSrvAddon.plugin.convertDiscordAttachments) {
            String url;
            Debug.debug("onReceiveMessageFromDiscordPost converting discord attachments");
            HashSet<String> processedUrl = new HashSet<String>();
            ArrayList<PreviewableImageContainer> previewableImageContainers = new ArrayList<PreviewableImageContainer>(message.getAttachments().size() + message.getStickers().size());
            for (Message.Attachment attachment : message.getAttachments()) {
                InteractiveChatDiscordSrvAddon.plugin.attachmentCounter.incrementAndGet();
                url = attachment.getUrl();
                if (!processedMessage.contains(url)) continue;
                processedUrl.add(url);
                if ((attachment.isImage() || attachment.isVideo()) && (long)attachment.getSize() <= InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsPreviewLimit) {
                    previewableImageContainers.add(PreviewableImageContainer.fromAttachment(attachment));
                    continue;
                }
                DiscordAttachmentData data = new DiscordAttachmentData(attachment.getFileName(), url);
                DiscordAttachmentConversionEvent dace = new DiscordAttachmentConversionEvent(url, data);
                Bukkit.getPluginManager().callEvent((Event)dace);
                DATA.put(data.getUniqueId(), data);
                Bukkit.getScheduler().runTaskLater((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> DATA.remove(data.getUniqueId()), (long)InteractiveChatDiscordSrvAddon.plugin.discordAttachmentTimeout);
            }
            for (MessageSticker sticker : message.getStickers()) {
                previewableImageContainers.add(PreviewableImageContainer.fromSticker(sticker));
            }
            for (PreviewableImageContainer imageContainer : previewableImageContainers) {
                InteractiveChatDiscordSrvAddon.plugin.attachmentImageCounter.incrementAndGet();
                url = imageContainer.getUrl();
                ArrayList<ThrowingSupplier<InputStream>> methods = new ArrayList<ThrowingSupplier<InputStream>>();
                methods.add(() -> imageContainer.retrieveInputStream().get());
                for (String url0 : imageContainer.getAllUrls()) {
                    if (!URLRequestUtils.isAllowed(url0)) continue;
                    methods.add(() -> URLRequestUtils.getInputStream0(url0));
                }
                try {
                    InputStream stream = URLRequestUtils.retrieveInputStreamUntilSuccessful(methods);
                    try {
                        GraphicsToPacketMapWrapper map;
                        boolean isVideo = false;
                        if (url.toLowerCase().endsWith(".gif.png") || url.toLowerCase().endsWith(".apng")) {
                            throw new UnsupportedOperationException("Animated PNG not yet supported, this error can be ignored");
                        }
                        if (url.toLowerCase().endsWith(".gif")) {
                            map = new GraphicsToPacketMapWrapper(InteractiveChatDiscordSrvAddon.plugin.playbackBarEnabled, InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsMapBackgroundColor);
                            GifReader.readGif(stream, InteractiveChatDiscordSrvAddon.plugin.mediaReadingService, (frames, e) -> {
                                if (e != null) {
                                    e.printStackTrace();
                                    map.completeFuture(null);
                                } else {
                                    map.completeFuture((List<ImageFrame>)frames);
                                }
                            });
                        } else {
                            BufferedImage image = ImageIO.read(stream);
                            map = new GraphicsToPacketMapWrapper(image, InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsMapBackgroundColor);
                        }
                        DiscordAttachmentData data = new DiscordAttachmentData(imageContainer.getName(), url, map, isVideo);
                        DiscordAttachmentConversionEvent dace = new DiscordAttachmentConversionEvent(url, data);
                        Bukkit.getPluginManager().callEvent((Event)dace);
                        DATA.put(data.getUniqueId(), data);
                        Bukkit.getScheduler().runTaskLater((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> DATA.remove(data.getUniqueId()), (long)InteractiveChatDiscordSrvAddon.plugin.discordAttachmentTimeout);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    DiscordAttachmentData data = new DiscordAttachmentData(imageContainer.getName(), url);
                    DiscordAttachmentConversionEvent dace = new DiscordAttachmentConversionEvent(url, data);
                    Bukkit.getPluginManager().callEvent((Event)dace);
                    DATA.put(data.getUniqueId(), data);
                    Bukkit.getScheduler().runTaskLater((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> DATA.remove(data.getUniqueId()), (long)InteractiveChatDiscordSrvAddon.plugin.discordAttachmentTimeout);
                }
            }
            Matcher matcher = URLRequestUtils.IMAGE_URL_PATTERN.matcher(message.getContentRaw());
            while (matcher.find()) {
                long size;
                String url2 = matcher.group();
                String extension = matcher.group(1);
                if (processedUrl.contains(url2) || !URLRequestUtils.isAllowed(url2) || (size = HTTPRequestUtils.getContentSize((String)url2)) < 0L || size > InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsPreviewLimit) continue;
                InteractiveChatDiscordSrvAddon.plugin.attachmentImageCounter.incrementAndGet();
                try {
                    InputStream stream = URLRequestUtils.getInputStream(url2);
                    try {
                        GraphicsToPacketMapWrapper map;
                        boolean isVideo = false;
                        if (extension.equals("gif.png") || extension.equals("apng")) {
                            throw new UnsupportedOperationException("Animated PNG not yet supported, this error can be ignored");
                        }
                        if (extension.equals("gif")) {
                            map = new GraphicsToPacketMapWrapper(InteractiveChatDiscordSrvAddon.plugin.playbackBarEnabled, InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsMapBackgroundColor);
                            GifReader.readGif(stream, InteractiveChatDiscordSrvAddon.plugin.mediaReadingService, (frames, e) -> {
                                if (e != null) {
                                    e.printStackTrace();
                                    map.completeFuture(null);
                                } else {
                                    map.completeFuture((List<ImageFrame>)frames);
                                }
                            });
                        } else {
                            BufferedImage image = ImageIO.read(stream);
                            map = new GraphicsToPacketMapWrapper(image, InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsMapBackgroundColor);
                        }
                        int end = matcher.end(1);
                        String name = url2.lastIndexOf("/") < 0 ? url2.substring(0, end) : url2.substring(url2.lastIndexOf("/") + 1, end);
                        DiscordAttachmentData data = new DiscordAttachmentData(name, url2, map, isVideo);
                        DiscordAttachmentConversionEvent dace = new DiscordAttachmentConversionEvent(url2, data);
                        Bukkit.getPluginManager().callEvent((Event)dace);
                        DATA.put(data.getUniqueId(), data);
                        Bukkit.getScheduler().runTaskLater((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> DATA.remove(data.getUniqueId()), (long)InteractiveChatDiscordSrvAddon.plugin.discordAttachmentTimeout);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (FileNotFoundException stream) {
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    @EventHandler
    public void onChatPacket(PrePacketComponentProcessEvent event) {
        Debug.debug("Triggering onChatPacket");
        if (InteractiveChatDiscordSrvAddon.plugin.convertDiscordAttachments) {
            Debug.debug("onChatPacket converting discord attachments");
            for (Map.Entry<UUID, DiscordAttachmentData> entry : DATA.entrySet()) {
                DiscordAttachmentData data = entry.getValue();
                String url = data.getUrl();
                com.loohp.interactivechat.libs.net.kyori.adventure.text.Component component = event.getComponent();
                String replacement = InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsFormattingText.replace("{FileName}", data.getFileName());
                TextComponent textComponent = LegacyComponentSerializer.legacySection().deserialize(replacement);
                if (InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsFormattingHoverEnabled) {
                    String hover = InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsFormattingHoverText.replace("{FileName}", data.getFileName());
                    textComponent = textComponent.hoverEvent((HoverEventSource)HoverEvent.showText((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)LegacyComponentSerializer.legacySection().deserialize(hover)));
                }
                if (InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsImagesUseMaps && data.isImage()) {
                    textComponent = textComponent.clickEvent(ClickEvent.runCommand((String)("/interactivechatdiscordsrv imagemap " + data.getUniqueId().toString())));
                    TextComponent imageAppend = LegacyComponentSerializer.legacySection().deserialize(InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsFormattingImageAppend.replace("{FileName}", data.getFileName()));
                    imageAppend = imageAppend.hoverEvent((HoverEventSource)HoverEvent.showText((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)LegacyComponentSerializer.legacySection().deserialize(InteractiveChatDiscordSrvAddon.plugin.discordAttachmentsFormattingImageAppendHover.replace("{FileName}", data.getFileName()))));
                    imageAppend = imageAppend.clickEvent(ClickEvent.openUrl((String)url));
                    textComponent = textComponent.append((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)imageAppend);
                } else {
                    textComponent = textComponent.clickEvent(ClickEvent.openUrl((String)url));
                }
                component = ComponentReplacing.replace((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)component, (String)("\\\\?" + CustomStringUtils.escapeMetaCharacters((String)url)), (com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)textComponent);
                event.setComponent(component);
            }
        }
    }

    @EventHandler
    public void onInventory(InventoryOpenEvent event) {
        boolean removed;
        Player player = (Player)event.getPlayer();
        boolean bl = removed = MAP_VIEWERS.remove(player) != null;
        if (removed) {
            player.getInventory().setItemInHand(player.getInventory().getItemInHand());
        }
    }

    @EventHandler
    public void onInventory(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            Bukkit.getScheduler().runTaskLater((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> {
                boolean removed;
                boolean bl = removed = MAP_VIEWERS.remove(player) != null;
                if (removed) {
                    player.getInventory().setItemInHand(player.getInventory().getItemInHand());
                }
            }, 1L);
        } else {
            boolean removed;
            boolean bl = removed = MAP_VIEWERS.remove(player) != null;
            if (removed) {
                player.getInventory().setItemInHand(player.getInventory().getItemInHand());
            }
        }
    }

    @EventHandler
    public void onInventory(InventoryCreativeEvent event) {
        Player player = (Player)event.getWhoClicked();
        boolean removed = MAP_VIEWERS.remove(player) != null;
        int slot = event.getSlot();
        if (removed) {
            if (player.getInventory().equals(event.getClickedInventory()) && slot >= 9) {
                ItemStack item = player.getInventory().getItem(slot);
                Bukkit.getScheduler().runTaskLater((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> player.getInventory().setItem(slot, item), 1L);
            } else {
                event.setCursor(null);
            }
        }
        if (removed) {
            player.getInventory().setItemInHand(player.getInventory().getItemInHand());
        }
    }

    @EventHandler
    public void onSlotChange(PlayerItemHeldEvent event) {
        boolean removed;
        if (event.getNewSlot() == event.getPreviousSlot()) {
            return;
        }
        Player player = event.getPlayer();
        boolean bl = removed = MAP_VIEWERS.remove(player) != null;
        if (removed) {
            player.getInventory().setItemInHand(player.getInventory().getItemInHand());
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            Bukkit.getScheduler().runTaskLater((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> {
                boolean removed;
                boolean bl = removed = MAP_VIEWERS.remove(player) != null;
                if (removed) {
                    player.getInventory().setItemInHand(player.getInventory().getItemInHand());
                }
            }, 1L);
        } else {
            boolean removed;
            boolean bl = removed = MAP_VIEWERS.remove(player) != null;
            if (removed) {
                player.getInventory().setItemInHand(player.getInventory().getItemInHand());
            }
        }
    }

    @EventHandler
    public void onAttack(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            boolean removed;
            Player player = (Player)entity;
            boolean bl = removed = MAP_VIEWERS.remove(player) != null;
            if (removed) {
                player.getInventory().setItemInHand(player.getInventory().getItemInHand());
            }
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        MAP_VIEWERS.remove(event.getPlayer());
    }

    public static class DiscordAttachmentData {
        private final String fileName;
        private final String url;
        private final GraphicsToPacketMapWrapper imageMap;
        private final UUID uuid;
        private final boolean isVideo;

        public DiscordAttachmentData(String fileName, String url, GraphicsToPacketMapWrapper imageMap, boolean isVideo) {
            this.fileName = fileName;
            this.url = url;
            this.imageMap = imageMap;
            this.uuid = UUID.randomUUID();
            this.isVideo = isVideo;
        }

        public DiscordAttachmentData(String fileName, String url) {
            this(fileName, url, null, false);
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isImage() {
            return this.imageMap != null && !this.isVideo;
        }

        public boolean isVideo() {
            return this.imageMap != null && this.isVideo;
        }

        public GraphicsToPacketMapWrapper getImageMap() {
            return this.imageMap;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        public int hashCode() {
            return 17 * this.uuid.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof DiscordAttachmentData) {
                return ((DiscordAttachmentData)object).uuid.equals(this.uuid);
            }
            return false;
        }
    }
}

