/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.listeners;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.api.events.ICPlayerJoinEvent;
import com.loohp.interactivechat.api.events.OfflineICPlayerCreationEvent;
import com.loohp.interactivechat.api.events.OfflineICPlayerUpdateEvent;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.objectholders.ConcurrentCacheHashMap;
import com.loohp.interactivechat.objectholders.OfflineICPlayer;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ICPlayerEvents
implements Listener {
    public static final String PROFILE_URL = "https://api.loohpjames.com/spigot/plugins/interactivechatdiscordsrvaddon/profile/%s";
    private static final ConcurrentCacheHashMap<UUID, Map<String, Object>> CACHED_PROPERTIES = new ConcurrentCacheHashMap(300000L);

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(ICPlayerJoinEvent event) {
        this.populate((OfflineICPlayer)event.getPlayer(), true);
    }

    @EventHandler
    public void onCreation(OfflineICPlayerCreationEvent event) {
        this.populate(event.getPlayer(), false);
    }

    @EventHandler
    public void onUpdate(OfflineICPlayerUpdateEvent event) {
        this.populate(event.getPlayer(), false);
    }

    private void populate(OfflineICPlayer player, boolean scheduleAsync) {
        if (scheduleAsync) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> this.populate(player, false));
            return;
        }
        HashMap<String, Object> cachedProperties = (HashMap<String, Object>)CACHED_PROPERTIES.get((Object)player.getUniqueId());
        if (cachedProperties == null) {
            cachedProperties = new HashMap<String, Object>();
            JSONObject json = HTTPRequestUtils.getJSONResponse((String)PROFILE_URL.replace("%s", player.getName()));
            if (json != null && json.containsKey((Object)"properties")) {
                JSONObject properties = (JSONObject)json.get((Object)"properties");
                for (Object obj : properties.keySet()) {
                    try {
                        String key = (String)obj;
                        String value = (String)properties.get((Object)key);
                        if (value.endsWith(".png")) {
                            BufferedImage image = ImageUtils.downloadImage(value);
                            player.addProperties(key, (Object)image);
                            cachedProperties.put(key, image);
                            continue;
                        }
                        if (value.endsWith(".bin")) {
                            byte[] data = HTTPRequestUtils.download((String)value);
                            player.addProperties(key, (Object)data);
                            cachedProperties.put(key, data);
                            continue;
                        }
                        player.addProperties(key, (Object)value);
                        cachedProperties.put(key, value);
                    }
                    catch (Exception exception) {}
                }
            }
            CACHED_PROPERTIES.put((Object)player.getUniqueId(), cachedProperties);
        } else {
            for (Map.Entry entry : cachedProperties.entrySet()) {
                player.addProperties((String)entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractiveChat.plugin, () -> CACHED_PROPERTIES.cleanUp(), 12000L, 12000L);
    }
}

