/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.listeners;

import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.debug.Debug;
import com.loohp.interactivechatdiscordsrvaddon.listeners.DiscordCommands;
import com.loohp.interactivechatdiscordsrvaddon.listeners.DiscordInteractionEvents;
import com.loohp.interactivechatdiscordsrvaddon.listeners.OutboundToDiscordEvents;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.commands.SlashCommandProvider;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DiscordReadyEvents {
    private volatile boolean init = false;

    public DiscordReadyEvents() {
        if (DiscordSRV.isReady) {
            this.init = true;
            this.ready();
        }
    }

    @Subscribe(priority=ListenerPriority.HIGHEST)
    public void onDiscordReady(DiscordReadyEvent event) {
        if (!this.init) {
            this.init = true;
            this.ready();
        }
    }

    public void ready() {
        Debug.debug("Triggering discord ready...");
        DiscordSRV discordsrv = InteractiveChatDiscordSrvAddon.discordsrv;
        JDA jda = discordsrv.getJda();
        jda.addEventListener(new Object[]{new OutboundToDiscordEvents.JDAEvents()});
        jda.addEventListener(new Object[]{new DiscordInteractionEvents()});
        DiscordCommands discordCommands = new DiscordCommands(discordsrv);
        discordCommands.init();
        Bukkit.getPluginManager().registerEvents((Listener)discordCommands, (Plugin)InteractiveChatDiscordSrvAddon.plugin);
        DiscordSRV.api.addSlashCommandProvider((SlashCommandProvider)discordCommands);
        discordCommands.reload();
        for (String channelId : discordsrv.getChannels().values()) {
            if (channelId == null) continue;
            try {
                GuildChannel channel = jda.getGuildChannelById(channelId);
                if (channel == null) continue;
                Guild guild = channel.getGuild();
                Member self = guild.getMember((User)jda.getSelfUser());
                for (Permission permission : InteractiveChatDiscordSrvAddon.requiredPermissions) {
                    if (self.hasPermission(channel, new Permission[]{permission})) continue;
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ICDiscordSrvAddon] DiscordSRV Bot is missing the \"" + permission.getName() + "\" permission in the channel \"" + channel.getName() + "\" (Id: " + channel.getId() + ")");
                }
            }
            catch (Exception e) {
                new RuntimeException("Error when getting guild from channelId (" + channelId + ")", e).printStackTrace();
            }
        }
    }
}

