/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.listeners;

import com.loohp.interactivechat.utils.ChatColorUtils;
import com.loohp.interactivechat.utils.HashUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.metrics.Metrics;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.DiscordMessageContent;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.InteractionHandler;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.ButtonClickEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericComponentInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.SelectionMenuEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DiscordInteractionEvents
extends ListenerAdapter {
    public static final String INTERACTION_ID_PREFIX;
    private static final Map<String, InteractionData> REGISTER;

    public static void register(Message message, InteractionHandler interactionHandler, List<DiscordMessageContent> discordMessageContent) {
        String messageId = message.getChannel().getId() + "/" + message.getId();
        List<String> interactionIds = interactionHandler.getInteractions();
        InteractionData interactionData = new InteractionData(interactionHandler, discordMessageContent, interactionIds, messageId);
        for (String id : interactionIds) {
            if (!id.startsWith(INTERACTION_ID_PREFIX)) {
                throw new IllegalArgumentException("InteractionIds must start with the INTERACTION_ID_PREFIX, however \"" + id + "\" does not");
            }
            REGISTER.put(id, interactionData);
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> {
            for (String id : interactionIds) {
                REGISTER.remove(id);
            }
        }, interactionHandler.getExpire() / 50L);
    }

    public static InteractionData getInteractionData(String interactionId) {
        return REGISTER.get(interactionId);
    }

    public static void unregisterAll() {
        REGISTER.clear();
    }

    public void onButtonClick(ButtonClickEvent event) {
        this.handleInteraction((GenericComponentInteractionCreateEvent)event);
    }

    public void onSelectionMenu(SelectionMenuEvent event) {
        this.handleInteraction((GenericComponentInteractionCreateEvent)event);
    }

    private void handleInteraction(GenericComponentInteractionCreateEvent event) {
        String id = event.getComponent().getId();
        if (!id.startsWith(INTERACTION_ID_PREFIX)) {
            return;
        }
        InteractionData data = REGISTER.get(id);
        if (data != null) {
            data.getInteractionHandler().getReactionConsumer().accept(event, data.getContents());
            return;
        }
        event.reply(ChatColorUtils.stripColor((String)InteractiveChatDiscordSrvAddon.plugin.interactionExpire)).setEphemeral(true).queue();
    }

    static {
        try {
            INTERACTION_ID_PREFIX = "ICD_" + HashUtils.createSha1String((InputStream)new ByteArrayInputStream(Metrics.getServerUUID().getBytes(StandardCharsets.UTF_8))) + "_";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        REGISTER = new ConcurrentHashMap<String, InteractionData>();
    }

    public static class InteractionData {
        private InteractionHandler interactionHandler;
        private List<DiscordMessageContent> contents;
        private List<String> interactionIds;
        private List<String> messageIds;

        public InteractionData(InteractionHandler interactionHandler, List<DiscordMessageContent> contents, List<String> interactionIds, List<String> messageIds) {
            this.interactionHandler = interactionHandler;
            this.contents = contents;
            this.interactionIds = interactionIds;
            this.messageIds = messageIds;
        }

        public InteractionData(InteractionHandler interactionHandler, List<DiscordMessageContent> contents, List<String> interactionIds, String messageId) {
            this.interactionHandler = interactionHandler;
            this.contents = contents;
            this.interactionIds = interactionIds;
            ArrayList<String> messageIds = new ArrayList<String>();
            messageIds.add(messageId);
            this.messageIds = messageIds;
        }

        public InteractionHandler getInteractionHandler() {
            return this.interactionHandler;
        }

        public List<DiscordMessageContent> getContents() {
            return this.contents;
        }

        public List<String> getInteractionIds() {
            return this.interactionIds;
        }

        public List<String> getMessageIds() {
            return this.messageIds;
        }
    }
}

