/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils;

import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.MathUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final Color TEXT_BACKGROUND_COLOR = new Color(0, 0, 0, 180);
    public static final double CHAT_COLOR_BACKGROUND_FACTOR = 0.19;

    public static String hash(BufferedImage image) {
        int[] colors;
        StringBuilder sb = new StringBuilder();
        for (int color : colors = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth())) {
            sb.append(Integer.toHexString(color));
        }
        return sb.toString();
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        try {
            GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            if (image.getColorModel().equals(gfxConfig.getColorModel())) {
                return image;
            }
            BufferedImage newImage = gfxConfig.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
            Graphics2D g2d = newImage.createGraphics();
            g2d.drawImage((Image)image, 0, 0, null);
            g2d.dispose();
            return newImage;
        }
        catch (Exception e) {
            return image;
        }
    }

    public static int getRGB(BufferedImage image, int x, int y) {
        if (x < 0 || y < 0 || x >= image.getWidth() || y >= image.getHeight()) {
            return 0;
        }
        return image.getRGB(x, y);
    }

    public static int getRGB(int[] colors, int x, int y, int w, int h) {
        if (x < 0 || y < 0 || x >= w || y >= h) {
            return 0;
        }
        return colors[y * w + x];
    }

    public static BufferedImage downloadImage(String link) throws IOException {
        URL url = new URL(link);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.addRequestProperty("Pragma", "no-cache");
        InputStream in = connection.getInputStream();
        BufferedImage image = ImageIO.read(in);
        in.close();
        return image;
    }

    public static BufferedImage transformRGB(BufferedImage image, PixelTransformFunction function) {
        boolean direct;
        int[] colors;
        int width = image.getWidth();
        int height = image.getHeight();
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            colors = ((DataBufferInt)dataBuffer).getData();
            direct = true;
        } else {
            colors = image.getRGB(0, 0, width, height, null, 0, width);
            direct = false;
        }
        int i = 0;
        for (int colorValue : colors) {
            colors[i] = function.apply(i % width, i / width, colorValue);
            ++i;
        }
        if (!direct) {
            image.setRGB(0, 0, width, height, colors, 0, width);
        }
        return image;
    }

    public static BufferedImage rotateImageByDegrees(BufferedImage img, double angle) {
        if (MathUtils.equals(angle % 360.0, 0.0)) {
            return img;
        }
        double rads = Math.toRadians(angle);
        double sin = Math.abs(Math.sin(rads));
        double cos = Math.abs(Math.cos(rads));
        int w = img.getWidth();
        int h = img.getHeight();
        int newWidth = (int)Math.floor((double)w * cos + (double)h * sin);
        int newHeight = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage rotated = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = rotated.createGraphics();
        AffineTransform at = new AffineTransform();
        at.translate((double)(newWidth - w) / 2.0, (double)(newHeight - h) / 2.0);
        int x = w / 2;
        int y = h / 2;
        at.rotate(rads, x, y);
        g.setTransform(at);
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return rotated;
    }

    public static BufferedImage flipHorizontal(BufferedImage image) {
        BufferedImage b = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage(image, image.getWidth(), 0, -image.getWidth(), image.getHeight(), null);
        g.dispose();
        return b;
    }

    public static BufferedImage flipVertically(BufferedImage image) {
        BufferedImage b = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage(image, 0, image.getHeight(), image.getWidth(), -image.getHeight(), null);
        g.dispose();
        return b;
    }

    public static BufferedImage expandCenterAligned(BufferedImage image, int pixels) {
        BufferedImage b = new BufferedImage(image.getWidth() + pixels + pixels, image.getHeight() + pixels + pixels, 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)image, pixels, pixels, null);
        g.dispose();
        return b;
    }

    public static BufferedImage expandCenterAligned(BufferedImage image, int up, int down, int left, int right) {
        BufferedImage b = new BufferedImage(image.getWidth() + left + right, image.getHeight() + up + down, 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)image, left, up, null);
        g.dispose();
        return b;
    }

    public static BufferedImage additionNonTransparent(BufferedImage image, BufferedImage imageToAdd) {
        return ImageUtils.additionNonTransparent(image, imageToAdd, 1.0);
    }

    public static BufferedImage additionNonTransparent(BufferedImage image, BufferedImage imageToAdd, double factor) {
        if (factor < 0.0 || factor > 1.0) {
            throw new IllegalArgumentException("factor cannot be smaller than 0 or greater than 1");
        }
        for (int y = 0; y < image.getHeight() && y < imageToAdd.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth() && x < imageToAdd.getWidth(); ++x) {
                int value = image.getRGB(x, y);
                int addValue = imageToAdd.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(value);
                if (alpha == 0) continue;
                int red = ColorUtils.getRed(value) + (int)((double)ColorUtils.getRed(addValue) * factor);
                int green = ColorUtils.getGreen(value) + (int)((double)ColorUtils.getGreen(addValue) * factor);
                int blue = ColorUtils.getBlue(value) + (int)((double)ColorUtils.getBlue(addValue) * factor);
                int color = ColorUtils.getIntFromColor(Math.min(red, 255), Math.min(green, 255), Math.min(blue, 255), alpha);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage drawTransparent(BufferedImage image, BufferedImage imageToAdd, int posX, int posY) {
        for (int y = 0; y + posY < image.getHeight() && y < imageToAdd.getHeight(); ++y) {
            for (int x = 0; x + posX < image.getWidth() && x < imageToAdd.getWidth(); ++x) {
                if (x + posX < 0 || y + posY < 0) continue;
                int value = image.getRGB(x + posX, y + posY);
                int addValue = imageToAdd.getRGB(x, y);
                if (ColorUtils.getAlpha(value) != 0) continue;
                image.setRGB(x + posX, y + posY, addValue);
            }
        }
        return image;
    }

    public static BufferedImage darken(BufferedImage image, int value) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(colorValue);
                if (alpha == 0) continue;
                int red = ColorUtils.getRed(colorValue) - value;
                int green = ColorUtils.getGreen(colorValue) - value;
                int blue = ColorUtils.getBlue(colorValue) - value;
                int color = ColorUtils.getIntFromColor(Math.max(red, 0), Math.max(green, 0), Math.max(blue, 0), alpha);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage add(BufferedImage image, int value) {
        return ImageUtils.add(image, value, value, value);
    }

    public static BufferedImage add(BufferedImage image, int xValue, int yValue, int zValue) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(colorValue);
                if (alpha == 0) continue;
                int red = ColorUtils.getRed(colorValue) + xValue;
                int green = ColorUtils.getGreen(colorValue) + yValue;
                int blue = ColorUtils.getBlue(colorValue) + zValue;
                int color = ColorUtils.getIntFromColor(red < 0 ? 0 : Math.min(red, 255), green < 0 ? 0 : Math.min(green, 255), blue < 0 ? 0 : Math.min(blue, 255), alpha);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage multiply(BufferedImage image, double value) {
        return ImageUtils.multiply(image, value, value, value);
    }

    public static BufferedImage multiply(BufferedImage image, double xValue, double yValue, double zValue) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(colorValue);
                if (alpha == 0) continue;
                int red = (int)((double)ColorUtils.getRed(colorValue) * xValue);
                int green = (int)((double)ColorUtils.getGreen(colorValue) * yValue);
                int blue = (int)((double)ColorUtils.getBlue(colorValue) * zValue);
                int color = ColorUtils.getIntFromColor(red < 0 ? 0 : Math.min(red, 255), green < 0 ? 0 : Math.min(green, 255), blue < 0 ? 0 : Math.min(blue, 255), alpha);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage multiply(BufferedImage image, BufferedImage imageOnTop) {
        for (int y = 0; y < image.getHeight() && y < imageOnTop.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth() && x < imageOnTop.getWidth(); ++x) {
                int value = image.getRGB(x, y);
                int multiplyValue = imageOnTop.getRGB(x, y);
                int red = (int)Math.round((double)ColorUtils.getRed(value) / 255.0 * (double)ColorUtils.getRed(multiplyValue));
                int green = (int)Math.round((double)ColorUtils.getGreen(value) / 255.0 * (double)ColorUtils.getGreen(multiplyValue));
                int blue = (int)Math.round((double)ColorUtils.getBlue(value) / 255.0 * (double)ColorUtils.getBlue(multiplyValue));
                int color = ColorUtils.getIntFromColor(red, green, blue, ColorUtils.getAlpha(value));
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage changeColorTo(BufferedImage image, Color color) {
        return ImageUtils.changeColorTo(image, color.getRGB());
    }

    public static BufferedImage changeColorTo(BufferedImage image, int color) {
        color &= 0xFFFFFF;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int newColor = color | colorValue & 0xFF000000;
                image.setRGB(x, y, newColor);
            }
        }
        return image;
    }

    public static BufferedImage raiseAlpha(BufferedImage image, int value) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(colorValue) + value;
                int color = ColorUtils.getIntFromColor(ColorUtils.getRed(colorValue), ColorUtils.getGreen(colorValue), ColorUtils.getBlue(colorValue), alpha > 255 ? 255 : Math.max(alpha, 0));
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage squarify(BufferedImage image) {
        if (image.getHeight() == image.getWidth()) {
            return image;
        }
        int size = Math.max(image.getHeight(), image.getWidth());
        int offsetX = (size - image.getWidth()) / 2;
        int offsetY = (size - image.getHeight()) / 2;
        BufferedImage newImage = new BufferedImage(size, size, 2);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                newImage.setRGB(x + offsetX, y + offsetY, colorValue);
            }
        }
        return newImage;
    }

    public static BufferedImage xor(BufferedImage bottom, BufferedImage top, int alpha) {
        for (int y = 0; y < bottom.getHeight(); ++y) {
            for (int x = 0; x < bottom.getWidth(); ++x) {
                int bottomValue = bottom.getRGB(x, y);
                int topValue = top.getRGB(x, y);
                int color = ColorUtils.getIntFromColor(ColorUtils.getRed(bottomValue) ^ ColorUtils.getRed(topValue), ColorUtils.getGreen(bottomValue) ^ ColorUtils.getGreen(topValue), ColorUtils.getBlue(bottomValue) ^ ColorUtils.getBlue(topValue), ColorUtils.getAlpha(bottomValue) ^ ColorUtils.getAlpha(topValue) * alpha / 255);
                bottom.setRGB(x, y, color);
            }
        }
        return bottom;
    }

    public static BufferedImage appendImageRight(BufferedImage source, BufferedImage append, int middleGap, int rightSpace) {
        BufferedImage b = new BufferedImage(source.getWidth() + append.getWidth() + middleGap + rightSpace, Math.max(source.getHeight(), append.getHeight()), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.drawImage((Image)append, source.getWidth() + middleGap, 0, null);
        g.dispose();
        return b;
    }

    public static BufferedImage copyImage(BufferedImage source) {
        BufferedImage b = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.dispose();
        return b;
    }

    public static BufferedImage copyAndGetSubImage(BufferedImage source, int x, int y, int w, int h) {
        BufferedImage copyOfImage = new BufferedImage(w, h, 2);
        Graphics2D g = copyOfImage.createGraphics();
        g.drawImage((Image)source, -x, -y, null);
        g.dispose();
        return copyOfImage;
    }

    public static BufferedImage resizeImage(BufferedImage source, double factor) {
        int w = (int)Math.round((double)source.getWidth() * factor);
        int h = (int)Math.round((double)source.getHeight() * factor);
        return ImageUtils.resizeImageAbs(source, w, h);
    }

    public static BufferedImage resizeImageQuality(BufferedImage source, int width, int height) {
        BufferedImage b = new BufferedImage(width, height, 2);
        Graphics2D g = b.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return b;
    }

    public static BufferedImage resizeImageAbs(BufferedImage source, int width, int height) {
        BufferedImage b = new BufferedImage(width, height, 2);
        Graphics2D g = b.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return b;
    }

    public static BufferedImage resizeImageFillWidth(BufferedImage source, int width) {
        int height = (int)Math.round((double)source.getHeight() * ((double)width / (double)source.getWidth()));
        return ImageUtils.resizeImageAbs(source, width, height);
    }

    public static BufferedImage resizeImageFillHeight(BufferedImage source, int height) {
        int width = (int)Math.round((double)source.getWidth() * ((double)height / (double)source.getHeight()));
        return ImageUtils.resizeImageAbs(source, width, height);
    }

    public static BufferedImage resizeImageStretch(BufferedImage source, int pixels) {
        int w = source.getWidth() + pixels;
        int h = source.getHeight() + pixels;
        return ImageUtils.resizeImageAbs(source, w, h);
    }

    @FunctionalInterface
    public static interface PixelTransformFunction {
        public int apply(int var1, int var2, int var3);
    }
}

