/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils;

import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.BlendingMode;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.BlendingModes;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.ColorCompositeFactor;

public class ColorUtils {
    public static int composite(int srcColor, int desColor, BlendingModes blendingModes) {
        return ColorUtils.composite(srcColor, desColor, blendingModes.getSrcColorComposite(), blendingModes.getDesColorComposite(), blendingModes.getSrcAlphaComposite(), blendingModes.getDesAlphaComposite());
    }

    public static int composite(int srcColor, int desColor, BlendingMode srcComposite, BlendingMode desComposite) {
        return ColorUtils.composite(srcColor, desColor, srcComposite, desComposite, srcComposite, desComposite);
    }

    public static int composite(int srcColor, int desColor, BlendingMode srcColorComposite, BlendingMode desColorComposite, BlendingMode srcAlphaComposite, BlendingMode desAlphaComposite) {
        ColorCompositeFactor srcFactor = srcColorComposite.getColorCompositeFactor(srcColor, desColor);
        ColorCompositeFactor desFactor = desColorComposite.getColorCompositeFactor(srcColor, desColor);
        double srcAlphaFactor = srcAlphaComposite.getAlphaCompositeFactor(srcColor, desColor);
        double desAlphaFactor = desAlphaComposite.getAlphaCompositeFactor(srcColor, desColor);
        return ColorUtils.composite(srcColor, desColor, srcFactor, desFactor, srcAlphaFactor, desAlphaFactor);
    }

    public static int composite(int srcColor, int desColor, ColorCompositeFactor srcFactor, ColorCompositeFactor desFactor, double srcAlphaFactor, double desAlphaFactor) {
        int red = Math.min(255, (int)((double)ColorUtils.getRed(srcColor) * srcFactor.getRed() + (double)ColorUtils.getRed(desColor) * desFactor.getRed()));
        int green = Math.min(255, (int)((double)ColorUtils.getGreen(srcColor) * srcFactor.getGreen() + (double)ColorUtils.getGreen(desColor) * desFactor.getGreen()));
        int blue = Math.min(255, (int)((double)ColorUtils.getBlue(srcColor) * srcFactor.getBlue() + (double)ColorUtils.getBlue(desColor) * desFactor.getBlue()));
        int alpha = Math.min(255, (int)((double)ColorUtils.getAlpha(srcColor) * srcAlphaFactor + (double)ColorUtils.getAlpha(desColor) * desAlphaFactor));
        return ColorUtils.getIntFromColor(red, green, blue, alpha);
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getIntFromColor(int r, int g, int b, int a) {
        int red = r << 16 & 0xFF0000;
        int green = g << 8 & 0xFF00;
        int blue = b & 0xFF;
        int alpha = a << 24 & 0xFF000000;
        return alpha | red | green | blue;
    }
}

