/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render;

import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.BlendingModes;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.BakeResult;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Face;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Hexahedron;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.ITransformable;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Vector;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.MathUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.TaskCompletion;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class Model
implements ITransformable {
    public static final int PIXEL_PER_THREAD = 256;
    private List<Hexahedron> components;
    private List<Face> faces;

    public Model(List<Hexahedron> components) {
        this.components = components;
        this.faces = new ArrayList<Face>();
        for (Hexahedron hexahedron : components) {
            this.faces.addAll(hexahedron.getFacesByAverageZ());
        }
        this.sortFaces();
    }

    public Model(Hexahedron ... components) {
        this(new ArrayList<Hexahedron>(Arrays.asList(components)));
    }

    public void append(Model model) {
        for (Hexahedron hexahedron : model.components) {
            this.components.add(hexahedron);
            this.faces.addAll(hexahedron.getFacesByAverageZ());
        }
        this.sortFaces();
    }

    public List<Hexahedron> getComponents() {
        return this.components;
    }

    @Override
    public void rotate(double x, double y, double z, boolean saveAxis) {
        for (Hexahedron hexahedron : this.components) {
            hexahedron.rotate(x, y, z, saveAxis);
        }
        this.sortFaces();
    }

    @Override
    public void translate(double x, double y, double z) {
        for (Hexahedron hexahedron : this.components) {
            hexahedron.translate(x, y, z);
        }
    }

    @Override
    public void scale(double x, double y, double z) {
        for (Hexahedron hexahedron : this.components) {
            hexahedron.scale(x, y, z);
        }
    }

    @Override
    public void flipAboutPlane(boolean x, boolean y, boolean z) {
        for (Hexahedron hexahedron : this.components) {
            hexahedron.flipAboutPlane(x, y, z);
        }
    }

    @Override
    public void updateLighting(Vector direction, double ambient, double max) {
        for (Hexahedron hexahedron : this.components) {
            hexahedron.updateLighting(direction, ambient, max);
        }
    }

    public void sortFaces() {
        this.faces.sort(Face.AVERAGE_DEPTH_COMPARATOR);
    }

    public TaskCompletion render(BufferedImage source, boolean useZBuffer, AffineTransform baseTransform, BlendingModes blendingMode, ExecutorService service) {
        LinkedList<BakeResult> bakes = new LinkedList<BakeResult>();
        for (Face face : this.faces) {
            BakeResult result = face.bake(baseTransform);
            if (result == null || !result.hasInverseTransform()) continue;
            bakes.add(result);
        }
        int w = source.getWidth();
        int h = source.getHeight();
        double baseTranslateX = baseTransform.getTranslateX();
        double baseTranslateY = baseTransform.getTranslateY();
        double baseScaleX = baseTransform.getScaleX();
        double baseScaleY = -baseTransform.getScaleY();
        int[] sourceColors = source.getRGB(0, 0, w, h, null, 0, w);
        int pixelCount = w * h;
        ArrayList futures = new ArrayList(pixelCount / 256 + 1);
        for (int i = 0; i < pixelCount; i += 256) {
            int currentI = i;
            futures.add(service.submit(() -> {
                int position;
                double[] pointSrc = new double[2];
                double[] pointDes = new double[2];
                for (int u = 0; u < 256 && (position = currentI + u) < pixelCount; ++u) {
                    int sourceColor = sourceColors[position];
                    int x = position % w;
                    int y = position / w;
                    double reverseTransformedX = ((double)x - baseTranslateX) / baseScaleX;
                    double reverseTransformedY = ((double)y - baseTranslateY) / baseScaleY;
                    int newColor = sourceColor;
                    double z = -1.7976931348623157E308;
                    int depthTieBreaker = Integer.MIN_VALUE;
                    pointSrc[0] = x;
                    pointSrc[1] = y;
                    for (BakeResult bake : bakes) {
                        if (bake.isOutOfBound(reverseTransformedX, reverseTransformedY)) continue;
                        bake.getInverseTransform().transform(pointSrc, 0, pointDes, 0, 1);
                        BufferedImage image = bake.getTexture();
                        if (!MathUtils.greaterThanOrEquals(pointDes[0], 0.0) || !MathUtils.greaterThanOrEquals(pointDes[1], 0.0) || !MathUtils.lessThan(pointDes[0], (double)image.getWidth()) || !MathUtils.lessThan(pointDes[1], (double)image.getHeight())) continue;
                        int imageColor = image.getRGB((int)pointDes[0], (int)pointDes[1]);
                        if (useZBuffer) {
                            int imageAlpha = ColorUtils.getAlpha(imageColor);
                            int sourceAlpha = ColorUtils.getAlpha(sourceColor);
                            if (imageAlpha > 0) {
                                double depth = bake.getDepthAt(reverseTransformedX, reverseTransformedY);
                                int tieBreak = bake.getDepthTieBreaker();
                                if (!MathUtils.greaterThan(depth, z) && (!MathUtils.equals(depth, z) || tieBreak <= depthTieBreaker)) continue;
                                depthTieBreaker = tieBreak;
                                if (depth > z) {
                                    z = depth;
                                }
                                if (imageAlpha >= 255) {
                                    newColor = imageColor;
                                    continue;
                                }
                                newColor = ColorUtils.composite(imageColor, newColor, blendingMode);
                                continue;
                            }
                            if (sourceAlpha >= 255) continue;
                            newColor = ColorUtils.composite(newColor, imageColor, blendingMode);
                            continue;
                        }
                        newColor = ColorUtils.composite(imageColor, newColor, blendingMode);
                    }
                    if (newColor == sourceColor) continue;
                    source.setRGB(x, y, newColor);
                }
            }));
        }
        return new TaskCompletion(futures);
    }
}

