/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render;

import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.BlendingModes;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Face;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.ITransformable;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Point3D;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Vector;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Hexahedron
implements ITransformable {
    private Face upFace;
    private Face downFace;
    private Face northFace;
    private Face eastFace;
    private Face southFace;
    private Face westFace;
    private List<Face> byDirection;
    private List<Face> byAverageZ;

    public static Hexahedron fromCorners(Point3D p1, Point3D p2, BufferedImage[] images) {
        if (images.length != 6) {
            throw new IllegalArgumentException("images length must be 6");
        }
        return new Hexahedron(new Face(images[0], new Point3D(p1.x, p2.y, p1.z), new Point3D(p2.x, p2.y, p1.z), new Point3D(p2.x, p2.y, p2.z), new Point3D(p1.x, p2.y, p2.z)), new Face(images[1], new Point3D(p1.x, p1.y, p2.z), new Point3D(p2.x, p1.y, p2.z), new Point3D(p2.x, p1.y, p1.z), new Point3D(p1.x, p1.y, p1.z)), new Face(images[2], new Point3D(p2.x, p2.y, p1.z), new Point3D(p1.x, p2.y, p1.z), new Point3D(p1.x, p1.y, p1.z), new Point3D(p2.x, p1.y, p1.z)), new Face(images[3], new Point3D(p2.x, p2.y, p2.z), new Point3D(p2.x, p2.y, p1.z), new Point3D(p2.x, p1.y, p1.z), new Point3D(p2.x, p1.y, p2.z)), new Face(images[4], new Point3D(p1.x, p2.y, p2.z), new Point3D(p2.x, p2.y, p2.z), new Point3D(p2.x, p1.y, p2.z), new Point3D(p1.x, p1.y, p2.z)), new Face(images[5], new Point3D(p1.x, p2.y, p1.z), new Point3D(p1.x, p2.y, p2.z), new Point3D(p1.x, p1.y, p2.z), new Point3D(p1.x, p1.y, p1.z)));
    }

    public Hexahedron(Face upFace, Face downFace, Face northFace, Face eastFace, Face southFace, Face westFace) {
        this.upFace = upFace;
        this.downFace = downFace;
        this.northFace = northFace;
        this.eastFace = eastFace;
        this.southFace = southFace;
        this.westFace = westFace;
        this.upFace.oppositeFace = this.downFace;
        this.downFace.oppositeFace = this.upFace;
        this.northFace.oppositeFace = this.southFace;
        this.eastFace.oppositeFace = this.westFace;
        this.southFace.oppositeFace = this.northFace;
        this.westFace.oppositeFace = this.eastFace;
        this.upFace.priority = 1;
        this.downFace.priority = 0;
        this.northFace.priority = 0;
        this.eastFace.priority = 1;
        this.southFace.priority = 1;
        this.westFace.priority = 0;
        this.byDirection = Collections.unmodifiableList(Arrays.asList(upFace, downFace, northFace, eastFace, southFace, westFace));
        this.byAverageZ = new ArrayList<Face>(Arrays.asList(upFace, downFace, northFace, eastFace, southFace, westFace));
        this.sortFaces();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.downFace == null ? 0 : this.downFace.hashCode());
        result = 31 * result + (this.eastFace == null ? 0 : this.eastFace.hashCode());
        result = 31 * result + (this.northFace == null ? 0 : this.northFace.hashCode());
        result = 31 * result + (this.byAverageZ == null ? 0 : this.byAverageZ.hashCode());
        result = 31 * result + (this.southFace == null ? 0 : this.southFace.hashCode());
        result = 31 * result + (this.upFace == null ? 0 : this.upFace.hashCode());
        result = 31 * result + (this.westFace == null ? 0 : this.westFace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Hexahedron)) {
            return false;
        }
        Hexahedron other = (Hexahedron)obj;
        if (this.downFace == null ? other.downFace != null : !this.downFace.equals(other.downFace)) {
            return false;
        }
        if (this.eastFace == null ? other.eastFace != null : !this.eastFace.equals(other.eastFace)) {
            return false;
        }
        if (this.northFace == null ? other.northFace != null : !this.northFace.equals(other.northFace)) {
            return false;
        }
        if (this.byAverageZ == null ? other.byAverageZ != null : !this.byAverageZ.equals(other.byAverageZ)) {
            return false;
        }
        if (this.southFace == null ? other.southFace != null : !this.southFace.equals(other.southFace)) {
            return false;
        }
        if (this.upFace == null ? other.upFace != null : !this.upFace.equals(other.upFace)) {
            return false;
        }
        if (this.westFace == null) {
            return other.westFace == null;
        }
        return this.westFace.equals(other.westFace);
    }

    public void setImage(BufferedImage[] images) {
        if (images.length != 6) {
            throw new IllegalArgumentException("images length must be 6");
        }
        this.upFace.image = images[0];
        this.downFace.image = images[1];
        this.northFace.image = images[2];
        this.eastFace.image = images[3];
        this.southFace.image = images[4];
        this.westFace.image = images[5];
    }

    public void setOverlay(BufferedImage[][] images) {
        if (images.length != 6) {
            throw new IllegalArgumentException("images length must be 6");
        }
        this.upFace.overlay = images[0];
        this.downFace.overlay = images[1];
        this.northFace.overlay = images[2];
        this.eastFace.overlay = images[3];
        this.southFace.overlay = images[4];
        this.westFace.overlay = images[5];
    }

    public void setOverlayBlendingMode(BlendingModes[][] blendingModes) {
        if (blendingModes.length != 6) {
            throw new IllegalArgumentException("blendingModes length must be 6");
        }
        this.upFace.overlayBlendingMode = blendingModes[0];
        this.downFace.overlayBlendingMode = blendingModes[1];
        this.northFace.overlayBlendingMode = blendingModes[2];
        this.eastFace.overlayBlendingMode = blendingModes[3];
        this.southFace.overlayBlendingMode = blendingModes[4];
        this.westFace.overlayBlendingMode = blendingModes[5];
    }

    public void setOverlayAdditionFactor(double[] factors) {
        if (factors.length != 6) {
            throw new IllegalArgumentException("factors length must be 6");
        }
        this.upFace.overlayAdditionFactor = factors[0];
        this.downFace.overlayAdditionFactor = factors[1];
        this.northFace.overlayAdditionFactor = factors[2];
        this.eastFace.overlayAdditionFactor = factors[3];
        this.southFace.overlayAdditionFactor = factors[4];
        this.westFace.overlayAdditionFactor = factors[5];
    }

    public List<Face> getFacesByAverageZ() {
        return this.byAverageZ;
    }

    public List<Face> getByDirectionOrder() {
        return this.byDirection;
    }

    public Face getUpFace() {
        return this.upFace;
    }

    public Face getDownFace() {
        return this.downFace;
    }

    public Face getNorthFace() {
        return this.northFace;
    }

    public Face getEastFace() {
        return this.eastFace;
    }

    public Face getSouthFace() {
        return this.southFace;
    }

    public Face getWestFace() {
        return this.westFace;
    }

    @Override
    public void rotate(double x, double y, double z, boolean saveAxis) {
        for (Face face : this.byAverageZ) {
            face.rotate(x, y, z, saveAxis);
        }
        this.sortFaces();
    }

    @Override
    public void translate(double x, double y, double z) {
        for (Face face : this.byAverageZ) {
            face.translate(x, y, z);
        }
    }

    @Override
    public void scale(double x, double y, double z) {
        for (Face face : this.byAverageZ) {
            face.scale(x, y, z);
        }
    }

    @Override
    public void flipAboutPlane(boolean x, boolean y, boolean z) {
        for (Face face : this.byAverageZ) {
            face.flipAboutPlane(x, y, z);
        }
    }

    @Override
    public void updateLighting(Vector direction, double ambient, double max) {
        for (Face face : this.byAverageZ) {
            face.updateLighting(direction, ambient, max);
        }
    }

    public void sortFaces() {
        this.byAverageZ.sort(Face.AVERAGE_DEPTH_COMPARATOR);
    }
}

