/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render;

import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.BlendingModes;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.BakeResult;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.ITransformable;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Point2D;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Point3D;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render.Vector;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.MathUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.PlaneUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.PointConversionUtils;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.stream.Stream;

public class Face
implements ITransformable {
    public static final Comparator<Face> AVERAGE_DEPTH_COMPARATOR = Comparator.comparing(face -> face.getAverageZ());
    protected BufferedImage image;
    protected BufferedImage[] overlay;
    protected BlendingModes[] overlayBlendingMode;
    protected double overlayAdditionFactor;
    protected Face oppositeFace;
    protected byte priority;
    private double lightRatio;
    private Point3D[] points;
    private Vector[][] axis;
    private Face cullface;

    public Face(BufferedImage image, Point3D ... points) {
        if (points.length != 4) {
            throw new RuntimeException("points must have a length of 4.");
        }
        this.lightRatio = 1.0;
        this.oppositeFace = null;
        this.priority = 1;
        this.cullface = null;
        this.image = image;
        this.overlay = null;
        this.overlayBlendingMode = null;
        this.overlayAdditionFactor = 1.0;
        this.points = new Point3D[points.length];
        this.axis = new Vector[points.length][];
        for (int i = 0; i < points.length; ++i) {
            this.points[i] = points[i].clone();
            this.axis[i] = new Vector[]{new Vector(1.0, 0.0, 0.0), new Vector(0.0, 1.0, 0.0), new Vector(0.0, 0.0, 1.0)};
        }
    }

    public Face(Point3D ... points) {
        this((BufferedImage)null, points);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + Arrays.hashCode(this.points);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Face)) {
            return false;
        }
        Face other = (Face)obj;
        if (this.image == null ? other.image != null : !this.image.equals(other.image)) {
            return false;
        }
        return Arrays.equals(this.points, other.points);
    }

    public boolean pointsEquals(Face other) {
        HashSet<Point3D> ourPoints = new HashSet<Point3D>(Arrays.asList(this.points));
        for (Point3D point : other.points) {
            if (!ourPoints.stream().noneMatch(each -> MathUtils.equals(each.x, point.x) && MathUtils.equals(each.y, point.y) && MathUtils.equals(each.z, point.z))) continue;
            return false;
        }
        return true;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage[] getOverlay() {
        return this.overlay;
    }

    public void setOverlay(BufferedImage[] overlay) {
        this.overlay = overlay;
    }

    public BlendingModes[] getOverlayBlendingMode() {
        return this.overlayBlendingMode;
    }

    public void setOverlayBlendingMode(BlendingModes[] overlayBlendingMode) {
        this.overlayBlendingMode = overlayBlendingMode;
    }

    public Face getOppositeFace() {
        return this.oppositeFace;
    }

    public boolean hasOppositeFace() {
        return this.oppositeFace != null;
    }

    public Face getCullface() {
        return this.cullface;
    }

    public void setCullface(Face cullface) {
        this.cullface = cullface;
    }

    public Point3D[] getPoints() {
        return this.points;
    }

    public boolean isWithin(double x, double y) {
        Point2D[] points2d = new Point2D[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            points2d[i] = PointConversionUtils.convert(this.points[i], false);
        }
        return PlaneUtils.contains(new Point2D(x, y), points2d);
    }

    public double getDepthAt(double x, double y) {
        Vector rayVector = new Vector(0.0, 0.0, 1.0);
        Vector rayPoint = new Vector(x, y, 0.0);
        Vector planeNormal = new Vector(this.points[3], this.points[0]).cross(new Vector(this.points[1], this.points[0])).normalize();
        Vector planePoint = new Vector(this.points[0].x, this.points[0].y, this.points[0].z);
        return this.intersectPoint(rayVector, rayPoint, planeNormal, planePoint).getZ();
    }

    private Vector intersectPoint(Vector rayVector, Vector rayPoint, Vector planeNormal, Vector planePoint) {
        Vector diff = rayPoint.clone().subtract(planePoint);
        double prod1 = diff.dot(planeNormal);
        double prod2 = rayVector.dot(planeNormal);
        double prod3 = prod1 / prod2;
        return rayPoint.clone().subtract(rayVector.clone().multiply(prod3));
    }

    public double getAverageX() {
        return Stream.of(this.points).mapToDouble(point -> point.x).average().getAsDouble();
    }

    public double getAverageY() {
        return Stream.of(this.points).mapToDouble(point -> point.y).average().getAsDouble();
    }

    public double getAverageZ() {
        return Stream.of(this.points).mapToDouble(point -> point.z).average().getAsDouble();
    }

    public double getMaxX() {
        return Stream.of(this.points).mapToDouble(point -> point.x).max().getAsDouble();
    }

    public double getMaxY() {
        return Stream.of(this.points).mapToDouble(point -> point.y).max().getAsDouble();
    }

    public double getMaxZ() {
        return Stream.of(this.points).mapToDouble(point -> point.z).max().getAsDouble();
    }

    public double getMinX() {
        return Stream.of(this.points).mapToDouble(point -> point.x).min().getAsDouble();
    }

    public double getMinY() {
        return Stream.of(this.points).mapToDouble(point -> point.y).min().getAsDouble();
    }

    public double getMinZ() {
        return Stream.of(this.points).mapToDouble(point -> point.z).min().getAsDouble();
    }

    public Point3D getCenterPoint() {
        return new Point3D(this.getAverageX(), this.getAverageY(), this.getAverageZ());
    }

    public Vector getCenterVector() {
        return new Vector(this.getAverageX(), this.getAverageY(), this.getAverageZ());
    }

    public double getLightRatio() {
        return this.lightRatio;
    }

    @Override
    public void rotate(double x, double y, double z, boolean saveAxis) {
        x = Math.toRadians(x);
        y = Math.toRadians(y);
        z = Math.toRadians(z);
        Vector origin = new Vector(0.0, 0.0, 0.0);
        for (int i = 0; i < this.points.length; ++i) {
            Point3D point = this.points[i];
            Vector xAxis = this.axis[i][0];
            Vector yAxis = this.axis[i][1];
            Vector zAxis = this.axis[i][2];
            if (!saveAxis) {
                xAxis = xAxis.clone();
                yAxis = yAxis.clone();
                zAxis = zAxis.clone();
            }
            Vector v = new Vector(point.x, point.y, point.z).subtract(origin);
            v.rotateAroundAxis(xAxis, x);
            yAxis.rotateAroundAxis(xAxis, x);
            zAxis.rotateAroundAxis(xAxis, x);
            v.rotateAroundAxis(yAxis, y);
            xAxis.rotateAroundAxis(yAxis, y);
            zAxis.rotateAroundAxis(yAxis, y);
            v.rotateAroundAxis(zAxis, z);
            xAxis.rotateAroundAxis(zAxis, z);
            yAxis.rotateAroundAxis(zAxis, z);
            point.x = v.getX();
            point.y = v.getY();
            point.z = v.getZ();
        }
    }

    @Override
    public void translate(double x, double y, double z) {
        for (Point3D point : this.points) {
            PointConversionUtils.translate(point, x, y, z);
        }
    }

    @Override
    public void scale(double x, double y, double z) {
        for (Point3D point : this.points) {
            PointConversionUtils.scale(point, x, y, z);
        }
    }

    @Override
    public void flipAboutPlane(boolean x, boolean y, boolean z) {
        for (Point3D point : this.points) {
            PointConversionUtils.flipAboutPlane(point, x, y, z);
        }
    }

    @Override
    public void updateLighting(Vector direction, double ambient, double max) {
        Vector normal = new Vector(this.points[1], this.points[2]).cross(new Vector(this.points[0], this.points[1])).normalize();
        double dot = normal.dot(direction);
        double sign = Math.signum(dot);
        dot = sign * dot * dot;
        dot = (dot + 1.0) / 2.0 * (1.0 - ambient);
        this.lightRatio = Math.min(Math.min(max, 1.0), Math.max(0.0, ambient + dot));
    }

    public BakeResult bake(AffineTransform baseTransform) {
        double scaleY;
        double scaleX;
        if (this.image == null) {
            return null;
        }
        if (this.cullface != null && AVERAGE_DEPTH_COMPARATOR.compare(this, this.cullface) <= 0 && (this.cullface.priority > this.priority || this.cullface.getAverageZ() - this.getAverageZ() > 0.1)) {
            return null;
        }
        Point2D[] points2d = new Point2D[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            points2d[i] = PointConversionUtils.convert(this.points[i], true);
        }
        BufferedImage image = ImageUtils.multiply(ImageUtils.copyImage(this.image), this.lightRatio);
        if (this.overlay != null) {
            for (int i = 0; i < this.overlay.length; ++i) {
                BufferedImage overlayLayer = this.overlay[i];
                BlendingModes blendingModes = this.overlayBlendingMode == null || i >= this.overlayBlendingMode.length || this.overlayBlendingMode[i] == null ? BlendingModes.GLINT : this.overlayBlendingMode[i];
                image = ImageUtils.transformRGB(image, (x, y, colorValue) -> ColorUtils.composite(overlayLayer.getRGB(x, y), colorValue, blendingModes));
            }
        }
        double w = 0.0;
        double h = 0.0;
        boolean first = true;
        do {
            if (!first) {
                points2d[0].x += 1.0E-4;
                points2d[0].y += 1.0E-4;
                points2d[1].x -= 1.0E-4;
                points2d[1].y -= 1.0E-4;
                points2d[2].x += 1.0E-4;
                points2d[2].y += 1.0E-4;
                points2d[3].x -= 1.0E-4;
                points2d[3].y -= 1.0E-4;
            }
            w = Math.abs(points2d[1].x - points2d[0].x);
            h = Math.abs(points2d[2].y - points2d[1].y);
            scaleX = w / (double)image.getWidth();
            scaleY = h / (double)image.getHeight();
            first = false;
        } while (w < 1.0E-10 || h < 1.0E-10);
        AffineTransform transform = (AffineTransform)baseTransform.clone();
        transform.concatenate(AffineTransform.getTranslateInstance(points2d[0].x, points2d[0].y));
        double dX1 = points2d[3].x - points2d[0].x;
        double dY1 = points2d[1].y - points2d[0].y;
        double dY2 = points2d[3].y - points2d[0].y;
        double dX2 = points2d[1].x - points2d[0].x;
        double dropOffX = dX1 / dY2;
        double dropOffY = dY1 / dX2;
        transform.concatenate(AffineTransform.getShearInstance(dropOffX, dropOffY));
        if (points2d[1].x - points2d[0].x < 0.0) {
            scaleX = -scaleX;
        }
        if (points2d[3].y - points2d[0].y < 0.0) {
            scaleY = -scaleY;
        }
        transform.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
        double maxX = this.getMaxX();
        double maxY = this.getMaxY();
        double minX = this.getMinX();
        double minY = this.getMinY();
        return new BakeResult(image, transform, (x, y) -> this.getDepthAt(x, y), this.priority, (x, y) -> !MathUtils.greaterThanOrEquals(x, minX) || !MathUtils.greaterThanOrEquals(y, minY) || !MathUtils.lessThanOrEquals(x, maxX) || !MathUtils.lessThanOrEquals(y, maxY));
    }
}

