/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.render;

import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.DoubleBiFunction;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.DoubleBiPredicate;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.MathUtils;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;

public class BakeResult {
    private final BufferedImage texture;
    private final AffineTransform transform;
    private final AffineTransform inverseTransform;
    private final DoubleBiFunction depthFunction;
    private final int depthTieBreaker;
    private final DoubleBiPredicate outOfBoundPredicate;

    public BakeResult(BufferedImage texture, AffineTransform transform, DoubleBiFunction depthFunction, int depthTieBreaker, DoubleBiPredicate outOfBoundPredicate) {
        AffineTransform inverseTransform;
        this.texture = texture;
        this.transform = transform;
        try {
            inverseTransform = MathUtils.equals(transform.getDeterminant(), 0.0) ? null : transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            inverseTransform = null;
        }
        this.inverseTransform = inverseTransform;
        this.depthFunction = depthFunction;
        this.depthTieBreaker = depthTieBreaker;
        this.outOfBoundPredicate = outOfBoundPredicate;
    }

    public BufferedImage getTexture() {
        return this.texture;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean hasInverseTransform() {
        return this.inverseTransform != null;
    }

    public AffineTransform getInverseTransform() {
        return this.inverseTransform;
    }

    public double getDepthAt(double x, double y) {
        return this.depthFunction.apply(x, y);
    }

    public int getDepthTieBreaker() {
        return this.depthTieBreaker;
    }

    public boolean isOutOfBound(double x, double y) {
        return this.outOfBoundPredicate.test(x, y);
    }
}

