/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending;

import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.AlphaCompositeFactorFunction;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.ColorCompositeFactor;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.ColorCompositeFactorFunction;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import java.util.HashMap;
import java.util.Map;

public enum BlendingMode {
    ZERO((src, des) -> ColorCompositeFactor.ZERO, (src, des) -> 0.0, 0),
    ONE((src, des) -> ColorCompositeFactor.ONE, (src, des) -> 1.0, 1),
    SRC_COLOR((src, des) -> new ColorCompositeFactor((double)ColorUtils.getRed(src) / 255.0, (double)ColorUtils.getGreen(src) / 255.0, (double)ColorUtils.getBlue(src) / 255.0), (src, des) -> (double)ColorUtils.getAlpha(src) / 255.0, 768),
    ONE_MINUS_SRC_COLOR((src, des) -> new ColorCompositeFactor(1.0 - (double)ColorUtils.getRed(src) / 255.0, 1.0 - (double)ColorUtils.getGreen(src) / 255.0, 1.0 - (double)ColorUtils.getBlue(src) / 255.0), (src, des) -> 1.0 - (double)ColorUtils.getAlpha(src) / 255.0, 769),
    DST_COLOR((src, des) -> new ColorCompositeFactor((double)ColorUtils.getRed(des) / 255.0, (double)ColorUtils.getGreen(des) / 255.0, (double)ColorUtils.getBlue(des) / 255.0), (src, des) -> (double)ColorUtils.getAlpha(des) / 255.0, 774),
    ONE_MINUS_DST_COLOR((src, des) -> new ColorCompositeFactor(1.0 - (double)ColorUtils.getRed(des) / 255.0, 1.0 - (double)ColorUtils.getGreen(des) / 255.0, 1.0 - (double)ColorUtils.getBlue(des) / 255.0), (src, des) -> 1.0 - (double)ColorUtils.getAlpha(des) / 255.0, 775),
    SRC_ALPHA((src, des) -> {
        double alpha = (double)ColorUtils.getAlpha(src) / 255.0;
        return new ColorCompositeFactor(alpha, alpha, alpha);
    }, (src, des) -> (double)ColorUtils.getAlpha(src) / 255.0, 770),
    ONE_MINUS_SRC_ALPHA((src, des) -> {
        double alpha = 1.0 - (double)ColorUtils.getAlpha(src) / 255.0;
        return new ColorCompositeFactor(alpha, alpha, alpha);
    }, (src, des) -> 1.0 - (double)ColorUtils.getAlpha(src) / 255.0, 771),
    DST_ALPHA((src, des) -> {
        double alpha = (double)ColorUtils.getAlpha(des) / 255.0;
        return new ColorCompositeFactor(alpha, alpha, alpha);
    }, (src, des) -> (double)ColorUtils.getAlpha(des) / 255.0, 772),
    ONE_MINUS_DST_ALPHA((src, des) -> {
        double alpha = 1.0 - (double)ColorUtils.getAlpha(des) / 255.0;
        return new ColorCompositeFactor(alpha, alpha, alpha);
    }, (src, des) -> 1.0 - (double)ColorUtils.getAlpha(des) / 255.0, 773);

    private static final BlendingMode[] VALUES;
    private static final Map<String, BlendingMode> BY_NAME;
    private static final Map<Integer, BlendingMode> BY_VALUE;
    private final ColorCompositeFactorFunction colorCompositeFunction;
    private final AlphaCompositeFactorFunction alphaCompositeFactorFunction;
    private final String name;
    private final int openGLValue;

    private BlendingMode(ColorCompositeFactorFunction colorCompositeFunction, AlphaCompositeFactorFunction alphaCompositeFactorFunction, int openGLValue) {
        this.colorCompositeFunction = colorCompositeFunction;
        this.alphaCompositeFactorFunction = alphaCompositeFactorFunction;
        this.openGLValue = openGLValue;
        this.name = "GL_" + this.name();
    }

    public ColorCompositeFactor getColorCompositeFactor(int src, int des) {
        return this.colorCompositeFunction.apply(src, des);
    }

    public double getAlphaCompositeFactor(int src, int des) {
        return this.alphaCompositeFactorFunction.apply(src, des);
    }

    public int getOpenGLValue() {
        return this.openGLValue;
    }

    public String getOpenGLName() {
        return this.name;
    }

    public static BlendingMode fromOpenGL(String name) {
        return BY_NAME.get(name);
    }

    public static BlendingMode fromOpenGL(int value) {
        return BY_VALUE.get(value);
    }

    static {
        VALUES = BlendingMode.values();
        BY_NAME = new HashMap<String, BlendingMode>();
        BY_VALUE = new HashMap<Integer, BlendingMode>();
        for (BlendingMode blendingMode : VALUES) {
            BY_NAME.put(blendingMode.getOpenGLName(), blendingMode);
            BY_VALUE.put(blendingMode.getOpenGLValue(), blendingMode);
        }
    }
}

