/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs;

import com.loohp.interactivechatdiscordsrvaddon.libs.org.checkerframework.checker.nullness.qual.NonNull;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;

public abstract class URLClassLoaderAccess {
    private final URLClassLoader classLoader;

    public static URLClassLoaderAccess create(URLClassLoader classLoader) {
        if (Reflection.isSupported()) {
            return new Reflection(classLoader);
        }
        if (Unsafe.isSupported()) {
            return new Unsafe(classLoader);
        }
        return Noop.INSTANCE;
    }

    private static void throwError(Throwable cause) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("InteractiveChatDiscordSRVAddon is unable to inject into the plugin URLClassLoader.\nYou may be able to fix this problem by adding the following command-line argument directly after the 'java' command in your start script: \n'--add-opens java.base/java.lang=ALL-UNNAMED'", cause);
    }

    protected URLClassLoaderAccess(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public abstract void addURL(@NonNull URL var1);

    private static class Reflection
    extends URLClassLoaderAccess {
        private static final Method ADD_URL_METHOD;

        private static boolean isSupported() {
            return ADD_URL_METHOD != null;
        }

        Reflection(URLClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public void addURL(@NonNull URL url) {
            try {
                ADD_URL_METHOD.invoke((Object)((URLClassLoaderAccess)this).classLoader, url);
            }
            catch (ReflectiveOperationException e) {
                URLClassLoaderAccess.throwError(e);
            }
        }

        static {
            Method addUrlMethod;
            try {
                addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addUrlMethod.setAccessible(true);
            }
            catch (Exception e) {
                addUrlMethod = null;
            }
            ADD_URL_METHOD = addUrlMethod;
        }
    }

    private static class Unsafe
    extends URLClassLoaderAccess {
        private static final Object UNSAFE;
        private static final Method OBJECT_FIELD_OFFSET_METHOD;
        private static final Method GET_OBJECT_METHOD;
        private final Collection<URL> unopenedURLs;
        private final Collection<URL> pathURLs;

        private static boolean isSupported() {
            return UNSAFE != null;
        }

        private static Object fetchField(Class<?> clazz, Object object, String name) throws NoSuchFieldException, InvocationTargetException, IllegalAccessException {
            Field field = clazz.getDeclaredField(name);
            long offset = (Long)OBJECT_FIELD_OFFSET_METHOD.invoke(UNSAFE, field);
            return GET_OBJECT_METHOD.invoke(UNSAFE, object, offset);
        }

        Unsafe(URLClassLoader classLoader) {
            super(classLoader);
            Collection pathURLs;
            Collection unopenedURLs;
            try {
                Object ucp = Unsafe.fetchField(URLClassLoader.class, classLoader, "ucp");
                unopenedURLs = (Collection)Unsafe.fetchField(ucp.getClass(), ucp, "unopenedUrls");
                pathURLs = (Collection)Unsafe.fetchField(ucp.getClass(), ucp, "path");
            }
            catch (Throwable e) {
                unopenedURLs = null;
                pathURLs = null;
            }
            this.unopenedURLs = unopenedURLs;
            this.pathURLs = pathURLs;
        }

        @Override
        public void addURL(@NonNull URL url) {
            if (this.unopenedURLs == null || this.pathURLs == null) {
                URLClassLoaderAccess.throwError(new NullPointerException("unopenedURLs or pathURLs"));
            }
            this.unopenedURLs.add(url);
            this.pathURLs.add(url);
        }

        static {
            Method getObjectMethod;
            Method objectFieldOffsetMethod;
            Object unsafe;
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                unsafe = unsafeField.get(null);
                objectFieldOffsetMethod = unsafe.getClass().getMethod("objectFieldOffset", Field.class);
                getObjectMethod = unsafe.getClass().getMethod("getObject", Object.class, Long.TYPE);
            }
            catch (Throwable t) {
                unsafe = null;
                objectFieldOffsetMethod = null;
                getObjectMethod = null;
            }
            UNSAFE = unsafe;
            OBJECT_FIELD_OFFSET_METHOD = objectFieldOffsetMethod;
            GET_OBJECT_METHOD = getObjectMethod;
        }
    }

    private static class Noop
    extends URLClassLoaderAccess {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
            super(null);
        }

        @Override
        public void addURL(@NonNull URL url) {
            URLClassLoaderAccess.throwError(null);
        }
    }
}

