/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs;

import com.loohp.interactivechatdiscordsrvaddon.libs.URLClassLoaderAccess;
import com.loohp.interactivechatdiscordsrvaddon.libs.me.lucko.jarrelocator.JarRelocator;
import com.loohp.interactivechatdiscordsrvaddon.libs.me.lucko.jarrelocator.Relocation;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class LibraryLoader {
    private static final URLClassLoaderAccess LOADER_ACCESS = URLClassLoaderAccess.create((URLClassLoader)LibraryLoader.class.getClassLoader());
    private static final BiConsumer<File, Throwable> NOOP_LISTENER = (file, e) -> {};
    private static final List<Relocation> RELOCATION_RULES = new ArrayList<Relocation>();

    private static String dot(String str) {
        return str.replace("{}", ".");
    }

    public static void loadLibraries(File libsFolder) {
        LibraryLoader.loadLibraries(libsFolder, NOOP_LISTENER, NOOP_LISTENER);
    }

    public static void loadLibraries(File libsFolder, BiConsumer<File, Throwable> remapListener, BiConsumer<File, Throwable> loadListener) {
        String rawName;
        String jarName;
        libsFolder.mkdirs();
        for (File jarFile : libsFolder.listFiles()) {
            File remappedFile;
            jarName = jarFile.getName();
            if (!jarName.endsWith(".jar") || (rawName = jarName.substring(0, jarName.length() - 4)).endsWith("-remapped") || (remappedFile = new File(libsFolder, rawName + "-remapped.jar")).exists()) continue;
            JarRelocator relocator = new JarRelocator(jarFile, remappedFile, RELOCATION_RULES);
            try {
                relocator.run();
                remapListener.accept(jarFile, null);
            }
            catch (IOException e) {
                remapListener.accept(jarFile, e);
            }
        }
        for (File jarFile : libsFolder.listFiles()) {
            jarName = jarFile.getName();
            if (!jarName.endsWith(".jar") || !(rawName = jarName.substring(0, jarName.length() - 4)).endsWith("-remapped")) continue;
            try {
                LOADER_ACCESS.addURL(jarFile.toURI().toURL());
                loadListener.accept(jarFile, null);
            }
            catch (Throwable e) {
                loadListener.accept(jarFile, e);
            }
        }
    }

    static {
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("com{}ibm{}icu"), "com.loohp.interactivechatdiscordsrvaddon.libs.com.ibm.icu"));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("darwin{}"), "com.loohp.interactivechatdiscordsrvaddon.libs.darwin."));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("kotlin{}"), "com.loohp.interactivechatdiscordsrvaddon.libs.kotlin."));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("linux{}"), "com.loohp.interactivechatdiscordsrvaddon.libs.linux."));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("win32{}"), "com.loohp.interactivechatdiscordsrvaddon.libs.win32."));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("net{}jpountz"), "com.loohp.interactivechatdiscordsrvaddon.libs.net.jpountz"));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("org{}checkerframework"), "com.loohp.interactivechatdiscordsrvaddon.libs.org.checkerframework"));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("org{}eclipse"), "com.loohp.interactivechatdiscordsrvaddon.libs.org.eclipse"));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("org{}json"), "com.loohp.interactivechatdiscordsrvaddon.libs.org.json"));
        RELOCATION_RULES.add(new Relocation(LibraryLoader.dot("org{}mapdb"), "com.loohp.interactivechatdiscordsrvaddon.libs.org.mapdb"));
    }
}

