/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.libs;

import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import java.io.File;
import java.util.HashSet;
import java.util.function.BiConsumer;

public class LibraryDownloadManager {
    public static final String LIBS_DATA_URL = "https://api.loohpjames.com/spigot/plugins/interactivechatdiscordsrvaddon/libs";
    private File libsFolder;
    private JSONObject data;

    public LibraryDownloadManager(File libsFolder) {
        this.libsFolder = libsFolder;
        this.data = null;
    }

    private void ensureData() {
        if (this.data == null) {
            this.data = HTTPRequestUtils.getJSONResponse((String)LIBS_DATA_URL);
        }
    }

    public String getHash() {
        this.ensureData();
        return this.data.get((Object)"hash").toString();
    }

    public synchronized void downloadLibraries(BiConsumer<Boolean, String> progressListener) {
        this.ensureData();
        try {
            JSONObject libs = (JSONObject)this.data.get((Object)"libs");
            HashSet<String> jarNames = new HashSet<String>();
            for (Object key : libs.keySet()) {
                String jarName = (String)key;
                jarNames.add(jarName);
                JSONObject details = (JSONObject)libs.get((Object)jarName);
                String url = (String)details.get((Object)"url");
                File jarFile = new File(this.libsFolder, jarName);
                if (HTTPRequestUtils.download((File)jarFile, (String)url)) {
                    progressListener.accept(true, jarName);
                    continue;
                }
                progressListener.accept(false, jarName);
            }
            for (File jarFile : this.libsFolder.listFiles()) {
                if (jarNames.contains(jarFile.getName())) continue;
                jarFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

