/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.graphics;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactivechat.utils.ChatColorUtils;
import com.loohp.interactivechat.utils.ComponentFlattening;
import com.loohp.interactivechat.utils.ComponentModernizing;
import com.loohp.interactivechat.utils.HashUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.BlendingModes;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.MathUtils;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.CharacterData;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MinecraftFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.languages.LanguageMeta;
import com.loohp.interactivechatdiscordsrvaddon.utils.ComponentStringUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.I18nUtils;
import it.unimi.dsi.fastutil.chars.CharObjectPair;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.BitSet;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final Color TEXT_BACKGROUND_COLOR = new Color(0, 0, 0, 180);
    public static final double CHAT_COLOR_BACKGROUND_FACTOR = 0.19;
    private static final double[] GAUSSIAN_CONSTANTS = new double[]{0.00598, 0.060626, 0.241843, 0.383103, 0.241843, 0.060626, 0.00598};

    public static ByteArrayOutputStream toOutputStream(BufferedImage image) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", outputStream);
        return outputStream;
    }

    public static byte[] toArray(BufferedImage image) throws IOException {
        return ImageUtils.toOutputStream(image).toByteArray();
    }

    public static BufferedImage fromInputStream(InputStream inputStream) throws IOException {
        return ImageIO.read(inputStream);
    }

    public static BufferedImage fromArray(byte[] data) throws IOException {
        return ImageUtils.fromInputStream(new ByteArrayInputStream(data));
    }

    public static String hash(BufferedImage image) {
        int[] colors;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int color : colors = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth())) {
            out.write((byte)(color >>> 24));
            out.write((byte)(color >>> 16));
            out.write((byte)(color >>> 8));
            out.write((byte)color);
        }
        try {
            return HashUtils.createSha1String((InputStream)new ByteArrayInputStream(out.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getRGB(BufferedImage image, int x, int y) {
        if (x < 0 || y < 0 || x >= image.getWidth() || y >= image.getHeight()) {
            return 0;
        }
        return image.getRGB(x, y);
    }

    public static int getRGB(int[] colors, int x, int y, int w, int h) {
        if (x < 0 || y < 0 || x >= w || y >= h) {
            return 0;
        }
        return colors[y * w + x];
    }

    public static BufferedImage downloadImage(String link) throws IOException {
        URL url = new URL(link);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.addRequestProperty("Pragma", "no-cache");
        InputStream in = connection.getInputStream();
        BufferedImage image = ImageIO.read(in);
        in.close();
        return image;
    }

    public static BufferedImage transformRGB(BufferedImage image, PixelTransformFunction function) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] colors = image.getRGB(0, 0, width, height, null, 0, width);
        int i = 0;
        for (int colorValue : colors) {
            colors[i] = function.apply(i % width, i / width, colorValue);
            ++i;
        }
        image.setRGB(0, 0, width, height, colors, 0, width);
        return image;
    }

    public static BufferedImage combineWithBinMask(BufferedImage background, BufferedImage foreground, byte[] foregroundMask) {
        BitSet bits = BitSet.valueOf(foregroundMask);
        int i = 0;
        for (int y = 0; y < background.getHeight(); ++y) {
            for (int x = 0; x < background.getWidth(); ++x) {
                int colorValue = foreground.getRGB(x, y);
                if (bits.get(i++)) {
                    background.setRGB(x, y, colorValue);
                    continue;
                }
                int alpha = ColorUtils.getAlpha(colorValue);
                if (alpha >= 255) {
                    background.setRGB(x, y, colorValue);
                    continue;
                }
                if (alpha <= 0) continue;
                background.setRGB(x, y, ColorUtils.composite(colorValue, background.getRGB(x, y), BlendingModes.NORMAL));
            }
        }
        return background;
    }

    public static BufferedImage rotateImageByDegrees(BufferedImage img, double angle) {
        if (MathUtils.equals(angle % 360.0, 0.0)) {
            return img;
        }
        double rads = Math.toRadians(angle);
        double sin = Math.abs(Math.sin(rads));
        double cos = Math.abs(Math.cos(rads));
        int w = img.getWidth();
        int h = img.getHeight();
        int newWidth = (int)Math.floor((double)w * cos + (double)h * sin);
        int newHeight = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage rotated = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = rotated.createGraphics();
        AffineTransform at = new AffineTransform();
        at.translate((double)(newWidth - w) / 2.0, (double)(newHeight - h) / 2.0);
        int x = w / 2;
        int y = h / 2;
        at.rotate(rads, x, y);
        g.setTransform(at);
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return rotated;
    }

    public static BufferedImage flipHorizontal(BufferedImage image) {
        BufferedImage b = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage(image, image.getWidth(), 0, -image.getWidth(), image.getHeight(), null);
        g.dispose();
        return b;
    }

    public static BufferedImage flipVertically(BufferedImage image) {
        BufferedImage b = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage(image, 0, image.getHeight(), image.getWidth(), -image.getHeight(), null);
        g.dispose();
        return b;
    }

    public static BufferedImage expandCenterAligned(BufferedImage image, int pixels) {
        BufferedImage b = new BufferedImage(image.getWidth() + pixels + pixels, image.getHeight() + pixels + pixels, 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)image, pixels, pixels, null);
        g.dispose();
        return b;
    }

    public static BufferedImage expandCenterAligned(BufferedImage image, int up, int down, int left, int right) {
        BufferedImage b = new BufferedImage(image.getWidth() + left + right, image.getHeight() + up + down, 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)image, left, up, null);
        g.dispose();
        return b;
    }

    public static BufferedImage additionNonTransparent(BufferedImage image, BufferedImage imageToAdd) {
        return ImageUtils.additionNonTransparent(image, imageToAdd, 1.0);
    }

    public static BufferedImage additionNonTransparent(BufferedImage image, BufferedImage imageToAdd, double factor) {
        if (factor < 0.0 || factor > 1.0) {
            throw new IllegalArgumentException("factor cannot be smaller than 0 or greater than 1");
        }
        for (int y = 0; y < image.getHeight() && y < imageToAdd.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth() && x < imageToAdd.getWidth(); ++x) {
                int value = image.getRGB(x, y);
                int addValue = imageToAdd.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(value);
                if (alpha == 0) continue;
                int red = ColorUtils.getRed(value) + (int)((double)ColorUtils.getRed(addValue) * factor);
                int green = ColorUtils.getGreen(value) + (int)((double)ColorUtils.getGreen(addValue) * factor);
                int blue = ColorUtils.getBlue(value) + (int)((double)ColorUtils.getBlue(addValue) * factor);
                int color = ColorUtils.getIntFromColor(Math.min(red, 255), Math.min(green, 255), Math.min(blue, 255), alpha);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage drawTransparent(BufferedImage image, BufferedImage imageToAdd, int posX, int posY) {
        for (int y = 0; y + posY < image.getHeight() && y < imageToAdd.getHeight(); ++y) {
            for (int x = 0; x + posX < image.getWidth() && x < imageToAdd.getWidth(); ++x) {
                if (x + posX < 0 || y + posY < 0) continue;
                int value = image.getRGB(x + posX, y + posY);
                int addValue = imageToAdd.getRGB(x, y);
                if (ColorUtils.getAlpha(value) != 0) continue;
                image.setRGB(x + posX, y + posY, addValue);
            }
        }
        return image;
    }

    public static BufferedImage darken(BufferedImage image, int value) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(colorValue);
                if (alpha == 0) continue;
                int red = ColorUtils.getRed(colorValue) - value;
                int green = ColorUtils.getGreen(colorValue) - value;
                int blue = ColorUtils.getBlue(colorValue) - value;
                int color = ColorUtils.getIntFromColor(Math.max(red, 0), Math.max(green, 0), Math.max(blue, 0), alpha);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage add(BufferedImage image, int value) {
        return ImageUtils.add(image, value, value, value);
    }

    public static BufferedImage add(BufferedImage image, int xValue, int yValue, int zValue) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(colorValue);
                if (alpha == 0) continue;
                int red = ColorUtils.getRed(colorValue) + xValue;
                int green = ColorUtils.getGreen(colorValue) + yValue;
                int blue = ColorUtils.getBlue(colorValue) + zValue;
                int color = ColorUtils.getIntFromColor(red < 0 ? 0 : Math.min(red, 255), green < 0 ? 0 : Math.min(green, 255), blue < 0 ? 0 : Math.min(blue, 255), alpha);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage multiply(BufferedImage image, double value) {
        return ImageUtils.multiply(image, value, value, value);
    }

    public static BufferedImage multiply(BufferedImage image, double xValue, double yValue, double zValue) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(colorValue);
                if (alpha == 0) continue;
                int red = (int)((double)ColorUtils.getRed(colorValue) * xValue);
                int green = (int)((double)ColorUtils.getGreen(colorValue) * yValue);
                int blue = (int)((double)ColorUtils.getBlue(colorValue) * zValue);
                int color = ColorUtils.getIntFromColor(red < 0 ? 0 : Math.min(red, 255), green < 0 ? 0 : Math.min(green, 255), blue < 0 ? 0 : Math.min(blue, 255), alpha);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage multiply(BufferedImage image, BufferedImage imageOnTop) {
        return ImageUtils.multiply(image, imageOnTop, false);
    }

    public static BufferedImage multiply(BufferedImage image, BufferedImage imageOnTop, boolean ignoreTransparent) {
        for (int y = 0; y < image.getHeight() && y < imageOnTop.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth() && x < imageOnTop.getWidth(); ++x) {
                int value = image.getRGB(x, y);
                int multiplyValue = imageOnTop.getRGB(x, y);
                if (ignoreTransparent && ColorUtils.getAlpha(multiplyValue) <= 0) continue;
                int red = (int)Math.round((double)ColorUtils.getRed(value) / 255.0 * (double)ColorUtils.getRed(multiplyValue));
                int green = (int)Math.round((double)ColorUtils.getGreen(value) / 255.0 * (double)ColorUtils.getGreen(multiplyValue));
                int blue = (int)Math.round((double)ColorUtils.getBlue(value) / 255.0 * (double)ColorUtils.getBlue(multiplyValue));
                int color = ColorUtils.getIntFromColor(red, green, blue, ColorUtils.getAlpha(value));
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage changeColorTo(BufferedImage image, Color color) {
        return ImageUtils.changeColorTo(image, color.getRGB());
    }

    public static BufferedImage changeColorTo(BufferedImage image, int color) {
        color &= 0xFFFFFF;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int newColor = color | colorValue & 0xFF000000;
                image.setRGB(x, y, newColor);
            }
        }
        return image;
    }

    public static BufferedImage raiseAlpha(BufferedImage image, int value) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int alpha = ColorUtils.getAlpha(colorValue) + value;
                int color = ColorUtils.getIntFromColor(ColorUtils.getRed(colorValue), ColorUtils.getGreen(colorValue), ColorUtils.getBlue(colorValue), Math.min(Math.max(alpha, 0), 255));
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage squarify(BufferedImage image) {
        if (image.getHeight() == image.getWidth()) {
            return image;
        }
        int size = Math.max(image.getHeight(), image.getWidth());
        int offsetX = (size - image.getWidth()) / 2;
        int offsetY = (size - image.getHeight()) / 2;
        BufferedImage newImage = new BufferedImage(size, size, 2);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                newImage.setRGB(x + offsetX, y + offsetY, colorValue);
            }
        }
        return newImage;
    }

    public static BufferedImage xor(BufferedImage bottom, BufferedImage top, int alpha) {
        for (int y = 0; y < bottom.getHeight(); ++y) {
            for (int x = 0; x < bottom.getWidth(); ++x) {
                int bottomValue = bottom.getRGB(x, y);
                int topValue = top.getRGB(x, y);
                int color = ColorUtils.getIntFromColor(ColorUtils.getRed(bottomValue) ^ ColorUtils.getRed(topValue), ColorUtils.getGreen(bottomValue) ^ ColorUtils.getGreen(topValue), ColorUtils.getBlue(bottomValue) ^ ColorUtils.getBlue(topValue), ColorUtils.getAlpha(bottomValue) ^ ColorUtils.getAlpha(topValue) * alpha / 255);
                bottom.setRGB(x, y, color);
            }
        }
        return bottom;
    }

    public static BufferedImage appendImageRight(BufferedImage source, BufferedImage append, int middleGap, int rightSpace) {
        BufferedImage b = new BufferedImage(source.getWidth() + append.getWidth() + middleGap + rightSpace, Math.max(source.getHeight(), append.getHeight()), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.drawImage((Image)append, source.getWidth() + middleGap, 0, null);
        g.dispose();
        return b;
    }

    public static BufferedImage appendImageBottom(BufferedImage source, BufferedImage append, int middleGap, int bottomSpace) {
        BufferedImage b = new BufferedImage(Math.max(source.getWidth(), append.getWidth()), source.getHeight() + append.getHeight() + middleGap + bottomSpace, 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.drawImage((Image)append, 0, source.getHeight() + middleGap, null);
        g.dispose();
        return b;
    }

    public static BufferedImage copyImage(BufferedImage source) {
        BufferedImage b = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.dispose();
        return b;
    }

    public static BufferedImage copyAndGetSubImage(BufferedImage source, int x, int y, int w, int h) {
        BufferedImage copyOfImage = new BufferedImage(w, h, 2);
        Graphics2D g = copyOfImage.createGraphics();
        g.drawImage((Image)source, -x, -y, null);
        g.dispose();
        return copyOfImage;
    }

    public static BufferedImage resizeImage(BufferedImage source, double factor) {
        int w = (int)Math.round((double)source.getWidth() * factor);
        int h = (int)Math.round((double)source.getHeight() * factor);
        return ImageUtils.resizeImageAbs(source, w, h);
    }

    public static BufferedImage resizeImageQuality(BufferedImage source, int width, int height) {
        BufferedImage b = new BufferedImage(width, height, 2);
        Graphics2D g = b.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return b;
    }

    public static BufferedImage resizeImageAbs(BufferedImage source, int width, int height) {
        BufferedImage b = new BufferedImage(width, height, 2);
        Graphics2D g = b.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return b;
    }

    public static BufferedImage resizeImageFillWidth(BufferedImage source, int width) {
        int height = (int)Math.round((double)source.getHeight() * ((double)width / (double)source.getWidth()));
        return ImageUtils.resizeImageAbs(source, width, height);
    }

    public static BufferedImage resizeImageFillHeight(BufferedImage source, int height) {
        int width = (int)Math.round((double)source.getWidth() * ((double)height / (double)source.getHeight()));
        return ImageUtils.resizeImageAbs(source, width, height);
    }

    public static BufferedImage resizeImageStretch(BufferedImage source, int pixels) {
        int w = source.getWidth() + pixels;
        int h = source.getHeight() + pixels;
        return ImageUtils.resizeImageAbs(source, w, h);
    }

    public static BufferedImage applyGaussianBlur(BufferedImage source) {
        return ImageUtils.transposedHBlur(ImageUtils.transposedHBlur(source));
    }

    private static BufferedImage transposedHBlur(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        BufferedImage result = new BufferedImage(height, width, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double red = 0.0;
                double green = 0.0;
                double blue = 0.0;
                for (int i = 0; i < 7; ++i) {
                    int currentX = Math.max(Math.min(x + i - 3, width - 1), 0);
                    int pixel = image.getRGB(currentX, y);
                    red += (double)ColorUtils.getRed(pixel) * GAUSSIAN_CONSTANTS[i];
                    green += (double)ColorUtils.getGreen(pixel) * GAUSSIAN_CONSTANTS[i];
                    blue += (double)ColorUtils.getBlue(pixel) * GAUSSIAN_CONSTANTS[i];
                }
                result.setRGB(y, x, ColorUtils.getIntFromColor((int)red, (int)green, (int)blue, ColorUtils.getAlpha(image.getRGB(y, x))));
            }
        }
        return result;
    }

    public static BufferedImage printComponentShadowlessDynamicSize(ResourceManager manager, BufferedImage image, Component component, String language, boolean legacyRGB, int centerX, int topY, float fontSize, boolean dynamicFontSize) {
        Component text = ComponentFlattening.flatten((Component)ComponentStringUtils.resolve(ComponentModernizing.modernize((Component)component), manager.getLanguageManager().getTranslateFunction().ofLanguage(language)));
        String striped = ChatColorUtils.stripColor((String)ChatColorUtils.filterIllegalColorCodes((String)PlainTextComponentSerializer.plainText().serialize(text)));
        if (dynamicFontSize) {
            fontSize = (float)Math.round(Math.max(2.0f, fontSize - (float)striped.length() / 3.0f) * 10.0f) / 8.0f;
        }
        BufferedImage textImage = new BufferedImage(image.getWidth() + centerX, image.getHeight() * 2, 2);
        LanguageMeta languageMeta = manager.getLanguageManager().getLanguageMeta(language);
        List<CharObjectPair<CharacterData>> data = I18nUtils.bidirectionalReorder(text, languageMeta.isBidirectional());
        int x = centerX;
        int lastItalicExtraWidth = 0;
        int height = 0;
        String character = null;
        for (int i = 0; i < data.size(); ++i) {
            CharObjectPair<CharacterData> pair = data.get(i);
            char c = pair.firstChar();
            if (character == null) {
                character = String.valueOf(c);
                if (Character.isHighSurrogate(c)) continue;
                if (Character.isLowSurrogate(c) && i + 1 < data.size()) {
                    character = String.valueOf(data.get(++i).firstChar()) + character;
                }
            } else {
                character = character + String.valueOf(c);
            }
            CharacterData characterData = (CharacterData)pair.right();
            MinecraftFont fontProvider = manager.getFontManager().getFontProviders(characterData.getFont()).forCharacter(character);
            MinecraftFont.FontRenderResult result = fontProvider.printCharacter(textImage, character, x, 1 + image.getHeight(), fontSize, lastItalicExtraWidth, characterData.getColor(), characterData.getDecorations());
            textImage = result.getImage();
            x += result.getWidth() + result.getSpaceWidth();
            lastItalicExtraWidth = result.getItalicExtraWidth();
            if (height < result.getHeight()) {
                height = result.getHeight();
            }
            character = null;
        }
        int width = x - centerX;
        x = centerX - width / 2;
        int border = (int)Math.ceil((double)height / 6.0);
        int y = topY + border;
        BufferedImage background = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = background.createGraphics();
        g2.setColor(TEXT_BACKGROUND_COLOR);
        g2.fillRect(x - border, y - border, width + border * 2, height + border);
        g2.setColor(Color.white);
        g2.dispose();
        Graphics2D g3 = image.createGraphics();
        g3.drawImage((Image)background, 0, 0, null);
        g3.drawImage((Image)textImage, x - centerX, (int)((float)(y - height / 5) + Math.max(1.0f, 1.0f * (fontSize / 8.0f))) - image.getHeight(), null);
        g3.dispose();
        return image;
    }

    public static BufferedImage printComponentRightAligned(ResourceManager manager, BufferedImage image, Component component, String language, boolean legacyRGB, int topX, int topY, float fontSize) {
        return ImageUtils.printComponentRightAligned(manager, image, component, language, legacyRGB, topX, topY, fontSize, 0.19);
    }

    public static BufferedImage printComponentRightAligned(ResourceManager manager, BufferedImage image, Component component, String language, boolean legacyRGB, int topX, int topY, float fontSize, double shadowFactor) {
        BufferedImage textImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        textImage = ImageUtils.printComponent(manager, textImage, component, language, legacyRGB, 0, 0, fontSize, shadowFactor);
        int lastX = 0;
        block0: for (int x = 0; x < textImage.getWidth() - 9; ++x) {
            for (int y = 0; y < textImage.getHeight(); ++y) {
                if (textImage.getRGB(x, y) == 0) continue;
                lastX = x;
                continue block0;
            }
        }
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)textImage, topX - lastX, topY, null);
        g.dispose();
        return image;
    }

    public static BufferedImage printComponentGlowing(ResourceManager manager, BufferedImage image, Component component, String language, boolean legacyRGB, int topX, int topY, float fontSize) {
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        temp = ImageUtils.printComponent0(manager, temp, component, language, legacyRGB, topX, topY, fontSize, 1.0);
        Graphics2D g = image.createGraphics();
        BufferedImage shadow = ImageUtils.transformRGB(ImageUtils.copyImage(temp), (x, y, color) -> {
            int alpha = ColorUtils.getAlpha(color);
            if (alpha <= 0) {
                return color;
            }
            if ((color & 0xFFFFFF) == 0) {
                return -988212;
            }
            int red = (int)((double)ColorUtils.getRed(color) * 0.4);
            int green = (int)((double)ColorUtils.getGreen(color) * 0.4);
            int blue = (int)((double)ColorUtils.getBlue(color) * 0.4);
            return ColorUtils.getIntFromColor(red, green, blue, alpha);
        });
        for (int x2 = -1; x2 <= 1; ++x2) {
            for (int y2 = -1; y2 <= 1; ++y2) {
                if (x2 == 0 && y2 == 0) continue;
                g.drawImage((Image)shadow, (int)((double)fontSize * 0.15) * x2, (int)((double)fontSize * 0.15) * y2, null);
            }
        }
        g.drawImage((Image)temp, 0, 0, null);
        g.dispose();
        return image;
    }

    public static BufferedImage printComponentShadowless(ResourceManager manager, BufferedImage image, Component component, String language, boolean legacyRGB, int topX, int topY, float fontSize) {
        return ImageUtils.printComponent0(manager, image, component, language, legacyRGB, topX, topY, fontSize, 1.0);
    }

    public static BufferedImage printComponent(ResourceManager manager, BufferedImage image, Component component, String language, boolean legacyRGB, int topX, int topY, float fontSize) {
        return ImageUtils.printComponent(manager, image, component, language, legacyRGB, topX, topY, fontSize, 0.19);
    }

    public static BufferedImage printComponent(ResourceManager manager, BufferedImage image, Component component, String language, boolean legacyRGB, int topX, int topY, float fontSize, double shadowFactor) {
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        temp = ImageUtils.printComponent0(manager, temp, component, language, legacyRGB, topX, topY, fontSize, 1.0);
        Graphics2D g = image.createGraphics();
        if (shadowFactor != 0.0) {
            BufferedImage shadow = ImageUtils.multiply(ImageUtils.copyImage(temp), shadowFactor);
            g.drawImage((Image)shadow, (int)((double)fontSize * 0.15), (int)((double)fontSize * 0.15), null);
        }
        g.drawImage((Image)temp, 0, 0, null);
        g.dispose();
        return image;
    }

    private static BufferedImage printComponent0(ResourceManager manager, BufferedImage image, Component component, String language, boolean legacyRGB, int topX, int topY, float fontSize, double factor) {
        Component text = ComponentFlattening.flatten((Component)ComponentStringUtils.resolve(ComponentModernizing.modernize((Component)component), manager.getLanguageManager().getTranslateFunction().ofLanguage(language)));
        BufferedImage textImage = new BufferedImage(image.getWidth(), image.getHeight() * 2, 2);
        LanguageMeta languageMeta = manager.getLanguageManager().getLanguageMeta(language);
        List<CharObjectPair<CharacterData>> data = I18nUtils.bidirectionalReorder(text, languageMeta.isBidirectional());
        int x = topX;
        int lastItalicExtraWidth = 0;
        String character = null;
        for (int i = 0; i < data.size(); ++i) {
            CharObjectPair<CharacterData> pair = data.get(i);
            char c = pair.firstChar();
            if (character == null) {
                character = String.valueOf(c);
                if (Character.isHighSurrogate(c)) continue;
                if (Character.isLowSurrogate(c) && i + 1 < data.size()) {
                    character = String.valueOf(data.get(++i).firstChar()) + character;
                }
            } else {
                character = character + String.valueOf(c);
            }
            CharacterData characterData = (CharacterData)pair.right();
            MinecraftFont fontProvider = manager.getFontManager().getFontProviders(characterData.getFont()).forCharacter(character);
            MinecraftFont.FontRenderResult result = fontProvider.printCharacter(textImage, character, x, 1 + image.getHeight(), fontSize, lastItalicExtraWidth, characterData.getColor(), characterData.getDecorations());
            textImage = result.getImage();
            x += result.getWidth() + result.getSpaceWidth();
            lastItalicExtraWidth = result.getItalicExtraWidth();
            character = null;
        }
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)textImage, 0, topY - image.getHeight(), null);
        g.dispose();
        return image;
    }

    @FunctionalInterface
    public static interface PixelTransformFunction {
        public int apply(int var1, int var2, int var3);
    }
}

