/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.graphics;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechat.libs.io.github.bananapuncher714.nbteditor.NBTEditor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.ComponentLike;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechat.objectholders.ICPlayer;
import com.loohp.interactivechat.objectholders.OfflineICPlayer;
import com.loohp.interactivechat.objectholders.ValuePairs;
import com.loohp.interactivechat.objectholders.ValueTrios;
import com.loohp.interactivechat.utils.ComponentStyling;
import com.loohp.interactivechat.utils.CustomStringUtils;
import com.loohp.interactivechat.utils.FilledMapUtils;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import com.loohp.interactivechat.utils.HashUtils;
import com.loohp.interactivechat.utils.InteractiveChatComponentSerializer;
import com.loohp.interactivechat.utils.ItemNBTUtils;
import com.loohp.interactivechat.utils.ItemStackUtils;
import com.loohp.interactivechat.utils.MCVersion;
import com.loohp.interactivechat.utils.SkinUtils;
import com.loohp.interactivechat.utils.XMaterialUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.debug.Debug;
import com.loohp.interactivechatdiscordsrvaddon.graphics.BlendingUtils;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.blending.BlendingModes;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.loohp.blockmodelrenderer.utils.ColorUtils;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.AdvancementType;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.ToolTipComponent;
import com.loohp.interactivechatdiscordsrvaddon.registry.ResourceRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.CacheObject;
import com.loohp.interactivechatdiscordsrvaddon.resources.CustomItemTextureRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.ICacheManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ModelRenderer;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.MinecraftFont;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelDisplay;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.EnchantmentProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.GeneratedTextureResource;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureAnimation;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureMeta;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import com.loohp.interactivechatdiscordsrvaddon.utils.BundleUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.ComponentStringUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.ContainerTitlePrintingFunction;
import com.loohp.interactivechatdiscordsrvaddon.utils.ItemRenderUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.ModelUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.TintUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.TranslationKeyUtils;
import com.loohp.interactivechatdiscordsrvaddon.wrappers.ItemMapWrapper;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapPalette;
import org.bukkit.plugin.Plugin;

public class ImageGeneration {
    public static final int MAP_ICON_PER_ROLE = InteractiveChat.version.isLegacy() ? 4 : 16;
    public static final int MAP_SIZE = 1120;
    public static final int SPACING = 36;
    public static final int DEFAULT_ITEM_RENDER_SIZE = 32;
    public static final double ITEM_AMOUNT_TEXT_DARKEN_FACTOR = 0.29411764705882354;
    public static final Color ENCHANTMENT_GLINT_LEGACY_COLOR = new Color(164, 84, 255);
    public static final String PLAYER_CAPE_CACHE_KEY = "PlayerCapeTexture";
    public static final String PLAYER_SKIN_CACHE_KEY = "PlayerSkinTexture";
    public static final String INVENTORY_CACHE_KEY = "Inventory";
    public static final String PLAYER_INVENTORY_CACHE_KEY = "PlayerInventory";
    public static final int TABLIST_SINGLE_COLUMN_LIMIT = 20;
    public static final int TABLIST_PLAYER_DISPLAY_LIMIT = 80;
    public static final int TABLIST_INTERNAL_HEIGHT = 146;
    public static final Color TABLIST_BACKGROUND = new Color(68, 68, 68);
    public static final Color TABLIST_PLAYER_BACKGROUND = new Color(107, 107, 107);
    public static final Color BUNDLE_FULLNESS_BAR_COLOR = new Color(0x6666FF);
    public static final TextColor INVENTORY_DEFAULT_FONT_COLOR = TextColor.color((int)0x404040);
    public static final int BOOK_LINE_LIMIT = 230;
    public static final Color TOOLTIP_BACKGROUND_COLOR = new Color(-267386864, true);
    public static final Color TOOLTIP_OUTLINE_TOP_COLOR = new Color(0x505000FF, true);
    public static final Color TOOLTIP_OUTLINE_BOTTOM_COLOR = new Color(1344798847, true);
    public static final String OPTIFINE_CAPE_URL = "https://optifine.net/capes/%s.png";
    public static final String PLAYER_INFO_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static Supplier<ResourceManager> resourceManager = () -> InteractiveChatDiscordSrvAddon.plugin.resourceManager;
    private static Supplier<MCVersion> version = () -> InteractiveChat.version;
    private static Supplier<String> language = () -> InteractiveChatDiscordSrvAddon.plugin.language;
    private static Supplier<UnaryOperator<String>> translateFunction = () -> resourceManager.get().getLanguageManager().getTranslateFunction().ofLanguage(language.get());

    public static BufferedImage getMissingImage(int width, int length) {
        return TextureManager.getMissingImage(width, length);
    }

    public static BufferedImage getRawEnchantedImage(TextureResource tintResource, BufferedImage source) {
        BufferedImage tintOriginal = tintResource.getTexture();
        if (version.get().isOlderOrEqualTo(MCVersion.V1_14)) {
            BufferedImage tinted = ImageUtils.changeColorTo(ImageUtils.copyImage(tintOriginal), ENCHANTMENT_GLINT_LEGACY_COLOR);
            tintOriginal = ImageUtils.multiply(tintOriginal, tinted);
        }
        if (tintResource.hasTextureMeta()) {
            TextureProperties properties;
            TextureMeta meta = tintResource.getTextureMeta();
            if (meta.hasProperties() && (properties = meta.getProperties()).isBlur()) {
                tintOriginal = ImageUtils.applyGaussianBlur(tintOriginal);
            }
            if (meta.hasAnimation()) {
                TextureAnimation animation = meta.getAnimation();
                tintOriginal = animation.hasWidth() && animation.hasHeight() ? tintOriginal.getSubimage(0, 0, animation.getWidth(), animation.getHeight()) : tintOriginal.getSubimage(0, 0, tintOriginal.getWidth(), tintOriginal.getWidth());
            }
        }
        BufferedImage tintImage = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        Graphics2D g3 = tintImage.createGraphics();
        g3.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        tintOriginal = tintImage.getHeight() < tintImage.getWidth() ? ImageUtils.resizeImageFillWidth(tintOriginal, tintImage.getWidth() * 4) : ImageUtils.resizeImageFillHeight(tintOriginal, tintImage.getHeight() * 4);
        g3.drawImage((Image)tintOriginal, 0, 0, null);
        g3.dispose();
        return tintImage;
    }

    public static BufferedImage getEnchantedImage(List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> tintResources, BufferedImage source) {
        for (ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending> tintResource : tintResources) {
            source = ImageGeneration.getEnchantedImage((TextureResource)tintResource.getFirst(), source, BlendingUtils.convert((EnchantmentProperties.OpenGLBlending)tintResource.getSecond()));
        }
        return source;
    }

    public static BufferedImage getEnchantedImage(TextureResource tintResource, BufferedImage source, BlendingModes blendingModes) {
        BufferedImage overlay = ImageGeneration.getRawEnchantedImage(tintResource, source);
        return ImageUtils.transformRGB(source, (x, y, colorValue) -> ColorUtils.composite(overlay.getRGB(x, y), colorValue, blendingModes));
    }

    public static List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> getDefaultEnchantmentTint() {
        return Collections.singletonList(new ValuePairs((Object)resourceManager.get().getTextureManager().getTexture("minecraft:misc/enchanted_item_glint"), (Object)EnchantmentProperties.OpenGLBlending.GLINT));
    }

    public static BufferedImage getAdvancementIcon(ItemStack item, AdvancementType advancementType, boolean completed, OfflineICPlayer player) throws IOException {
        BufferedImage frame = ImageUtils.resizeImageAbs(ImageGeneration.getAdvancementFrame(advancementType, completed), 52, 52);
        BufferedImage itemImage = ImageGeneration.getRawItemImage(item, player);
        Graphics2D g = frame.createGraphics();
        g.drawImage((Image)itemImage, 10, 10, null);
        g.dispose();
        return frame;
    }

    public static BufferedImage getItemStackImage(ItemStack item, OfflineICPlayer player) throws IOException {
        return ImageGeneration.getItemStackImage(item, player, false);
    }

    public static BufferedImage getItemStackImage(ItemStack item, OfflineICPlayer player, int renderSize) throws IOException {
        return ImageGeneration.getItemStackImage(item, player, false, renderSize);
    }

    public static BufferedImage getItemStackImage(ItemStack item, OfflineICPlayer player, boolean alternateAir) throws IOException {
        return ImageGeneration.getItemStackImage(item, player, alternateAir, 32);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BufferedImage getItemStackImage(ItemStack item, OfflineICPlayer player, boolean alternateAir, int renderSize) throws IOException {
        BufferedImage itemImage;
        InteractiveChatDiscordSrvAddon.plugin.imageCounter.incrementAndGet();
        Debug.debug("ImageGeneration creating item stack image " + item);
        double scale = (double)renderSize / 32.0;
        BufferedImage background = new BufferedImage((int)Math.round(36.0 * scale), (int)Math.round(36.0 * scale), 2);
        Graphics2D g = background.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            if (!alternateAir) {
                g.dispose();
                return background;
            }
            itemImage = resourceManager.get().getTextureManager().getTexture("minecraft:interactivechatdiscordsrvaddon/block/air_alternate").getTexture(32, 32);
        } else {
            itemImage = ImageGeneration.getRawItemImage(item, player, renderSize);
        }
        if (itemImage != null) {
            g.drawImage((Image)itemImage, 0, 0, null);
        }
        g.dispose();
        return background;
    }

    public static BufferedImage getInventoryImage(Inventory inventory, OfflineICPlayer player) throws Exception {
        return ImageGeneration.getInventoryImage(inventory, null, player);
    }

    public static BufferedImage getInventoryImage(Inventory inventory, Component title, OfflineICPlayer player) throws Exception {
        CacheObject<?> cache;
        InteractiveChatDiscordSrvAddon.plugin.imageCounter.incrementAndGet();
        InteractiveChatDiscordSrvAddon.plugin.inventoryImageCounter.incrementAndGet();
        Debug.debug("ImageGeneration creating inventory image of " + player.getName());
        String key = INVENTORY_CACHE_KEY + HashUtils.createSha1((String)INVENTORY_CACHE_KEY, (Inventory)inventory);
        if (!inventory.contains(XMaterial.COMPASS.parseMaterial()) && !inventory.contains(XMaterial.CLOCK.parseMaterial()) && Arrays.stream(inventory.getContents()).anyMatch(each -> each != null && NBTEditor.contains((Object)each, (Object[])new Object[]{"CustomModelData"})) && (cache = resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).getCache(key)) != null) {
            return ImageUtils.copyImage((BufferedImage)cache.getObject());
        }
        int rows = inventory.getSize() / 9;
        GenericContainerBackgroundResult result = ImageGeneration.getGenericContainerBackground(rows, (image, x, y, fontSize, defaultTextColor) -> {
            Component defaultColorTitle = title == null ? Component.translatable((String)TranslationKeyUtils.getDefaultContainerTitle()).color(defaultTextColor) : title.colorIfAbsent(defaultTextColor);
            return ImageUtils.printComponentShadowless(resourceManager.get(), image, defaultColorTitle, InteractiveChatDiscordSrvAddon.plugin.language, version.get().isLegacyRGB(), x, y, fontSize);
        });
        BufferedImage background = result.getBackgroundImage();
        BufferedImage target = new BufferedImage(background.getWidth(), background.getHeight(), 2);
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage((Image)background, 0, 0, null);
        for (int i = 0; i < inventory.getSize(); ++i) {
            BufferedImage itemImage;
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType().equals((Object)Material.AIR) || (itemImage = ImageGeneration.getRawItemImage(item, player)) == null) continue;
            g.drawImage((Image)itemImage, result.getExpandedX() + 18 + 36 * (i % 9), result.getExpandedY() + 38 + 36 * (i / 9), null);
        }
        g.dispose();
        resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).putCache(key, target);
        return target;
    }

    public static BufferedImage getPlayerInventoryImage(Inventory inventory, OfflineICPlayer player) throws Exception {
        EntityEquipment equipment = player.getEquipment();
        ItemStack rightHand = player.isRightHanded() ? player.getMainHandItem() : player.getOffHandItem();
        ItemStack leftHand = player.isRightHanded() ? player.getOffHandItem() : player.getMainHandItem();
        return ImageGeneration.getPlayerInventoryImage(inventory, rightHand, leftHand, equipment.getHelmet(), equipment.getChestplate(), equipment.getLeggings(), equipment.getBoots(), player);
    }

    public static BufferedImage getPlayerInventoryImage(Inventory inventory, ItemStack puppetRightHand, ItemStack puppetLeftHand, ItemStack puppetHelmet, ItemStack puppetChestplate, ItemStack puppetLeggings, ItemStack puppetBoots, OfflineICPlayer player) throws Exception {
        BufferedImage itemImage;
        ItemStack item;
        int i;
        CacheObject<?> cache;
        InteractiveChatDiscordSrvAddon.plugin.imageCounter.incrementAndGet();
        InteractiveChatDiscordSrvAddon.plugin.inventoryImageCounter.incrementAndGet();
        Debug.debug("ImageGeneration creating player inventory image of " + player.getName());
        BufferedImage background = resourceManager.get().getTextureManager().getTexture("minecraft:interactivechatdiscordsrvaddon/gui/player_inventory").getTexture(356, 336);
        Object playerInventoryData = player.getProperty("player_inventory");
        if (playerInventoryData != null && playerInventoryData instanceof BufferedImage) {
            BufferedImage playerBackground = ImageUtils.copyImage((BufferedImage)playerInventoryData);
            Object mask = player.getProperty("player_inventory_mask");
            background = mask == null ? playerBackground : ImageUtils.combineWithBinMask(background, playerBackground, (byte[])mask);
        }
        String key = PLAYER_INVENTORY_CACHE_KEY + HashUtils.createSha1((String)player.getUniqueId().toString(), (Inventory)inventory) + ImageUtils.hash(background);
        if (!inventory.contains(XMaterial.COMPASS.parseMaterial()) && !inventory.contains(XMaterial.CLOCK.parseMaterial()) && Arrays.stream(inventory.getContents()).anyMatch(each -> each != null && NBTEditor.contains((Object)each, (Object[])new Object[]{"CustomModelData"})) && (cache = resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).getCache(key)) != null) {
            return ImageUtils.copyImage((BufferedImage)cache.getObject());
        }
        BufferedImage target = new BufferedImage(background.getWidth(), background.getHeight(), 2);
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage((Image)background, 0, 0, null);
        for (i = 0; i < 9; ++i) {
            item = inventory.getItem(i);
            if (item == null || item.getType().equals((Object)Material.AIR) || (itemImage = ImageGeneration.getRawItemImage(item, player)) == null) continue;
            g.drawImage((Image)itemImage, 18 + 36 * (i % 9), 286 + 36 * (i / 9), null);
        }
        while (i < 36) {
            item = inventory.getItem(i);
            if (item != null && !item.getType().equals((Object)Material.AIR) && (itemImage = ImageGeneration.getRawItemImage(item, player)) != null) {
                g.drawImage((Image)itemImage, 18 + 36 * (i % 9), 170 + 36 * ((i - 9) / 9), null);
            }
            ++i;
        }
        ItemStack boots = inventory.getItem(i);
        if (boots == null || boots.getType().equals((Object)Material.AIR)) {
            g.drawImage(resourceManager.get().getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "empty_armor_slot_boots").getTexture(32, 32), 18, 126 - 36 * (i - 36), 32, 32, null);
        } else {
            itemImage = ImageGeneration.getRawItemImage(boots, player);
            if (itemImage != null) {
                g.drawImage((Image)itemImage, 18, 126 - 36 * (i - 36), null);
            }
        }
        ItemStack leggings = inventory.getItem(++i);
        if (leggings == null || leggings.getType().equals((Object)Material.AIR)) {
            g.drawImage(resourceManager.get().getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "empty_armor_slot_leggings").getTexture(32, 32), 18, 126 - 36 * (i - 36), 32, 32, null);
        } else {
            BufferedImage itemImage2 = ImageGeneration.getRawItemImage(leggings, player);
            if (itemImage2 != null) {
                g.drawImage((Image)itemImage2, 18, 126 - 36 * (i - 36), null);
            }
        }
        ItemStack chestplate = inventory.getItem(++i);
        if (chestplate == null || chestplate.getType().equals((Object)Material.AIR)) {
            g.drawImage(resourceManager.get().getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "empty_armor_slot_chestplate").getTexture(32, 32), 18, 126 - 36 * (i - 36), 32, 32, null);
        } else {
            BufferedImage itemImage3 = ImageGeneration.getRawItemImage(chestplate, player);
            if (itemImage3 != null) {
                g.drawImage((Image)itemImage3, 18, 126 - 36 * (i - 36), null);
            }
        }
        ItemStack helmet = inventory.getItem(++i);
        if (helmet == null || helmet.getType().equals((Object)Material.AIR)) {
            g.drawImage(resourceManager.get().getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "empty_armor_slot_helmet").getTexture(32, 32), 18, 126 - 36 * (i - 36), 32, 32, null);
        } else {
            BufferedImage itemImage4 = ImageGeneration.getRawItemImage(helmet, player);
            if (itemImage4 != null) {
                g.drawImage((Image)itemImage4, 18, 126 - 36 * (i - 36), null);
            }
        }
        ++i;
        if (!version.get().isOld()) {
            ItemStack offhand = inventory.getItem(i);
            if (offhand == null || offhand.getType().equals((Object)Material.AIR)) {
                g.drawImage(resourceManager.get().getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "empty_armor_slot_shield").getTexture(32, 32), 162, 126, 32, 32, null);
            } else {
                BufferedImage itemImage5 = ImageGeneration.getRawItemImage(offhand, player);
                if (itemImage5 != null) {
                    g.drawImage((Image)itemImage5, 162, 126, null);
                }
            }
        }
        BufferedImage puppet = ImageGeneration.getFullBodyImage(player, puppetRightHand, puppetLeftHand, puppetHelmet, puppetChestplate, puppetLeggings, puppetBoots);
        g.drawImage((Image)puppet, 45, -10, null);
        g.dispose();
        resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).putCache(key, target);
        return target;
    }

    private static BufferedImage getFullBodyImage(OfflineICPlayer player, ItemStack rightHand, ItemStack leftHand, ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots) throws IOException {
        Graphics2D g2;
        BufferedImage colorOverlay;
        BufferedImage armorOverlay;
        Color color;
        LeatherArmorMeta meta;
        Graphics2D g22;
        BufferedImage colorOverlay2;
        BufferedImage armorOverlay2;
        Color color2;
        LeatherArmorMeta meta2;
        XMaterial type;
        BufferedImage cape;
        boolean slim;
        BufferedImage skin;
        Player livingEntity;
        World world;
        block75: {
            InteractiveChatDiscordSrvAddon.plugin.imageCounter.incrementAndGet();
            Debug.debug("ImageGeneration creating puppet image of " + player.getName());
            world = null;
            livingEntity = null;
            if (player.isOnline() && player.getPlayer().isLocal()) {
                livingEntity = player.getPlayer().getLocalPlayer();
                world = livingEntity.getWorld();
            }
            skin = null;
            slim = false;
            try {
                CacheObject<?> cache;
                ICPlayer icPlayer = player.getPlayer();
                JSONObject json = icPlayer != null && icPlayer.isLocal() ? (JSONObject)new JSONParser().parse(SkinUtils.getSkinJsonFromProfile((Player)((ICPlayer)player).getLocalPlayer())) : (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(((JSONObject)((JSONArray)HTTPRequestUtils.getJSONResponse((String)PLAYER_INFO_URL.replace("%s", player.getUniqueId().toString())).get((Object)"properties")).get(0)).get((Object)"value").toString())));
                if (json == null) {
                    cape = null;
                    break block75;
                }
                try {
                    String url;
                    if (((JSONObject)json.get((Object)"textures")).containsKey((Object)"CAPE")) {
                        url = (String)((JSONObject)((JSONObject)json.get((Object)"textures")).get((Object)"CAPE")).get((Object)"url");
                        cache = resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).getCache(player.getUniqueId().toString() + url + PLAYER_CAPE_CACHE_KEY);
                        if (cache == null) {
                            cape = ImageUtils.downloadImage(url);
                            resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).putCache(player.getUniqueId().toString() + url + PLAYER_CAPE_CACHE_KEY, cape);
                        } else {
                            cape = (BufferedImage)cache.getObject();
                        }
                    } else {
                        url = OPTIFINE_CAPE_URL.replaceAll("%s", CustomStringUtils.escapeReplaceAllMetaCharacters((String)player.getName()));
                        cache = resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).getCache(player.getUniqueId().toString() + url + PLAYER_CAPE_CACHE_KEY);
                        if (cache == null) {
                            try {
                                cape = ImageUtils.downloadImage(url);
                                resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).putCache(player.getUniqueId().toString() + url + PLAYER_CAPE_CACHE_KEY, cape);
                            }
                            catch (Throwable ignore) {
                                cape = null;
                            }
                        } else {
                            cape = (BufferedImage)cache.getObject();
                        }
                    }
                }
                catch (Throwable e) {
                    cape = null;
                }
                try {
                    String value = (String)((JSONObject)((JSONObject)json.get((Object)"textures")).get((Object)"SKIN")).get((Object)"url");
                    if (((JSONObject)((JSONObject)json.get((Object)"textures")).get((Object)"SKIN")).containsKey((Object)"metadata")) {
                        slim = ((JSONObject)((JSONObject)((JSONObject)json.get((Object)"textures")).get((Object)"SKIN")).get((Object)"metadata")).get((Object)"model").toString().equals("slim");
                    }
                    if ((cache = resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).getCache(player.getUniqueId().toString() + value + PLAYER_SKIN_CACHE_KEY)) == null) {
                        skin = ImageUtils.downloadImage(value);
                        resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).putCache(player.getUniqueId().toString() + value + PLAYER_SKIN_CACHE_KEY, skin);
                    } else {
                        skin = (BufferedImage)cache.getObject();
                    }
                    skin = ImageUtils.copyImage(skin);
                }
                catch (Throwable value) {}
            }
            catch (Exception e) {
                cape = null;
            }
        }
        if (skin == null) {
            skin = slim ? resourceManager.get().getTextureManager().getTexture("minecraft:entity/alex").getTexture() : resourceManager.get().getTextureManager().getTexture("minecraft:entity/steve").getTexture();
        }
        BufferedImage elytraImage = null;
        BufferedImage image = new BufferedImage(556, 748, 2);
        HashMap<String, TextureResource> providedTextures = new HashMap<String, TextureResource>();
        HashMap<ModelRenderer.PlayerModelItemPosition, ModelRenderer.PlayerModelItem> modelItems = new HashMap<ModelRenderer.PlayerModelItemPosition, ModelRenderer.PlayerModelItem>();
        providedTextures.put("minecraft:interactivechatdiscordsrvaddon/skin_full", new GeneratedTextureResource(resourceManager.get(), ModelUtils.convertToModernSkinTexture(skin)));
        if (ItemStackUtils.isWearable((ItemStack)leggings)) {
            type = XMaterialUtils.matchXMaterial((ItemStack)leggings);
            BufferedImage leggingsImage = null;
            switch (type) {
                case LEATHER_LEGGINGS: {
                    leggingsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("leather_layer_2", EquipmentSlot.LEGS, leggings, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/leather_layer_2").getTexture());
                    meta2 = (LeatherArmorMeta)leggings.getItemMeta();
                    color2 = new Color(meta2.getColor().asRGB());
                    armorOverlay2 = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("leather_layer_2_overlay", EquipmentSlot.LEGS, leggings, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/leather_layer_2_overlay").getTexture());
                    colorOverlay2 = ImageUtils.changeColorTo(ImageUtils.copyImage(leggingsImage), color2);
                    leggingsImage = ImageUtils.multiply(leggingsImage, colorOverlay2);
                    g22 = leggingsImage.createGraphics();
                    g22.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    g22.drawImage((Image)armorOverlay2, 0, 0, null);
                    g22.dispose();
                    break;
                }
                case CHAINMAIL_LEGGINGS: {
                    leggingsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("chainmail_layer_2", EquipmentSlot.LEGS, leggings, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/chainmail_layer_2").getTexture());
                    break;
                }
                case GOLDEN_LEGGINGS: {
                    leggingsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("gold_layer_2", EquipmentSlot.LEGS, leggings, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/gold_layer_2").getTexture());
                    break;
                }
                case IRON_LEGGINGS: {
                    leggingsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("iron_layer_2", EquipmentSlot.LEGS, leggings, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/iron_layer_2").getTexture());
                    break;
                }
                case DIAMOND_LEGGINGS: {
                    leggingsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("diamond_layer_2", EquipmentSlot.LEGS, leggings, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/diamond_layer_2").getTexture());
                    break;
                }
                case NETHERITE_LEGGINGS: {
                    leggingsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("netherite_layer_2", EquipmentSlot.LEGS, leggings, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/netherite_layer_2").getTexture());
                    break;
                }
            }
            if (leggingsImage != null) {
                if (leggings.getEnchantments().size() > 0) {
                    leggingsImage = ImageGeneration.getEnchantedImage(resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(EquipmentSlot.LEGS, leggings, () -> ImageGeneration.getDefaultEnchantmentTint(), translateFunction.get()), leggingsImage);
                }
                providedTextures.put("minecraft:interactivechatdiscordsrvaddon/leggings", new GeneratedTextureResource(resourceManager.get(), leggingsImage));
            }
        }
        if (ItemStackUtils.isWearable((ItemStack)boots)) {
            type = XMaterialUtils.matchXMaterial((ItemStack)boots);
            BufferedImage bootsImage = null;
            switch (type) {
                case LEATHER_BOOTS: {
                    bootsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("leather_layer_1", EquipmentSlot.FEET, boots, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/leather_layer_1").getTexture());
                    meta2 = (LeatherArmorMeta)boots.getItemMeta();
                    color2 = new Color(meta2.getColor().asRGB());
                    armorOverlay2 = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("leather_layer_1_overlay", EquipmentSlot.FEET, boots, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/leather_layer_1_overlay").getTexture());
                    colorOverlay2 = ImageUtils.changeColorTo(ImageUtils.copyImage(bootsImage), color2);
                    bootsImage = ImageUtils.multiply(bootsImage, colorOverlay2);
                    g22 = bootsImage.createGraphics();
                    g22.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    g22.drawImage((Image)armorOverlay2, 0, 0, null);
                    g22.dispose();
                    break;
                }
                case CHAINMAIL_BOOTS: {
                    bootsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("chainmail_layer_1", EquipmentSlot.FEET, boots, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/chainmail_layer_1").getTexture());
                    break;
                }
                case GOLDEN_BOOTS: {
                    bootsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("gold_layer_1", EquipmentSlot.FEET, boots, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/gold_layer_1").getTexture());
                    break;
                }
                case IRON_BOOTS: {
                    bootsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("iron_layer_1", EquipmentSlot.FEET, boots, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/iron_layer_1").getTexture());
                    break;
                }
                case DIAMOND_BOOTS: {
                    bootsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("diamond_layer_1", EquipmentSlot.FEET, boots, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/diamond_layer_1").getTexture());
                    break;
                }
                case NETHERITE_BOOTS: {
                    bootsImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("netherite_layer_1", EquipmentSlot.FEET, boots, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/netherite_layer_1").getTexture());
                    break;
                }
            }
            if (bootsImage != null) {
                if (boots.getEnchantments().size() > 0) {
                    bootsImage = ImageGeneration.getEnchantedImage(resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(EquipmentSlot.FEET, boots, () -> ImageGeneration.getDefaultEnchantmentTint(), translateFunction.get()), bootsImage);
                }
                providedTextures.put("minecraft:interactivechatdiscordsrvaddon/boots", new GeneratedTextureResource(resourceManager.get(), bootsImage));
            }
        }
        if (ItemStackUtils.isWearable((ItemStack)chestplate)) {
            type = XMaterialUtils.matchXMaterial((ItemStack)chestplate);
            BufferedImage chestplateImage = null;
            boolean isArmor = true;
            switch (type) {
                case LEATHER_CHESTPLATE: {
                    chestplateImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("leather_layer_1", EquipmentSlot.CHEST, chestplate, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/leather_layer_1").getTexture());
                    meta = (LeatherArmorMeta)chestplate.getItemMeta();
                    color = new Color(meta.getColor().asRGB());
                    armorOverlay = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("leather_layer_1_overlay", EquipmentSlot.CHEST, chestplate, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/leather_layer_1_overlay").getTexture());
                    colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(chestplateImage), color);
                    chestplateImage = ImageUtils.multiply(chestplateImage, colorOverlay);
                    g2 = chestplateImage.createGraphics();
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    g2.drawImage((Image)armorOverlay, 0, 0, null);
                    g2.dispose();
                    break;
                }
                case CHAINMAIL_CHESTPLATE: {
                    chestplateImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("chainmail_layer_1", EquipmentSlot.CHEST, chestplate, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/chainmail_layer_1").getTexture());
                    break;
                }
                case GOLDEN_CHESTPLATE: {
                    chestplateImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("gold_layer_1", EquipmentSlot.CHEST, chestplate, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/gold_layer_1").getTexture());
                    break;
                }
                case IRON_CHESTPLATE: {
                    chestplateImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("iron_layer_1", EquipmentSlot.CHEST, chestplate, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/iron_layer_1").getTexture());
                    break;
                }
                case DIAMOND_CHESTPLATE: {
                    chestplateImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("diamond_layer_1", EquipmentSlot.CHEST, chestplate, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/diamond_layer_1").getTexture());
                    break;
                }
                case NETHERITE_CHESTPLATE: {
                    chestplateImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("netherite_layer_1", EquipmentSlot.CHEST, chestplate, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/netherite_layer_1").getTexture());
                    break;
                }
                case ELYTRA: {
                    isArmor = false;
                    chestplateImage = new BufferedImage(150, 150, 2);
                    BufferedImage wing = null;
                    wing = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getElytraOverrideTextures(EquipmentSlot.CHEST, chestplate, translateFunction.get()).map(t -> t.getTexture()).orElse(cape == null ? resourceManager.get().getTextureManager().getTexture("minecraft:entity/elytra").getTexture() : cape);
                    if (wing.getWidth() % 64 != 0 || wing.getHeight() % 32 != 0) {
                        int w = 0;
                        int h = 0;
                        while (w < wing.getWidth()) {
                            w += 64;
                            h += 32;
                        }
                        BufferedImage resize = new BufferedImage(w, h, 2);
                        Graphics2D g3 = resize.createGraphics();
                        g3.drawImage((Image)wing, 0, 0, null);
                        g3.dispose();
                        wing = resize;
                    }
                    int scale = wing.getWidth() / 64;
                    wing = ImageUtils.copyAndGetSubImage(wing, 34 * scale, 2 * scale, 12 * scale, 20 * scale);
                    wing = ImageUtils.multiply(ImageUtils.resizeImage(wing, Math.pow(scale, -1.0) * 3.75), 0.7);
                    BufferedImage leftWing = ImageUtils.rotateImageByDegrees(wing, 23.41);
                    Graphics2D g3 = chestplateImage.createGraphics();
                    g3.drawImage((Image)leftWing, 0, 0, null);
                    wing = ImageUtils.flipHorizontal(wing);
                    BufferedImage rightWing = ImageUtils.rotateImageByDegrees(wing, 336.59);
                    g3.drawImage((Image)rightWing, 26, 0, null);
                    g3.dispose();
                    if (chestplate.getEnchantments().size() > 0) {
                        chestplateImage = ImageGeneration.getEnchantedImage(resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(EquipmentSlot.CHEST, chestplate, () -> ImageGeneration.getDefaultEnchantmentTint(), translateFunction.get()), chestplateImage);
                    }
                    elytraImage = chestplateImage;
                }
            }
            if (isArmor && chestplateImage != null) {
                if (chestplate.getEnchantments().size() > 0) {
                    chestplateImage = ImageGeneration.getEnchantedImage(resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(EquipmentSlot.CHEST, chestplate, () -> ImageGeneration.getDefaultEnchantmentTint(), translateFunction.get()), chestplateImage);
                }
                providedTextures.put("minecraft:interactivechatdiscordsrvaddon/chestplate", new GeneratedTextureResource(resourceManager.get(), chestplateImage));
            }
        }
        if (helmet != null && !helmet.getType().equals((Object)Material.AIR)) {
            type = XMaterialUtils.matchXMaterial((ItemStack)helmet);
            BufferedImage helmetImage = null;
            boolean isArmor = true;
            switch (type) {
                case LEATHER_HELMET: {
                    helmetImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("leather_layer_1", EquipmentSlot.HEAD, helmet, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/leather_layer_1").getTexture());
                    meta = (LeatherArmorMeta)helmet.getItemMeta();
                    color = new Color(meta.getColor().asRGB());
                    armorOverlay = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("leather_layer_1_overlay", EquipmentSlot.HEAD, helmet, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/leather_layer_1_overlay").getTexture());
                    colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(helmetImage), color);
                    helmetImage = ImageUtils.multiply(helmetImage, colorOverlay);
                    g2 = helmetImage.createGraphics();
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    g2.drawImage((Image)armorOverlay, 0, 0, null);
                    g2.dispose();
                    break;
                }
                case CHAINMAIL_HELMET: {
                    helmetImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("chainmail_layer_1", EquipmentSlot.HEAD, helmet, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/chainmail_layer_1").getTexture());
                    break;
                }
                case GOLDEN_HELMET: {
                    helmetImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("gold_layer_1", EquipmentSlot.HEAD, helmet, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/gold_layer_1").getTexture());
                    break;
                }
                case IRON_HELMET: {
                    helmetImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("iron_layer_1", EquipmentSlot.HEAD, helmet, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/iron_layer_1").getTexture());
                    break;
                }
                case DIAMOND_HELMET: {
                    helmetImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("diamond_layer_1", EquipmentSlot.HEAD, helmet, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/diamond_layer_1").getTexture());
                    break;
                }
                case NETHERITE_HELMET: {
                    helmetImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("netherite_layer_1", EquipmentSlot.HEAD, helmet, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/netherite_layer_1").getTexture());
                    break;
                }
                case TURTLE_HELMET: {
                    helmetImage = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getArmorOverrideTextures("turtle_layer_1", EquipmentSlot.HEAD, helmet, player, world, (LivingEntity)livingEntity, translateFunction.get()).map(t -> t.getTexture()).orElse(resourceManager.get().getTextureManager().getTexture("minecraft:models/armor/turtle_layer_1").getTexture());
                    break;
                }
                default: {
                    isArmor = false;
                    ItemRenderUtils.ItemStackProcessResult itemProcessResult = ItemRenderUtils.processItemForRendering(resourceManager.get(), player, helmet, EquipmentSlot.HEAD, version.get().isOld(), language.get());
                    boolean enchanted = itemProcessResult.requiresEnchantmentGlint();
                    Map<ModelOverride.ModelOverrideType, Float> predicate = itemProcessResult.getPredicates();
                    String modelKey = itemProcessResult.getModelKey();
                    Map<String, TextureResource> itemProvidedTextures = itemProcessResult.getProvidedTextures();
                    TintUtils.TintIndexData tintIndexData = itemProcessResult.getTintIndexData();
                    List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> enchantmentGlintResource = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(EquipmentSlot.HEAD, helmet, () -> ImageGeneration.getDefaultEnchantmentTint(), translateFunction.get());
                    UnaryOperator enchantmentGlintFunction = img -> ImageGeneration.getEnchantedImage(enchantmentGlintResource, img);
                    Function<BufferedImage, ModelRenderer.RawEnchantmentGlintData> rawEnchantmentGlintFunction = img -> new ModelRenderer.RawEnchantmentGlintData(enchantmentGlintResource.stream().map(each -> ImageGeneration.getRawEnchantedImage((TextureResource)each.getFirst(), img)).collect(Collectors.toList()), enchantmentGlintResource.stream().map(each -> (EnchantmentProperties.OpenGLBlending)each.getSecond()).collect(Collectors.toList()));
                    modelItems.put(ModelRenderer.PlayerModelItemPosition.HELMET, new ModelRenderer.PlayerModelItem(ModelRenderer.PlayerModelItemPosition.HELMET, modelKey, resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getItemPostResolveFunction(modelKey, EquipmentSlot.HEAD, helmet, version.get().isOld(), predicate, player, world, (LivingEntity)livingEntity, translateFunction.get()).orElse(null), predicate, enchanted, itemProvidedTextures, tintIndexData, enchantmentGlintFunction, rawEnchantmentGlintFunction));
                }
            }
            if (isArmor) {
                if (helmet.getEnchantments().size() > 0) {
                    helmetImage = ImageGeneration.getEnchantedImage(resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(EquipmentSlot.HEAD, helmet, () -> ImageGeneration.getDefaultEnchantmentTint(), translateFunction.get()), helmetImage);
                }
                providedTextures.put("minecraft:interactivechatdiscordsrvaddon/helmet", new GeneratedTextureResource(resourceManager.get(), helmetImage));
            }
        }
        if (InteractiveChatDiscordSrvAddon.plugin.renderHandHeldItems) {
            UnaryOperator enchantmentGlintFunction;
            List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> enchantmentGlintResource;
            TintUtils.TintIndexData tintIndexData;
            Map<String, TextureResource> itemProvidedTextures;
            String modelKey;
            Map<ModelOverride.ModelOverrideType, Float> predicate;
            ItemRenderUtils.ItemStackProcessResult itemProcessResult;
            EquipmentSlot slot;
            if (rightHand != null && !rightHand.getType().equals((Object)Material.AIR)) {
                slot = player.isRightHanded() ? EquipmentSlot.HAND : EquipmentSlot.valueOf((String)"OFF_HAND");
                itemProcessResult = ItemRenderUtils.processItemForRendering(resourceManager.get(), player, rightHand, slot, version.get().isOld(), language.get());
                boolean enchanted = itemProcessResult.requiresEnchantmentGlint();
                predicate = itemProcessResult.getPredicates();
                modelKey = itemProcessResult.getModelKey();
                itemProvidedTextures = itemProcessResult.getProvidedTextures();
                tintIndexData = itemProcessResult.getTintIndexData();
                enchantmentGlintResource = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(slot, rightHand, () -> ImageGeneration.getDefaultEnchantmentTint(), translateFunction.get());
                enchantmentGlintFunction = img -> ImageGeneration.getEnchantedImage(enchantmentGlintResource, img);
                Function<BufferedImage, ModelRenderer.RawEnchantmentGlintData> rawEnchantmentGlintFunction = img -> new ModelRenderer.RawEnchantmentGlintData(enchantmentGlintResource.stream().map(each -> ImageGeneration.getRawEnchantedImage((TextureResource)each.getFirst(), img)).collect(Collectors.toList()), enchantmentGlintResource.stream().map(each -> (EnchantmentProperties.OpenGLBlending)each.getSecond()).collect(Collectors.toList()));
                modelItems.put(ModelRenderer.PlayerModelItemPosition.RIGHT_HAND, new ModelRenderer.PlayerModelItem(ModelRenderer.PlayerModelItemPosition.RIGHT_HAND, modelKey, resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getItemPostResolveFunction(modelKey, slot, rightHand, version.get().isOld(), predicate, player, world, (LivingEntity)livingEntity, translateFunction.get()).orElse(null), predicate, enchanted, itemProvidedTextures, tintIndexData, enchantmentGlintFunction, rawEnchantmentGlintFunction));
            }
            if (leftHand != null && !leftHand.getType().equals((Object)Material.AIR)) {
                slot = player.isRightHanded() ? EquipmentSlot.valueOf((String)"OFF_HAND") : EquipmentSlot.HAND;
                itemProcessResult = ItemRenderUtils.processItemForRendering(resourceManager.get(), player, leftHand, slot, version.get().isOld(), language.get());
                boolean enchanted = itemProcessResult.requiresEnchantmentGlint();
                predicate = itemProcessResult.getPredicates();
                modelKey = itemProcessResult.getModelKey();
                itemProvidedTextures = itemProcessResult.getProvidedTextures();
                tintIndexData = itemProcessResult.getTintIndexData();
                enchantmentGlintResource = resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(slot, leftHand, () -> ImageGeneration.getDefaultEnchantmentTint(), translateFunction.get());
                enchantmentGlintFunction = img -> ImageGeneration.getEnchantedImage(enchantmentGlintResource, img);
                Function<BufferedImage, ModelRenderer.RawEnchantmentGlintData> rawEnchantmentGlintFunction = img -> new ModelRenderer.RawEnchantmentGlintData(enchantmentGlintResource.stream().map(each -> ImageGeneration.getRawEnchantedImage((TextureResource)each.getFirst(), img)).collect(Collectors.toList()), enchantmentGlintResource.stream().map(each -> (EnchantmentProperties.OpenGLBlending)each.getSecond()).collect(Collectors.toList()));
                modelItems.put(ModelRenderer.PlayerModelItemPosition.LEFT_HAND, new ModelRenderer.PlayerModelItem(ModelRenderer.PlayerModelItemPosition.LEFT_HAND, modelKey, resourceManager.get().getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getItemPostResolveFunction(modelKey, slot, leftHand, version.get().isOld(), predicate, player, world, (LivingEntity)livingEntity, translateFunction.get()).orElse(null), predicate, enchanted, itemProvidedTextures, tintIndexData, enchantmentGlintFunction, rawEnchantmentGlintFunction));
            }
        }
        boolean upsideDown = ModelUtils.isRenderedUpsideDown(player.getName(), cape != null);
        ModelRenderer.RenderResult renderResult = InteractiveChatDiscordSrvAddon.plugin.modelRenderer.renderPlayer(image.getWidth(), image.getHeight(), resourceManager.get(), version.get().isOld(), slim, providedTextures, TintUtils.TintIndexData.EMPTY_INSTANCE, modelItems);
        Graphics2D g = image.createGraphics();
        BufferedImage resizedImage = ImageUtils.resizeImageAbs(renderResult.getImage(), 117, 159);
        if (upsideDown) {
            resizedImage = ImageUtils.rotateImageByDegrees(resizedImage, 180.0);
        }
        g.drawImage((Image)resizedImage, -1, 12, null);
        g.dispose();
        if (elytraImage != null) {
            BufferedImage resizedElytraImage = ImageUtils.resizeImage(elytraImage, 0.9);
            if (upsideDown) {
                resizedElytraImage = ImageUtils.rotateImageByDegrees(resizedElytraImage, 180.0);
            }
            ImageUtils.drawTransparent(image, resizedElytraImage, 14, 75);
        }
        return image;
    }

    private static BufferedImage getRawItemImage(ItemStack item, OfflineICPlayer player) throws IOException {
        return ImageGeneration.getRawItemImage(item, player, 32);
    }

    private static BufferedImage getRawItemImage(ItemStack item, OfflineICPlayer player, int size) throws IOException {
        short maxDur;
        int durability;
        double percentage;
        BufferedImage itemImage;
        InteractiveChatDiscordSrvAddon.plugin.imageCounter.incrementAndGet();
        Debug.debug("ImageGeneration creating raw item stack image " + (item == null ? "null" : ItemNBTUtils.getNMSItemStackJson((ItemStack)item)));
        double scale = (double)size / 32.0;
        XMaterial xMaterial = XMaterialUtils.matchXMaterial((ItemStack)item);
        int amount = item.getAmount();
        String key = ModelUtils.getItemModelKey(xMaterial);
        ItemRenderUtils.ItemStackProcessResult processResult = ItemRenderUtils.processItemForRendering(resourceManager.get(), player, item, null, version.get().isOld(), language.get());
        boolean requiresEnchantmentGlint = processResult.requiresEnchantmentGlint();
        Map<ModelOverride.ModelOverrideType, Float> predicates = processResult.getPredicates();
        Map<String, TextureResource> providedTextures = processResult.getProvidedTextures();
        TintUtils.TintIndexData tintIndexData = processResult.getTintIndexData();
        String modelKey = processResult.getModelKey();
        ModelRenderer.RenderResult renderResult = InteractiveChatDiscordSrvAddon.plugin.modelRenderer.render(size, size, resourceManager.get(), processResult.getPostResolveFunction(), version.get().isOld(), modelKey, ModelDisplay.ModelDisplayPosition.GUI, predicates, providedTextures, tintIndexData, requiresEnchantmentGlint, processResult.getEnchantmentGlintFunction(), processResult.getRawEnchantmentGlintFunction());
        if (renderResult.isSuccessful()) {
            itemImage = renderResult.getImage();
        } else {
            Debug.debug("ImageGeneration creating missing Image for material " + xMaterial);
            itemImage = TextureManager.getMissingImage(size, size);
        }
        if (item.getType().getMaxDurability() > 0 && (percentage = Math.max(0.0, Math.min(1.0, (double)(durability = (maxDur = item.getType().getMaxDurability()) - (version.get().isLegacy() ? item.getDurability() : ((Damageable)item.getItemMeta()).getDamage())) / (double)maxDur))) < 1.0) {
            int hue = (int)(125.0 * percentage);
            int length = (int)Math.round(26.0 * scale * percentage);
            Color color = Color.getHSBColor((float)hue / 360.0f, 1.0f, 1.0f);
            Graphics2D g4 = itemImage.createGraphics();
            g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g4.setColor(Color.BLACK);
            g4.fillPolygon(new int[]{(int)Math.round(4.0 * scale), (int)Math.round(30.0 * scale), (int)Math.round(30.0 * scale), (int)Math.round(4.0 * scale)}, new int[]{(int)Math.round(26.0 * scale), (int)Math.round(26.0 * scale), (int)Math.round(30.0 * scale), (int)Math.round(30.0 * scale)}, 4);
            g4.setColor(color);
            g4.fillPolygon(new int[]{(int)Math.round(4.0 * scale), (int)Math.round(4.0 * scale + (double)length), (int)Math.round(4.0 * scale + (double)length), (int)Math.round(4.0 * scale)}, new int[]{(int)Math.round(26.0 * scale), (int)Math.round(26.0 * scale), (int)Math.round(28.0 * scale), (int)Math.round(28.0 * scale)}, 4);
            g4.dispose();
        }
        if (xMaterial.equals((Object)XMaterial.BUNDLE)) {
            double fullness = Math.max(0.0, Math.min(1.0, (double)BundleUtils.getFullnessPercentage(((BundleMeta)item.getItemMeta()).getItems())));
            int length = (int)Math.round(26.0 * scale * fullness);
            Graphics2D g4 = itemImage.createGraphics();
            g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g4.setColor(Color.BLACK);
            g4.fillPolygon(new int[]{(int)Math.round(4.0 * scale), (int)Math.round(30.0 * scale), (int)Math.round(30.0 * scale), (int)Math.round(4.0 * scale)}, new int[]{(int)Math.round(26.0 * scale), (int)Math.round(26.0 * scale), (int)Math.round(30.0 * scale), (int)Math.round(30.0 * scale)}, 4);
            g4.setColor(BUNDLE_FULLNESS_BAR_COLOR);
            g4.fillPolygon(new int[]{(int)Math.round(4.0 * scale), (int)Math.round(4.0 * scale + (double)length), (int)Math.round(4.0 * scale + (double)length), (int)Math.round(4.0 * scale)}, new int[]{(int)Math.round(26.0 * scale), (int)Math.round(26.0 * scale), (int)Math.round(28.0 * scale), (int)Math.round(28.0 * scale)}, 4);
            g4.dispose();
        }
        if (amount != 1) {
            BufferedImage newItemImage = new BufferedImage((int)Math.round(40.0 * scale), (int)Math.round(40.0 * scale), 2);
            Graphics2D g4 = newItemImage.createGraphics();
            g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g4.drawImage((Image)itemImage, 0, 0, null);
            TextComponent component = Component.text((int)amount);
            if (amount <= 0) {
                component = component.color((TextColor)NamedTextColor.RED);
            }
            newItemImage = ImageUtils.printComponentRightAligned(resourceManager.get(), newItemImage, (Component)component, InteractiveChatDiscordSrvAddon.plugin.language, version.get().isLegacyRGB(), (int)Math.round(33.0 * scale), (int)Math.round(17.0 * scale), (float)(16.0 * scale), 0.29411764705882354);
            g4.dispose();
            itemImage = newItemImage;
        }
        return itemImage;
    }

    public static Future<BufferedImage> getMapImage(ItemStack item, Player player) {
        if (!FilledMapUtils.isFilledMap((ItemStack)item)) {
            throw new IllegalArgumentException("Provided item is not a filled map");
        }
        Debug.debug("ImageGeneration creating map image with item");
        if (Bukkit.isPrimaryThread()) {
            ItemMapWrapper data = new ItemMapWrapper(item, player);
            return CompletableFuture.completedFuture(ImageGeneration.getMapImage(data.getColors(), data.getMapCursors(), player));
        }
        CompletableFuture<BufferedImage> future = new CompletableFuture<BufferedImage>();
        ItemStack finalItem = item.clone();
        Bukkit.getScheduler().runTask((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> {
            ItemMapWrapper data;
            try {
                data = new ItemMapWrapper(finalItem, player);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> {
                try {
                    future.complete(ImageGeneration.getMapImage(data.getColors(), data.getMapCursors(), player));
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            });
        });
        return future;
    }

    public static BufferedImage getMapImage(byte[] colors, List<MapCursor> mapCursors, Player player) {
        if (colors != null && colors.length != 16384) {
            throw new IllegalArgumentException("Map color array is not null or of length 16384");
        }
        InteractiveChatDiscordSrvAddon.plugin.imageCounter.incrementAndGet();
        Debug.debug("ImageGeneration creating map image with color and cursors");
        BufferedImage background = resourceManager.get().getTextureManager().getTexture("minecraft:map/map_background").getTexture();
        BufferedImage image = new BufferedImage(1120, 1120, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage(background, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        int borderOffset = (int)((double)image.getWidth() / 23.333333333333332);
        int ratio = (image.getWidth() - borderOffset * 2) / 128;
        if (colors != null) {
            for (int widthOffset = 0; widthOffset < 128; ++widthOffset) {
                for (int heightOffset = 0; heightOffset < 128; ++heightOffset) {
                    byte index = colors[widthOffset + heightOffset * 128];
                    if (0 == index) continue;
                    Color color = MapPalette.getColor((byte)index);
                    for (int x = 0; x < ratio; ++x) {
                        for (int y = 0; y < ratio; ++y) {
                            image.setRGB(widthOffset * ratio + borderOffset + x, heightOffset * ratio + borderOffset + y, color.getRGB());
                        }
                    }
                }
            }
        }
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        BufferedImage asset = resourceManager.get().getTextureManager().getTexture("minecraft:map/map_icons").getTexture();
        int iconWidth = asset.getWidth() / MAP_ICON_PER_ROLE;
        if (mapCursors != null) {
            for (MapCursor icon : mapCursors) {
                Component component;
                int x = icon.getX() + 128;
                int y = icon.getY() + 128;
                double rotation = 22.5 * (double)icon.getDirection() + 180.0;
                int type = icon.getType().ordinal();
                try {
                    component = LegacyComponentSerializer.legacySection().deserializeOrNull((Object)icon.getCaption());
                }
                catch (Throwable e) {
                    component = null;
                }
                BufferedImage iconImage = ImageUtils.copyAndGetSubImage(asset, type % MAP_ICON_PER_ROLE * iconWidth, type / MAP_ICON_PER_ROLE * iconWidth, iconWidth, iconWidth);
                BufferedImage iconImageBig = new BufferedImage(96, 96, 2);
                Graphics2D g3 = iconImageBig.createGraphics();
                g3.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g3.drawImage(iconImage, iconImageBig.getWidth() / 6, iconImageBig.getHeight() / 6, 64, 64, null);
                g3.dispose();
                iconImage = iconImageBig;
                BufferedImage iconCan = new BufferedImage(96, 96, 2);
                AffineTransform at = new AffineTransform();
                at.rotate(Math.toRadians(rotation), (double)iconImage.getWidth() / 2.0, (double)iconImage.getHeight() / 2.0);
                Graphics2D g2d = iconCan.createGraphics();
                g2d.drawImage(iconImage, at, null);
                g2d.dispose();
                int imageX = x * ratio / 2 + borderOffset;
                int imageY = y * ratio / 2 + borderOffset;
                g2.drawImage(iconCan, imageX - iconCan.getWidth() / 2, imageY - iconCan.getHeight() / 2, 96, 96, null);
                if (component == null) continue;
                ImageUtils.printComponentShadowlessDynamicSize(resourceManager.get(), image, component, InteractiveChatDiscordSrvAddon.plugin.language, version.get().isLegacyRGB(), imageX, imageY + 32, 30.0f, true);
            }
        }
        g2.dispose();
        return image;
    }

    public static BufferedImage getToolTipImage(Component print) {
        return ImageGeneration.getToolTipImage(print, false);
    }

    public static BufferedImage getToolTipImage(Component print, boolean allowLineBreaks) {
        return ImageGeneration.getToolTipImage(Collections.singletonList(ToolTipComponent.text(print)), allowLineBreaks);
    }

    public static BufferedImage getToolTipImage(List<ToolTipComponent<?>> prints) {
        return ImageGeneration.getToolTipImage(prints, false);
    }

    public static BufferedImage getToolTipImage(List<ToolTipComponent<?>> prints, boolean allowLineBreaks) {
        if (prints.isEmpty() || !prints.get(0).getType().equals(ToolTipComponent.ToolTipType.TEXT)) {
            Debug.debug("ImageGeneration creating tooltip image");
        } else {
            Debug.debug("ImageGeneration creating tooltip image of " + InteractiveChatComponentSerializer.bungeecordApiLegacy().serialize((Component)prints.get(0).getToolTipComponent()));
        }
        if (allowLineBreaks) {
            ArrayList newList = new ArrayList();
            for (ToolTipComponent<?> toolTip : prints) {
                if (toolTip.getType().equals(ToolTipComponent.ToolTipType.TEXT)) {
                    for (Component newComponent : ComponentStyling.splitAtLineBreaks((Component)((Component)toolTip.getToolTipComponent()))) {
                        newList.add(ToolTipComponent.text(newComponent));
                    }
                    continue;
                }
                newList.add(toolTip);
            }
            prints = newList;
        }
        int requiredHeight = prints.stream().mapToInt(each -> {
            ToolTipComponent.ToolTipType type = each.getType();
            if (type.equals(ToolTipComponent.ToolTipType.TEXT)) {
                return 20;
            }
            if (type.equals(ToolTipComponent.ToolTipType.IMAGE)) {
                return ((BufferedImage)each.getToolTipComponent()).getHeight() + 16;
            }
            return 0;
        }).sum() + 15;
        BufferedImage image = new BufferedImage(2240, requiredHeight, 2);
        Graphics2D g = image.createGraphics();
        int topX = image.getWidth() / 5 * 2;
        int currentY = 8;
        for (ToolTipComponent<?> print : prints) {
            ToolTipComponent.ToolTipType<?> type = print.getType();
            if (type.equals(ToolTipComponent.ToolTipType.TEXT)) {
                ImageUtils.printComponent(resourceManager.get(), image, (Component)print.getToolTipComponent(), InteractiveChatDiscordSrvAddon.plugin.language, version.get().isLegacyRGB(), topX + 8, currentY, 16.0f);
                currentY += 20;
                continue;
            }
            if (!type.equals(ToolTipComponent.ToolTipType.IMAGE)) continue;
            BufferedImage componentImage = (BufferedImage)print.getToolTipComponent();
            g.drawImage((Image)componentImage, topX + 8, currentY += 5, null);
            currentY += componentImage.getHeight() + 11;
        }
        g.dispose();
        int firstX = 0;
        block3: for (int x = 0; x < image.getWidth() - 9; ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                if (image.getRGB(x, y) == 0) continue;
                firstX = x;
                break block3;
            }
        }
        int lastX = 0;
        block5: for (int x = firstX; x < image.getWidth() - 9; ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                if (image.getRGB(x, y) == 0) continue;
                lastX = x;
                continue block5;
            }
        }
        firstX = Math.max(0, firstX - 8);
        BufferedImage background = new BufferedImage(lastX - topX + 9, image.getHeight(), 2);
        Graphics2D g2 = background.createGraphics();
        g2.setColor(TOOLTIP_BACKGROUND_COLOR);
        g2.fillRect(2, 0, background.getWidth() - 4, background.getHeight());
        g2.fillRect(0, 2, 2, background.getHeight() - 4);
        g2.fillRect(background.getWidth() - 2, 2, 2, background.getHeight() - 4);
        g2.setColor(TOOLTIP_OUTLINE_TOP_COLOR);
        g2.fillRect(4, 2, background.getWidth() - 8, 2);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, TOOLTIP_OUTLINE_TOP_COLOR, 0.0f, background.getHeight() - 4, TOOLTIP_OUTLINE_BOTTOM_COLOR);
        g2.setPaint(gradientPaint);
        g2.fillRect(2, 2, 2, background.getHeight() - 4);
        g2.fillRect(background.getWidth() - 4, 2, 2, background.getHeight() - 4);
        g2.setColor(TOOLTIP_OUTLINE_BOTTOM_COLOR);
        g2.fillRect(4, background.getHeight() - 4, background.getWidth() - 8, 2);
        g2.dispose();
        int offsetX = Math.max(topX - firstX, 0);
        BufferedImage output = new BufferedImage(offsetX + background.getWidth(), background.getHeight(), 2);
        Graphics2D g3 = output.createGraphics();
        g3.drawImage((Image)background, offsetX, 0, null);
        g3.drawImage((Image)image, -firstX, 0, null);
        g3.dispose();
        return output;
    }

    public static BufferedImage getTabListImage(List<Component> header, List<Component> footer, List<ValueTrios<UUID, Component, Integer>> players, boolean showAvatar, boolean showPing) {
        return ImageGeneration.getTabListImage(header, footer, players, showAvatar, showPing, 80);
    }

    public static BufferedImage getTabListImage(List<Component> header, List<Component> footer, List<ValueTrios<UUID, Component, Integer>> players, boolean showAvatar, boolean showPing, int maxPlayerDisplayed) {
        players = players.subList(0, Math.min(players.size(), maxPlayerDisplayed));
        ArrayList<ValuePairs> playerImages = new ArrayList<ValuePairs>(players.size());
        int masterOffsetX = 0;
        for (ValueTrios<UUID, Component, Integer> valueTrios : players) {
            UUID uUID = (UUID)valueTrios.getFirst();
            Component component = (Component)valueTrios.getSecond();
            int ping = (Integer)valueTrios.getThird();
            BufferedImage image = new BufferedImage(2048, 146, 2);
            Graphics2D g = image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            int offsetX = 0;
            if (showAvatar) {
                BufferedImage skin;
                try {
                    String value;
                    Player onlinePlayer = Bukkit.getPlayer((UUID)uUID);
                    if (onlinePlayer == null) {
                        CacheObject<?> cache = resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).getCache(uUID + "null" + PLAYER_SKIN_CACHE_KEY);
                        if (cache == null) {
                            value = SkinUtils.getSkinURLFromUUID((UUID)uUID);
                            skin = ImageUtils.downloadImage(value);
                            resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).putCache(uUID + "null" + PLAYER_SKIN_CACHE_KEY, skin);
                            skin = ImageUtils.copyImage(skin);
                        } else {
                            skin = ImageUtils.copyImage((BufferedImage)cache.getObject());
                        }
                    } else {
                        try {
                            JSONObject json = (JSONObject)new JSONParser().parse(SkinUtils.getSkinJsonFromProfile((Player)onlinePlayer));
                            value = (String)((JSONObject)((JSONObject)json.get((Object)"textures")).get((Object)"SKIN")).get((Object)"url");
                            CacheObject<?> cache = resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).getCache(uUID + value + PLAYER_SKIN_CACHE_KEY);
                            if (cache == null) {
                                skin = ImageUtils.downloadImage(value);
                                resourceManager.get().getResourceRegistry("CacheManager", ICacheManager.class).putCache(uUID + value + PLAYER_SKIN_CACHE_KEY, skin);
                            } else {
                                skin = (BufferedImage)cache.getObject();
                            }
                            skin = ImageUtils.copyImage(skin);
                        }
                        catch (Exception e) {
                            value = SkinUtils.getSkinURLFromUUID((UUID)uUID);
                            skin = ImageUtils.downloadImage(value);
                        }
                    }
                }
                catch (Exception e) {
                    skin = resourceManager.get().getTextureManager().getTexture("minecraft:entity/steve").getTexture(64, 64);
                }
                BufferedImage avatar = ImageUtils.copyAndGetSubImage(skin, 8, 8, 8, 8);
                BufferedImage avatarOverlay = ImageUtils.copyAndGetSubImage(skin, 40, 8, 8, 8);
                if (ModelUtils.isRenderedUpsideDown(component)) {
                    avatar = ImageUtils.rotateImageByDegrees(avatar, 180.0);
                    avatarOverlay = ImageUtils.rotateImageByDegrees(avatarOverlay, 180.0);
                }
                g.drawImage(avatar, offsetX, 64, 16, 16, null);
                g.drawImage(avatarOverlay, offsetX, 64, 16, 16, null);
                offsetX += 18;
            } else {
                offsetX += 2;
            }
            g.dispose();
            ImageUtils.printComponent(resourceManager.get(), image, component, InteractiveChatDiscordSrvAddon.plugin.language, version.get().isLegacyRGB(), offsetX, 63, 16.0f);
            int lastX = InteractiveChatDiscordSrvAddon.plugin.playerlistCommandMinWidth;
            block5: for (int x = InteractiveChatDiscordSrvAddon.plugin.playerlistCommandMinWidth; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    if (image.getRGB(x, y) == 0) continue;
                    lastX = x;
                    continue block5;
                }
            }
            if (lastX > masterOffsetX) {
                masterOffsetX = lastX;
            }
            playerImages.add(new ValuePairs((Object)image, (Object)ping));
        }
        ArrayList<BufferedImage> playerRows = new ArrayList<BufferedImage>(playerImages.size());
        masterOffsetX = showPing ? (masterOffsetX += 26) : (masterOffsetX += 2);
        for (ValuePairs valuePairs : playerImages) {
            Graphics2D g;
            BufferedImage bufferedImage = (BufferedImage)valuePairs.getFirst();
            if (showPing) {
                BufferedImage ping = ImageGeneration.getPingIcon((Integer)valuePairs.getSecond(), false);
                g = bufferedImage.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g.drawImage((Image)ImageUtils.resizeImageAbs(ping, 20, 14), masterOffsetX - 22, 66, null);
                g.dispose();
            }
            BufferedImage cropped = new BufferedImage(masterOffsetX, 146, 2);
            g = cropped.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.setColor(TABLIST_PLAYER_BACKGROUND);
            g.fillRect(0, 64, cropped.getWidth(), 16);
            g.drawImage((Image)bufferedImage, 0, 0, null);
            g.dispose();
            playerRows.add(cropped);
        }
        LinkedHashMap<BufferedImage, Integer> linkedHashMap = new LinkedHashMap<BufferedImage, Integer>(header.size());
        for (Component component : header) {
            BufferedImage image = new BufferedImage(2048, 146, 2);
            ImageUtils.printComponent(resourceManager.get(), image, component, InteractiveChatDiscordSrvAddon.plugin.language, version.get().isLegacyRGB(), 0, 63, 16.0f);
            int lastX = 0;
            block9: for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    if (image.getRGB(x, y) == 0) continue;
                    lastX = x;
                    continue block9;
                }
            }
            BufferedImage cropped = new BufferedImage(Math.max(1, lastX), 146, 2);
            Graphics2D g = cropped.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            linkedHashMap.put(cropped, lastX);
        }
        LinkedHashMap<BufferedImage, Integer> linkedHashMap2 = new LinkedHashMap<BufferedImage, Integer>(footer.size());
        for (Component line : footer) {
            BufferedImage image = new BufferedImage(2048, 146, 2);
            ImageUtils.printComponent(resourceManager.get(), image, line, InteractiveChatDiscordSrvAddon.plugin.language, version.get().isLegacyRGB(), 0, 63, 16.0f);
            int lastX = 0;
            block12: for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    if (image.getRGB(x, y) == 0) continue;
                    lastX = x;
                    continue block12;
                }
            }
            BufferedImage cropped = new BufferedImage(Math.max(1, lastX), 146, 2);
            Graphics2D g = cropped.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            linkedHashMap2.put(cropped, lastX);
        }
        int n = (playerRows.size() - 1) / 20 + 1;
        int playersPerColumn = (int)Math.ceil((double)playerRows.size() / (double)n);
        BufferedImage image = new BufferedImage((masterOffsetX + 2) * n + 2, playersPerColumn * 18 + 2, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setColor(TABLIST_BACKGROUND);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        int baseOffsetY = -62;
        int startingIndex = 0;
        for (int column = 0; column < n; ++column) {
            int offsetY = baseOffsetY;
            for (int u = 0; u < playersPerColumn; ++u) {
                int i = startingIndex + u;
                if (i < playerRows.size()) {
                    g.drawImage((Image)playerRows.get(i), 2 + (masterOffsetX + 2) * column, offsetY, null);
                }
                offsetY += 18;
            }
            startingIndex += playersPerColumn;
        }
        g.dispose();
        int maxOffsetX = Stream.concat(linkedHashMap.values().stream(), linkedHashMap2.values().stream()).mapToInt(each -> each).max().orElse(0);
        if (maxOffsetX <= 0) {
            return image;
        }
        BufferedImage decoration = new BufferedImage(Math.max(image.getWidth(), maxOffsetX + 4), (linkedHashMap.isEmpty() ? 0 : linkedHashMap.size() * 18 + 2) + image.getHeight() + (linkedHashMap2.isEmpty() ? 2 : linkedHashMap2.size() * 18 + 4), 2);
        Graphics2D g2 = decoration.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        int offsetY = -62;
        for (BufferedImage each2 : linkedHashMap.keySet()) {
            g2.drawImage((Image)each2, decoration.getWidth() / 2 - each2.getWidth() / 2, offsetY, null);
            offsetY += 18;
        }
        g2.drawImage((Image)image, decoration.getWidth() / 2 - image.getWidth() / 2, offsetY + 64, null);
        offsetY += image.getHeight() + 2;
        for (BufferedImage each2 : linkedHashMap2.keySet()) {
            g2.drawImage((Image)each2, decoration.getWidth() / 2 - each2.getWidth() / 2, offsetY, null);
            offsetY += 18;
        }
        g2.dispose();
        int lastY = offsetY + 62;
        block18: for (int y = offsetY + 62; y < decoration.getHeight(); ++y) {
            for (int x = 0; x < decoration.getWidth(); ++x) {
                if (decoration.getRGB(x, y) == 0) continue;
                lastY = y;
                continue block18;
            }
        }
        BufferedImage finalDecoration = new BufferedImage(decoration.getWidth(), lastY + 3, 2);
        Graphics2D g3 = finalDecoration.createGraphics();
        g3.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g3.setColor(TABLIST_BACKGROUND);
        g3.fillRect(0, 0, finalDecoration.getWidth(), finalDecoration.getHeight());
        g3.drawImage((Image)decoration, 0, 0, null);
        g3.dispose();
        return finalDecoration;
    }

    public static GenericContainerBackgroundResult getGenericContainerBackground(int rows, ContainerTitlePrintingFunction titlePrintingFunction) {
        int lastY;
        int firstY;
        int y;
        int lastX;
        int firstX;
        rows = Math.max(rows, 1);
        BufferedImage image = resourceManager.get().getTextureManager().getTexture("minecraft:interactivechatdiscordsrvaddon/gui/generic_54").getTexture(356, 268);
        if (rows < 6) {
            BufferedImage head = image.getSubimage(0, 0, 356, 36 + 36 * rows);
            BufferedImage tail = image.getSubimage(0, 252, 356, 16);
            image = ImageUtils.appendImageBottom(head, tail, 0, 0);
        }
        BufferedImage expanded = new BufferedImage(image.getWidth() * 3, image.getHeight() * 3, 2);
        expanded = titlePrintingFunction.apply(expanded, 18 + image.getWidth(), 13 + image.getHeight(), 16.0f, INVENTORY_DEFAULT_FONT_COLOR);
        block0: for (int x = firstX = image.getWidth(); x >= 0; --x) {
            for (int y2 = 0; y2 < expanded.getHeight(); ++y2) {
                if (expanded.getRGB(x, y2) == 0) continue;
                firstX = x;
                continue block0;
            }
        }
        block2: for (int x = lastX = image.getWidth() * 2; x < expanded.getWidth(); ++x) {
            for (y = 0; y < expanded.getHeight(); ++y) {
                if (expanded.getRGB(x, y) == 0) continue;
                lastX = x + 1;
                continue block2;
            }
        }
        block4: for (y = firstY = image.getHeight(); y >= 0; --y) {
            for (int x = firstX; x < lastX; ++x) {
                if (expanded.getRGB(x, y) == 0) continue;
                firstY = y;
                continue block4;
            }
        }
        block6: for (int y3 = lastY = image.getHeight() * 2; y3 < expanded.getHeight(); ++y3) {
            for (int x = firstX; x < lastX; ++x) {
                if (expanded.getRGB(x, y3) == 0) continue;
                lastY = y3 + 1;
                continue block6;
            }
        }
        int expandedX = image.getWidth() - firstX;
        int expandedY = image.getHeight() - firstY;
        BufferedImage resultImage = new BufferedImage(lastX - firstX, lastY - firstY, 2);
        Graphics2D g = resultImage.createGraphics();
        g.drawImage((Image)image, expandedX, expandedY, null);
        g.drawImage((Image)expanded, -firstX, -firstY, null);
        g.dispose();
        return new GenericContainerBackgroundResult(resultImage, expandedX, expandedY);
    }

    public static BufferedImage getPingIcon(int ms, boolean useNoConnectionIcon) {
        BufferedImage icons = resourceManager.get().getTextureManager().getTexture("minecraft:gui/icons").getTexture();
        int scale = icons.getWidth() / 256;
        if (ms < 0) {
            return ImageUtils.copyAndGetSubImage(icons, 0, 56 * scale, 10 * scale, 7 * scale);
        }
        if (ms < 150) {
            return ImageUtils.copyAndGetSubImage(icons, 0, 16 * scale, 10 * scale, 7 * scale);
        }
        if (ms < 300) {
            return ImageUtils.copyAndGetSubImage(icons, 0, 24 * scale, 10 * scale, 7 * scale);
        }
        if (ms < 600) {
            return ImageUtils.copyAndGetSubImage(icons, 0, 32 * scale, 10 * scale, 7 * scale);
        }
        if (!useNoConnectionIcon || ms < 1000) {
            return ImageUtils.copyAndGetSubImage(icons, 0, 40 * scale, 10 * scale, 7 * scale);
        }
        return ImageUtils.copyAndGetSubImage(icons, 0, 48 * scale, 10 * scale, 7 * scale);
    }

    public static BufferedImage getAdvancementFrame(AdvancementType advancementType, boolean completed) {
        if (advancementType.isLegacy()) {
            BufferedImage icons = resourceManager.get().getTextureManager().getTexture("minecraft:gui/achievement/achievement_background").getTexture();
            int scale = icons.getWidth() / 256;
            return ImageUtils.copyAndGetSubImage(icons, 0, 202 * scale, 26 * scale, 26 * scale);
        }
        BufferedImage icons = resourceManager.get().getTextureManager().getTexture("minecraft:gui/advancements/widgets").getTexture();
        int scale = icons.getWidth() / 256;
        int offsetY = completed ? 0 : 26 * scale;
        switch (advancementType) {
            case CHALLENGE: {
                return ImageUtils.copyAndGetSubImage(icons, 26 * scale, 128 * scale + offsetY, 26 * scale, 26 * scale);
            }
            case GOAL: {
                return ImageUtils.copyAndGetSubImage(icons, 52 * scale, 128 * scale + offsetY, 26 * scale, 26 * scale);
            }
        }
        return ImageUtils.copyAndGetSubImage(icons, 0, 128 * scale + offsetY, 26 * scale, 26 * scale);
    }

    public static BufferedImage getBundleContainerInterface(OfflineICPlayer offlineICPlayer, List<ItemStack> items) throws IOException {
        BufferedImage icons = resourceManager.get().getTextureManager().getTexture("minecraft:gui/container/bundle").getTexture(256, 256);
        int gridWidth = BundleUtils.getContainerGridSizeX(items.size());
        int gridHeight = BundleUtils.getContainerGridSizeY(items.size());
        boolean isFull = BundleUtils.getFullness(items) >= 64;
        BufferedImage image = new BufferedImage(36 * gridWidth + 4, 40 * gridHeight + 4, 2);
        Graphics2D g = image.createGraphics();
        BufferedImage topCorner = ImageUtils.copyAndGetSubImage(icons, 0, 40, 2, 2);
        g.drawImage((Image)topCorner, 0, 0, null);
        g.drawImage((Image)topCorner, image.getWidth() - 2, 0, null);
        BufferedImage horizontalTop = ImageUtils.copyAndGetSubImage(icons, 0, 40, 36, 2);
        BufferedImage horizontalBottom = ImageUtils.copyAndGetSubImage(icons, 0, 120, 36, 2);
        for (int x = 2; x < image.getWidth() - 2; x += horizontalTop.getWidth()) {
            g.drawImage((Image)horizontalTop, x, 0, null);
            g.drawImage((Image)horizontalBottom, x, image.getHeight() - 2, null);
        }
        BufferedImage vertical = ImageUtils.copyAndGetSubImage(icons, 0, 36, 2, 40);
        for (int y = 2; y < image.getHeight() - 2; y += vertical.getHeight()) {
            g.drawImage((Image)vertical, 0, y, null);
            g.drawImage((Image)vertical, image.getWidth() - 2, y, null);
        }
        BufferedImage bottomCorner = ImageUtils.copyAndGetSubImage(icons, 0, 120, 2, 2);
        g.drawImage((Image)bottomCorner, 0, image.getHeight() - 2, null);
        g.drawImage((Image)bottomCorner, image.getWidth() - 2, image.getHeight() - 2, null);
        BufferedImage slot = ImageUtils.copyAndGetSubImage(icons, 0, 0, 36, 40);
        BufferedImage fullSlot = ImageUtils.copyAndGetSubImage(icons, 0, 80, 36, 40);
        int i = -1;
        for (int y = 2; y < image.getHeight() - 2; y += vertical.getHeight()) {
            for (int x = 2; x < image.getWidth() - 2; x += horizontalTop.getWidth()) {
                if (++i < items.size()) {
                    g.drawImage((Image)slot, x, y, null);
                    BufferedImage itemImage = ImageGeneration.getRawItemImage(items.get(i), offlineICPlayer);
                    g.drawImage((Image)itemImage, x + 2, y + 2, null);
                    continue;
                }
                g.drawImage((Image)(isFull ? fullSlot : slot), x, y, null);
            }
        }
        g.dispose();
        return image;
    }

    public static Future<List<BufferedImage>> getBookInterface(List<Component> pages) {
        CompletableFuture<List<BufferedImage>> future = new CompletableFuture<List<BufferedImage>>();
        List<Supplier<BufferedImage>> suppliers = ImageGeneration.getBookInterfaceSuppliers(pages);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> future.complete(suppliers.stream().map(each -> (BufferedImage)each.get()).collect(Collectors.toList())));
        return future;
    }

    public static List<Supplier<BufferedImage>> getBookInterfaceSuppliers(List<Component> pages) {
        BufferedImage icons = resourceManager.get().getTextureManager().getTexture("minecraft:gui/book").getTexture(512, 512);
        BufferedImage background = ImageUtils.copyAndGetSubImage(icons, 38, 0, 296, 364);
        BufferedImage nextPage = ImageUtils.copyAndGetSubImage(icons, 6, 388, 36, 20);
        BufferedImage previousPage = ImageUtils.copyAndGetSubImage(icons, 6, 414, 36, 20);
        int totalPages = pages.size();
        ArrayList<Supplier<BufferedImage>> result = new ArrayList<Supplier<BufferedImage>>(totalPages);
        int i = 0;
        for (Component component : pages) {
            int pageNumber = ++i;
            result.add(() -> {
                BufferedImage page = ImageUtils.copyImage(background);
                Graphics2D g = page.createGraphics();
                if (pageNumber < totalPages) {
                    g.drawImage((Image)nextPage, 201, 317, null);
                }
                if (pageNumber > 1) {
                    g.drawImage((Image)previousPage, 54, 317, null);
                }
                Component pageHeader = Component.translatable((String)TranslationKeyUtils.getBookPageIndicator()).args(new ComponentLike[]{Component.text((int)pageNumber), Component.text((int)totalPages)}).color((TextColor)NamedTextColor.BLACK);
                ImageUtils.printComponentRightAligned(resourceManager.get(), page, pageHeader, InteractiveChatDiscordSrvAddon.plugin.language, InteractiveChat.version.isLegacyRGB(), 255, 30, 16.0f, 0.0);
                final BufferedImage temp = new BufferedImage(100, 100, 2);
                ArrayList<Component> lines = new ArrayList<Component>();
                lines.addAll(ComponentStringUtils.applyWordWrap(component, resourceManager.get().getLanguageManager().getTranslateFunction().ofLanguage(InteractiveChatDiscordSrvAddon.plugin.language), 230, new ToIntFunction<ComponentStringUtils.CharacterLengthProviderData>(){
                    int lastItalicExtraWidth = 0;

                    @Override
                    public int applyAsInt(ComponentStringUtils.CharacterLengthProviderData data) {
                        String character = data.getCharacter();
                        MinecraftFont.FontRenderResult renderResult = ((ResourceManager)resourceManager.get()).getFontManager().getFontProviders(data.getFont()).forCharacter(character).printCharacter(temp, character, 0, 0, 16.0f, this.lastItalicExtraWidth, (TextColor)NamedTextColor.BLACK, data.getDecorations());
                        this.lastItalicExtraWidth = renderResult.getItalicExtraWidth();
                        return renderResult.getWidth() + renderResult.getSpaceWidth();
                    }
                }));
                int y = 58;
                for (Component each : lines) {
                    each = each.colorIfAbsent((TextColor)NamedTextColor.BLACK);
                    ImageUtils.printComponent(resourceManager.get(), page, each, InteractiveChatDiscordSrvAddon.plugin.language, InteractiveChat.version.isLegacyRGB(), 34, y, 16.0f, 0.0);
                    y += 18;
                }
                g.dispose();
                return page;
            });
        }
        return result;
    }

    public static class GenericContainerBackgroundResult {
        private BufferedImage image;
        private int expandedX;
        private int expandedY;

        private GenericContainerBackgroundResult(BufferedImage image, int expandedX, int expandedY) {
            this.image = image;
            this.expandedX = expandedX;
            this.expandedY = expandedY;
        }

        public BufferedImage getBackgroundImage() {
            return this.image;
        }

        public int getExpandedX() {
            return this.expandedX;
        }

        public int getExpandedY() {
            return this.expandedY;
        }
    }
}

