/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.graphics;

import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageFrame;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.madgag.gif.fmsware.GifDecoder;
import com.loohp.interactivechatdiscordsrvaddon.utils.ThrowingSupplier;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GifReader {
    public static Future<List<ImageFrame>> readGif(InputStream stream, ExecutorService service, BiConsumer<List<ImageFrame>, Throwable> completeAction) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[2048];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        stream.close();
        byte[] targetArray = buffer.toByteArray();
        return service.submit(() -> {
            try {
                List<ImageFrame> result = GifReader.returnOrNull(() -> GifReader.readGifMethod0(new ByteArrayInputStream(targetArray)));
                if (result != null) {
                    completeAction.accept(result, null);
                    return result;
                }
                result = GifReader.returnOrNull(() -> GifReader.readGifMethod1(new ByteArrayInputStream(targetArray)));
                if (result != null) {
                    completeAction.accept(result, null);
                    return result;
                }
                List<ImageFrame> frames = GifReader.returnOrNull(() -> GifReader.readGifFallbackMethod(new ByteArrayInputStream(targetArray)));
                completeAction.accept(frames, null);
                return frames;
            }
            catch (Throwable e) {
                completeAction.accept(null, e);
                return null;
            }
        });
    }

    private static List<ImageFrame> returnOrNull(ThrowingSupplier<List<ImageFrame>> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static List<ImageFrame> readGifMethod0(InputStream stream) throws IOException {
        GifDecoder reader = new GifDecoder();
        if (reader.read(stream) == 0) {
            ArrayList<ImageFrame> frames = new ArrayList<ImageFrame>(reader.getFrameCount());
            for (int i = 0; i < reader.getFrameCount(); ++i) {
                BufferedImage image = reader.getFrame(i);
                int delay = reader.getDelay(i);
                frames.add(new ImageFrame(image, delay, ""));
            }
            return frames;
        }
        throw new IOException("Unable to read Gif");
    }

    private static List<ImageFrame> readGifMethod1(InputStream input) throws IOException {
        IIOMetadataNode screenDescriptor;
        IIOMetadataNode globalRoot;
        NodeList globalScreenDescriptor;
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        reader.setInput(stream);
        LinkedList<ImageFrame> frames = new LinkedList<ImageFrame>();
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        if (metadata != null && (globalScreenDescriptor = (globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName())).getElementsByTagName("LogicalScreenDescriptor")) != null && globalScreenDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreenDescriptor.item(0)) != null) {
            width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
            height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
        }
        BufferedImage master = null;
        Graphics2D masterGraphics = null;
        int frameIndex = 0;
        while (true) {
            BufferedImage image;
            try {
                image = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException io) {
                break;
            }
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            int delay = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
            String disposal = gce.getAttribute("disposalMethod");
            int x = 0;
            int y = 0;
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else {
                NodeList children = root.getChildNodes();
                for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    NamedNodeMap map = nodeItem.getAttributes();
                    x = Integer.parseInt(map.getNamedItem("imageLeftPosition").getNodeValue());
                    y = Integer.parseInt(map.getNamedItem("imageTopPosition").getNodeValue());
                }
            }
            masterGraphics.drawImage((Image)image, x, y, null);
            BufferedImage copy = new BufferedImage(master.getColorModel(), master.copyData(null), master.isAlphaPremultiplied(), null);
            frames.add(new ImageFrame(copy, delay, disposal));
            if (disposal.equals("restoreToPrevious")) {
                BufferedImage from = null;
                for (int i = frameIndex - 1; i >= 0; --i) {
                    if (((ImageFrame)frames.get(i)).getDisposal().equals("restoreToPrevious") && frameIndex != 0) continue;
                    from = ((ImageFrame)frames.get(i)).getImage();
                    break;
                }
                master = new BufferedImage(from.getColorModel(), from.copyData(null), from.isAlphaPremultiplied(), null);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else if (disposal.equals("restoreToBackgroundColor")) {
                masterGraphics.clearRect(x, y, image.getWidth(), image.getHeight());
            }
            ++frameIndex;
        }
        reader.dispose();
        return frames;
    }

    private static List<ImageFrame> readGifFallbackMethod(InputStream input) throws IOException {
        return Collections.singletonList(new ImageFrame(ImageIO.read(input)));
    }
}

