/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.graphics;

import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechat.utils.XMaterialUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.wrappers.PatternTypeWrapper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;

public class BannerGraphics {
    public static BannerAssetResult generateBannerAssets(ItemStack item) {
        List patterns;
        BufferedImage baseImage = InteractiveChatDiscordSrvAddon.plugin.resourceManager.getTextureManager().getTexture("minecraft:entity/banner_base").getTexture(64, 64);
        BufferedImage patternsImage = new BufferedImage(64, 64, 2);
        XMaterial xMaterial = XMaterialUtils.matchXMaterial((ItemStack)item);
        String colorName = xMaterial.name().replace("_BANNER", "");
        Color baseColor = new Color(DyeColor.valueOf((String)colorName.toUpperCase()).getColor().asRGB());
        BufferedImage baseTint = new BufferedImage(42, 41, 2);
        Graphics2D g = baseTint.createGraphics();
        g.setColor(baseColor);
        g.fillRect(0, 0, 42, 41);
        g.dispose();
        baseImage = ImageUtils.add(ImageUtils.multiply(baseImage, baseTint, true), 40);
        if (!item.hasItemMeta()) {
            return new BannerAssetResult(baseImage, patternsImage);
        }
        if (!(item.getItemMeta() instanceof BannerMeta)) {
            if (!(item.getItemMeta() instanceof BlockStateMeta)) {
                return new BannerAssetResult(baseImage, patternsImage);
            }
            BlockStateMeta bmeta = (BlockStateMeta)item.getItemMeta();
            Banner bannerBlockMeta = (Banner)bmeta.getBlockState();
            patterns = bannerBlockMeta.getPatterns();
        } else {
            BannerMeta meta = (BannerMeta)item.getItemMeta();
            patterns = meta.getPatterns();
        }
        Graphics2D g2 = patternsImage.createGraphics();
        for (Pattern pattern : patterns) {
            PatternTypeWrapper type = PatternTypeWrapper.fromPatternType(pattern.getPattern());
            Color color = new Color(pattern.getColor().getColor().asRGB());
            BufferedImage image = InteractiveChatDiscordSrvAddon.plugin.resourceManager.getTextureManager().getTexture("minecraft:entity/banner/" + type.getAssetName()).getTexture(64, 64);
            BufferedImage tint = new BufferedImage(64, 64, 2);
            Graphics2D g3 = tint.createGraphics();
            g3.setColor(color);
            g3.fillRect(0, 0, 64, 64);
            g3.dispose();
            image = ImageUtils.add(ImageUtils.multiply(image, tint), 40);
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.dispose();
        return new BannerAssetResult(baseImage, patternsImage);
    }

    public static BannerAssetResult generateShieldAssets(ItemStack item) {
        Color baseColor;
        List patterns;
        if (!item.hasItemMeta()) {
            return BannerGraphics.getDefaultShieldAssets();
        }
        if (!(item.getItemMeta() instanceof BannerMeta)) {
            if (!(item.getItemMeta() instanceof BlockStateMeta)) {
                return BannerGraphics.getDefaultShieldAssets();
            }
            BlockStateMeta bmeta = (BlockStateMeta)item.getItemMeta();
            if (!bmeta.hasBlockState()) {
                return BannerGraphics.getDefaultShieldAssets();
            }
            Banner bannerBlockMeta = (Banner)bmeta.getBlockState();
            patterns = bannerBlockMeta.getPatterns();
            baseColor = new Color(bannerBlockMeta.getBaseColor().getColor().asRGB());
        } else {
            BannerMeta meta = (BannerMeta)item.getItemMeta();
            patterns = meta.getPatterns();
            baseColor = new Color(meta.getBaseColor().getColor().asRGB());
        }
        BufferedImage baseImage = InteractiveChatDiscordSrvAddon.plugin.resourceManager.getTextureManager().getTexture("minecraft:entity/shield_base").getTexture(64, 64);
        BufferedImage patternsImage = new BufferedImage(64, 64, 2);
        BufferedImage baseTint = new BufferedImage(12, 22, 2);
        Graphics2D g = baseTint.createGraphics();
        g.setColor(baseColor);
        g.fillRect(2, 2, 10, 20);
        g.dispose();
        baseImage = ImageUtils.add(ImageUtils.multiply(baseImage, baseTint, true), 40);
        Graphics2D g2 = patternsImage.createGraphics();
        for (Pattern pattern : patterns) {
            PatternTypeWrapper type = PatternTypeWrapper.fromPatternType(pattern.getPattern());
            Color color = new Color(pattern.getColor().getColor().asRGB());
            BufferedImage image = InteractiveChatDiscordSrvAddon.plugin.resourceManager.getTextureManager().getTexture("minecraft:entity/shield/" + type.getAssetName()).getTexture(64, 64);
            BufferedImage tint = new BufferedImage(64, 64, 2);
            Graphics2D g3 = tint.createGraphics();
            g3.setColor(color);
            g3.fillRect(0, 0, 64, 64);
            g3.dispose();
            image = ImageUtils.add(ImageUtils.multiply(image, tint), 40);
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.dispose();
        return new BannerAssetResult(baseImage, patternsImage);
    }

    private static BannerAssetResult getDefaultShieldAssets() {
        return new BannerAssetResult(InteractiveChatDiscordSrvAddon.plugin.resourceManager.getTextureManager().getTexture("minecraft:entity/shield_base_nopattern").getTexture(), new BufferedImage(64, 64, 2));
    }

    public static class BannerAssetResult {
        private BufferedImage base;
        private BufferedImage patterns;

        public BannerAssetResult(BufferedImage base, BufferedImage patterns) {
            this.base = base;
            this.patterns = patterns;
        }

        public BufferedImage getBase() {
            return this.base;
        }

        public BufferedImage getPatterns() {
            return this.patterns;
        }
    }
}

