/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechat.utils.FileUtils;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import com.loohp.interactivechat.utils.HashUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.libs.LibraryDownloadManager;
import com.loohp.interactivechatdiscordsrvaddon.libs.LibraryLoader;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceDownloadManager;
import com.loohp.interactivechatdiscordsrvaddon.utils.ResourcePackUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class AssetsDownloader {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.0");
    private static final ReentrantLock LOCK = new ReentrantLock(true);

    public static void loadAssets(File rootFolder, boolean force, boolean clean, CommandSender ... senders) throws Exception {
        if (!Arrays.asList(senders).contains(Bukkit.getConsoleSender())) {
            ArrayList<CommandSender> senderList = new ArrayList<CommandSender>(Arrays.asList(senders));
            senderList.add((CommandSender)Bukkit.getConsoleSender());
            senders = senderList.toArray(new CommandSender[senderList.size()]);
        }
        if (!LOCK.tryLock(0L, TimeUnit.MILLISECONDS)) {
            return;
        }
        try {
            JSONObject json;
            File hashes = new File(rootFolder, "hashes.json");
            if (!hashes.exists()) {
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(hashes.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    pw.println("{}");
                    pw.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try (InputStreamReader hashReader = new InputStreamReader(Files.newInputStream(hashes.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                json = (JSONObject)new JSONParser().parse((Reader)hashReader);
            }
            catch (Throwable e) {
                new RuntimeException("Invalid hashes.json! It will be reset.", e).printStackTrace();
                json = new JSONObject();
            }
            InteractiveChatDiscordSrvAddon.plugin.defaultResourceHash = json.containsKey((Object)"Default") ? json.get((Object)"Default").toString() : "EMPTY";
            String oldHash = InteractiveChatDiscordSrvAddon.plugin.defaultResourceHash;
            String oldVersion = json.containsKey((Object)"version") ? json.get((Object)"version").toString() : "EMPTY";
            File defaultAssetsFolder = new File(rootFolder + "/built-in", "Default");
            defaultAssetsFolder.mkdirs();
            ResourceDownloadManager downloadManager = new ResourceDownloadManager(InteractiveChat.exactMinecraftVersion, defaultAssetsFolder);
            String hash = downloadManager.getHash();
            if (force || !hash.equals(oldHash) || !InteractiveChatDiscordSrvAddon.plugin.getDescription().getVersion().equals(oldVersion)) {
                if (clean) {
                    InteractiveChatDiscordSrvAddon.plugin.sendMessage(ChatColor.AQUA + "[ICDiscordSrvAddon] Cleaning old default resources!", senders);
                    FileUtils.removeFolderRecursively((File)defaultAssetsFolder);
                    defaultAssetsFolder.mkdirs();
                }
                if (force) {
                    InteractiveChatDiscordSrvAddon.plugin.sendMessage(ChatColor.AQUA + "[ICDiscordSrvAddon] Forcibly re-downloading default resources! Please wait... (" + oldHash + " -> " + hash + ")", senders);
                } else if (!hash.equals(oldHash)) {
                    InteractiveChatDiscordSrvAddon.plugin.sendMessage(ChatColor.AQUA + "[ICDiscordSrvAddon] Hash changed! Re-downloading default resources! Please wait... (" + oldHash + " -> " + hash + ")", senders);
                } else {
                    InteractiveChatDiscordSrvAddon.plugin.sendMessage(ChatColor.AQUA + "[ICDiscordSrvAddon] Plugin version changed! Re-downloading default resources! Please wait... (" + oldHash + " -> " + hash + ")", senders);
                }
                downloadManager.downloadResources((type, fileName, percentage) -> {
                    switch (type) {
                        case CLIENT_DOWNLOAD: {
                            if (InteractiveChatDiscordSrvAddon.plugin.reducedAssetsDownloadInfo) break;
                            Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "[ICDiscordSrvAddon] Downloading client jar");
                            break;
                        }
                        case EXTRACT: {
                            if (InteractiveChatDiscordSrvAddon.plugin.reducedAssetsDownloadInfo) break;
                            Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "[ICDiscordSrvAddon] Extracting " + fileName);
                            break;
                        }
                        case DOWNLOAD: {
                            if (InteractiveChatDiscordSrvAddon.plugin.reducedAssetsDownloadInfo) break;
                            Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "[ICDiscordSrvAddon] Downloading " + fileName + " (" + FORMAT.format(percentage) + "%)");
                            break;
                        }
                        case DONE: {
                            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[ICDiscordSrvAddon] Done!");
                        }
                    }
                });
            }
            downloadManager.downloadExtras(() -> InteractiveChatDiscordSrvAddon.plugin.extras.clear(), (key, dataBytes) -> InteractiveChatDiscordSrvAddon.plugin.extras.put((String)key, (byte[])dataBytes));
            InteractiveChatDiscordSrvAddon.plugin.defaultResourceHash = hash;
            json.put((Object)"Default", (Object)hash);
            json.put((Object)"version", (Object)InteractiveChatDiscordSrvAddon.plugin.getDescription().getVersion());
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(hashes.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                Gson g = new GsonBuilder().setPrettyPrinting().create();
                pw.println(g.toJson(new JsonParser().parse(json.toString())));
                pw.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOCK.unlock();
    }

    public static void loadExtras() {
        ResourceDownloadManager downloadManager = new ResourceDownloadManager(InteractiveChat.exactMinecraftVersion, null);
        downloadManager.downloadExtras(() -> InteractiveChatDiscordSrvAddon.plugin.extras.clear(), (key, dataBytes) -> InteractiveChatDiscordSrvAddon.plugin.extras.put((String)key, (byte[])dataBytes));
    }

    public static ServerResourcePackDownloadResult downloadServerResourcePack(File packFolder) {
        File desFile;
        String url = InteractiveChatDiscordSrvAddon.plugin.alternateResourcePackURL;
        String hash = InteractiveChatDiscordSrvAddon.plugin.alternateResourcePackHash;
        if (url == null || url.isEmpty()) {
            url = ResourcePackUtils.getServerResourcePack();
            hash = ResourcePackUtils.getServerResourcePackHash();
            if (url == null || url.isEmpty()) {
                return new ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType.NO_PACK);
            }
        }
        File file = desFile = hash != null && !hash.isEmpty() ? new File(packFolder, hash) : null;
        if (desFile != null && desFile.exists()) {
            try {
                String packHash;
                if (hash != null && !hash.isEmpty() && (packHash = HashUtils.createSha1String((File)desFile)).equalsIgnoreCase(hash)) {
                    return new ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType.SUCCESS_NO_CHANGES, desFile, packHash, hash);
                }
            }
            catch (Exception packHash) {
                // empty catch block
            }
        }
        Arrays.stream(packFolder.listFiles()).forEach(each -> {
            if (each.isFile()) {
                each.delete();
            }
        });
        byte[] packData = HTTPRequestUtils.download((String)url);
        if (packData != null) {
            try {
                String packHash = HashUtils.createSha1String((InputStream)new ByteArrayInputStream(packData));
                desFile = new File(packFolder, packHash);
                if (hash == null || hash.isEmpty()) {
                    FileUtils.copy((InputStream)new ByteArrayInputStream(packData), (File)desFile);
                    return new ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType.SUCCESS_NO_HASH, desFile);
                }
                if (packHash.equalsIgnoreCase(hash)) {
                    FileUtils.copy((InputStream)new ByteArrayInputStream(packData), (File)desFile);
                    return new ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType.SUCCESS_WITH_HASH, desFile, packHash, hash);
                }
                return new ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType.FAILURE_WRONG_HASH, packHash, hash);
            }
            catch (Exception e) {
                return new ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType.FAILURE_WRONG_HASH, null, "ERROR", hash, e);
            }
        }
        return new ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType.FAILURE_DOWNLOAD);
    }

    public static void loadLibraries(File rootFolder) {
        try {
            JSONObject json;
            File hashes = new File(rootFolder, "hashes.json");
            if (!hashes.exists()) {
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(hashes.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    pw.println("{}");
                    pw.flush();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            try (InputStreamReader hashReader = new InputStreamReader(Files.newInputStream(hashes.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                json = (JSONObject)new JSONParser().parse((Reader)hashReader);
            }
            catch (Throwable e3) {
                new RuntimeException("Invalid hashes.json! It will be reset.", e3).printStackTrace();
                json = new JSONObject();
            }
            InteractiveChatDiscordSrvAddon.plugin.defaultResourceHash = json.containsKey((Object)"libs") ? json.get((Object)"libs").toString() : "EMPTY";
            String oldHash = InteractiveChatDiscordSrvAddon.plugin.defaultResourceHash;
            String oldVersion = json.containsKey((Object)"version") ? json.get((Object)"version").toString() : "EMPTY";
            File libsFolder = new File(rootFolder, "libs");
            libsFolder.mkdirs();
            LibraryDownloadManager downloadManager = new LibraryDownloadManager(libsFolder);
            String hash = "N/A";
            try {
                hash = downloadManager.getHash();
                if (!hash.equals(oldHash) || !InteractiveChatDiscordSrvAddon.plugin.getDescription().getVersion().equals(oldVersion)) {
                    downloadManager.downloadLibraries((result, jarName) -> {
                        if (result.booleanValue()) {
                            Bukkit.getConsoleSender().sendMessage("[ICDiscordSrvAddon] Downloaded library \"" + jarName + "\"");
                        } else {
                            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ICDiscordSrvAddon] Unable to download library \"" + jarName + "\"");
                        }
                    });
                }
            }
            catch (Throwable e4) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ICDiscordSrvAddon] Error while downloading libraries");
                e4.printStackTrace();
            }
            LibraryLoader.loadLibraries(libsFolder, (file, e) -> {
                String jarName = file.getName();
                if (e == null) {
                    Bukkit.getConsoleSender().sendMessage("[ICDiscordSrvAddon] Remapped library \"" + jarName + "\"");
                } else {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ICDiscordSrvAddon] Unable to remap library \"" + jarName + "\"");
                    e.printStackTrace();
                }
            }, (file, e) -> {
                String jarName = file.getName();
                if (e == null) {
                    Bukkit.getConsoleSender().sendMessage("[ICDiscordSrvAddon] Loaded library \"" + jarName + "\"");
                } else {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ICDiscordSrvAddon] Unable to load library \"" + jarName + "\"");
                    e.printStackTrace();
                }
            });
            json.put((Object)"libs", (Object)hash);
            json.put((Object)"version", (Object)InteractiveChatDiscordSrvAddon.plugin.getDescription().getVersion());
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(hashes.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                Gson g = new GsonBuilder().setPrettyPrinting().create();
                pw.println(g.toJson(new JsonParser().parse(json.toString())));
                pw.flush();
            }
            catch (Exception e5) {
                e5.printStackTrace();
            }
        }
        catch (Exception e6) {
            e6.printStackTrace();
        }
    }

    private static String getEntryName(String name) {
        int pos = name.lastIndexOf("/");
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        pos = name.lastIndexOf("\\");
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static class ServerResourcePackDownloadResult {
        private ServerResourcePackDownloadResultType type;
        private File resourcePackFile;
        private String packHash;
        private String expectedHash;
        private Throwable error;

        public ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType type, File resourcePackFile, String packHash, String expectedHash, Throwable error) {
            this.type = type;
            this.resourcePackFile = resourcePackFile;
            this.packHash = packHash;
            this.expectedHash = expectedHash;
            this.error = error;
        }

        public ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType type, File resourcePackFile, String packHash, String expectedHash) {
            this(type, resourcePackFile, packHash, expectedHash, null);
        }

        public ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType type, String packHash, String expectedHash) {
            this(type, null, packHash, expectedHash, null);
        }

        public ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType type, Throwable error) {
            this(type, null, null, null, error);
        }

        public ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType type, File resourcePackFile) {
            this(type, resourcePackFile, null, null, null);
        }

        public ServerResourcePackDownloadResult(ServerResourcePackDownloadResultType type) {
            this(type, null, null, null, null);
        }

        public ServerResourcePackDownloadResultType getType() {
            return this.type;
        }

        public File getResourcePackFile() {
            return this.resourcePackFile;
        }

        public String getPackHash() {
            return this.packHash;
        }

        public String getExpectedHash() {
            return this.expectedHash;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static enum ServerResourcePackDownloadResultType {
        NO_PACK,
        SUCCESS_NO_CHANGES,
        SUCCESS_NO_HASH,
        SUCCESS_WITH_HASH,
        FAILURE_DOWNLOAD,
        FAILURE_WRONG_HASH;

    }
}

